/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.database;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.introspection.GenericIntrospectorLegacyModelUtils;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasCluster;
import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasOperator;
import com.intellij.database.model.DasPositioned;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTrigger;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicModArgument;
import com.intellij.database.model.basic.BasicModArrangedElement;
import com.intellij.database.model.basic.BasicModCheck;
import com.intellij.database.model.basic.BasicModColumniation;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModForeignKey;
import com.intellij.database.model.basic.BasicModIndex;
import com.intellij.database.model.basic.BasicModKey;
import com.intellij.database.model.basic.BasicModMateNamespace;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.basic.BasicModTrigger;
import com.intellij.database.model.basic.BasicModTypedElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.oracle.OraModCluster;
import com.intellij.database.model.oracle.OraModClusterColumn;
import com.intellij.database.model.postgres.PostgresModOperator;
import com.intellij.database.model.properties.PostgresOperatorKind;
import com.intellij.database.model.sybase.SybaseModProcedure;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.database.SqlModelBuilder;
import com.intellij.sql.psi.SqlConstraintDefinition;
import com.intellij.sql.psi.SqlCreateProcedureStatement;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.util.Consumer;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlModelBuilderUtils {
    private static final Logger LOG = Logger.getInstance(SqlModelBuilder.class);
    private static final List<Consumer<DasObject>> ourFinalizers = Arrays.asList(SqlModelBuilderUtils.simpleFinalizer(BasicModForeignKey.class, fk -> {
        BasicLikeTable refTable = fk.getRefTable();
        if (refTable == null) {
            return;
        }
        List<String> refCols = fk.getRefColNames();
        if (refCols.isEmpty()) {
            BasicKey key = refTable.getPrimaryKey();
            if (key != null) {
                fk.setRefColNames(key.getColNames());
                fk.setRefKeyName(key.getName());
            }
        } else {
            BasicKey key = refTable.getKeys().find(k -> k.areColNames(refCols));
            if (key != null) {
                fk.setRefKeyName(key.getName());
            }
        }
    }));
    private static final List<PairConsumer<DasObject, DasObject>> ourCopying = Arrays.asList(SqlModelBuilderUtils.simpleCopy(BasicModMateNamespace.class, DasObject.class, (t, s) -> t.setVisible(true)), SqlModelBuilderUtils.simpleCopy(BasicModNamedElement.class, DasObject.class, (t, s) -> t.setComment(s.getComment())), SqlModelBuilderUtils.simpleCopy(BasicModNamedElement.class, DasObject.class, (t, s) -> t.setNameQuoted(DbSqlUtil.isQuoted(s))), SqlModelBuilderUtils.simpleCopy(BasicModNamedElement.class, DasObject.class, (t, s) -> t.setNameScripted(DbSqlUtil.isSqlObject(s))), SqlModelBuilderUtils.simpleCopy(BasicModArrangedElement.class, DasPositioned.class, (t, s) -> t.setPosition(s.getPosition())), SqlModelBuilderUtils.simpleCopy(BasicModTypedElement.class, DasTypedObject.class, (t, s) -> t.setDataType(s.getDataType())), SqlModelBuilderUtils.simpleCopy(BasicModTypedElement.class, DasTypedObject.class, (t, s) -> t.setDefaultExpression(s.getDefault())), SqlModelBuilderUtils.simpleCopy(BasicModTypedElement.class, DasTypedObject.class, (t, s) -> t.setNotNull(s.isNotNull())), SqlModelBuilderUtils.simpleCopy(BasicModArgument.class, DasArgument.class, (t, s) -> t.setArgumentDirection(s.getArgumentDirection())), SqlModelBuilderUtils.simpleCopy(OraModCluster.class, DasCluster.class, (t, s) -> t.setClusterType(s.getClusterType())), SqlModelBuilderUtils.simpleCopy(OraModClusterColumn.class, DasTypedObject.class, (t, s) -> t.setDataType(s.getDataType())), SqlModelBuilderUtils.simpleCopy(BasicModColumniation.class, DasConstraint.class, (t, s) -> t.setColNames(ContainerUtil.newArrayList((Iterable)s.getColumnsRef().names()))), SqlModelBuilderUtils.simpleCopy(BasicModForeignKey.class, DasForeignKey.class, (t, s) -> t.setDeferrable(SqlModelBuilderUtils.isDeferrable(s.getDeferrability()))), SqlModelBuilderUtils.simpleCopy(BasicModForeignKey.class, DasForeignKey.class, (t, s) -> t.setInitiallyDeferred(s.getDeferrability() == DasForeignKey.Deferrability.INITIALLY_DEFERRED)), SqlModelBuilderUtils.simpleCopy(BasicModForeignKey.class, DasForeignKey.class, (t, s) -> t.setOnDelete(GenericIntrospectorLegacyModelUtils.asCascadeRule(s.getDeleteRule(), t.getModel().getRdbms()))), SqlModelBuilderUtils.simpleCopy(BasicModForeignKey.class, DasForeignKey.class, (t, s) -> t.setOnUpdate(GenericIntrospectorLegacyModelUtils.asCascadeRule(s.getUpdateRule(), t.getModel().getRdbms()))), SqlModelBuilderUtils.simpleCopy(BasicModForeignKey.class, DasForeignKey.class, (t, s) -> t.setRefColNames(ContainerUtil.newArrayList((Iterable)s.getRefColumns().names()))), SqlModelBuilderUtils.simpleCopy(BasicModForeignKey.class, DasForeignKey.class, (t, s) -> t.setRefTableName(s.getRefTableName())), SqlModelBuilderUtils.simpleCopy(BasicModForeignKey.class, DasForeignKey.class, (t, s) -> t.setRefSchemaName(StringUtil.nullize((String)s.getRefTableSchema(), (boolean)true))), SqlModelBuilderUtils.simpleCopy(BasicModColumniation.class, DasIndex.class, (t, s) -> t.setColNames(ContainerUtil.newArrayList((Iterable)s.getColumnsRef().names()))), SqlModelBuilderUtils.simpleCopy(BasicModIndex.class, DasIndex.class, (t, s) -> t.setUnique(s.isUnique())), SqlModelBuilderUtils.simpleCopy(BasicModIndex.class, DasIndex.class, (t, s) -> t.setReverseColNames(JBIterable.from((Iterable)s.getColumnsRef().resolveObjects()).filter(c -> s.getColumnSorting(c) == DasIndex.Sorting.DESCENDING).transform(DasObject::getName).toSet())), SqlModelBuilderUtils.simpleCopy(PostgresModOperator.class, DasOperator.class, (t, s) -> t.setLeftType(SqlModelBuilderUtils.get(s.getArgumentTypes(), 0, DataType.UNKNOWN))), SqlModelBuilderUtils.simpleCopy(PostgresModOperator.class, DasOperator.class, (t, s) -> t.setRightType(SqlModelBuilderUtils.get(s.getArgumentTypes(), 1, DataType.UNKNOWN))), SqlModelBuilderUtils.simpleCopy(PostgresModOperator.class, DasOperator.class, (t, s) -> t.setResultType(s.getResultType())), SqlModelBuilderUtils.simpleCopy(PostgresModOperator.class, DasOperator.class, (t, s) -> t.setOperatorKind(SqlModelBuilderUtils.getPgOperatorKind(s.getOperatorNotation()))), SqlModelBuilderUtils.simpleCopy(BasicModRoutine.class, DasRoutine.class, (t, s) -> t.setRoutineKind(s.getRoutineKind())), SqlModelBuilderUtils.simpleCopy(SybaseModProcedure.class, DasRoutine.class, (t, s) -> t.setPosition(SqlModelBuilderUtils.getSybaseNumber((DasObject)s))), SqlModelBuilderUtils.simpleCopy(BasicModKey.class, DasTableKey.class, (t, s) -> t.setPrimary(s.isPrimary())), SqlModelBuilderUtils.simpleCopy(BasicModTrigger.class, DasTrigger.class, (t, s) -> t.setEvents(s.getEvents())), SqlModelBuilderUtils.simpleCopy(BasicModTrigger.class, DasTrigger.class, (t, s) -> t.setTurn(s.getTurn())), SqlModelBuilderUtils.simpleCopy(BasicModTrigger.class, DasTrigger.class, (t, s) -> t.setCondition(s.getCondition())), SqlModelBuilderUtils.simpleCopy(BasicModCheck.class, SqlConstraintDefinition.class, (t, s) -> {
        SqlExpression parameter = (SqlExpression)s.getConstraintParameter(SqlConstraintDefinition.EXPRESSION);
        t.setPredicate(parameter == null ? null : parameter.getText());
    }));

    static void fillObject(@NotNull BasicModElement target, @NotNull DasObject source) {
        if (target == null) {
            SqlModelBuilderUtils.$$$reportNull$$$0(0);
        }
        if (source == null) {
            SqlModelBuilderUtils.$$$reportNull$$$0(1);
        }
        if (!(target instanceof DasNamespace)) {
            target.getFamilies().forEach(ModFamily::markChildrenAsSyncPending);
        }
        ourCopying.forEach(c -> {
            if (target == null) {
                SqlModelBuilderUtils.$$$reportNull$$$0(15);
            }
            if (source == null) {
                SqlModelBuilderUtils.$$$reportNull$$$0(16);
            }
            c.consume((Object)target, (Object)source);
        });
    }

    static void finalizeObject(@NotNull BasicModElement object) {
        if (object == null) {
            SqlModelBuilderUtils.$$$reportNull$$$0(2);
        }
        ourFinalizers.forEach(c -> {
            if (object == null) {
                SqlModelBuilderUtils.$$$reportNull$$$0(14);
            }
            c.consume((Object)object);
        });
    }

    private static boolean isDeferrable(@Nullable DasForeignKey.Deferrability def) {
        return def != null && def != DasForeignKey.Deferrability.NOT_DEFERRABLE;
    }

    private static PostgresOperatorKind getPgOperatorKind(DasOperator.OperatorNotation n) {
        if (n == DasOperator.OperatorNotation.INFIX) {
            return PostgresOperatorKind.BINARY;
        }
        if (n == DasOperator.OperatorNotation.POSTFIX) {
            return PostgresOperatorKind.POSTFIX;
        }
        if (n == DasOperator.OperatorNotation.PREFIX) {
            return PostgresOperatorKind.PREFIX;
        }
        return PostgresOperatorKind.UNKNOWN;
    }

    private static <T> T get(List<T> l, int idx, T def) {
        return idx < l.size() ? l.get(idx) : def;
    }

    private static <T, S> PairConsumer<DasObject, DasObject> simpleCopy(@NotNull Class<T> trg, @NotNull Class<S> src, @NotNull PairConsumer<T, S> cons) {
        if (trg == null) {
            SqlModelBuilderUtils.$$$reportNull$$$0(3);
        }
        if (src == null) {
            SqlModelBuilderUtils.$$$reportNull$$$0(4);
        }
        if (cons == null) {
            SqlModelBuilderUtils.$$$reportNull$$$0(5);
        }
        return (t, s) -> {
            if (trg == null) {
                SqlModelBuilderUtils.$$$reportNull$$$0(11);
            }
            if (src == null) {
                SqlModelBuilderUtils.$$$reportNull$$$0(12);
            }
            if (cons == null) {
                SqlModelBuilderUtils.$$$reportNull$$$0(13);
            }
            if (!trg.isAssignableFrom(t.getClass())) {
                return;
            }
            if (!src.isAssignableFrom(s.getClass())) {
                return;
            }
            cons.consume(trg.cast(t), src.cast(s));
        };
    }

    private static <T> Consumer<DasObject> simpleFinalizer(@NotNull Class<T> clazz, @NotNull Consumer<T> cons) {
        if (clazz == null) {
            SqlModelBuilderUtils.$$$reportNull$$$0(6);
        }
        if (cons == null) {
            SqlModelBuilderUtils.$$$reportNull$$$0(7);
        }
        return x -> {
            if (clazz == null) {
                SqlModelBuilderUtils.$$$reportNull$$$0(9);
            }
            if (cons == null) {
                SqlModelBuilderUtils.$$$reportNull$$$0(10);
            }
            if (!clazz.isAssignableFrom(x.getClass())) {
                return;
            }
            cons.consume(clazz.cast(x));
        };
    }

    public static boolean isIgnored(DatabaseFamilyId familyId, ObjectKind p, ObjectKind c) {
        if (c == SqlDbElementType.ANY) {
            return true;
        }
        if (p == ObjectKind.SCHEMA && c == SqlDbElementType.ROLE) {
            return true;
        }
        if (familyId.isOracle()) {
            if (p == ObjectKind.BODY) {
                return true;
            }
            if (p == ObjectKind.PACKAGE) {
                return c != ObjectKind.ROUTINE;
            }
            if (p == ObjectKind.SCHEMA) {
                return c == ObjectKind.OPERATOR || "exception".equals(c.name()) || "library".equals(c.name()) || "INDEX TYPE".equals(c.name());
            }
        }
        if (p == SqlDbElementType.DOMAIN) {
            return c == SqlDbElementType.CONSTRAINT;
        }
        return false;
    }

    public static short getSybaseNumber(DasObject obj) {
        if (obj instanceof SqlCreateProcedureStatement) {
            return SqlModelBuilderUtils.getSybaseNumber(obj.getName());
        }
        if (obj instanceof DasPositioned) {
            return ((DasPositioned)obj).getPosition();
        }
        return SqlModelBuilderUtils.getSybaseNumber(obj.getName());
    }

    public static short getSybaseNumber(String name) {
        if (name.contains(";")) {
            SqlModelBuilderUtils.hardWarning("Sybase routine with ; : " + name);
        }
        Short num = SqlModelBuilderUtils.isNumber(name) ? SqlModelBuilderUtils.tryConvert(name) : null;
        return num == null ? (short)1 : num;
    }

    @Nullable
    public static Short tryConvert(@Nullable String sub) {
        if (sub == null) {
            return null;
        }
        try {
            return Short.valueOf(sub);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private static boolean isNumber(@Nullable String s) {
        if (s == null) {
            return false;
        }
        for (int i2 = 0; i2 < s.length(); ++i2) {
            if (Character.isDigit(s.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static void hardWarning(@NotNull String message) {
        Application app;
        if (message == null) {
            SqlModelBuilderUtils.$$$reportNull$$$0(8);
        }
        if ((app = ApplicationManager.getApplication()) == null || app.isUnitTestMode()) {
            throw new AssertionError((Object)message);
        }
        LOG.warn(message);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trg";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "src";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cons";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/database/SqlModelBuilderUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fillObject";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "finalizeObject";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "simpleCopy";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "simpleFinalizer";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "hardWarning";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$simpleFinalizer$39";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$simpleCopy$38";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$finalizeObject$1";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$fillObject$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

