/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.exasol;

import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.psi.DbDataSource;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.TreePattern;
import com.intellij.sql.dialects.TreePatternNode;
import com.intellij.sql.dialects.exasol.ExasolReservedKeywords;
import com.intellij.sql.dialects.exasol.ExasolTokens;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlKeywordTokenType;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExasolDialect
extends SqlLanguageDialectEx {
    public static final ExasolDialect INSTANCE = new ExasolDialect();

    public ExasolDialect() {
        super("Exasol");
    }

    @Override
    @NotNull
    public DatabaseDialectEx getDatabaseDialect() {
        com.intellij.database.dialects.ExasolDialect exasolDialect = com.intellij.database.dialects.ExasolDialect.INSTANCE;
        if (exasolDialect == null) {
            ExasolDialect.$$$reportNull$$$0(0);
        }
        return exasolDialect;
    }

    @Override
    public TokenSet getStatementSeparators() {
        return LazyData.ourClosingTokens;
    }

    public boolean isReservedKeyword(IElementType tokenType) {
        return tokenType instanceof SqlKeywordTokenType && LazyData.ourReservedTokens.fun((Object)tokenType.toString()) != null;
    }

    @Override
    @NotNull
    public Map<String, SqlFunctionDefinition> getSupportedFunctions() {
        Map<String, SqlFunctionDefinition> map2 = LazyData.ourFunctionMap;
        if (map2 == null) {
            ExasolDialect.$$$reportNull$$$0(1);
        }
        return map2;
    }

    public boolean isOperatorSupported(IElementType tokenType) {
        return LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getKeywords() {
        Set set = SqlTokenRegistry.getTokens(ExasolTokens.class);
        if (set == null) {
            ExasolDialect.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = Collections.emptySet();
        if (set == null) {
            ExasolDialect.$$$reportNull$$$0(3);
        }
        return set;
    }

    @Override
    @Nullable
    public String getDefaultTypeName(@NotNull SqlType.Category cat) {
        if (cat == null) {
            ExasolDialect.$$$reportNull$$$0(4);
        }
        switch (cat) {
            case INTEGER: {
                return "DECIMAL";
            }
            case REAL: {
                return "DECIMAL";
            }
            case STRING: {
                return "VARCHAR";
            }
            case BOOLEAN: {
                return "BOOLEAN";
            }
            case DATE_TIME: {
                return "TIMESTAMP";
            }
            case DATE: {
                return "DATE";
            }
            case TIME: {
                return "TIMESTAMP";
            }
            case TIMESTAMP: {
                return "TIMESTAMP";
            }
            case INTERVAL: {
                return "INTERVAL";
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String getNormalizedTypeName(@NotNull String name) {
        if (name == null) {
            ExasolDialect.$$$reportNull$$$0(5);
        }
        if ("BIGINT".equals(name = super.getNormalizedTypeName(name))) {
            if ("DECIMAL" == null) {
                ExasolDialect.$$$reportNull$$$0(6);
            }
            return "DECIMAL";
        }
        if ("BOOL".equals(name)) {
            if ("BOOLEAN" == null) {
                ExasolDialect.$$$reportNull$$$0(7);
            }
            return "BOOLEAN";
        }
        if ("CHAR VARYING".equals(name)) {
            if ("VARCHAR" == null) {
                ExasolDialect.$$$reportNull$$$0(8);
            }
            return "VARCHAR";
        }
        if ("CHARACTER".equals(name)) {
            if ("CHAR" == null) {
                ExasolDialect.$$$reportNull$$$0(9);
            }
            return "CHAR";
        }
        if ("CHARACTER LARGE OBJECT".equals(name)) {
            if ("VARCHAR" == null) {
                ExasolDialect.$$$reportNull$$$0(10);
            }
            return "VARCHAR";
        }
        if ("CHARACTER VARYING".equals(name)) {
            if ("VARCHAR" == null) {
                ExasolDialect.$$$reportNull$$$0(11);
            }
            return "VARCHAR";
        }
        if ("CLOB".equals(name)) {
            if ("VARCHAR" == null) {
                ExasolDialect.$$$reportNull$$$0(12);
            }
            return "VARCHAR";
        }
        if ("DEC".equals(name)) {
            if ("DECIMAL" == null) {
                ExasolDialect.$$$reportNull$$$0(13);
            }
            return "DECIMAL";
        }
        if ("DOUBLE".equals(name)) {
            if ("DOUBLE PRECISION" == null) {
                ExasolDialect.$$$reportNull$$$0(14);
            }
            return "DOUBLE PRECISION";
        }
        if ("FLOAT".equals(name)) {
            if ("DOUBLE PRECISION" == null) {
                ExasolDialect.$$$reportNull$$$0(15);
            }
            return "DOUBLE PRECISION";
        }
        if ("INT".equals(name)) {
            if ("DECIMAL" == null) {
                ExasolDialect.$$$reportNull$$$0(16);
            }
            return "DECIMAL";
        }
        if ("INTEGER".equals(name)) {
            if ("DECIMAL" == null) {
                ExasolDialect.$$$reportNull$$$0(17);
            }
            return "DECIMAL";
        }
        if ("LONG VARCHAR".equals(name)) {
            if ("VARCHAR" == null) {
                ExasolDialect.$$$reportNull$$$0(18);
            }
            return "VARCHAR";
        }
        if ("NCHAR".equals(name)) {
            if ("CHAR" == null) {
                ExasolDialect.$$$reportNull$$$0(19);
            }
            return "CHAR";
        }
        if ("NUMBER".equals(name)) {
            if ("DECIMAL" == null) {
                ExasolDialect.$$$reportNull$$$0(20);
            }
            return "DECIMAL";
        }
        if ("NUMERIC".equals(name)) {
            if ("DECIMAL" == null) {
                ExasolDialect.$$$reportNull$$$0(21);
            }
            return "DECIMAL";
        }
        if ("NVARCHAR".equals(name)) {
            if ("VARCHAR" == null) {
                ExasolDialect.$$$reportNull$$$0(22);
            }
            return "VARCHAR";
        }
        if ("NVARCHAR2".equals(name)) {
            if ("VARCHAR" == null) {
                ExasolDialect.$$$reportNull$$$0(23);
            }
            return "VARCHAR";
        }
        if ("REAL".equals(name)) {
            if ("DOUBLE PRECISION" == null) {
                ExasolDialect.$$$reportNull$$$0(24);
            }
            return "DOUBLE PRECISION";
        }
        if ("SHORTINT".equals(name)) {
            if ("DECIMAL" == null) {
                ExasolDialect.$$$reportNull$$$0(25);
            }
            return "DECIMAL";
        }
        if ("SMALLINT".equals(name)) {
            if ("DECIMAL" == null) {
                ExasolDialect.$$$reportNull$$$0(26);
            }
            return "DECIMAL";
        }
        if ("TINYINT".equals(name)) {
            if ("DECIMAL" == null) {
                ExasolDialect.$$$reportNull$$$0(27);
            }
            return "DECIMAL";
        }
        if ("VARCHAR2".equals(name)) {
            if ("VARCHAR" == null) {
                ExasolDialect.$$$reportNull$$$0(28);
            }
            return "VARCHAR";
        }
        String string = name;
        if (string == null) {
            ExasolDialect.$$$reportNull$$$0(29);
        }
        return string;
    }

    @Override
    @NotNull
    public SqlType.Category getTypeCategoryByName(@NotNull String typeName) {
        if (typeName == null) {
            ExasolDialect.$$$reportNull$$$0(30);
        }
        if ("DECIMAL".equals(typeName)) {
            SqlType.Category category = SqlType.Category.REAL;
            if (category == null) {
                ExasolDialect.$$$reportNull$$$0(31);
            }
            return category;
        }
        if ("NUMERIC".equals(typeName)) {
            SqlType.Category category = SqlType.Category.REAL;
            if (category == null) {
                ExasolDialect.$$$reportNull$$$0(32);
            }
            return category;
        }
        SqlType.Category category = super.getTypeCategoryByName(typeName);
        if (category == null) {
            ExasolDialect.$$$reportNull$$$0(33);
        }
        return category;
    }

    @Override
    @NotNull
    protected TreePattern getBaseImports(@Nullable DbDataSource dataSource, @Nullable ObjectName[] dsNames) {
        ObjectName exaDb = ObjectName.quoted((String)"EXA_DB");
        DasNamespace namespace = ExasolDialect.getDefaultNamespace(dataSource, exaDb);
        if (namespace != null) {
            TreePattern treePattern = SqlDialectImplUtil.createObjectPattern(dsNames, (DasObject)namespace, new TreePatternNode.Group[0]);
            if (treePattern == null) {
                ExasolDialect.$$$reportNull$$$0(34);
            }
            return treePattern;
        }
        TreePattern treePattern = new TreePattern(SqlImportUtil.createDataSources(dsNames, SqlImportUtil.createNodeIfNotNull(exaDb, ObjectKind.DATABASE, new TreePatternNode.Group[0])));
        if (treePattern == null) {
            ExasolDialect.$$$reportNull$$$0(35);
        }
        return treePattern;
    }

    @Override
    protected boolean canBeWithoutCurrentSchema() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 30: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 30: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/exasol/ExasolDialect";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cat";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseDialect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFunctions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywords";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 4: 
            case 5: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/exasol/ExasolDialect";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getNormalizedTypeName";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeCategoryByName";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseImports";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTypeName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedTypeName";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getTypeCategoryByName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 30: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LazyData {
        static final Map<String, SqlFunctionDefinition> ourFunctionMap = Collections.unmodifiableMap(SqlFunctionsUtil.loadFunctionDefinition(INSTANCE));
        static final NullableFunction<String, IElementType> ourReservedTokens = SqlTokenRegistry.getTokenProvider(ExasolReservedKeywords.class);
        static final Set<IElementType> ourSupportedOperators = ContainerUtil.newTroveSet((Object[])new IElementType[]{SqlTokens.SQL_OP_PLUS, SqlTokens.SQL_OP_MINUS, SqlTokens.SQL_OP_MUL, SqlTokens.SQL_OP_DIV, SqlTokens.SQL_OP_NEQ2, SqlTokens.SQL_OP_LE, SqlTokens.SQL_OP_LT, SqlTokens.SQL_OP_GE, SqlTokens.SQL_OP_EQ, SqlTokens.SQL_OP_GT, SqlTokens.SQL_OP_CONCAT, SqlTokens.SQL_AND, SqlTokens.SQL_NOT, SqlTokens.SQL_OR, SqlTokens.SQL_IS, SqlTokens.SQL_LIKE, SqlTokens.SQL_IN, SqlTokens.SQL_INTERVAL, SqlTokens.SQL_SECOND, SqlTokens.SQL_MINUTE, SqlTokens.SQL_HOUR, SqlTokens.SQL_DAY, SqlTokens.SQL_MONTH, SqlTokens.SQL_YEAR});
        static final TokenSet ourClosingTokens = TokenSet.orSet((TokenSet[])new TokenSet[]{SqlTokens.STATEMENT_SEPARATORS, TokenSet.create((IElementType[])new IElementType[]{SqlTokens.SQL_OP_DIV})});

        private LazyData() {
        }
    }
}

