/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.exasol;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.SqlGeneratedParserUtil;
import com.intellij.sql.dialects.exasol.ExasolDdlParsing;
import com.intellij.sql.dialects.exasol.ExasolDialect;
import com.intellij.sql.dialects.exasol.ExasolDmlParsing;
import com.intellij.sql.dialects.exasol.ExasolExpressionParsing;
import com.intellij.sql.dialects.exasol.ExasolGeneratedParser;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.injection.SqlSuggestedInjection;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.impl.parser.SqlParser;
import com.intellij.sql.psi.impl.parser.SqlParserUtil;
import org.jetbrains.annotations.Nullable;

public class ExasolParser
extends SqlParser {
    public static final SqlSuggestedInjection EXASOL_INJECTION = new SqlSuggestedInjection("Exasol");

    public ExasolParser() {
        super(ExasolDialect.INSTANCE);
    }

    @Override
    public boolean parseSqlStatement(PsiBuilder builder, int level) {
        return ExasolGeneratedParser.statement(builder, level);
    }

    @Override
    protected TokenSet[] getExtendsTokenSets() {
        return ExasolGeneratedParser.EXTENDS_SETS_;
    }

    @Override
    public boolean parseQueryExpression(PsiBuilder builder, int level) {
        return ExasolDmlParsing.top_query_expression(builder, level);
    }

    @Override
    public boolean parseValueExpression(PsiBuilder builder, int level, boolean optional, boolean allowBoolean) {
        boolean result2 = ExasolExpressionParsing.value_expression(builder, level);
        if (!result2 && !optional) {
            builder.error("<expression> expected");
        }
        return result2;
    }

    public SqlCompositeElementType parseIntervalLiteral(PsiBuilder builder, int level) {
        if (ExasolExpressionParsing.unary_interval_literal_expr_tail(builder, level)) {
            return SQL_INTERVAL_LITERAL;
        }
        return null;
    }

    @Override
    public boolean parseParenContentQorV(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict(builder, level, ExasolExpressionParsing::parenthesized_values_expr, ExasolDmlParsing::top_query_expression, ExasolParser::parseTopQueryExpressionTail, ExasolExpressionParsing::row_element_list, (b, l) -> ExasolExpressionParsing.root_expr_0(b, l, -1) && ExasolExpressionParsing.row_element_list_separator(b, l) && ExasolExpressionParsing.row_element_list(b, l));
    }

    @Override
    @Nullable
    public SqlSuggestedInjection getCurrentSqlInjection() {
        return EXASOL_INJECTION;
    }

    @Override
    public boolean parseEvaluableExpression(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.parseAndRemapToGenericReference(builder, level, ExasolExpressionParsing::evaluable_expression);
    }

    @Override
    public boolean parseDataType(PsiBuilder builder, int level, boolean ext) {
        return ExasolDdlParsing.type_element(builder, level);
    }

    @Override
    protected boolean allowNoopStringConcatenation(PsiBuilder builder, boolean first) {
        return SqlParserUtil.nextTokenIs(builder, (IElementType)SQL_STRING_TOKEN);
    }

    @Override
    public boolean parseFunctionParametersAndParens(PsiBuilder builder, int level, String functionName, SqlFunctionDefinition definition, boolean allowNoParens) {
        if (super.parseFunctionParametersAndParens(builder, level, functionName, definition, allowNoParens)) {
            ExasolParser.parseAnalyticAggregateFunctionTail(builder, level, definition);
            return true;
        }
        return false;
    }

    @Override
    public boolean parseFunctionArgument(PsiBuilder builder, int level, boolean optional, boolean allowBoolean) {
        boolean res = super.parseFunctionArgument(builder, level, optional, allowBoolean);
        if (res) {
            ExasolDmlParsing.order_by_clause(builder, level);
        }
        return res;
    }

    public static boolean parseTopQueryExpressionTail(PsiBuilder builder, int level) {
        ExasolDmlParsing.query_expression_0(builder, level, -1);
        return ExasolDmlParsing.left_inner_table_op_tail(builder, level);
    }

    @Override
    public boolean parseFunctionCallTail(PsiBuilder builder, int level) {
        boolean res = super.parseFunctionCallTail(builder, level);
        if (res) {
            ExasolGeneratedParser.emits_clause(builder, level);
        }
        return res;
    }

    public static void parseAnalyticAggregateFunctionTail(PsiBuilder builder, int level, SqlFunctionDefinition definition) {
        if (definition == null) {
            return;
        }
        if ("true".equals(definition.getDialectAttribute("aggregate"))) {
            ExasolGeneratedParser.analytic_clause(builder, level);
        }
    }
}

