/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.functions;

import com.intellij.database.model.DataType;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlTypeFactory;
import com.intellij.util.PairConsumer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlFunctionDefinition
extends BuiltinFunction {
    public static final Type ANY = new Type("ANY", DataTypeFactory.of("any"));
    public static final Type REF = new Type("ref", SqlLanguageDialectEx.REFERENCE.getDataType());
    public static final Type TOKEN = new Type("token", DataTypeFactory.of("token"));
    public static final Type DATATYPE = new Type("datatype", DataTypeFactory.of("datatype"));
    public static final Type TABLE = new Type("table", DataTypeFactory.of("table"));
    public static final Type SETOF = new Type("setof", DataTypeFactory.of("setof"));
    public static final Parameter COMMA = new SyntaxParameter(-1, ",");
    public static final String PARAM_TYPE_PREFIX = "P";
    private final Map<String, String> myDialectAttrs;
    private final Prototype[] myPrototypes;
    private final String myName;
    private final String myAliasedFunction;

    public static void addSimpleType(@NotNull Map<String, Type> types, @NotNull String name, @NotNull String spec, @NotNull SqlLanguageDialectEx dialect) {
        if (types == null) {
            SqlFunctionDefinition.$$$reportNull$$$0(0);
        }
        if (name == null) {
            SqlFunctionDefinition.$$$reportNull$$$0(1);
        }
        if (spec == null) {
            SqlFunctionDefinition.$$$reportNull$$$0(2);
        }
        if (dialect == null) {
            SqlFunctionDefinition.$$$reportNull$$$0(3);
        }
        types.put(name, new Type(name, DataTypeFactory.of(dialect.getNormalizedTypeName(spec))));
    }

    public static void addSimpleType(@NotNull Map<String, Type> types, @NotNull String name, @NotNull SqlType.Category category, @NotNull SqlLanguageDialectEx dialect) {
        if (types == null) {
            SqlFunctionDefinition.$$$reportNull$$$0(4);
        }
        if (name == null) {
            SqlFunctionDefinition.$$$reportNull$$$0(5);
        }
        if (category == null) {
            SqlFunctionDefinition.$$$reportNull$$$0(6);
        }
        if (dialect == null) {
            SqlFunctionDefinition.$$$reportNull$$$0(7);
        }
        types.put(name, new Type(name, SqlTypeFactory.defaultType(category, dialect).getDataType()));
    }

    public static void addSimpleTypes(@NotNull Map<String, Type> types, @NotNull SqlLanguageDialectEx dialect) {
        if (types == null) {
            SqlFunctionDefinition.$$$reportNull$$$0(8);
        }
        if (dialect == null) {
            SqlFunctionDefinition.$$$reportNull$$$0(9);
        }
        types.put(ANY.getName(), ANY);
        types.put(REF.getName(), REF);
        types.put(TOKEN.getName(), TOKEN);
        types.put(DATATYPE.getName(), DATATYPE);
        types.put(TABLE.getName(), TABLE);
        types.put(SETOF.getName(), SETOF);
        SqlFunctionDefinition.addSimpleType(types, "array", SqlType.Category.ARRAY, dialect);
        SqlFunctionDefinition.addSimpleType(types, "N", SqlType.Category.INTEGER, dialect);
        SqlFunctionDefinition.addSimpleType(types, "X", SqlType.Category.REAL, dialect);
        SqlFunctionDefinition.addSimpleType(types, "str", SqlType.Category.STRING, dialect);
        SqlFunctionDefinition.addSimpleType(types, "bytes", SqlType.Category.BYTES, dialect);
        SqlFunctionDefinition.addSimpleType(types, "B", SqlType.Category.BOOLEAN, dialect);
        SqlFunctionDefinition.addSimpleType(types, "time", SqlType.Category.TIME, dialect);
        SqlFunctionDefinition.addSimpleType(types, "date", SqlType.Category.DATE, dialect);
        SqlFunctionDefinition.addSimpleType(types, "timestamp", SqlType.Category.TIMESTAMP, dialect);
        SqlFunctionDefinition.addSimpleType(types, "datetime", SqlType.Category.DATE_TIME, dialect);
        SqlFunctionDefinition.addSimpleType(types, "interval", SqlType.Category.INTERVAL, dialect);
    }

    public SqlFunctionDefinition(String name, String aliasedFunction, Map<String, String> dialectAttrs, List<Prototype> prototypes) {
        this.myName = name;
        this.myAliasedFunction = aliasedFunction;
        this.myDialectAttrs = dialectAttrs;
        this.myPrototypes = new Prototype[prototypes.size()];
        for (int i2 = 0; i2 < prototypes.size(); ++i2) {
            Prototype p = prototypes.get(i2);
            this.myPrototypes[i2] = new Prototype(this, p.getReturnType(), p.getPrototypeId(), p.getParams(), p.getTailBlock(), p.getAttributes());
        }
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            SqlFunctionDefinition.$$$reportNull$$$0(10);
        }
        return string;
    }

    public String getAliasedFunction() {
        return this.myAliasedFunction;
    }

    public Prototype[] getPrototypes() {
        return this.myPrototypes;
    }

    @Nullable
    public String getDialectAttribute(String name) {
        return this.myDialectAttrs.get(name);
    }

    public String toString() {
        return this.myName + Prototype.toString(this.myDialectAttrs) + Arrays.asList(this.myPrototypes);
    }

    public String getPostfixType() {
        return this.getDialectAttribute("postfix");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spec";
                break;
            }
            case 3: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/functions/SqlFunctionDefinition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/functions/SqlFunctionDefinition";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addSimpleType";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addSimpleTypes";
                break;
            }
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class SyntaxParameter
    extends Parameter {
        private final String myText;

        public SyntaxParameter(int prototypeId, String text) {
            super(prototypeId);
            this.myText = text;
        }

        public String getText() {
            return this.myText;
        }

        public String toString() {
            return !"()[]{}.\\:|".contains(this.myText) ? this.myText : "'" + this.myText + "'";
        }

        @Override
        public Parameter copyWithPrototype(int prototypeId) {
            return new SyntaxParameter(prototypeId, this.myText);
        }
    }

    public static class ParamType
    extends Type {
        private final int myIndex;

        public ParamType(int index) {
            super(SqlFunctionDefinition.PARAM_TYPE_PREFIX + index, null);
            this.myIndex = index;
        }

        @Override
        public String getDisplayName() {
            return "TypeOf(" + this.myIndex + ")";
        }

        public int getIndex() {
            return this.myIndex;
        }
    }

    public static class Type {
        private final String myName;
        private final DataType myDataType;

        public Type(@NonNls String name, DataType dataType) {
            this.myName = name;
            this.myDataType = dataType;
        }

        public String getName() {
            return this.myName;
        }

        public String getDisplayName() {
            return this.myDataType.getSpecification();
        }

        public DataType getDataType() {
            return this.myDataType;
        }

        public String toString() {
            return this.getDisplayName();
        }
    }

    public static class Keyword
    extends Parameter {
        private final String myName;

        public Keyword(int prototypeId, String name) {
            super(prototypeId);
            this.myName = name;
        }

        public String getName() {
            return this.myName;
        }

        public String toString() {
            return this.myName;
        }

        @Override
        public Parameter copyWithPrototype(int prototypeId) {
            return new Keyword(prototypeId, this.myName);
        }
    }

    public static class ReferenceParameter
    extends SimpleParameter {
        private final String myRefTypeName;

        public ReferenceParameter(int prototypeId, String name, Type type, @NotNull String refTypeName, boolean many) {
            if (refTypeName == null) {
                ReferenceParameter.$$$reportNull$$$0(0);
            }
            super(prototypeId, name, type, many);
            this.myRefTypeName = refTypeName;
        }

        @Override
        public Parameter copyWithPrototype(int prototypeId) {
            return new ReferenceParameter(prototypeId, this.getName(), this.getType(), this.myRefTypeName, this.isMany());
        }

        public String getRefTypeName() {
            return this.myRefTypeName;
        }

        @Override
        public String toString() {
            return super.toString() + "/" + this.myRefTypeName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refTypeName", "com/intellij/sql/dialects/functions/SqlFunctionDefinition$ReferenceParameter", "<init>"));
        }
    }

    public static class SimpleParameter
    extends Parameter {
        private final String myName;
        private final Type myType;
        private final boolean myMany;

        public SimpleParameter(int prototypeId, String name, @NotNull Type type, boolean many) {
            if (type == null) {
                SimpleParameter.$$$reportNull$$$0(0);
            }
            super(prototypeId);
            this.myName = name == null ? type.getName().toLowerCase() : name;
            this.myType = type;
            this.myMany = many;
        }

        @Override
        public boolean isMany() {
            return this.myMany;
        }

        @Override
        public Parameter copyWithPrototype(int prototypeId) {
            return new SimpleParameter(prototypeId, this.myName, this.myType, this.myMany);
        }

        public String getName() {
            return this.myName;
        }

        public Type getType() {
            return this.myType;
        }

        public String toString() {
            return this.myName + ":" + this.myType.getDisplayName() + (this.myMany ? "*" : "");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/sql/dialects/functions/SqlFunctionDefinition$SimpleParameter", "<init>"));
        }
    }

    public static class ParameterBlock
    extends Parameter {
        private final Parameter[] myParams;
        private final boolean myMany;
        private final ParameterBlockType myBlockType;

        public ParameterBlock(int prototypeId, ParameterBlockType blockType, Parameter[] params2, boolean many) {
            super(prototypeId);
            this.myBlockType = blockType;
            this.myParams = params2;
            this.myMany = many;
        }

        public ParameterBlockType getBlockType() {
            return this.myBlockType;
        }

        public Parameter[] getParams() {
            return this.myParams;
        }

        @Override
        public boolean isMany() {
            return this.myMany;
        }

        @Override
        public Parameter copyWithPrototype(int prototypeId) {
            Parameter[] params2 = this.myParams.length == 0 ? EMPTY_ARRAY : new Parameter[this.myParams.length];
            for (int i2 = 0; i2 < this.myParams.length; ++i2) {
                params2[i2] = this.myParams[i2].copyWithPrototype(prototypeId);
            }
            return new ParameterBlock(prototypeId, this.myBlockType, params2, this.myMany);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.toString(sb, null);
            return sb.toString();
        }

        public void toString(StringBuilder sb, @Nullable PairConsumer<Parameter, Boolean> markerProcessor) {
            boolean first = true;
            if (markerProcessor != null) {
                markerProcessor.consume((Object)this, (Object)true);
            }
            switch (this.myBlockType) {
                case CHOICE: {
                    sb.append("{");
                    break;
                }
                case OPTIONAL_SEQUENCE: {
                    sb.append("[");
                    break;
                }
                case SEQUENCE: {
                    sb.append("(");
                }
            }
            for (Parameter param : this.myParams) {
                if (first) {
                    first = false;
                } else if (this.myBlockType == ParameterBlockType.CHOICE) {
                    sb.append(" | ");
                } else if (param != COMMA) {
                    sb.append(' ');
                }
                if (param instanceof ParameterBlock) {
                    ((ParameterBlock)param).toString(sb, markerProcessor);
                    continue;
                }
                if (markerProcessor != null) {
                    markerProcessor.consume((Object)param, (Object)true);
                }
                sb.append(param);
                if (markerProcessor == null) continue;
                markerProcessor.consume((Object)param, (Object)false);
            }
            switch (this.myBlockType) {
                case CHOICE: {
                    sb.append("}");
                    break;
                }
                case OPTIONAL_SEQUENCE: {
                    sb.append("]");
                    break;
                }
                case SEQUENCE: {
                    sb.append(")");
                }
            }
            if (this.myMany) {
                sb.append("...");
            }
            if (markerProcessor != null) {
                markerProcessor.consume((Object)this, (Object)false);
            }
        }
    }

    public static enum ParameterBlockType {
        SEQUENCE,
        OPTIONAL_SEQUENCE,
        CHOICE;

    }

    public static abstract class Parameter {
        public static final Parameter[] EMPTY_ARRAY = new Parameter[0];
        private final int myPrototypeId;

        public Parameter(int prototypeId) {
            this.myPrototypeId = prototypeId;
        }

        public int getPrototypeId() {
            return this.myPrototypeId;
        }

        public boolean isMany() {
            return false;
        }

        public abstract Parameter copyWithPrototype(int var1);
    }

    public static class Prototype
    extends ParameterBlock {
        public static final Prototype[] EMPTY_ARRAY = new Prototype[0];
        private final Type myReturnType;
        private final SqlFunctionDefinition myFunction;
        private final Parameter myTailBlock;
        private final Map<String, String> myAttributes;

        public Prototype(@Nullable SqlFunctionDefinition function, @NotNull Type returnType, int id, Parameter[] parameters, @Nullable Parameter tailBlock, @NotNull Map<String, String> attributes) {
            if (returnType == null) {
                Prototype.$$$reportNull$$$0(0);
            }
            if (attributes == null) {
                Prototype.$$$reportNull$$$0(1);
            }
            super(id, ParameterBlockType.SEQUENCE, parameters, false);
            this.myFunction = function;
            this.myReturnType = returnType;
            this.myTailBlock = tailBlock;
            this.myAttributes = attributes.isEmpty() ? Collections.emptyMap() : attributes;
        }

        @Override
        public Parameter copyWithPrototype(int prototypeId) {
            throw new UnsupportedOperationException();
        }

        public Type getReturnType() {
            return this.myReturnType;
        }

        @Override
        public String toString() {
            return Prototype.toString(this.myAttributes) + super.toString() + ":" + this.myReturnType + (this.myTailBlock == null ? "" : " " + this.myTailBlock);
        }

        @NotNull
        public SqlFunctionDefinition getFunction() {
            assert (this.myFunction != null);
            SqlFunctionDefinition sqlFunctionDefinition = this.myFunction;
            if (sqlFunctionDefinition == null) {
                Prototype.$$$reportNull$$$0(2);
            }
            return sqlFunctionDefinition;
        }

        @Nullable
        public Parameter getTailBlock() {
            return this.myTailBlock;
        }

        @NotNull
        public Map<String, String> getAttributes() {
            Map<String, String> map2 = this.myAttributes;
            if (map2 == null) {
                Prototype.$$$reportNull$$$0(3);
            }
            return map2;
        }

        private static String toString(Map<String, String> attrs) {
            if (attrs.isEmpty()) {
                return "";
            }
            return "{" + StringUtil.join(attrs.entrySet(), entry -> (String)entry.getKey() + ":" + (String)entry.getValue(), (String)",") + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "returnType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/dialects/functions/SqlFunctionDefinition$Prototype";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/dialects/functions/SqlFunctionDefinition$Prototype";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFunction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAttributes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

