/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mssql;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.SqlGeneratedParserUtil;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.mssql.MssqlDdlParsing;
import com.intellij.sql.dialects.mssql.MssqlDialect;
import com.intellij.sql.dialects.mssql.MssqlDmlParsing;
import com.intellij.sql.dialects.mssql.MssqlElementTypes;
import com.intellij.sql.dialects.mssql.MssqlExpressionParsing;
import com.intellij.sql.dialects.mssql.MssqlGeneratedParser;
import com.intellij.sql.dialects.mssql.MssqlOptionalKeywords;
import com.intellij.sql.psi.impl.parser.SqlParser;
import com.intellij.sql.psi.impl.parser.SqlParserUtil;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MssqlParser
extends SqlParser {
    public MssqlParser() {
        super(MssqlDialect.INSTANCE);
    }

    @Override
    public boolean allowStringsAsIdentifiers() {
        return true;
    }

    @Override
    protected boolean allowNoopStringConcatenation(PsiBuilder builder, boolean b) {
        return false;
    }

    @Override
    protected void parseScriptDefault(PsiBuilder builder) {
        SqlGeneratedParserUtil.parseAsTree(builder, 0, SQL_DUMMY_BLOCK, false, new GeneratedParserUtilBase.Parser(){

            public boolean parse(PsiBuilder builder, int level) {
                return MssqlParser.this.parseBatchBlock(builder, MssqlElementTypes.MSSQL_BATCH_BLOCK, MssqlOptionalKeywords.TSQL_GO);
            }
        }, GeneratedParserUtilBase.TRUE_CONDITION);
    }

    @Override
    public IElementType parseLiteralOther(PsiBuilder builder, int level) {
        if (GeneratedParserUtilBase.consumeToken((PsiBuilder)builder, (String)"$action", (boolean)true)) {
            return SQL_SPECIAL_LITERAL;
        }
        return super.parseLiteralOther(builder, level);
    }

    @Override
    public boolean parseSqlStatement(PsiBuilder builder, int level) {
        boolean result2 = MssqlGeneratedParser.statement(builder, level);
        if (!SqlParserUtil.nextTokenIs(builder, (IElementType)SQL_SEMICOLON)) {
            this.statementSeparatorParsed();
        }
        return result2;
    }

    @Override
    public boolean parseEvaluableExpression(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.parseAndRemapToGenericReference(builder, level, MssqlExpressionParsing::evaluable_expression);
    }

    @Override
    protected TokenSet[] getExtendsTokenSets() {
        return MssqlGeneratedParser.EXTENDS_SETS_;
    }

    @Override
    public boolean parseQueryExpression(PsiBuilder builder, int level) {
        return MssqlDmlParsing.top_query_expression(builder, level);
    }

    @Override
    public boolean parseDataType(PsiBuilder builder, int level, boolean ext) {
        return MssqlDdlParsing.type_element(builder, level);
    }

    @Override
    public boolean parseValueExpression(PsiBuilder builder, int level, boolean optional, boolean allowBoolean) {
        boolean result2 = MssqlExpressionParsing.value_expression(builder, level);
        if (!result2 && !optional) {
            builder.error("<expression> expected");
        }
        return result2;
    }

    @Override
    @Nullable
    protected IElementType getOdbcTokenType(@Nullable String text) {
        if (StringUtil.equalsIgnoreCase((CharSequence)text, (CharSequence)"guid")) {
            return ODBC_GENERIC;
        }
        return super.getOdbcTokenType(text);
    }

    @Override
    protected boolean allowNoStatementSeparator() {
        return true;
    }

    @Override
    protected boolean parseParameterReferenceInner(PsiBuilder builder, IElementType paramToken, IElementType resultType) {
        String tokenText = builder.getTokenText();
        String string = tokenText = tokenText == null ? null : tokenText.toUpperCase(Locale.ENGLISH);
        if (this.getLanguage().getSupportedFunctions().containsKey(tokenText)) {
            return false;
        }
        return super.parseParameterReferenceInner(builder, paramToken, resultType);
    }

    @Override
    public boolean parseFunctionParametersAndParens(PsiBuilder builder, int level, String functionName, SqlFunctionDefinition definition, boolean allowNoParens) {
        if (!super.parseFunctionParametersAndParens(builder, level, functionName, definition, allowNoParens)) {
            return false;
        }
        if ("OPENXML".equalsIgnoreCase(functionName) && GeneratedParserUtilBase.consumeTokenFast((PsiBuilder)builder, (IElementType)SQL_WITH) && !this.parseStringLiteral(builder)) {
            SqlParserUtil.consumeToken(builder, (IElementType)SQL_STRING_TOKEN);
        }
        if (MssqlParser.is(definition, "aggregate") || MssqlParser.is(definition, "rank")) {
            if (StringUtil.startsWithIgnoreCase((String)functionName, (String)"PERCENTILE")) {
                MssqlDmlParsing.within_group_clause(builder, level);
            }
            MssqlDmlParsing.analytic_clause(builder, level);
        }
        return true;
    }

    private static boolean is(@Nullable SqlFunctionDefinition def, @NotNull String type) {
        if (type == null) {
            MssqlParser.$$$reportNull$$$0(0);
        }
        if (def == null) {
            return false;
        }
        return "true".equals(def.getDialectAttribute(type));
    }

    @Override
    public boolean parseParenContentQorV(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict(builder, level, MssqlExpressionParsing::parenthesized_values_expr, MssqlDmlParsing::top_query_expression, MssqlParser::parseTopQueryExpressionTail, MssqlExpressionParsing::row_element_list, (b, l) -> MssqlExpressionParsing.root_expr_0(b, l, -1) && MssqlExpressionParsing.row_element_list_separator(b, l) && MssqlExpressionParsing.row_element_list(b, l));
    }

    @Override
    public boolean parseParenContentQorJ(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict(builder, level, MssqlDmlParsing::parenthesized_aliased_join_expression, MssqlDmlParsing::parenthesized_query_join_expression_inner, MssqlParser::parseTopQueryExpressionTail, (b, l) -> MssqlDmlParsing.join_expression(b, l, -1), (b, l) -> MssqlDmlParsing.join_expression_0(b, l, -1));
    }

    public static boolean parseTopQueryExpressionTail(PsiBuilder builder, int level) {
        MssqlDmlParsing.query_expression_0(builder, level, -1);
        return MssqlDmlParsing.left_inner_table_op_tail(builder, level);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/sql/dialects/mssql/MssqlParser", "is"));
    }
}

