/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.injection;

import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.sql.injection.SqlTypeBasedInjection;
import com.intellij.sql.injection.SqlTypeBasedInjector;
import com.intellij.sql.injection.SqlTypePanel;
import com.intellij.sql.psi.SqlElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JComponent;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.AbstractLanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlTypeBasedInjectionSupport
extends AbstractLanguageInjectionSupport {
    public static final String SUPPORT_ID = "sql";

    @NotNull
    public String getId() {
        if (SUPPORT_ID == null) {
            SqlTypeBasedInjectionSupport.$$$reportNull$$$0(0);
        }
        return SUPPORT_ID;
    }

    @NotNull
    public Class[] getPatternClasses() {
        if (ArrayUtil.EMPTY_CLASS_ARRAY == null) {
            SqlTypeBasedInjectionSupport.$$$reportNull$$$0(1);
        }
        return ArrayUtil.EMPTY_CLASS_ARRAY;
    }

    public AnAction[] createAddActions(final Project project, final Consumer<BaseInjection> consumer) {
        return new AnAction[]{new AnAction("Sql Type Injection", null, DatabaseIcons.Sql){

            public void actionPerformed(AnActionEvent e) {
                SqlTypeBasedInjection newInjection = SqlTypeBasedInjectionSupport.showInjectionUI(project, new SqlTypeBasedInjection());
                if (newInjection != null) {
                    consumer.consume((Object)newInjection);
                }
            }
        }};
    }

    public boolean isApplicableTo(PsiLanguageInjectionHost host) {
        return host instanceof SqlElement;
    }

    public boolean configureInjectionForTypes(@NotNull Project project, @NotNull Language lang, @NotNull Set<String> types) {
        Pattern pattern;
        if (project == null) {
            SqlTypeBasedInjectionSupport.$$$reportNull$$$0(2);
        }
        if (lang == null) {
            SqlTypeBasedInjectionSupport.$$$reportNull$$$0(3);
        }
        if (types == null) {
            SqlTypeBasedInjectionSupport.$$$reportNull$$$0(4);
        }
        if (types.isEmpty()) {
            return false;
        }
        SqlTypeBasedInjection injection = new SqlTypeBasedInjection();
        injection.generatePlaces();
        injection.setInjectedLanguageId(lang.getID());
        injection.setPlaceEnabled(null, true);
        String patternStr = StringUtil.join(types, (String)"|");
        try {
            pattern = Pattern.compile(patternStr);
        }
        catch (PatternSyntaxException e) {
            patternStr = StringUtil.join(types, Pattern::quote, (String)"|");
            pattern = Pattern.compile(patternStr);
        }
        injection.setDisplayName(patternStr);
        injection.setPattern(pattern);
        SqlTypeBasedInjection res = SqlTypeBasedInjectionSupport.showInjectionUI(project, injection);
        if (res != null) {
            SqlTypeBasedInjectionSupport.doAddInjection(project, res);
            return true;
        }
        return false;
    }

    public boolean editInjectionInPlace(PsiLanguageInjectionHost psiElement) {
        Project project = psiElement.getProject();
        Configuration configuration = InjectorUtils.getEditableInstance((Project)project);
        SqlTypeBasedInjection injection = SqlTypeBasedInjectionSupport.findUsedInjection(psiElement);
        if (injection == null) {
            return false;
        }
        SqlTypeBasedInjection result2 = SqlTypeBasedInjectionSupport.showInjectionUI(project, injection.copy());
        if (result2 != null) {
            configuration.replaceInjectionsWithUndo(project, Collections.singletonList(result2), Collections.singletonList(injection), Collections.emptyList());
        }
        return true;
    }

    @Nullable
    private static SqlTypeBasedInjection findUsedInjection(PsiLanguageInjectionHost psiElement) {
        if (SqlTypeBasedInjector.isInjectedByComment(psiElement)) {
            return null;
        }
        Set<String> types = SqlTypeBasedInjector.getTypesFor(psiElement);
        if (types.isEmpty() || types.size() > 1) {
            return null;
        }
        String type = types.iterator().next();
        Project project = psiElement.getProject();
        Configuration configuration = InjectorUtils.getEditableInstance((Project)project);
        return (SqlTypeBasedInjection)((Object)JBIterable.from((Iterable)configuration.getInjections(SUPPORT_ID)).filter(SqlTypeBasedInjection.class).filter(i2 -> i2.getPattern().matcher(type).matches()).first());
    }

    public boolean removeInjectionInPlace(PsiLanguageInjectionHost psiElement) {
        Project project = psiElement.getProject();
        Configuration configuration = InjectorUtils.getEditableInstance((Project)project);
        SqlTypeBasedInjection injection = SqlTypeBasedInjectionSupport.findUsedInjection(psiElement);
        if (injection == null) {
            return false;
        }
        configuration.replaceInjectionsWithUndo(project, Collections.emptyList(), Collections.singletonList(injection), Collections.emptyList());
        return true;
    }

    public BaseInjection createInjection(Element element) {
        return new SqlTypeBasedInjection();
    }

    public AnAction createEditAction(final Project project, final Factory<BaseInjection> producer) {
        return new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                SqlTypeBasedInjection newInjection = SqlTypeBasedInjectionSupport.showInjectionUI(project, (SqlTypeBasedInjection)((BaseInjection)producer.create()).copy());
                if (newInjection != null) {
                    ((BaseInjection)producer.create()).copyFrom((BaseInjection)newInjection);
                }
            }
        };
    }

    @Nullable
    private static SqlTypeBasedInjection showInjectionUI(Project project, SqlTypeBasedInjection injection) {
        DialogBuilder builder = new DialogBuilder(project);
        SqlTypePanel panel = new SqlTypePanel(injection, project);
        builder.setHelpId("reference.settings.injection.language.injection.settings.sql.type");
        panel.reset();
        builder.addOkAction();
        builder.addCancelAction();
        builder.setCenterPanel((JComponent)panel.getComponent());
        builder.setTitle("Language Injection Settings");
        builder.setOkOperation(() -> {
            panel.apply();
            builder.getDialogWrapper().close(0);
        });
        builder.setDimensionServiceKey(SqlTypeBasedInjectionSupport.class.getName());
        if (builder.show() == 0) {
            return injection.copy();
        }
        return null;
    }

    private static void doAddInjection(Project project, SqlTypeBasedInjection template) {
        Configuration configuration = InjectorUtils.getEditableInstance((Project)project);
        SqlTypeBasedInjection originalInjection = (SqlTypeBasedInjection)configuration.findExistingInjection((BaseInjection)template);
        SqlTypeBasedInjection newInjection = originalInjection == null || !originalInjection.equals((Object)template) ? template : originalInjection.copy();
        configuration.replaceInjectionsWithUndo(project, Collections.singletonList(newInjection), Collections.emptyList(), Collections.emptyList());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/injection/SqlTypeBasedInjectionSupport";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lang";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatternClasses";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/injection/SqlTypeBasedInjectionSupport";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "configureInjectionForTypes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

