/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlEditorAwareFix;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlAlterTableInstruction;
import com.intellij.sql.psi.SqlAlterTableStatement;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlTableKeyDefinition;
import com.intellij.sql.psi.impl.SqlImplUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlAddNotNullColumnInspection
extends SqlInspectionBase {
    @Override
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, final boolean onTheFly) {
        if (dialect == null) {
            SqlAddNotNullColumnInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SqlAddNotNullColumnInspection.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            SqlAddNotNullColumnInspection.$$$reportNull$$$0(2);
        }
        if (dialect.getDatabaseDialect().getFamilyId() == DatabaseFamilyId.UNKNOWN) {
            return null;
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2){

            public void visitSqlAlterTableStatement(SqlAlterTableStatement o) {
                for (SqlAlterTableInstruction instruction : o.getAlterTableInstructions()) {
                    IElementType type = instruction.getInstructionType();
                    if (type != SqlCommonKeywords.SQL_ADD) {
                        return;
                    }
                    for (PsiElement e : instruction.getChildren()) {
                        boolean pkWithoutAutoInc;
                        if (!(e instanceof SqlColumnDefinition)) continue;
                        ASTNode nullConstraint = e.getNode().findChildByType((IElementType)SqlCompositeElementTypes.SQL_NULLABLE_CONSTRAINT_DEFINITION);
                        ASTNode notNullConstraint = e.getNode().findChildByType((IElementType)SqlCompositeElementTypes.SQL_NOT_NULL_CONSTRAINT_DEFINITION);
                        ASTNode defaultConstraint = e.getNode().findChildByType((IElementType)SqlCompositeElementTypes.SQL_DEFAULT_CONSTRAINT_DEFINITION);
                        SqlTableKeyDefinition pkDefinition = ((SqlColumnDefinition)e).getPrimaryKey();
                        DatabaseFamilyId familyId = this.myDialect.getFamilyId();
                        boolean pkExists = pkDefinition != null;
                        boolean autoInc = SqlImplUtil.isAutoVal((SqlColumnDefinition)e);
                        boolean notNullWithoutDefault = notNullConstraint != null && defaultConstraint == null && !familyId.isMysql() && !familyId.isDb2();
                        boolean notNullAlone = notNullConstraint != null && defaultConstraint == null && nullConstraint == null && familyId.isDb2();
                        boolean bl = pkWithoutAutoInc = pkExists && !autoInc;
                        if (!notNullWithoutDefault && !notNullAlone && !pkWithoutAutoInc) continue;
                        this.addDescriptor(this.myManager.createProblemDescriptor(e, "The column can not be added because it's mandatory (not null) but unknown how to fill it for the existing rows.", (LocalQuickFix)(!pkExists && onTheFly ? new AddDefaultFix((SqlColumnDefinition)e, this.myDialect) : null), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                    }
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "dialect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/sql/inspections/SqlAddNotNullColumnInspection";
        objectArray[2] = "createAnnotationVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class AddDefaultFix
    extends SqlEditorAwareFix<SqlColumnDefinition> {
        private final SqlLanguageDialect myLanguage;

        public AddDefaultFix(SqlColumnDefinition element, SqlLanguageDialect language) {
            super(element);
            this.myLanguage = language;
        }

        @Override
        @NotNull
        public String getText() {
            if ("Add default value" == null) {
                AddDefaultFix.$$$reportNull$$$0(0);
            }
            return "Add default value";
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void applyFix(@NotNull Project project, @NotNull SqlColumnDefinition element, @Nullable Editor editor) {
            if (project == null) {
                AddDefaultFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                AddDefaultFix.$$$reportNull$$$0(2);
            }
            if (editor == null) {
                return;
            }
            TemplateManager templateManager = TemplateManager.getInstance((Project)project);
            Template template = templateManager.createTemplate("", "");
            template.addTextSegment(" default ");
            template.addVariable("value", (Expression)new ConstantNode(""), true);
            template.setToReformat(true);
            DatabaseFamilyId familyId = this.myLanguage.getDatabaseDialect().getFamilyId();
            if (familyId.isHsqldb() || familyId.isSybase() || familyId.isOracle()) {
                ASTNode notNullConstraint = element.getNode().findChildByType((IElementType)SqlCompositeElementTypes.SQL_NOT_NULL_CONSTRAINT_DEFINITION);
                if (notNullConstraint == null) return;
                editor.getCaretModel().moveToOffset(notNullConstraint.getTextRange().getStartOffset());
                template.addTextSegment(" ");
            } else {
                editor.getCaretModel().moveToOffset(element.getTextRange().getEndOffset());
            }
            templateManager.startTemplate(editor, template);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/SqlAddNotNullColumnInspection$AddDefaultFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/SqlAddNotNullColumnInspection$AddDefaultFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

