/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.dataSource.DataSourceSyncManager;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcPath;
import com.intellij.database.dataSource.srcStorage.DbSrcStorageDsMetadata;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcStorage;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcStorageManager;
import com.intellij.database.introspection.DBIntrospectorFactory;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.LoaderContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileSystemInterface;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlStorageInspection
extends LocalInspectionTool {
    public static final Key<Boolean> IGNORE_UNSAVED = Key.create((String)"IGNORE_UNSAVED");
    private static final LocalQuickFix[] OLD_STAGING_FIXES = new LocalQuickFix[]{new RevertFix(), new KeepModifiedFix()};
    private static final LocalQuickFix[] INVALID_SOURCES_FIXES = new LocalQuickFix[]{new ReintrospectFix()};

    public SqlStorageInspection() {
        boolean a = true;
    }

    @NotNull
    public String getShortName() {
        if ("SqlStorageInspection" == null) {
            SqlStorageInspection.$$$reportNull$$$0(0);
        }
        return "SqlStorageInspection";
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            SqlStorageInspection.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            SqlStorageInspection.$$$reportNull$$$0(2);
        }
        VirtualFile vfile = file.getVirtualFile();
        if (!isOnTheFly || !DbSrcUtils.isDbSrcFile(vfile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ProblemDescriptor oldStaging = SqlStorageInspection.checkOldStaging(file, manager, vfile);
        ProblemDescriptor invalidSources = SqlStorageInspection.checkInvalidSources(file, manager, vfile);
        if (oldStaging == null && invalidSources == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        if (oldStaging == null) {
            return (ProblemDescriptor[])ContainerUtil.ar((Object[])new ProblemDescriptor[]{invalidSources});
        }
        if (invalidSources == null) {
            return (ProblemDescriptor[])ContainerUtil.ar((Object[])new ProblemDescriptor[]{oldStaging});
        }
        return (ProblemDescriptor[])ContainerUtil.ar((Object[])new ProblemDescriptor[]{oldStaging, invalidSources});
    }

    @Nullable
    private static ProblemDescriptor checkOldStaging(@NotNull PsiFile file, @NotNull InspectionManager manager, VirtualFile vfile) {
        if (file == null) {
            SqlStorageInspection.$$$reportNull$$$0(3);
        }
        if (manager == null) {
            SqlStorageInspection.$$$reportNull$$$0(4);
        }
        if (SqlStorageInspection.isUnsaved(vfile)) {
            return null;
        }
        DbSrcFileSystem fs = DbSrcFileSystem.getInstance();
        VirtualFile staging = fs.getBaseFile(vfile, true);
        if (staging == null) {
            return null;
        }
        VirtualFile base = fs.getBaseFile(vfile, false);
        if (base == null || base.getTimeStamp() <= staging.getTimeStamp()) {
            return null;
        }
        return manager.createProblemDescriptor((PsiElement)file, "Object has changed in database", true, OLD_STAGING_FIXES, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    @Nullable
    private static ProblemDescriptor checkInvalidSources(final @NotNull PsiFile file, final @NotNull InspectionManager manager, VirtualFile vfile) {
        if (file == null) {
            SqlStorageInspection.$$$reportNull$$$0(5);
        }
        if (manager == null) {
            SqlStorageInspection.$$$reportNull$$$0(6);
        }
        return DbSrcFileSystem.processPath(vfile, new DbSrcFileSystem.ItemProcessor<ProblemDescriptor>(){

            @Override
            public ProblemDescriptor processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull DbSrcPath path, boolean original) {
                BasicModel model;
                DbSrcStorage layout;
                DbSrcStorageDsMetadata.MetaData res;
                if (dataSourceId == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (path == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((res = (layout = DbSrcStorageManager.getInstance(project).getStorage(dataSourceId, true)).getMetaData(path)) == null) {
                    return null;
                }
                LocalDataSource dataSource = DbSrcUtils.findDataSource(project, dataSourceId);
                if (dataSource == null) {
                    return null;
                }
                BasicSourceAware object = DbSrcUtils.findObject(path, dataSource.getModel(), BasicSourceAware.class, true);
                BasicModel basicModel = model = object == null ? null : object.getModel();
                if (model == null) {
                    return null;
                }
                int version = DBIntrospectorFactory.getCurrentSrcIntrospectionVersion(model.getRdbms(), object.getKind());
                if (res.introContentVersion == version) {
                    return null;
                }
                return manager.createProblemDescriptor((PsiElement)file, "Object source code may be invalid.", true, INVALID_SOURCES_FIXES, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "dataSourceId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "path";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/sql/inspections/SqlStorageInspection$1";
                objectArray[2] = "processFile";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static boolean isUnsaved(VirtualFile vfile) {
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        Document document = documentManager.getDocument(vfile);
        return documentManager.isFileModified(vfile) && !Boolean.TRUE.equals(IGNORE_UNSAVED.get((UserDataHolder)document));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/inspections/SqlStorageInspection";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/inspections/SqlStorageInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkOldStaging";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkInvalidSources";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class KeepModifiedFix
    extends IntentionAndQuickFixAction {
        private KeepModifiedFix() {
        }

        @NotNull
        public String getName() {
            if ("Keep modified" == null) {
                KeepModifiedFix.$$$reportNull$$$0(0);
            }
            return "Keep modified";
        }

        @NotNull
        public String getFamilyName() {
            if ("Keep modified" == null) {
                KeepModifiedFix.$$$reportNull$$$0(1);
            }
            return "Keep modified";
        }

        public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor) {
            VirtualFile vfile;
            if (project == null) {
                KeepModifiedFix.$$$reportNull$$$0(2);
            }
            if (!DbSrcUtils.isDbSrcFile(vfile = file.getVirtualFile())) {
                return;
            }
            DbSrcFileSystem fs = DbSrcFileSystem.getInstance();
            VirtualFile staging = fs.getBaseFile(vfile, true);
            if (staging == null) {
                return;
            }
            VirtualFile base = fs.getBaseFile(vfile, false);
            if (base == null) {
                return;
            }
            FileSystemInterface stagingFs = (FileSystemInterface)ObjectUtils.tryCast((Object)staging.getFileSystem(), FileSystemInterface.class);
            if (stagingFs == null) {
                return;
            }
            try {
                stagingFs.setTimeStamp(staging, base.getTimeStamp());
                VfsUtil.markDirty((boolean)false, (boolean)false, (VirtualFile[])new VirtualFile[]{staging, vfile});
                DbSrcUtils.refresh();
                FileContentUtilCore.reparseFiles((VirtualFile[])new VirtualFile[]{vfile});
            }
            catch (IOException e) {
                DatabaseNotifications.REFACTORING_GROUP.createNotification("Failed to update staging file for " + vfile.getUrl(), MessageType.INFO).notify(file.getProject());
            }
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/SqlStorageInspection$KeepModifiedFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/SqlStorageInspection$KeepModifiedFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class RevertFix
    extends IntentionAndQuickFixAction {
        private RevertFix() {
        }

        @NotNull
        public String getName() {
            if ("Revert local changes" == null) {
                RevertFix.$$$reportNull$$$0(0);
            }
            return "Revert local changes";
        }

        @NotNull
        public String getFamilyName() {
            if ("Revert local changes" == null) {
                RevertFix.$$$reportNull$$$0(1);
            }
            return "Revert local changes";
        }

        public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor) {
            VirtualFile vfile;
            if (project == null) {
                RevertFix.$$$reportNull$$$0(2);
            }
            if (!DbSrcUtils.isDbSrcFile(vfile = file.getVirtualFile())) {
                return;
            }
            try {
                DbSrcUtils.revert((Iterable<VirtualFile>)JBIterable.of((Object)vfile));
            }
            catch (IOException e) {
                DatabaseNotifications.REFACTORING_GROUP.createNotification("Failed to revert " + vfile.getUrl(), MessageType.INFO).notify(file.getProject());
            }
        }

        public boolean startInWriteAction() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/SqlStorageInspection$RevertFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/SqlStorageInspection$RevertFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ReintrospectFix
    extends IntentionAndQuickFixAction {
        private ReintrospectFix() {
        }

        @NotNull
        public String getName() {
            if ("Synchronize" == null) {
                ReintrospectFix.$$$reportNull$$$0(0);
            }
            return "Synchronize";
        }

        @NotNull
        public String getFamilyName() {
            if ("Synchronize" == null) {
                ReintrospectFix.$$$reportNull$$$0(1);
            }
            return "Synchronize";
        }

        public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, PsiFile file) {
            VirtualFile vfile;
            if (project == null) {
                ReintrospectFix.$$$reportNull$$$0(2);
            }
            LocalDataSource dataSource = DbSrcUtils.isDbSrcFile(vfile = file.getVirtualFile()) ? DbSrcUtils.findDataSource(vfile) : null;
            return dataSource != null && DbImplUtil.canConnectTo(dataSource) && DataSourceSyncManager.getInstance().isAbleToPerform(dataSource);
        }

        public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor) {
            VirtualFile vfile;
            LocalDataSource dataSource;
            if (project == null) {
                ReintrospectFix.$$$reportNull$$$0(3);
            }
            LocalDataSource localDataSource = dataSource = DbSrcUtils.isDbSrcFile(vfile = file.getVirtualFile()) ? DbSrcUtils.findDataSource(vfile) : null;
            if (dataSource == null) {
                return;
            }
            DasObject object = DbSrcUtils.findLocalDsObject(vfile.getPath(), DasObject.class, false);
            LoaderContext context = new LoaderContext(project, dataSource);
            if (object == null) {
                context.includeAllSchemas();
            } else {
                context.include(object);
            }
            DataSourceUiUtil.performManualSyncTask(context);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/SqlStorageInspection$ReintrospectFix";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/SqlStorageInspection$ReintrospectFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

