/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.model.DasArgument;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LazyParseableElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlMessages;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlReturnsClause;
import com.intellij.sql.psi.SqlVariableDefinition;
import com.intellij.sql.psi.impl.SqlBlockStatementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlObjectAttributeDefinitionImpl;
import com.intellij.sql.psi.impl.SqlProcedureDefinitionImpl;
import com.intellij.sql.psi.impl.SqlStatementImpl;
import com.intellij.util.ObjectUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlUnusedVariableInspection
extends SqlInspectionBase {
    @NotNull
    public String getDisplayName() {
        String string = SqlMessages.message("inspection.name.unused", new Object[0]);
        if (string == null) {
            SqlUnusedVariableInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(final @NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, final boolean onTheFly) {
        if (dialect == null) {
            SqlUnusedVariableInspection.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            SqlUnusedVariableInspection.$$$reportNull$$$0(2);
        }
        if (result2 == null) {
            SqlUnusedVariableInspection.$$$reportNull$$$0(3);
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2){

            public void visitSqlVariableDefinition(SqlVariableDefinition o) {
                PsiElement body;
                if (o instanceof SqlReturnsClause || o instanceof SqlObjectAttributeDefinitionImpl) {
                    return;
                }
                if (dialect.getFamilyId().isPostgres() && o instanceof DasArgument && ((DasArgument)o).getArgumentDirection() == DasArgument.Direction.OUT) {
                    return;
                }
                PsiElement scope = PsiTreeUtil.getParentOfType((PsiElement)o, (Class[])new Class[]{PsiFile.class, SqlCreateStatement.class, SqlProcedureDefinitionImpl.class, SqlBlockStatementImpl.class});
                if (scope == null) {
                    return;
                }
                if (scope instanceof SqlProcedureDefinitionImpl && ((body = (PsiElement)SqlImplUtil.sqlChildren(scope).filter(Conditions.instanceOf((Class[])new Class[]{SqlStatementImpl.class, LazyParseableElement.class})).first()) == null || body instanceof LazyParseableElement && SqlImplUtil.sqlChildren(body).filter(LazyParseableElement.class).isEmpty())) {
                    return;
                }
                if (o.getNode().getElementType() == SqlCompositeElementTypes.SQL_PARAMETER_DEFINITION && !(scope instanceof SqlCreateStatement) && !(scope instanceof SqlProcedureDefinitionImpl)) {
                    return;
                }
                Ref found = Ref.create((Object)false);
                ReferencesSearch.search((PsiElement)o, (SearchScope)o.getUseScope()).forEach(ref -> {
                    if (ref.getElement() == o) {
                        return true;
                    }
                    found.set((Object)true);
                    return false;
                });
                if (((Boolean)found.get()).booleanValue()) {
                    return;
                }
                PsiElement element = (PsiElement)ObjectUtils.chooseNotNull((Object)o.getNameElement(), (Object)o);
                this.addDescriptor(this.myManager.createProblemDescriptor(element, StringUtil.capitalize((String)StringUtil.toLowerCase((String)o.getKind().name())) + " " + o.getName() + " is never used", true, ProblemHighlightType.LIKE_UNUSED_SYMBOL, onTheFly, new LocalQuickFix[0]));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/inspections/SqlUnusedVariableInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/inspections/SqlUnusedVariableInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotationVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

