/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.TextWithRanges;
import com.intellij.formatting.Block;
import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormatterEx;
import com.intellij.formatting.FormattingModel;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.SqlDialectMappings;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.formatter.SqlFormattingModelBuilder;
import com.intellij.sql.formatter.SqlPreFormatProcessor;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.fragments.SqlCodeFragmentImpl;
import com.intellij.sql.script.SqlReader;
import com.intellij.sql.script.SqlReaderImpl;
import com.intellij.sql.script.SqlScriptModel;
import com.intellij.util.text.TextRangeUtil;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlPsiFacadeImpl
extends SqlPsiFacade {
    private final Project myProject;

    public SqlPsiFacadeImpl(Project project) {
        this.myProject = project;
    }

    @NotNull
    public SqlLanguageDialect getDefaultDialect() {
        SqlLanguageDialect sqlLanguageDialect = SqlDialectMappings.getMapping(this.myProject, null);
        if (sqlLanguageDialect == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(0);
        }
        return sqlLanguageDialect;
    }

    public void setDialectMapping(@NotNull VirtualFile file, @NotNull SqlLanguageDialect dialect) {
        if (file == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(1);
        }
        if (dialect == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(2);
        }
        SqlDialectMappings.getInstance(this.myProject).setMapping(file, dialect);
    }

    @NotNull
    public SqlLanguageDialect getDialectMapping(@NotNull VirtualFile file) {
        if (file == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(3);
        }
        SqlLanguageDialect sqlLanguageDialect = SqlDialectMappings.getInstance(this.myProject).getMapping(file);
        if (sqlLanguageDialect == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(4);
        }
        return sqlLanguageDialect;
    }

    @NotNull
    public SqlScriptModel createScriptModel(@NotNull PsiFile file) {
        if (file == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(5);
        }
        SqlScriptModel sqlScriptModel = new SqlScriptModel(file);
        if (sqlScriptModel == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(6);
        }
        return sqlScriptModel;
    }

    @NotNull
    public SqlReader createSqlReader() {
        SqlReaderImpl sqlReaderImpl = new SqlReaderImpl(this.myProject);
        if (sqlReaderImpl == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(7);
        }
        return sqlReaderImpl;
    }

    @NotNull
    public CharSequence format(@NotNull Project project, @NotNull SqlLanguageDialect dialect, @NotNull TextWithRanges textWithRanges) {
        if (project == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(8);
        }
        if (dialect == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(9);
        }
        if (textWithRanges == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(10);
        }
        CommonCodeStyleSettings sqlSettings = CodeStyleSettingsManager.getSettings((Project)project).getCommonSettings((Language)dialect);
        FormattingModel model = SqlFormattingModelBuilder.createDocumentFormattingModel(project, dialect, sqlSettings.getRootSettings(), textWithRanges);
        SqlPsiFacadeImpl.format(project, dialect, sqlSettings, model);
        CharSequence charSequence = model.getDocumentModel().getDocument().getImmutableCharSequence();
        if (charSequence == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(11);
        }
        return charSequence;
    }

    public void format(@NotNull Project project, @NotNull SqlLanguageDialect dialect, @NotNull Document document) {
        if (project == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(12);
        }
        if (dialect == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(13);
        }
        if (document == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(14);
        }
        CommonCodeStyleSettings sqlSettings = CodeStyleSettingsManager.getSettings((Project)project).getCommonSettings((Language)dialect);
        FormattingModel model = SqlFormattingModelBuilder.createModel(project, dialect, sqlSettings.getRootSettings(), document.getText(), document);
        SqlPsiFacadeImpl.format(project, dialect, sqlSettings, model);
    }

    private static void format(@NotNull Project project, @NotNull SqlLanguageDialect dialect, @NotNull CommonCodeStyleSettings sqlSettings, @NotNull FormattingModel model) {
        if (project == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(15);
        }
        if (dialect == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(16);
        }
        if (sqlSettings == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(17);
        }
        if (model == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(18);
        }
        CodeStyleSettings settings = sqlSettings.getRootSettings();
        Block rootBlock = model.getRootBlock();
        TextRange range = new SqlPreFormatProcessor().process(((AbstractBlock)rootBlock).getNode(), TextRange.create((int)0, (int)model.getDocumentModel().getTextLength()));
        Document document = model.getDocumentModel().getDocument();
        FormatTextRanges ranges = new FormatTextRanges();
        Iterable toProcess = TextRangeUtil.excludeRanges((TextRange)range, ((DocumentEx)document).getGuardedBlocks().stream().map(marker -> TextRange.create((int)marker.getStartOffset(), (int)marker.getEndOffset())).collect(Collectors.toList()));
        for (TextRange tr : toProcess) {
            ranges.add(tr, true);
        }
        model = SqlFormattingModelBuilder.createModel(project, dialect, settings, document.getCharsSequence(), document);
        FormatterEx.getInstance().format(model, settings, sqlSettings.getIndentOptions(), ranges);
    }

    @NotNull
    public PsiCodeFragment createTableReferenceFragment(@NotNull Language dialect, @Nullable DbDataSource context, @Nullable DbElement schemaElement, @NotNull String text) {
        if (dialect == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(19);
        }
        if (text == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(20);
        }
        SqlCodeFragmentImpl codeFragment = new SqlCodeFragmentImpl(this.myProject, (SqlLanguageDialect)dialect, (IElementType)SqlCompositeElementTypes.SQL_TABLE_REFERENCE, "dummy.sql", text, true);
        codeFragment.setContext((PsiElement)schemaElement);
        codeFragment.putUserData(DatabaseDataKeys.DATA_SOURCE_KEY, context);
        SqlCodeFragmentImpl sqlCodeFragmentImpl = codeFragment;
        if (sqlCodeFragmentImpl == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(21);
        }
        return sqlCodeFragmentImpl;
    }

    @NotNull
    public PsiCodeFragment createEvaluableExpressionFragment(@NotNull Language dialect, @Nullable DbDataSource dataSourceElement, @Nullable List<DasNamespace> searchPath, @NotNull String text) {
        if (dialect == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(22);
        }
        if (text == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(23);
        }
        SqlCodeFragmentImpl fragment = new SqlCodeFragmentImpl(this.myProject, (SqlLanguageDialect)dialect, SqlCompositeElementTypes.SQL_EVALUABLE_EXPRESSION, "dummy.sql", text, true);
        fragment.putUserData(DatabaseDataKeys.DATA_SOURCE_KEY, dataSourceElement);
        fragment.putUserData(DatabaseDataKeys.SEARCH_PATH_KEY, searchPath);
        SqlCodeFragmentImpl sqlCodeFragmentImpl = fragment;
        if (sqlCodeFragmentImpl == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(24);
        }
        return sqlCodeFragmentImpl;
    }

    @NotNull
    public PsiCodeFragment createTypeElementFragment(@NotNull Language dialect, @Nullable DbDataSource context, @Nullable List<DasNamespace> searchPath, @NotNull String text) {
        if (dialect == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(25);
        }
        if (text == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(26);
        }
        SqlCodeFragmentImpl codeFragment = new SqlCodeFragmentImpl(this.myProject, (SqlLanguageDialect)dialect, (IElementType)SqlCompositeElementTypes.SQL_TYPE_ELEMENT, "dummy.sql", text, true);
        codeFragment.putUserData(DatabaseDataKeys.DATA_SOURCE_KEY, context);
        codeFragment.putUserData(DatabaseDataKeys.SEARCH_PATH_KEY, searchPath);
        SqlCodeFragmentImpl sqlCodeFragmentImpl = codeFragment;
        if (sqlCodeFragmentImpl == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(27);
        }
        return sqlCodeFragmentImpl;
    }

    @NotNull
    public PsiCodeFragment createExpressionFragment(@NotNull Language dialect, @Nullable DbDataSource context, @Nullable List<DasNamespace> searchPath, @NotNull String text) {
        if (dialect == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(28);
        }
        if (text == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(29);
        }
        SqlCodeFragmentImpl codeFragment = new SqlCodeFragmentImpl(this.myProject, (SqlLanguageDialect)dialect, (IElementType)SqlCompositeElementTypes.SQL_EXPRESSION, "dummy.sql", text, true);
        codeFragment.putUserData(DatabaseDataKeys.DATA_SOURCE_KEY, context);
        codeFragment.putUserData(DatabaseDataKeys.SEARCH_PATH_KEY, searchPath);
        SqlCodeFragmentImpl sqlCodeFragmentImpl = codeFragment;
        if (sqlCodeFragmentImpl == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(30);
        }
        return sqlCodeFragmentImpl;
    }

    @NotNull
    public PsiCodeFragment createExpressionFragment(@NotNull Language dialect, @Nullable DbDataSource context, @Nullable List<DasNamespace> searchPath, @NotNull String text, @NotNull String contextQuery) {
        if (dialect == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(31);
        }
        if (text == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(32);
        }
        if (contextQuery == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(33);
        }
        SqlCodeFragmentImpl codeFragment = new SqlCodeFragmentImpl(this.myProject, (SqlLanguageDialect)dialect, (IElementType)SqlCompositeElementTypes.SQL_EXPRESSION, "dummy.sql", text, true);
        codeFragment.putUserData(DatabaseDataKeys.DATA_SOURCE_KEY, context);
        codeFragment.putUserData(DatabaseDataKeys.SEARCH_PATH_KEY, searchPath);
        SqlFile file = (SqlFile)PsiFileFactory.getInstance((Project)this.myProject).createFileFromText("a.sql", dialect, (CharSequence)contextQuery);
        file.putUserData(DatabaseDataKeys.DATA_SOURCE_KEY, (Object)context);
        file.putUserData(DatabaseDataKeys.SEARCH_PATH_KEY, searchPath);
        final Ref ref = Ref.create();
        file.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                if (element instanceof SqlQueryExpression) {
                    ref.set((Object)((SqlQueryExpression)element));
                } else {
                    super.visitElement(element);
                }
            }
        });
        if (!ref.isNull()) {
            codeFragment.setContext((PsiElement)ref.get());
        }
        SqlCodeFragmentImpl sqlCodeFragmentImpl = codeFragment;
        if (sqlCodeFragmentImpl == null) {
            SqlPsiFacadeImpl.$$$reportNull$$$0(34);
        }
        return sqlCodeFragmentImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/SqlPsiFacadeImpl";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 9: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 25: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 8: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textWithRanges";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqlSettings";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 20: 
            case 23: 
            case 26: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextQuery";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultDialect";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/SqlPsiFacadeImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialectMapping";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createScriptModel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createSqlReader";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "format";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createTableReferenceFragment";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createEvaluableExpressionFragment";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeElementFragment";
                break;
            }
            case 30: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "createExpressionFragment";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setDialectMapping";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDialectMapping";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createScriptModel";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "format";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createTableReferenceFragment";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createEvaluableExpressionFragment";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createTypeElementFragment";
                break;
            }
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createExpressionFragment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

