/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.Case;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlAltNamesProvider;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NameChecker {
    public final String sourceText;
    public final String sourceActual;
    public final Case sourceCase;
    public final boolean sourcePlain;
    public final SqlLanguageDialectEx dialect;
    public final CasingProvider casingProvider;

    public NameChecker(String sourceText, Case sourceCase, boolean sourcePlain, SqlLanguageDialectEx dialect, CasingProvider casingProvider) {
        this.dialect = dialect;
        this.sourceCase = sourceCase;
        this.sourcePlain = sourcePlain;
        this.sourceText = sourceText;
        this.casingProvider = casingProvider;
        this.sourceActual = sourceCase.apply(sourceText);
    }

    public NameChecker(@NotNull SqlReferenceExpression ref, SqlLanguageDialectEx dialect, CasingProvider provider) {
        if (ref == null) {
            NameChecker.$$$reportNull$$$0(0);
        }
        this.dialect = dialect;
        ObjectKind kind = ref.getReferenceElementType().getTargetKind();
        DasObject context = this.getDasContext(ref.getQualifierExpression());
        this.sourcePlain = !DbSqlUtil.isQuoted((SqlNameElement)ref);
        this.sourceText = ref.getName();
        this.casingProvider = provider;
        this.sourceCase = this.casingProvider.getCasing(kind, context).choose(this.sourcePlain);
        this.sourceActual = this.sourceCase.apply(this.sourceText);
    }

    NameChecker(@NotNull SqlReferenceImpl ref, SqlLanguageDialectEx dialect, CasingProvider provider) {
        if (ref == null) {
            NameChecker.$$$reportNull$$$0(1);
        }
        this.dialect = dialect;
        ObjectKind kind = ref.getReferenceElementType().getTargetKind();
        DasObject context = this.getDasContext(ref.getQualifierExpression());
        this.sourceText = ref.getReferenceName();
        this.sourcePlain = !DbSqlUtil.isQuoted((SqlNameElement)ObjectUtils.tryCast((Object)ref.getElement(), SqlNameElement.class));
        this.casingProvider = provider;
        this.sourceCase = this.casingProvider.getCasing(kind, context).choose(this.sourcePlain);
        this.sourceActual = this.sourceCase.apply(this.sourceText);
    }

    @Nullable
    protected DasObject getDasContext(@Nullable SqlExpression qualifier) {
        PsiReference reference = qualifier == null ? null : qualifier.getReference();
        PsiElement target = reference == null ? null : reference.resolve();
        return target instanceof DasObject ? (DasObject)target : null;
    }

    public boolean checkName(@Nullable Object target, @Nullable Boolean forcedCaseSens) {
        boolean caseSensitive;
        String[] altNames;
        if (target == null) {
            return false;
        }
        DasObject targetObject = (DasObject)ObjectUtils.tryCast((Object)target, DasObject.class);
        SqlReferenceExpression targetRef = (SqlReferenceExpression)ObjectUtils.tryCast((Object)target, SqlReferenceExpression.class);
        if (targetObject == null && targetRef == null) {
            throw new IllegalArgumentException(target.getClass().getName());
        }
        String name = targetObject != null ? targetObject.getName() : targetRef.getName();
        String[] stringArray = altNames = target instanceof SqlAltNamesProvider ? ((SqlAltNamesProvider)target).getAltNames() : ArrayUtil.EMPTY_STRING_ARRAY;
        if (!Comparing.strEqual((String)name, (String)this.sourceText, (boolean)false)) {
            String alt = null;
            for (String text : altNames) {
                if (!Comparing.strEqual((String)text, (String)this.sourceText, (boolean)false)) continue;
                alt = text;
                break;
            }
            if (alt == null) {
                return false;
            }
            name = alt;
        }
        DatabaseDialectEx databaseDialect = this.dialect.getDatabaseDialect();
        boolean isBuiltInFunction = target instanceof BuiltinFunction;
        if (isBuiltInFunction && databaseDialect.getFamilyId().isSybase()) {
            return true;
        }
        if (isBuiltInFunction && databaseDialect.getFamilyId().isTransactSql() && ((BuiltinFunction)target).getPostfixType() == null) {
            return this.sourcePlain;
        }
        boolean targetIsPlain = targetObject != null ? !DbSqlUtil.isQuoted(targetObject) : !DbSqlUtil.isQuoted((SqlNameElement)targetRef);
        Case targetCase = targetObject != null ? this.casingProvider.getCasing(targetObject.getKind(), targetObject).choose(targetIsPlain) : new NameChecker((SqlReferenceExpression)targetRef, (SqlLanguageDialectEx)this.dialect, (CasingProvider)this.casingProvider).sourceCase;
        String targetActual = SqlImplUtil.getActualName(target, name, targetIsPlain, this.casingProvider);
        if (forcedCaseSens != null) {
            return Comparing.strEqual((String)targetActual, (String)this.sourceActual, (forcedCaseSens == Boolean.TRUE ? 1 : 0) != 0);
        }
        if (isBuiltInFunction) {
            return Comparing.strEqual((String)targetActual, (String)this.sourceActual, (this.sourceCase == Case.EXACT && !this.sourcePlain ? 1 : 0) != 0);
        }
        boolean targetCaseSensitive = targetCase != Case.MIXED;
        boolean sourceCaseSensitive = this.sourceCase != Case.MIXED;
        boolean bl = caseSensitive = sourceCaseSensitive && targetCaseSensitive;
        return Comparing.strEqual((String)targetActual, (String)this.sourceActual, (boolean)caseSensitive);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/sql/psi/impl/NameChecker", "<init>"));
    }
}

