/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExtraDeclarationsProvider;
import com.intellij.sql.psi.SqlGroupByClause;
import com.intellij.sql.psi.SqlHavingClause;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.SqlWithClause;
import com.intellij.sql.psi.impl.SqlExpressionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SqlQueryExpressionImpl
extends SqlExpressionImpl
implements SqlQueryExpression {
    public SqlQueryExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            SqlQueryExpressionImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Override
    public void accept(SqlVisitor visitor) {
        visitor.visitSqlQueryExpression((SqlQueryExpression)this);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        SqlWithClause withClause;
        DatabaseFamilyId familyId;
        if (processor == null) {
            SqlQueryExpressionImpl.$$$reportNull$$$0(1);
        }
        if (state == null) {
            SqlQueryExpressionImpl.$$$reportNull$$$0(2);
        }
        if (place == null) {
            SqlQueryExpressionImpl.$$$reportNull$$$0(3);
        }
        SqlSelectClause selectClause = this.getSelectClause();
        SqlTableExpression tableExpression = this.getTableExpression();
        if (selectClause != null && lastParent != selectClause && (tableExpression == null || lastParent != tableExpression || !PsiTreeUtil.isAncestor((PsiElement)tableExpression, (PsiElement)place, (boolean)false) || ((familyId = SqlImplUtil.getSqlDialectSafe((PsiElement)this).getFamilyId()).isMysql() || familyId.isH2()) && PsiTreeUtil.getParentOfType((PsiElement)place, SqlHavingClause.class, (boolean)true, (Class[])new Class[]{SqlQueryExpression.class}) != null || (familyId.isMysql() || familyId.isPostgres() || familyId.isH2()) && PsiTreeUtil.getParentOfType((PsiElement)place, SqlGroupByClause.class, (boolean)true, (Class[])new Class[]{SqlQueryExpression.class}) != null) && !selectClause.processDeclarations(processor, state, lastParent, place)) {
            return false;
        }
        if (tableExpression != null && lastParent != tableExpression && !tableExpression.processDeclarations(processor, state, lastParent, place)) {
            return false;
        }
        for (SqlExtraDeclarationsProvider child : SqlImplUtil.childrenTreeIt((PsiElement)this).filter(SqlExtraDeclarationsProvider.class)) {
            if (child.processExtraDeclarations(processor, state, lastParent, place)) continue;
            return false;
        }
        PsiElement firstChild = this.getFirstChild();
        SqlWithClause sqlWithClause = withClause = firstChild instanceof SqlWithClause ? (SqlWithClause)firstChild : null;
        return withClause == null || firstChild.processDeclarations(processor, state, lastParent, place);
    }

    public SqlTableExpression getTableExpression() {
        return (SqlTableExpression)this.findChildByType((IElementType)SqlCompositeElementTypes.SQL_TABLE_EXPRESSION);
    }

    public SqlSelectClause getSelectClause() {
        return (SqlSelectClause)this.findChildByType((IElementType)SqlCompositeElementTypes.SQL_SELECT_CLAUSE);
    }

    @Override
    @NotNull
    public SqlType getSqlType() {
        SqlReferenceList refs;
        PsiElement flatten = this.findChildByType((IElementType)SqlCompositeElementTypes.SQL_QUERY_FLATTEN_CLAUSE);
        if (flatten != null) {
            SqlTableType sqlTableType = SqlTableTypeBase.ensureTableType(this.getSqlTypeForCategory(SqlType.Category.STRING), (SqlElement)flatten, null);
            if (sqlTableType == null) {
                SqlQueryExpressionImpl.$$$reportNull$$$0(4);
            }
            return sqlTableType;
        }
        SqlTableExpression tableExpression = this.getTableExpression();
        SqlSelectClause selectClause = this.getSelectClause();
        if (selectClause == null) {
            Object object = tableExpression == null ? SqlType.UNKNOWN : tableExpression.getSqlType();
            if (object == null) {
                SqlQueryExpressionImpl.$$$reportNull$$$0(5);
            }
            return object;
        }
        List expressions = selectClause.getExpressions();
        if (expressions.isEmpty() && (refs = (SqlReferenceList)PsiTreeUtil.getChildOfType((PsiElement)tableExpression, SqlReferenceList.class)) != null) {
            SqlTableType sqlTableType = tableExpression.getSqlType().alias(null, (PsiElement)tableExpression, refs.getReferenceList());
            if (sqlTableType == null) {
                SqlQueryExpressionImpl.$$$reportNull$$$0(6);
            }
            return sqlTableType;
        }
        SqlTableType sqlTableType = SqlImplUtil.getSelectType(expressions, (PsiElement)this);
        if (sqlTableType == null) {
            SqlQueryExpressionImpl.$$$reportNull$$$0(7);
        }
        return sqlTableType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlQueryExpressionImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlQueryExpressionImpl";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

