/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbTableKey;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.scope.BaseScopeProcessor;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReturningClause;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlScopeProcessor
extends BaseScopeProcessor {
    public static PsiScopeProcessor.Event EXPECTED_TYPE = new PsiScopeProcessor.Event(){};
    public static PsiScopeProcessor.Event STRICT_TYPE = new PsiScopeProcessor.Event(){};
    public static PsiScopeProcessor.Event RESOLVE_CONTEXT = new PsiScopeProcessor.Event(){};
    public final SqlLanguageDialectEx dialect;
    public final Iterable<DbDataSource> dataSources;
    public final boolean resolve;
    private Set<ObjectKind> myExpectedType = Collections.singleton(SqlDbElementType.ANY);
    private boolean myStrict = false;

    public SqlScopeProcessor(boolean resolve, SqlLanguageDialectEx dialect, Iterable<DbDataSource> dataSources) {
        this.dialect = dialect;
        this.dataSources = dataSources;
        this.resolve = resolve;
    }

    public abstract boolean isResultEmpty();

    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        if (element == null) {
            SqlScopeProcessor.$$$reportNull$$$0(0);
        }
        if (state == null) {
            SqlScopeProcessor.$$$reportNull$$$0(1);
        }
        return this.executeTarget(element instanceof DasObject ? (DasObject)element : null, element, null, null, state);
    }

    public abstract boolean executeTarget(@Nullable DasObject var1, @NotNull PsiElement var2, @Nullable SqlType var3, @Nullable Boolean var4, @NotNull ResolveState var5);

    protected boolean checkType(@NotNull Object element, @Nullable SqlType forcedSqlType) {
        if (element == null) {
            SqlScopeProcessor.$$$reportNull$$$0(2);
        }
        return this.checkType(element, forcedSqlType, this.myExpectedType, false);
    }

    protected boolean checkType(@NotNull Object element, @Nullable SqlType forcedSqlType, @NotNull Set<ObjectKind> forcedExpectedTypes, boolean acceptUnresolvedSynonyms) {
        if (element == null) {
            SqlScopeProcessor.$$$reportNull$$$0(3);
        }
        if (forcedExpectedTypes == null) {
            SqlScopeProcessor.$$$reportNull$$$0(4);
        }
        if (forcedSqlType instanceof SqlTableType) {
            return true;
        }
        if (SqlType.Category.REFERENCE.is(forcedSqlType)) {
            return true;
        }
        if (forcedSqlType != null) {
            return this.myExpectedType.contains(SqlDbElementType.COLUMN) || this.myExpectedType.contains(SqlDbElementType.VARIABLE);
        }
        return SqlScopeProcessor.acceptsElement(element, this.dialect, forcedExpectedTypes, this.myStrict, acceptUnresolvedSynonyms);
    }

    public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
        if (event == null) {
            SqlScopeProcessor.$$$reportNull$$$0(5);
        }
        if (event == EXPECTED_TYPE) {
            this.myExpectedType = (Set)associated;
        } else if (event == STRICT_TYPE) {
            this.myStrict = (Boolean)associated;
        } else {
            super.handleEvent(event, associated);
        }
    }

    @NotNull
    public Set<ObjectKind> getExpectedTypes() {
        Set<ObjectKind> set = this.myExpectedType;
        if (set == null) {
            SqlScopeProcessor.$$$reportNull$$$0(6);
        }
        return set;
    }

    public static boolean acceptsElement(@NotNull Object element, @NotNull SqlLanguageDialect dialect, @NotNull Set<ObjectKind> expectedTypes, boolean strict, boolean acceptUnresolvedSynonyms) {
        IStubElementType elementType;
        if (element == null) {
            SqlScopeProcessor.$$$reportNull$$$0(7);
        }
        if (dialect == null) {
            SqlScopeProcessor.$$$reportNull$$$0(8);
        }
        if (expectedTypes == null) {
            SqlScopeProcessor.$$$reportNull$$$0(9);
        }
        if (expectedTypes.contains(SqlDbElementType.ANY)) {
            return true;
        }
        ObjectKind t = SqlScopeProcessor.getElementType(element);
        if (t == ObjectKind.SYNONYM && !expectedTypes.contains(t) && element instanceof DasObject && (t = SqlImplUtil.getKindSynonymAware((DasObject)element)) == SqlDbElementType.ANY && acceptUnresolvedSynonyms) {
            return true;
        }
        if (expectedTypes.contains(t)) {
            return true;
        }
        if (t == SqlDbElementType.LOCAL_ALIAS) {
            if (expectedTypes.contains(SqlDbElementType.TABLE) || expectedTypes.contains(SqlDbElementType.VARIABLE)) {
                return true;
            }
            if (expectedTypes.contains(SqlDbElementType.COLUMN)) {
                PsiElement parent;
                PsiElement psiElement = parent = element instanceof PsiElement ? ((PsiElement)element).getParent() : null;
                if (parent instanceof SqlSelectClause || parent instanceof SqlReturningClause || element instanceof SqlFileImpl.FakeDefinition) {
                    return true;
                }
            }
        }
        if (strict) {
            return false;
        }
        if ((t == SqlDbElementType.KEY || t == SqlDbElementType.FOREIGN_KEY || t == SqlDbElementType.CHECK) && expectedTypes.contains(SqlDbElementType.CONSTRAINT)) {
            return true;
        }
        if (t == SqlDbElementType.KEY && expectedTypes.contains(SqlDbElementType.INDEX) && (element instanceof StubBasedPsiElement ? (elementType = ((StubBasedPsiElement)element).getElementType()) == SqlCompositeElementTypes.SQL_UNIQUE_KEY_DEFINITION || elementType == SqlCompositeElementTypes.SQL_PRIMARY_KEY_DEFINITION : element instanceof DbTableKey && ((DbTableKey)element).isPrimary())) {
            return true;
        }
        if ((t == SqlDbElementType.VARIABLE || t == SqlDbElementType.ARGUMENT || t == SqlDbElementType.OBJECT_ATTRIBUTE) && expectedTypes.contains(SqlDbElementType.COLUMN)) {
            return true;
        }
        if (t == SqlDbElementType.ARGUMENT && (expectedTypes.contains(SqlDbElementType.VARIABLE) || expectedTypes.contains(SqlDbElementType.TABLE) || expectedTypes.contains(SqlDbElementType.CURSOR))) {
            return true;
        }
        if (t == SqlDbElementType.COLUMN && expectedTypes.contains(SqlDbElementType.VARIABLE)) {
            return true;
        }
        if (t == SqlDbElementType.VARIABLE && (expectedTypes.contains(SqlDbElementType.COLUMN) || expectedTypes.contains(SqlDbElementType.TABLE) || expectedTypes.contains(SqlDbElementType.CURSOR))) {
            return true;
        }
        if (t == SqlDbElementType.SEQUENCE && expectedTypes.contains(SqlDbElementType.TABLE)) {
            return true;
        }
        if ((t == SqlDbElementType.TABLE || t == SqlDbElementType.VIEW || t == SqlDbElementType.MAT_VIEW) && expectedTypes.contains(SqlDbElementType.OBJECT_TYPE)) {
            return true;
        }
        if (t == SqlDbElementType.DOMAIN && expectedTypes.contains(SqlDbElementType.OBJECT_TYPE)) {
            return true;
        }
        if ((t == SqlDbElementType.VIEW || t == SqlDbElementType.MAT_VIEW) && expectedTypes.contains(SqlDbElementType.TABLE)) {
            return true;
        }
        if (t == SqlDbElementType.PACKAGE && expectedTypes.contains(SqlDbElementType.SCHEMA)) {
            return true;
        }
        if (t == SqlDbElementType.USER && expectedTypes.contains(SqlDbElementType.ROLE)) {
            return true;
        }
        if (element instanceof PsiElement && dialect.isResolveTargetAccepted((PsiElement)element, t, expectedTypes)) {
            return true;
        }
        return t == SqlDbElementType.CURSOR && expectedTypes.contains(SqlDbElementType.VARIABLE);
    }

    @NotNull
    public static ObjectKind getElementType(@Nullable Object o) {
        ObjectKind objectKind = o instanceof SqlFunctionCallExpression ? SqlScopeProcessor.getElementType(((SqlFunctionCallExpression)o).getNameElement()) : (o instanceof SqlReferenceExpression ? SqlScopeProcessor.getElementType((SqlReferenceExpression)o) : (o instanceof DasObject ? ((DasObject)o).getKind() : SqlDbElementType.ANY));
        if (objectKind == null) {
            SqlScopeProcessor.$$$reportNull$$$0(10);
        }
        return objectKind;
    }

    @NotNull
    private static ObjectKind getElementType(@Nullable SqlReferenceExpression o) {
        ObjectKind objectKind = o == null ? SqlDbElementType.ANY : o.getReferenceElementType().getTargetKind();
        if (objectKind == null) {
            SqlScopeProcessor.$$$reportNull$$$0(11);
        }
        return objectKind;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forcedExpectedTypes";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 6: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlScopeProcessor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlScopeProcessor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedTypes";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handleEvent";
                break;
            }
            case 6: 
            case 10: 
            case 11: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "acceptsElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

