/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.DataType;
import com.intellij.database.model.LengthUnit;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.util.DasUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlColumnDefinitionImpl;
import com.intellij.sql.psi.impl.SqlCompositeElementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlKeywordTokenType;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.impl.SqlTypeFactory;
import com.intellij.sql.psi.impl.TableBasedSqlTableTypeImpl;
import com.intellij.util.ObjectUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlTypeElementImpl
extends SqlCompositeElementImpl
implements SqlTypeElement {
    private DataType myDataType;

    public SqlTypeElementImpl(@NotNull ASTNode node) {
        if (node == null) {
            SqlTypeElementImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Override
    public void accept(SqlVisitor visitor) {
        visitor.visitSqlTypeElement((SqlTypeElement)this);
    }

    public void subtreeChanged() {
        super.subtreeChanged();
        this.myDataType = null;
    }

    @NotNull
    public DataType getDataType() {
        if (this.myDataType == null) {
            this.myDataType = new DataTypeParser(this).parse();
        }
        DataType dataType = this.myDataType;
        if (dataType == null) {
            SqlTypeElementImpl.$$$reportNull$$$0(1);
        }
        return dataType;
    }

    @NotNull
    public SqlType findSqlType() {
        if (this.findChildByType((IElementType)SqlCommonKeywords.SQL_TABLE) != null) {
            List columns2 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this, SqlColumnDefinitionImpl.class);
            if (columns2.isEmpty()) {
                SqlExpression expr = (SqlExpression)PsiTreeUtil.getChildOfType((PsiElement)this, SqlExpression.class);
                SqlTableType sqlTableType = expr != null ? SqlTableTypeBase.ensureTableType(expr.getSqlType(), (SqlElement)this, null) : SqlTableTypeBase.EMPTY_TABLE;
                if (sqlTableType == null) {
                    SqlTypeElementImpl.$$$reportNull$$$0(2);
                }
                return sqlTableType;
            }
            TableBasedSqlTableTypeImpl tableBasedSqlTableTypeImpl = new TableBasedSqlTableTypeImpl(columns2, (PsiElement)this);
            if (tableBasedSqlTableTypeImpl == null) {
                SqlTypeElementImpl.$$$reportNull$$$0(3);
            }
            return tableBasedSqlTableTypeImpl;
        }
        SqlReferenceExpression ref = (SqlReferenceExpression)this.findChildByClass(SqlReferenceExpression.class);
        if (ref != null) {
            SqlType sqlType = ref.getSqlType();
            if (sqlType == null) {
                SqlTypeElementImpl.$$$reportNull$$$0(4);
            }
            return sqlType;
        }
        SqlType sqlType = SqlTypeFactory.of(this.getDataType(), SqlImplUtil.getSqlDialectSafe((PsiElement)this));
        if (sqlType == null) {
            SqlTypeElementImpl.$$$reportNull$$$0(5);
        }
        return sqlType;
    }

    public String getDisplayName() {
        return this.getDataType().getSpecification();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlTypeElementImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlTypeElementImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataType";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findSqlType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DataTypeParser {
        private final SqlTypeElementImpl myElement;
        private String mySchema;
        private StringBuilder myTypeName;

        public DataTypeParser(@NotNull SqlTypeElementImpl element) {
            if (element == null) {
                DataTypeParser.$$$reportNull$$$0(0);
            }
            this.mySchema = null;
            this.myTypeName = new StringBuilder();
            this.myElement = element;
        }

        @NotNull
        public DataType parse() {
            int state = 0;
            String suffix = null;
            int i1 = -1;
            int i2 = 0;
            LengthUnit unit = null;
            for (PsiElement cur = this.myElement.getFirstChild(); cur != null; cur = cur.getNextSibling()) {
                ASTNode node = cur.getNode();
                IElementType type = node == null ? null : node.getElementType();
                boolean isIdentToken = type instanceof SqlKeywordTokenType || type == SqlCompositeElementTypes.SQL_TYPE_ELEMENT || type == SqlTokens.SQL_IDENT;
                String text = cur.getText();
                if (state == 0 && type == SqlCommonKeywords.SQL_TABLE) {
                    DataType dataType = DataTypeFactory.of(null, "table", this.getTableVagueArgs(), null);
                    if (dataType == null) {
                        DataTypeParser.$$$reportNull$$$0(1);
                    }
                    return dataType;
                }
                if (state == 0 && type == SqlCommonKeywords.SQL_ENUM) {
                    DataType dataType = DataTypeFactory.of(null, "enum", this.getEnumVagueArgs(), null);
                    if (dataType == null) {
                        DataTypeParser.$$$reportNull$$$0(2);
                    }
                    return dataType;
                }
                if (state == 0 && type == SqlCommonKeywords.SQL_SET) {
                    DataType dataType = DataTypeFactory.of(null, "set", this.getEnumVagueArgs(), null);
                    if (dataType == null) {
                        DataTypeParser.$$$reportNull$$$0(3);
                    }
                    return dataType;
                }
                if (state == 0 && cur instanceof SqlReferenceExpression) {
                    state = 2;
                    this.parseTypeAndSchema((SqlReferenceExpression)cur);
                    continue;
                }
                if (state < 2 && isIdentToken) {
                    state = 1;
                    DataTypeParser.spAppend(this.myTypeName, text);
                    continue;
                }
                if (state < 3 && (type == SqlTokens.SQL_LEFT_BRACKET || type == SqlTokens.SQL_RIGHT_BRACKET)) {
                    state = 1;
                    this.myTypeName.append(text);
                    continue;
                }
                if ((state == 1 || state == 2) && type == SqlTokens.SQL_LEFT_PAREN) {
                    state = 3;
                    continue;
                }
                if (state == 3 && this.isNumeric(type)) {
                    ++state;
                    i1 = StringUtil.parseInt((String)text, (int)i1);
                    continue;
                }
                if (state == 4 && this.isNumeric(type)) {
                    ++state;
                    i2 = StringUtil.parseInt((String)text, (int)i2);
                    continue;
                }
                if (state == 4 && type instanceof SqlKeywordTokenType) {
                    ++state;
                    unit = LengthUnit.of((String)text);
                    continue;
                }
                if (state > 2 && type == SqlTokens.SQL_RIGHT_PAREN) {
                    state = 10;
                    continue;
                }
                if (state >= 11 || type != SqlCompositeElementTypes.SQL_TYPE_SUFFIX) continue;
                state = 11;
                suffix = text;
            }
            String name = DasUtil.NO_NAME;
            if (this.myTypeName.length() != 0) {
                name = this.myTypeName.toString();
            }
            DataType dataType = DataTypeFactory.of(this.mySchema, name, i1, i2, unit, suffix, unit != null, false);
            if (dataType == null) {
                DataTypeParser.$$$reportNull$$$0(4);
            }
            return dataType;
        }

        public void parseTypeAndSchema(SqlReferenceExpression cur) {
            this.myTypeName.append(StringUtil.notNullize((String)DataTypeParser.getNameAsIs(cur)));
            this.mySchema = DataTypeParser.getNameAsIs((SqlReferenceExpression)ObjectUtils.tryCast((Object)cur.getQualifierExpression(), SqlReferenceExpression.class));
        }

        @Nullable
        public static String getNameAsIs(@Nullable SqlReferenceExpression ref) {
            SqlIdentifier identifier = ref == null ? null : ref.getIdentifier();
            return identifier == null ? null : identifier.getText();
        }

        private static void spAppend(StringBuilder b, String text) {
            if (b.length() != 0) {
                b.append(' ').append(text);
            } else {
                b.append(text);
            }
        }

        public boolean isNumeric(IElementType type) {
            return type == SqlCompositeElementTypes.SQL_NUMERIC_LITERAL || type == SqlTokens.SQL_INTEGER_TOKEN;
        }

        @Nullable
        private String getEnumVagueArgs() {
            SqlParenthesizedExpression child = (SqlParenthesizedExpression)PsiTreeUtil.getChildOfType((PsiElement)this.myElement, SqlParenthesizedExpression.class);
            Object[] items = (SqlExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)child, SqlExpression.class);
            return items == null ? null : StringUtil.join((Object[])items, PsiElement::getText, (String)", ");
        }

        @Nullable
        private String getTableVagueArgs() {
            SqlColumnDefinition[] children = (SqlColumnDefinition[])PsiTreeUtil.getChildrenOfType((PsiElement)this.myElement, SqlColumnDefinition.class);
            if (children == null || children.length == 0) {
                return null;
            }
            StringBuilder builder = new StringBuilder();
            for (SqlColumnDefinition c : children) {
                if (builder.length() != 0) {
                    builder.append(", ");
                }
                builder.append(c.getName()).append(" ").append(c.getDataType().getSpecification());
            }
            return builder.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/psi/impl/SqlTypeElementImpl$DataTypeParser";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/psi/impl/SqlTypeElementImpl$DataTypeParser";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parse";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

