/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl.lexer;

import com.intellij.database.util.TokenPattern;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.sql.psi.impl.lexer.PreprocessingLexer;

class PreprocessorMatchState {
    private static final Logger LOG = Logger.getInstance(PreprocessingLexer.class);
    private final TokenPattern.Matcher myMatcher;
    private int myStart = -1;
    private int myEnd = -1;

    public PreprocessorMatchState(TokenPattern pattern) {
        this.myMatcher = pattern.newMatcher();
    }

    public void reset(CharSequence buffer) {
        this.myMatcher.reset(buffer);
        this.myStart = -1;
        this.myEnd = -1;
    }

    public void resetTo(int end) {
        this.myStart = this.myEnd = end;
    }

    public boolean findMatchOn(int offset, int limit) {
        assert (offset <= limit);
        if (offset < limit) {
            boolean found = this.myMatcher.find(offset, limit);
            if (found && this.myMatcher.start() == this.myMatcher.end()) {
                LOG.warn("Pattern matches empty text");
                found = false;
            }
            if (found) {
                this.myStart = this.myMatcher.start();
                this.myEnd = this.myMatcher.end();
                return true;
            }
        }
        this.myStart = this.myEnd = limit;
        return false;
    }

    public int start() {
        return this.myStart;
    }

    public int end() {
        return this.myEnd;
    }

    boolean hasMatch() {
        return this.myStart < this.myEnd;
    }

    public TokenPattern.Matcher getMatcher() {
        return this.myMatcher;
    }
}

