/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.ResourceBundleManager;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ResourceBundleImpl
extends ResourceBundle {
    @NotNull
    private final PropertiesFile myDefaultPropertiesFile;
    private boolean myValid;

    public ResourceBundleImpl(@NotNull PropertiesFile defaultPropertiesFile) {
        if (defaultPropertiesFile == null) {
            ResourceBundleImpl.$$$reportNull$$$0(0);
        }
        this.myValid = true;
        this.myDefaultPropertiesFile = defaultPropertiesFile;
    }

    @Override
    @NotNull
    public List<PropertiesFile> getPropertiesFiles() {
        List<PropertiesFile> list = PropertiesImplUtil.getResourceBundleWithCachedFiles(this.myDefaultPropertiesFile).getFiles();
        if (list == null) {
            ResourceBundleImpl.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    public PropertiesFile getDefaultPropertiesFile() {
        PropertiesFile propertiesFile = this.myDefaultPropertiesFile;
        if (propertiesFile == null) {
            ResourceBundleImpl.$$$reportNull$$$0(2);
        }
        return propertiesFile;
    }

    @Override
    @NotNull
    public String getBaseName() {
        String string = ResourceBundleManager.getInstance(this.getProject()).getBaseName(this.myDefaultPropertiesFile.getContainingFile());
        if (string == null) {
            ResourceBundleImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public VirtualFile getBaseDirectory() {
        VirtualFile virtualFile = this.myDefaultPropertiesFile.getParent().getVirtualFile();
        if (virtualFile == null) {
            ResourceBundleImpl.$$$reportNull$$$0(4);
        }
        return virtualFile;
    }

    @Override
    public boolean isValid() {
        return this.myValid && this.myDefaultPropertiesFile.getContainingFile().isValid();
    }

    public void invalidate() {
        this.myValid = false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceBundleImpl resourceBundle = (ResourceBundleImpl)o;
        return this.myDefaultPropertiesFile.equals(resourceBundle.myDefaultPropertiesFile);
    }

    public int hashCode() {
        return this.myDefaultPropertiesFile.hashCode();
    }

    public String getUrl() {
        return this.getBaseDirectory() + "/" + this.getBaseName();
    }

    public String toString() {
        return "ResourceBundleImpl:" + this.getBaseName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultPropertiesFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/ResourceBundleImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/ResourceBundleImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertiesFiles";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultPropertiesFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

