/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.projectView;

import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.lang.properties.CustomResourceBundle;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.projectView.CustomResourceBundlePropertiesFileNode;
import com.intellij.lang.properties.projectView.ResourceBundleDeleteProvider;
import com.intellij.lang.properties.projectView.ResourceBundleNode;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ResourceBundleGrouper
implements TreeStructureProvider,
DumbAware {
    private static final Logger LOG = Logger.getInstance(ResourceBundleGrouper.class);
    private final Project myProject;

    public ResourceBundleGrouper(Project project) {
        this.myProject = project;
    }

    @NotNull
    public Collection<AbstractTreeNode> modify(@NotNull AbstractTreeNode parent, @NotNull Collection<AbstractTreeNode> children, ViewSettings settings) {
        if (parent == null) {
            ResourceBundleGrouper.$$$reportNull$$$0(0);
        }
        if (children == null) {
            ResourceBundleGrouper.$$$reportNull$$$0(1);
        }
        if (parent instanceof ResourceBundleNode) {
            Collection<AbstractTreeNode> collection = children;
            if (collection == null) {
                ResourceBundleGrouper.$$$reportNull$$$0(2);
            }
            return collection;
        }
        Collection collection = (Collection)ReadAction.compute(() -> {
            if (children == null) {
                ResourceBundleGrouper.$$$reportNull$$$0(4);
            }
            THashMap childBundles = new THashMap();
            for (AbstractTreeNode child : children) {
                void var11_14;
                PropertiesFile propertiesFile;
                Object f = child.getValue();
                if (!(f instanceof PsiFile) || (propertiesFile = PropertiesImplUtil.getPropertiesFile((PsiFile)f)) == null) continue;
                boolean isProcessed = false;
                for (Collection files : childBundles.values()) {
                    if (!files.contains(propertiesFile)) continue;
                    isProcessed = true;
                    break;
                }
                if (isProcessed) continue;
                PropertiesImplUtil.ResourceBundleWithCachedFiles resourceBundleWithCachedFiles = PropertiesImplUtil.getResourceBundleWithCachedFiles(propertiesFile);
                ResourceBundle bundle = resourceBundleWithCachedFiles.getBundle();
                Collection collection = (Collection)childBundles.get(bundle);
                if (collection == null) {
                    LinkedHashSet linkedHashSet = new LinkedHashSet();
                    childBundles.put(bundle, linkedHashSet);
                }
                var11_14.add(propertiesFile);
                var11_14.addAll(resourceBundleWithCachedFiles.getFiles());
            }
            ArrayList<Object> result = new ArrayList<Object>();
            for (Map.Entry entry : childBundles.entrySet()) {
                ResourceBundle resourceBundle = (ResourceBundle)entry.getKey();
                Collection files = (Collection)entry.getValue();
                if (files.size() == 1) continue;
                result.add((Object)new ResourceBundleNode(this.myProject, resourceBundle, settings));
            }
            for (AbstractTreeNode child : children) {
                PropertiesFile propertiesFile;
                Object f = child.getValue();
                if (f instanceof PsiFile && (propertiesFile = PropertiesImplUtil.getPropertiesFile((PsiFile)f)) != null) {
                    ResourceBundle bundle = null;
                    for (Map.Entry entry : childBundles.entrySet()) {
                        if (!((Collection)entry.getValue()).contains(propertiesFile)) continue;
                        bundle = (ResourceBundle)entry.getKey();
                        break;
                    }
                    LOG.assertTrue(bundle != null);
                    if (((Collection)childBundles.get(bundle)).size() != 1) continue;
                    if (bundle instanceof CustomResourceBundle) {
                        CustomResourceBundlePropertiesFileNode node = new CustomResourceBundlePropertiesFileNode(this.myProject, (PsiFile)f, settings);
                        result.add((Object)node);
                    }
                }
                result.add(child);
            }
            return result;
        });
        if (collection == null) {
            ResourceBundleGrouper.$$$reportNull$$$0(3);
        }
        return collection;
    }

    public Object getData(Collection<AbstractTreeNode> selected, String dataName) {
        if (selected == null) {
            return null;
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataName)) {
            for (AbstractTreeNode selectedElement : selected) {
                Object element = selectedElement.getValue();
                if (!(element instanceof ResourceBundle)) continue;
                return new ResourceBundleDeleteProvider();
            }
        } else if (ResourceBundle.ARRAY_DATA_KEY.is(dataName)) {
            ArrayList<ResourceBundle> selectedElements = new ArrayList<ResourceBundle>();
            for (AbstractTreeNode node : selected) {
                Object value = node.getValue();
                if (!(value instanceof ResourceBundle)) continue;
                selectedElements.add((ResourceBundle)value);
            }
            return selectedElements.isEmpty() ? null : selectedElements.toArray(new ResourceBundle[selectedElements.size()]);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/projectView/ResourceBundleGrouper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/projectView/ResourceBundleGrouper";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "modify";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "modify";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "lambda$modify$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

