/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.projectView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.DropTargetNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.ValidateableNode;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.ResourceBundleManager;
import com.intellij.lang.properties.editor.ResourceBundleAsVirtualFile;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceBundleNode
extends ProjectViewNode<ResourceBundle>
implements ValidateableNode,
DropTargetNode {
    public ResourceBundleNode(Project project, @NotNull ResourceBundle resourceBundle, ViewSettings settings) {
        if (resourceBundle == null) {
            ResourceBundleNode.$$$reportNull$$$0(0);
        }
        super(project, (Object)resourceBundle, settings);
    }

    @NotNull
    public Collection<AbstractTreeNode> getChildren() {
        List<PropertiesFile> propertiesFiles = ((ResourceBundle)ObjectUtils.notNull((Object)this.getValue())).getPropertiesFiles();
        ArrayList<AbstractTreeNode> children = new ArrayList<AbstractTreeNode>();
        for (PropertiesFile propertiesFile : propertiesFiles) {
            PsiFileNode node = new PsiFileNode(this.myProject, propertiesFile.getContainingFile(), this.getSettings());
            children.add((AbstractTreeNode)node);
        }
        ArrayList<AbstractTreeNode> arrayList = children;
        if (arrayList == null) {
            ResourceBundleNode.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            ResourceBundleNode.$$$reportNull$$$0(2);
        }
        if (!file.isValid()) {
            return false;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.getProject()).findFile(file);
        PropertiesFile propertiesFile = PropertiesImplUtil.getPropertiesFile(psiFile);
        return propertiesFile != null && ((ResourceBundle)ObjectUtils.notNull((Object)this.getValue())).getPropertiesFiles().contains(propertiesFile);
    }

    public VirtualFile getVirtualFile() {
        List<PropertiesFile> list = ((ResourceBundle)ObjectUtils.notNull((Object)this.getValue())).getPropertiesFiles();
        if (!list.isEmpty()) {
            return list.get(0).getVirtualFile();
        }
        return null;
    }

    public void update(PresentationData presentation) {
        presentation.setIcon(AllIcons.Nodes.ResourceBundle);
        presentation.setPresentableText(PropertiesBundle.message("project.view.resource.bundle.tree.node.text", ((ResourceBundle)ObjectUtils.notNull((Object)this.getValue())).getBaseName()));
    }

    public boolean canNavigateToSource() {
        return true;
    }

    public boolean canNavigate() {
        return true;
    }

    public void navigate(boolean requestFocus) {
        OpenFileDescriptor descriptor = new OpenFileDescriptor(this.getProject(), (VirtualFile)new ResourceBundleAsVirtualFile((ResourceBundle)ObjectUtils.notNull((Object)this.getValue())));
        FileEditorManager.getInstance((Project)this.getProject()).openTextEditor(descriptor, requestFocus);
    }

    public boolean isSortByFirstChild() {
        return true;
    }

    public Comparable getTypeSortKey() {
        return new PsiFileNode.ExtensionSortKey(StdFileTypes.PROPERTIES.getDefaultExtension());
    }

    public boolean validate() {
        ResourceBundle currentBundle;
        if (!super.validate()) {
            return false;
        }
        ResourceBundle newBundle = ((ResourceBundle)ObjectUtils.notNull((Object)this.getValue())).getDefaultPropertiesFile().getResourceBundle();
        if (!Comparing.equal((Object)newBundle, (Object)(currentBundle = (ResourceBundle)this.getValue()))) {
            return false;
        }
        return ((ResourceBundle)ObjectUtils.notNull((Object)currentBundle)).isValid();
    }

    public boolean isValid() {
        return ((ResourceBundle)ObjectUtils.notNull((Object)this.getValue())).isValid();
    }

    public boolean canDrop(TreeNode[] sourceNodes) {
        for (TreeNode node : sourceNodes) {
            if (ResourceBundleNode.extractPropertiesFileFromNode(node) != null) continue;
            return false;
        }
        return true;
    }

    public void drop(TreeNode[] sourceNodes, DataContext dataContext) {
        MultiMap bundleGrouping = new MultiMap();
        for (TreeNode sourceNode : sourceNodes) {
            PropertiesFile propertiesFile = ResourceBundleNode.extractPropertiesFileFromNode(sourceNode);
            if (propertiesFile == null) {
                return;
            }
            bundleGrouping.putValue((Object)propertiesFile.getResourceBundle(), (Object)propertiesFile);
        }
        ResourceBundle resourceBundle = (ResourceBundle)ObjectUtils.notNull((Object)this.getValue());
        bundleGrouping.remove((Object)resourceBundle);
        ResourceBundleManager resourceBundleManager = ResourceBundleManager.getInstance(this.myProject);
        ArrayList<PropertiesFile> toAddInResourceBundle = new ArrayList<PropertiesFile>();
        for (Map.Entry entry : bundleGrouping.entrySet()) {
            toAddInResourceBundle.addAll((Collection)entry.getValue());
            ResourceBundle currentBundle = (ResourceBundle)entry.getKey();
            Collection propertiesFilesToMove = (Collection)entry.getValue();
            if (currentBundle.getPropertiesFiles().size() - propertiesFilesToMove.size() <= 0) continue;
            String currentBundleBaseName = currentBundle.getBaseName();
            ArrayList<PropertiesFile> files = new ArrayList<PropertiesFile>(currentBundle.getPropertiesFiles());
            files.removeAll(propertiesFilesToMove);
            resourceBundleManager.dissociateResourceBundle(currentBundle);
            resourceBundleManager.combineToResourceBundle(files, currentBundleBaseName);
        }
        toAddInResourceBundle.addAll(resourceBundle.getPropertiesFiles());
        String baseName = resourceBundle.getBaseName();
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.getProject());
        fileEditorManager.closeFile((VirtualFile)new ResourceBundleAsVirtualFile(resourceBundle));
        resourceBundleManager.dissociateResourceBundle(resourceBundle);
        ResourceBundle updatedBundle = resourceBundleManager.combineToResourceBundleAndGet(toAddInResourceBundle, baseName);
        FileEditorManager.getInstance((Project)this.getProject()).openFile((VirtualFile)new ResourceBundleAsVirtualFile(updatedBundle), true);
        ProjectView.getInstance((Project)this.getProject()).refresh();
    }

    public void dropExternalFiles(PsiFileSystemItem[] sourceFileArray, DataContext dataContext) {
    }

    @Nullable
    private static PropertiesFile extractPropertiesFileFromNode(TreeNode node) {
        if (!(node instanceof DefaultMutableTreeNode)) {
            return null;
        }
        Object userObject = ((DefaultMutableTreeNode)node).getUserObject();
        if (!(userObject instanceof PsiFileNode)) {
            return null;
        }
        PsiFile file = (PsiFile)((PsiFileNode)userObject).getValue();
        PropertiesFile propertiesFile = PropertiesImplUtil.getPropertiesFile(file);
        if (propertiesFile == null || !file.getManager().isInProject((PsiElement)file) || !file.isValid()) {
            return null;
        }
        return propertiesFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceBundle";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/projectView/ResourceBundleNode";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/projectView/ResourceBundleNode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

