/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.flavours.gfm;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTNodeKt;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.ast.LeafASTNode;
import org.intellij.markdown.ast.impl.ListCompositeNode;
import org.intellij.markdown.ast.impl.ListItemCompositeNode;
import org.intellij.markdown.flavours.gfm.GFMTokenTypes;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.markdown.html.InlineHolderGeneratingProvider;
import org.intellij.markdown.html.SimpleTagProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J$\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u00060\u000bR\u00020\f2\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J$\u0010\r\u001a\u00020\t2\n\u0010\n\u001a\u00060\u000bR\u00020\f2\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000f"}, d2={"Lorg/intellij/markdown/flavours/gfm/CheckedListItemGeneratingProvider;", "Lorg/intellij/markdown/html/SimpleTagProvider;", "()V", "getIsCheckedString", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "text", "openTag", "", "visitor", "Lorg/intellij/markdown/html/HtmlGenerator$HtmlGeneratingVisitor;", "Lorg/intellij/markdown/html/HtmlGenerator;", "processNode", "SubParagraphGeneratingProvider", "intellij-markdown"})
public final class CheckedListItemGeneratingProvider
extends SimpleTagProvider {
    @Override
    public void openTag(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull((Object)visitor, (String)"visitor");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
    }

    @Override
    public void processNode(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
        CharSequence inputHtml;
        CharSequence listItemClass;
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)visitor, (String)"visitor");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        boolean bl = node instanceof ListItemCompositeNode;
        if (_Assertions.ENABLED) {
            if (!bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        ASTNode checkBoxElement = ASTUtilKt.findChildOfType(node, GFMTokenTypes.CHECK_BOX);
        if (checkBoxElement != null) {
            listItemClass = "class=\"task-list-item\"";
            String checkedString = this.getIsCheckedString(checkBoxElement, text);
            inputHtml = "<input type=" + "\"" + "checkbox" + "\"" + " class=" + "\"" + "task-list-item-checkbox" + "\"" + checkedString + " disabled />";
        } else {
            listItemClass = null;
            inputHtml = "";
        }
        HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default(visitor, node, "li", new CharSequence[]{listItemClass}, false, 8, null);
        ASTNode aSTNode = node;
        if (aSTNode == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.intellij.markdown.ast.impl.ListItemCompositeNode");
        }
        ListCompositeNode listCompositeNode = ((ListItemCompositeNode)aSTNode).getParent();
        if (listCompositeNode == null) {
            Intrinsics.throwNpe();
        }
        boolean isLoose = listCompositeNode.getLoose();
        boolean flushedInput = false;
        for (ASTNode child : node.getChildren()) {
            if (child instanceof LeafASTNode) continue;
            if (!flushedInput) {
                if (Intrinsics.areEqual((Object)child.getType(), (Object)MarkdownElementTypes.PARAGRAPH)) {
                    new SubParagraphGeneratingProvider(isLoose, (String)inputHtml).processNode(visitor, text, child);
                } else {
                    visitor.consumeHtml(inputHtml);
                    ASTNodeKt.accept(child, visitor);
                }
                flushedInput = true;
                continue;
            }
            ASTNodeKt.accept(child, visitor);
        }
        this.closeTag(visitor, text, node);
    }

    private final String getIsCheckedString(ASTNode node, String text) {
        Boolean bl;
        Object object = node;
        if (object != null && (object = ASTUtilKt.getTextInNode((ASTNode)object, text)) != null) {
            Object object2 = object;
            CharSequence it = (CharSequence)object2;
            bl = it.length() > 1 && it.charAt(1) != ' ';
        } else {
            bl = null;
        }
        boolean isChecked = Intrinsics.areEqual(bl, (Object)true);
        String checkedString = isChecked ? " checked" : "";
        return checkedString;
    }

    public CheckedListItemGeneratingProvider() {
        super("li");
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u00060\u000eR\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J$\u0010\u0013\u001a\u00020\f2\n\u0010\r\u001a\u00060\u000eR\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/intellij/markdown/flavours/gfm/CheckedListItemGeneratingProvider$SubParagraphGeneratingProvider;", "Lorg/intellij/markdown/html/InlineHolderGeneratingProvider;", "wrapInParagraph", "", "inputHtml", "", "(ZLjava/lang/String;)V", "getInputHtml", "()Ljava/lang/String;", "getWrapInParagraph", "()Z", "closeTag", "", "visitor", "Lorg/intellij/markdown/html/HtmlGenerator$HtmlGeneratingVisitor;", "Lorg/intellij/markdown/html/HtmlGenerator;", "text", "node", "Lorg/intellij/markdown/ast/ASTNode;", "openTag", "intellij-markdown"})
    private static final class SubParagraphGeneratingProvider
    extends InlineHolderGeneratingProvider {
        private final boolean wrapInParagraph;
        @NotNull
        private final String inputHtml;

        @Override
        public void openTag(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
            Intrinsics.checkParameterIsNotNull((Object)visitor, (String)"visitor");
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            if (this.wrapInParagraph) {
                HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default(visitor, node, "p", new CharSequence[0], false, 8, null);
            }
            visitor.consumeHtml(this.inputHtml);
        }

        @Override
        public void closeTag(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
            Intrinsics.checkParameterIsNotNull((Object)visitor, (String)"visitor");
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            if (this.wrapInParagraph) {
                visitor.consumeTagClose("p");
            }
        }

        public final boolean getWrapInParagraph() {
            return this.wrapInParagraph;
        }

        @NotNull
        public final String getInputHtml() {
            return this.inputHtml;
        }

        public SubParagraphGeneratingProvider(boolean wrapInParagraph, @NotNull String inputHtml) {
            Intrinsics.checkParameterIsNotNull((Object)inputHtml, (String)"inputHtml");
            this.wrapInParagraph = wrapInParagraph;
            this.inputHtml = inputHtml;
        }
    }
}

