/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.backwardRefs;

import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Function;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.InvertedIndex;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import javax.lang.model.element.Modifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.backwardRefs.CompilerBackwardReferenceIndex;
import org.jetbrains.jps.backwardRefs.LightRef;
import org.jetbrains.jps.backwardRefs.NameEnumerator;
import org.jetbrains.jps.backwardRefs.index.CompiledFileData;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.java.JavaBuilder;
import org.jetbrains.jps.incremental.storage.BuildDataManager;
import org.jetbrains.jps.javac.ast.api.JavacRef;

public class BackwardReferenceIndexWriter {
    public static final String PROP_KEY = "jps.backward.ref.index.builder";
    private static volatile BackwardReferenceIndexWriter ourInstance;
    private final CompilerBackwardReferenceIndex myIndex;

    private BackwardReferenceIndexWriter(CompilerBackwardReferenceIndex index) {
        this.myIndex = index;
    }

    Exception getRebuildRequestCause() {
        return this.myIndex.getRebuildRequestCause();
    }

    void setRebuildCause(Exception e) {
        this.myIndex.setRebuildRequestCause(e);
    }

    public static void closeIfNeed(boolean clearIndex) {
        if (ourInstance != null) {
            File dir = clearIndex ? BackwardReferenceIndexWriter.ourInstance.myIndex.getIndicesDir() : null;
            try {
                ourInstance.close();
            }
            finally {
                ourInstance = null;
                if (dir != null) {
                    FileUtil.delete((File)dir);
                }
            }
        }
    }

    static BackwardReferenceIndexWriter getInstance() {
        return ourInstance;
    }

    static void initialize(@NotNull CompileContext context, int attempt) {
        if (context == null) {
            BackwardReferenceIndexWriter.$$$reportNull$$$0(0);
        }
        BuildDataManager dataManager = context.getProjectDescriptor().dataManager;
        File buildDir = dataManager.getDataPaths().getDataStorageRoot();
        if (BackwardReferenceIndexWriter.isEnabled()) {
            boolean isRebuild = BackwardReferenceIndexWriter.isRebuildInAllJavaModules(context);
            if (!"Javac".equals(JavaBuilder.getUsedCompilerId(context)) || !((Boolean)JavaBuilder.IS_ENABLED.get((UserDataHolder)context, (Object)Boolean.TRUE)).booleanValue()) {
                CompilerBackwardReferenceIndex.removeIndexFiles(buildDir);
                return;
            }
            if (isRebuild) {
                CompilerBackwardReferenceIndex.removeIndexFiles(buildDir);
            } else if (CompilerBackwardReferenceIndex.versionDiffers(buildDir)) {
                CompilerBackwardReferenceIndex.removeIndexFiles(buildDir);
                if (attempt == 0 && BackwardReferenceIndexWriter.areAllJavaModulesAffected(context)) {
                    throw new BuildDataCorruptedException("backward reference index should be updated to actual version");
                }
            }
            if (CompilerBackwardReferenceIndex.exist(buildDir) || isRebuild) {
                ourInstance = new BackwardReferenceIndexWriter(new CompilerBackwardReferenceIndex(buildDir, false));
            }
        } else {
            CompilerBackwardReferenceIndex.removeIndexFiles(buildDir);
        }
    }

    public static boolean isEnabled() {
        return SystemProperties.getBooleanProperty((String)PROP_KEY, (boolean)false);
    }

    synchronized LightRef.JavaLightClassRef asClassUsage(JavacRef aClass) throws IOException {
        return new LightRef.JavaLightClassRef(BackwardReferenceIndexWriter.id(aClass, this.myIndex.getByteSeqEum()));
    }

    void processDeletedFiles(Collection<String> files) throws IOException {
        for (String file : files) {
            this.writeData(this.enumeratePath(new File(file).getPath()), null);
        }
    }

    void writeData(int id, CompiledFileData d) {
        for (InvertedIndex<?, ?, CompiledFileData> index : this.myIndex.getIndices()) {
            index.update(id, (Object)d).compute();
        }
    }

    synchronized int enumeratePath(String file) throws IOException {
        return this.myIndex.getFilePathEnumerator().enumerate(file);
    }

    private void close() {
        this.myIndex.close();
    }

    @Nullable
    LightRef enumerateNames(JavacRef ref, Function<String, Integer> ownerIdReplacer) throws IOException {
        NameEnumerator nameEnumerator = this.myIndex.getByteSeqEum();
        if (ref instanceof JavacRef.JavacClass) {
            if (!BackwardReferenceIndexWriter.isPrivate(ref) && !((JavacRef.JavacClass)ref).isAnonymous()) {
                return new LightRef.JavaLightClassRef(BackwardReferenceIndexWriter.id(ref, nameEnumerator));
            }
        } else {
            if (BackwardReferenceIndexWriter.isPrivate(ref)) {
                return null;
            }
            String ownerName = ref.getOwnerName();
            Integer ownerPrecalculatedId = (Integer)ownerIdReplacer.fun((Object)ownerName);
            if (ref instanceof JavacRef.JavacField) {
                return new LightRef.JavaLightFieldRef(ownerPrecalculatedId != null ? ownerPrecalculatedId : BackwardReferenceIndexWriter.id(ownerName, nameEnumerator), BackwardReferenceIndexWriter.id(ref, nameEnumerator));
            }
            if (ref instanceof JavacRef.JavacMethod) {
                byte paramCount = ((JavacRef.JavacMethod)ref).getParamCount();
                return new LightRef.JavaLightMethodRef(ownerPrecalculatedId != null ? ownerPrecalculatedId : BackwardReferenceIndexWriter.id(ownerName, nameEnumerator), BackwardReferenceIndexWriter.id(ref, nameEnumerator), paramCount);
            }
            throw new AssertionError((Object)("unexpected symbol: " + ref + " class: " + ref.getClass()));
        }
        return null;
    }

    private static boolean isPrivate(JavacRef ref) {
        return ref.getModifiers().contains((Object)Modifier.PRIVATE);
    }

    private static int id(JavacRef ref, NameEnumerator nameEnumerator) throws IOException {
        return BackwardReferenceIndexWriter.id(ref.getName(), nameEnumerator);
    }

    private static int id(String name, NameEnumerator nameEnumerator) throws IOException {
        return nameEnumerator.enumerate(name);
    }

    private static boolean isRebuildInAllJavaModules(CompileContext context) {
        for (JavaModuleBuildTargetType type : JavaModuleBuildTargetType.ALL_TYPES) {
            for (ModuleBuildTarget target : context.getProjectDescriptor().getBuildTargetIndex().getAllTargets(type)) {
                if (context.getScope().isBuildForced(target)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean areAllJavaModulesAffected(CompileContext context) {
        for (JavaModuleBuildTargetType type : JavaModuleBuildTargetType.ALL_TYPES) {
            for (ModuleBuildTarget target : context.getProjectDescriptor().getBuildTargetIndex().getAllTargets(type)) {
                if (context.getScope().isWholeTargetAffected(target)) continue;
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jps/backwardRefs/BackwardReferenceIndexWriter", "initialize"));
    }
}

