/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.backwardRefs.index;

import com.intellij.openapi.util.io.DataInputOutputUtilRt;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.VoidDataExternalizer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.backwardRefs.LightRef;
import org.jetbrains.jps.backwardRefs.LightRefDescriptor;
import org.jetbrains.jps.backwardRefs.SignatureData;
import org.jetbrains.jps.backwardRefs.index.CompiledFileData;

public class CompilerIndices {
    public static final int VERSION = 5;
    public static final IndexId<LightRef, Integer> BACK_USAGES = IndexId.create((String)"back.refs");
    public static final IndexId<LightRef, Collection<LightRef>> BACK_HIERARCHY = IndexId.create((String)"back.hierarchy");
    public static final IndexId<LightRef, Void> BACK_CLASS_DEF = IndexId.create((String)"back.class.def");
    public static final IndexId<SignatureData, Collection<LightRef>> BACK_MEMBER_SIGN = IndexId.create((String)"back.member.sign");

    public static List<IndexExtension<?, ?, CompiledFileData>> getIndices() {
        return Arrays.asList(CompilerIndices.createBackwardClassDefinitionExtension(), CompilerIndices.createBackwardUsagesExtension(), CompilerIndices.createBackwardHierarchyExtension(), CompilerIndices.createBackwardSignatureExtension());
    }

    private static IndexExtension<LightRef, Integer, CompiledFileData> createBackwardUsagesExtension() {
        return new IndexExtension<LightRef, Integer, CompiledFileData>(){

            public int getVersion() {
                return 5;
            }

            @NotNull
            public IndexId<LightRef, Integer> getName() {
                IndexId<LightRef, Integer> indexId = BACK_USAGES;
                if (indexId == null) {
                    1.$$$reportNull$$$0(0);
                }
                return indexId;
            }

            @NotNull
            public DataIndexer<LightRef, Integer, CompiledFileData> getIndexer() {
                DataIndexer dataIndexer = CompiledFileData::getReferences;
                if (dataIndexer == null) {
                    1.$$$reportNull$$$0(1);
                }
                return dataIndexer;
            }

            @NotNull
            public KeyDescriptor<LightRef> getKeyDescriptor() {
                LightRefDescriptor lightRefDescriptor = LightRefDescriptor.INSTANCE;
                if (lightRefDescriptor == null) {
                    1.$$$reportNull$$$0(2);
                }
                return lightRefDescriptor;
            }

            @NotNull
            public DataExternalizer<Integer> getValueExternalizer() {
                UnsignedByteExternalizer unsignedByteExternalizer = new UnsignedByteExternalizer();
                if (unsignedByteExternalizer == null) {
                    1.$$$reportNull$$$0(3);
                }
                return unsignedByteExternalizer;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "org/jetbrains/jps/backwardRefs/index/CompilerIndices$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIndexer";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getKeyDescriptor";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getValueExternalizer";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    private static IndexExtension<LightRef, Collection<LightRef>, CompiledFileData> createBackwardHierarchyExtension() {
        return new IndexExtension<LightRef, Collection<LightRef>, CompiledFileData>(){

            public int getVersion() {
                return 5;
            }

            @NotNull
            public IndexId<LightRef, Collection<LightRef>> getName() {
                IndexId<LightRef, Collection<LightRef>> indexId = BACK_HIERARCHY;
                if (indexId == null) {
                    2.$$$reportNull$$$0(0);
                }
                return indexId;
            }

            @NotNull
            public DataIndexer<LightRef, Collection<LightRef>, CompiledFileData> getIndexer() {
                DataIndexer dataIndexer = CompiledFileData::getBackwardHierarchy;
                if (dataIndexer == null) {
                    2.$$$reportNull$$$0(1);
                }
                return dataIndexer;
            }

            @NotNull
            public KeyDescriptor<LightRef> getKeyDescriptor() {
                LightRefDescriptor lightRefDescriptor = LightRefDescriptor.INSTANCE;
                if (lightRefDescriptor == null) {
                    2.$$$reportNull$$$0(2);
                }
                return lightRefDescriptor;
            }

            @NotNull
            public DataExternalizer<Collection<LightRef>> getValueExternalizer() {
                DataExternalizer dataExternalizer = CompilerIndices.createLightRefSeqExternalizer();
                if (dataExternalizer == null) {
                    2.$$$reportNull$$$0(3);
                }
                return dataExternalizer;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "org/jetbrains/jps/backwardRefs/index/CompilerIndices$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIndexer";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getKeyDescriptor";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getValueExternalizer";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    private static IndexExtension<LightRef, Void, CompiledFileData> createBackwardClassDefinitionExtension() {
        return new IndexExtension<LightRef, Void, CompiledFileData>(){

            public int getVersion() {
                return 5;
            }

            @NotNull
            public IndexId<LightRef, Void> getName() {
                IndexId<LightRef, Void> indexId = BACK_CLASS_DEF;
                if (indexId == null) {
                    3.$$$reportNull$$$0(0);
                }
                return indexId;
            }

            @NotNull
            public DataIndexer<LightRef, Void, CompiledFileData> getIndexer() {
                DataIndexer dataIndexer = CompiledFileData::getDefinitions;
                if (dataIndexer == null) {
                    3.$$$reportNull$$$0(1);
                }
                return dataIndexer;
            }

            @NotNull
            public KeyDescriptor<LightRef> getKeyDescriptor() {
                LightRefDescriptor lightRefDescriptor = LightRefDescriptor.INSTANCE;
                if (lightRefDescriptor == null) {
                    3.$$$reportNull$$$0(2);
                }
                return lightRefDescriptor;
            }

            @NotNull
            public DataExternalizer<Void> getValueExternalizer() {
                VoidDataExternalizer voidDataExternalizer = VoidDataExternalizer.INSTANCE;
                if (voidDataExternalizer == null) {
                    3.$$$reportNull$$$0(3);
                }
                return voidDataExternalizer;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "org/jetbrains/jps/backwardRefs/index/CompilerIndices$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIndexer";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getKeyDescriptor";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getValueExternalizer";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    private static IndexExtension<SignatureData, Collection<LightRef>, CompiledFileData> createBackwardSignatureExtension() {
        return new IndexExtension<SignatureData, Collection<LightRef>, CompiledFileData>(){

            @NotNull
            public IndexId<SignatureData, Collection<LightRef>> getName() {
                IndexId<SignatureData, Collection<LightRef>> indexId = BACK_MEMBER_SIGN;
                if (indexId == null) {
                    4.$$$reportNull$$$0(0);
                }
                return indexId;
            }

            @NotNull
            public DataIndexer<SignatureData, Collection<LightRef>, CompiledFileData> getIndexer() {
                DataIndexer dataIndexer = CompiledFileData::getSignatureData;
                if (dataIndexer == null) {
                    4.$$$reportNull$$$0(1);
                }
                return dataIndexer;
            }

            @NotNull
            public KeyDescriptor<SignatureData> getKeyDescriptor() {
                KeyDescriptor keyDescriptor = CompilerIndices.createSignatureDataDescriptor();
                if (keyDescriptor == null) {
                    4.$$$reportNull$$$0(2);
                }
                return keyDescriptor;
            }

            @NotNull
            public DataExternalizer<Collection<LightRef>> getValueExternalizer() {
                DataExternalizer dataExternalizer = CompilerIndices.createLightRefSeqExternalizer();
                if (dataExternalizer == null) {
                    4.$$$reportNull$$$0(3);
                }
                return dataExternalizer;
            }

            public int getVersion() {
                return 5;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "org/jetbrains/jps/backwardRefs/index/CompilerIndices$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIndexer";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getKeyDescriptor";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getValueExternalizer";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @NotNull
    private static DataExternalizer<Collection<LightRef>> createLightRefSeqExternalizer() {
        DataExternalizer<Collection<LightRef>> dataExternalizer = new DataExternalizer<Collection<LightRef>>(){

            public void save(@NotNull DataOutput out, Collection<LightRef> value) throws IOException {
                if (out == null) {
                    5.$$$reportNull$$$0(0);
                }
                DataInputOutputUtilRt.writeSeq((DataOutput)out, value, lightRef -> {
                    if (out == null) {
                        5.$$$reportNull$$$0(3);
                    }
                    LightRefDescriptor.INSTANCE.save(out, (LightRef)lightRef);
                });
            }

            public Collection<LightRef> read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    5.$$$reportNull$$$0(1);
                }
                return DataInputOutputUtilRt.readSeq((DataInput)in, () -> {
                    if (in == null) {
                        5.$$$reportNull$$$0(2);
                    }
                    return LightRefDescriptor.INSTANCE.read(in);
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "in";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/jps/backwardRefs/index/CompilerIndices$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "save";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "read";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$read$1";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$save$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (dataExternalizer == null) {
            CompilerIndices.$$$reportNull$$$0(0);
        }
        return dataExternalizer;
    }

    private static KeyDescriptor<SignatureData> createSignatureDataDescriptor() {
        return new KeyDescriptor<SignatureData>(){

            public int getHashCode(SignatureData value) {
                return value.hashCode();
            }

            public boolean isEqual(SignatureData val1, SignatureData val2) {
                return val1.equals(val2);
            }

            public void save(@NotNull DataOutput out, SignatureData value) throws IOException {
                if (out == null) {
                    6.$$$reportNull$$$0(0);
                }
                DataInputOutputUtil.writeINT((DataOutput)out, (int)value.getRawReturnType());
                out.writeByte(value.getIteratorKind());
                out.writeBoolean(value.isStatic());
            }

            public SignatureData read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    6.$$$reportNull$$$0(1);
                }
                return new SignatureData(DataInputOutputUtil.readINT((DataInput)in), in.readByte(), in.readBoolean());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "in";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/jps/backwardRefs/index/CompilerIndices$6";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "save";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "read";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/backwardRefs/index/CompilerIndices", "createLightRefSeqExternalizer"));
    }

    private static class UnsignedByteExternalizer
    implements DataExternalizer<Integer> {
        private UnsignedByteExternalizer() {
        }

        public void save(@NotNull DataOutput out, Integer value) throws IOException {
            int v;
            if (out == null) {
                UnsignedByteExternalizer.$$$reportNull$$$0(0);
            }
            if ((v = value.intValue()) > 255) {
                v = 255;
            }
            out.writeByte(v);
        }

        public Integer read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                UnsignedByteExternalizer.$$$reportNull$$$0(1);
            }
            return in.readByte() & 0xFF;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/jps/backwardRefs/index/CompilerIndices$UnsignedByteExternalizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

