/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms;

import com.android.ddmlib.IDevice;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.tools.idea.ddms.DeviceNameRendererEx;
import com.android.tools.idea.ddms.DevicePropertyUtil;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import icons.AndroidIcons;
import javax.swing.JList;
import javax.swing.JTable;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceRenderer {
    private DeviceRenderer() {
    }

    public static void renderDeviceName(@NotNull IDevice d, @NotNull ColoredTextContainer component) {
        if (d == null) {
            DeviceRenderer.$$$reportNull$$$0(0);
        }
        if (component == null) {
            DeviceRenderer.$$$reportNull$$$0(1);
        }
        DeviceRenderer.renderDeviceName(d, component, null);
    }

    static void renderDeviceName(@NotNull IDevice d, @NotNull ColoredTextContainer component, @Nullable AvdManager avdManager) {
        String name;
        if (d == null) {
            DeviceRenderer.$$$reportNull$$$0(2);
        }
        if (component == null) {
            DeviceRenderer.$$$reportNull$$$0(3);
        }
        component.setIcon(d.isEmulator() ? AndroidIcons.Ddms.Emulator2 : AndroidIcons.Ddms.RealDevice);
        if (d.isEmulator()) {
            AvdInfo info;
            String avdName = d.getAvdName();
            if (avdManager != null && (info = avdManager.getAvd(avdName, true)) != null) {
                avdName = (String)info.getProperties().get("avd.ini.displayname");
            }
            if (avdName == null) {
                avdName = "unknown";
            }
            name = String.format("%1$s %2$s ", AndroidBundle.message("android.emulator", new Object[0]), avdName);
        } else {
            name = String.format("%1$s %2$s ", DevicePropertyUtil.getManufacturer(d, ""), DevicePropertyUtil.getModel(d, ""));
        }
        component.append(name, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        IDevice.DeviceState deviceState = d.getState();
        if (deviceState != IDevice.DeviceState.ONLINE) {
            String state = String.format("%1$s [%2$s] ", d.getSerialNumber(), d.getState());
            component.append(state, SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
        }
        if (deviceState != IDevice.DeviceState.DISCONNECTED && deviceState != IDevice.DeviceState.OFFLINE) {
            component.append(DevicePropertyUtil.getBuild(d), SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "d";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "component";
                break;
            }
        }
        objectArray[1] = "com/android/tools/idea/ddms/DeviceRenderer";
        objectArray[2] = "renderDeviceName";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class DeviceNameRenderer
    extends ColoredTableCellRenderer {
        private static final ExtensionPointName<DeviceNameRendererEx> EP_NAME = ExtensionPointName.create((String)"com.android.run.deviceNameRenderer");
        private final DeviceNameRendererEx[] myRenderers = (DeviceNameRendererEx[])EP_NAME.getExtensions();
        private final AvdManager myAvdManager;

        public DeviceNameRenderer(@Nullable AvdManager avdManager) {
            this.myAvdManager = avdManager;
        }

        protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
            if (!(value instanceof IDevice)) {
                return;
            }
            IDevice device = (IDevice)value;
            for (DeviceNameRendererEx renderer : this.myRenderers) {
                if (!renderer.isApplicable(device)) continue;
                renderer.render(device, (ColoredTextContainer)this);
                return;
            }
            DeviceRenderer.renderDeviceName(device, (ColoredTextContainer)this, this.myAvdManager);
        }
    }

    public static class DeviceComboBoxRenderer
    extends ColoredListCellRenderer {
        @NotNull
        private String myEmptyText;

        public DeviceComboBoxRenderer(@NotNull String emptyText) {
            if (emptyText == null) {
                DeviceComboBoxRenderer.$$$reportNull$$$0(0);
            }
            this.myEmptyText = emptyText;
        }

        public DeviceComboBoxRenderer() {
            this("[none]");
        }

        protected void customizeCellRenderer(@NotNull JList list, Object value, int index, boolean selected, boolean hasFocus) {
            if (list == null) {
                DeviceComboBoxRenderer.$$$reportNull$$$0(1);
            }
            if (value instanceof String) {
                this.append((String)value, SimpleTextAttributes.ERROR_ATTRIBUTES);
            } else if (value instanceof IDevice) {
                DeviceRenderer.renderDeviceName((IDevice)value, (ColoredTextContainer)this);
            } else if (value == null) {
                this.append(this.myEmptyText, SimpleTextAttributes.ERROR_ATTRIBUTES);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "emptyText";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/ddms/DeviceRenderer$DeviceComboBoxRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "customizeCellRenderer";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

