/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.dependencies;

import com.android.tools.idea.gradle.dsl.model.GradleDslBlockModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencySpec;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependencyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.FileDependencyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.FileTreeDependencyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ModuleDependencyModel;
import com.android.tools.idea.gradle.dsl.parser.dependencies.DependenciesDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElementList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependenciesModel
extends GradleDslBlockModel {
    public DependenciesModel(@NotNull DependenciesDslElement dslElement) {
        if (dslElement == null) {
            DependenciesModel.$$$reportNull$$$0(0);
        }
        super(dslElement);
    }

    @NotNull
    public List<DependencyModel> all() {
        ArrayList dependencies = Lists.newArrayList();
        for (String configurationName : this.myDslElement.getProperties()) {
            GradleDslElementList list = this.myDslElement.getPropertyElement(configurationName, GradleDslElementList.class);
            if (list == null) continue;
            for (GradleDslElement element : list.getElements(GradleDslElement.class)) {
                dependencies.addAll(ArtifactDependencyModel.create(element));
                if (!(element instanceof GradleDslMethodCall)) continue;
                GradleDslMethodCall methodCall = (GradleDslMethodCall)element;
                dependencies.addAll(ModuleDependencyModel.create(configurationName, methodCall));
            }
        }
        ArrayList arrayList = dependencies;
        if (arrayList == null) {
            DependenciesModel.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    public List<ArtifactDependencyModel> artifacts(@NotNull String configurationName) {
        if (configurationName == null) {
            DependenciesModel.$$$reportNull$$$0(2);
        }
        ArrayList dependencies = Lists.newArrayList();
        this.addArtifacts(configurationName, dependencies);
        ArrayList arrayList = dependencies;
        if (arrayList == null) {
            DependenciesModel.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    public List<ArtifactDependencyModel> artifacts() {
        ArrayList dependencies = Lists.newArrayList();
        for (String configurationName : this.myDslElement.getProperties()) {
            this.addArtifacts(configurationName, dependencies);
        }
        ArrayList arrayList = dependencies;
        if (arrayList == null) {
            DependenciesModel.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private void addArtifacts(@NotNull String configurationName, @NotNull List<ArtifactDependencyModel> dependencies) {
        GradleDslElementList list;
        if (configurationName == null) {
            DependenciesModel.$$$reportNull$$$0(5);
        }
        if (dependencies == null) {
            DependenciesModel.$$$reportNull$$$0(6);
        }
        if ((list = this.myDslElement.getPropertyElement(configurationName, GradleDslElementList.class)) != null) {
            for (GradleDslElement element : list.getElements(GradleDslElement.class)) {
                dependencies.addAll(ArtifactDependencyModel.create(element));
            }
        }
    }

    public boolean containsArtifact(@NotNull String configurationName, @NotNull ArtifactDependencySpec dependency) {
        if (configurationName == null) {
            DependenciesModel.$$$reportNull$$$0(7);
        }
        if (dependency == null) {
            DependenciesModel.$$$reportNull$$$0(8);
        }
        for (ArtifactDependencyModel artifactDependencyModel : this.artifacts(configurationName)) {
            if (!ArtifactDependencySpec.create(artifactDependencyModel).equals(dependency)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public DependenciesModel addArtifact(@NotNull String configurationName, @NotNull String compactNotation) {
        ArtifactDependencySpec dependency;
        if (configurationName == null) {
            DependenciesModel.$$$reportNull$$$0(9);
        }
        if (compactNotation == null) {
            DependenciesModel.$$$reportNull$$$0(10);
        }
        if ((dependency = ArtifactDependencySpec.create(compactNotation)) == null) {
            String msg = String.format("'%1$s' is not a valid artifact dependency", compactNotation);
            throw new IllegalArgumentException(msg);
        }
        this.addArtifact(configurationName, dependency);
        DependenciesModel dependenciesModel = this;
        if (dependenciesModel == null) {
            DependenciesModel.$$$reportNull$$$0(11);
        }
        return dependenciesModel;
    }

    @NotNull
    public DependenciesModel addArtifact(@NotNull String configurationName, @NotNull ArtifactDependencySpec dependency) {
        if (configurationName == null) {
            DependenciesModel.$$$reportNull$$$0(12);
        }
        if (dependency == null) {
            DependenciesModel.$$$reportNull$$$0(13);
        }
        DependenciesModel dependenciesModel = this.addArtifact(configurationName, dependency, Collections.emptyList());
        if (dependenciesModel == null) {
            DependenciesModel.$$$reportNull$$$0(14);
        }
        return dependenciesModel;
    }

    @NotNull
    public DependenciesModel addArtifact(@NotNull String configurationName, @NotNull ArtifactDependencySpec dependency, @NotNull List<ArtifactDependencySpec> excludes) {
        if (configurationName == null) {
            DependenciesModel.$$$reportNull$$$0(15);
        }
        if (dependency == null) {
            DependenciesModel.$$$reportNull$$$0(16);
        }
        if (excludes == null) {
            DependenciesModel.$$$reportNull$$$0(17);
        }
        GradleDslElementList list = this.getOrCreateGradleDslElementList(configurationName);
        ArtifactDependencyModel.createAndAddToList(list, configurationName, dependency, excludes);
        DependenciesModel dependenciesModel = this;
        if (dependenciesModel == null) {
            DependenciesModel.$$$reportNull$$$0(18);
        }
        return dependenciesModel;
    }

    @NotNull
    public List<ModuleDependencyModel> modules() {
        ArrayList dependencies = Lists.newArrayList();
        for (String configurationName : this.myDslElement.getProperties()) {
            GradleDslElementList list = this.myDslElement.getPropertyElement(configurationName, GradleDslElementList.class);
            if (list == null) continue;
            for (GradleDslMethodCall element : list.getElements(GradleDslMethodCall.class)) {
                dependencies.addAll(ModuleDependencyModel.create(configurationName, element));
            }
        }
        ArrayList arrayList = dependencies;
        if (arrayList == null) {
            DependenciesModel.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    @NotNull
    public DependenciesModel addModule(@NotNull String configurationName, @NotNull String path) {
        if (configurationName == null) {
            DependenciesModel.$$$reportNull$$$0(20);
        }
        if (path == null) {
            DependenciesModel.$$$reportNull$$$0(21);
        }
        DependenciesModel dependenciesModel = this.addModule(configurationName, path, null);
        if (dependenciesModel == null) {
            DependenciesModel.$$$reportNull$$$0(22);
        }
        return dependenciesModel;
    }

    @NotNull
    public DependenciesModel addModule(@NotNull String configurationName, @NotNull String path, @Nullable String config) {
        if (configurationName == null) {
            DependenciesModel.$$$reportNull$$$0(23);
        }
        if (path == null) {
            DependenciesModel.$$$reportNull$$$0(24);
        }
        GradleDslElementList list = this.getOrCreateGradleDslElementList(configurationName);
        ModuleDependencyModel.createAndAddToList(list, configurationName, path, config);
        DependenciesModel dependenciesModel = this;
        if (dependenciesModel == null) {
            DependenciesModel.$$$reportNull$$$0(25);
        }
        return dependenciesModel;
    }

    @NotNull
    public List<FileTreeDependencyModel> fileTrees() {
        ArrayList dependencies = Lists.newArrayList();
        for (String configurationName : this.myDslElement.getProperties()) {
            GradleDslElementList list = this.myDslElement.getPropertyElement(configurationName, GradleDslElementList.class);
            if (list == null) continue;
            for (GradleDslMethodCall element : list.getElements(GradleDslMethodCall.class)) {
                dependencies.addAll(FileTreeDependencyModel.create(configurationName, element));
            }
        }
        ArrayList arrayList = dependencies;
        if (arrayList == null) {
            DependenciesModel.$$$reportNull$$$0(26);
        }
        return arrayList;
    }

    @NotNull
    public DependenciesModel addFileTree(@NotNull String configurationName, @NotNull String dir) {
        if (configurationName == null) {
            DependenciesModel.$$$reportNull$$$0(27);
        }
        if (dir == null) {
            DependenciesModel.$$$reportNull$$$0(28);
        }
        DependenciesModel dependenciesModel = this.addFileTree(configurationName, dir, null, null);
        if (dependenciesModel == null) {
            DependenciesModel.$$$reportNull$$$0(29);
        }
        return dependenciesModel;
    }

    @NotNull
    public DependenciesModel addFileTree(@NotNull String configurationName, @NotNull String dir, @Nullable List<String> includes, @Nullable List<String> excludes) {
        if (configurationName == null) {
            DependenciesModel.$$$reportNull$$$0(30);
        }
        if (dir == null) {
            DependenciesModel.$$$reportNull$$$0(31);
        }
        GradleDslElementList list = this.getOrCreateGradleDslElementList(configurationName);
        FileTreeDependencyModel.createAndAddToList(list, configurationName, dir, includes, excludes);
        DependenciesModel dependenciesModel = this;
        if (dependenciesModel == null) {
            DependenciesModel.$$$reportNull$$$0(32);
        }
        return dependenciesModel;
    }

    @NotNull
    public List<FileDependencyModel> files() {
        ArrayList dependencies = Lists.newArrayList();
        for (String configurationName : this.myDslElement.getProperties()) {
            GradleDslElementList list = this.myDslElement.getPropertyElement(configurationName, GradleDslElementList.class);
            if (list == null) continue;
            for (GradleDslMethodCall element : list.getElements(GradleDslMethodCall.class)) {
                dependencies.addAll(FileDependencyModel.create(configurationName, element));
            }
        }
        ArrayList arrayList = dependencies;
        if (arrayList == null) {
            DependenciesModel.$$$reportNull$$$0(33);
        }
        return arrayList;
    }

    @NotNull
    public DependenciesModel addFile(@NotNull String configurationName, @NotNull String file) {
        if (configurationName == null) {
            DependenciesModel.$$$reportNull$$$0(34);
        }
        if (file == null) {
            DependenciesModel.$$$reportNull$$$0(35);
        }
        GradleDslElementList list = this.getOrCreateGradleDslElementList(configurationName);
        FileDependencyModel.createAndAddToList(list, configurationName, file);
        DependenciesModel dependenciesModel = this;
        if (dependenciesModel == null) {
            DependenciesModel.$$$reportNull$$$0(36);
        }
        return dependenciesModel;
    }

    @NotNull
    private GradleDslElementList getOrCreateGradleDslElementList(@NotNull String configurationName) {
        GradleDslElementList list;
        if (configurationName == null) {
            DependenciesModel.$$$reportNull$$$0(37);
        }
        if ((list = this.myDslElement.getPropertyElement(configurationName, GradleDslElementList.class)) == null) {
            list = new GradleDslElementList(this.myDslElement, configurationName);
            this.myDslElement.setNewElement(configurationName, list);
        }
        GradleDslElementList gradleDslElementList = list;
        if (gradleDslElementList == null) {
            DependenciesModel.$$$reportNull$$$0(38);
        }
        return gradleDslElementList;
    }

    @NotNull
    public DependenciesModel remove(@NotNull DependencyModel dependency) {
        GradleDslElementList gradleDslElementList;
        if (dependency == null) {
            DependenciesModel.$$$reportNull$$$0(39);
        }
        if ((gradleDslElementList = this.myDslElement.getPropertyElement(dependency.configurationName(), GradleDslElementList.class)) != null) {
            GradleDslElement dependencyElement = dependency.getDslElement();
            GradleDslElement parent = dependencyElement.getParent();
            if (parent instanceof GradleDslMethodCall) {
                GradleDslMethodCall methodCall = (GradleDslMethodCall)parent;
                List<GradleDslElement> arguments = methodCall.getArguments();
                if (arguments.size() == 1 && arguments.get(0).equals(dependencyElement)) {
                    gradleDslElementList.removeElement(methodCall);
                } else {
                    methodCall.remove(dependencyElement);
                }
            } else {
                gradleDslElementList.removeElement(dependencyElement);
            }
        }
        DependenciesModel dependenciesModel = this;
        if (dependenciesModel == null) {
            DependenciesModel.$$$reportNull$$$0(40);
        }
        return dependenciesModel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 11: 
            case 14: 
            case 18: 
            case 19: 
            case 22: 
            case 25: 
            case 26: 
            case 29: 
            case 32: 
            case 33: 
            case 36: 
            case 38: 
            case 40: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 11: 
            case 14: 
            case 18: 
            case 19: 
            case 22: 
            case 25: 
            case 26: 
            case 29: 
            case 32: 
            case 33: 
            case 36: 
            case 38: 
            case 40: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dslElement";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 11: 
            case 14: 
            case 18: 
            case 19: 
            case 22: 
            case 25: 
            case 26: 
            case 29: 
            case 32: 
            case 33: 
            case 36: 
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 15: 
            case 20: 
            case 23: 
            case 27: 
            case 30: 
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 8: 
            case 13: 
            case 16: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compactNotation";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludes";
                break;
            }
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "all";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "artifacts";
                break;
            }
            case 11: 
            case 14: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "addArtifact";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "modules";
                break;
            }
            case 22: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "addModule";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "fileTrees";
                break;
            }
            case 29: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "addFileTree";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "files";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "addFile";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateGradleDslElementList";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "remove";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 11: 
            case 14: 
            case 18: 
            case 19: 
            case 22: 
            case 25: 
            case 26: 
            case 29: 
            case 32: 
            case 33: 
            case 36: 
            case 38: 
            case 40: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "artifacts";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addArtifacts";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "containsArtifact";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addArtifact";
                break;
            }
            case 20: 
            case 21: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addModule";
                break;
            }
            case 27: 
            case 28: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "addFileTree";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "addFile";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateGradleDslElementList";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 11: 
            case 14: 
            case 18: 
            case 19: 
            case 22: 
            case 25: 
            case 26: 
            case 29: 
            case 32: 
            case 33: 
            case 36: 
            case 38: 
            case 40: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

