/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.compiler;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.BuildSettings;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.build.compiler.AndroidGradleBuildConfiguration;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.sdk.IdeSdks;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.intellij.compiler.server.BuildProcessParametersProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.net.HttpConfigurable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

public class AndroidGradleBuildProcessParametersProvider
extends BuildProcessParametersProvider {
    @NotNull
    private final Project myProject;

    public AndroidGradleBuildProcessParametersProvider(@NotNull Project project) {
        if (project == null) {
            AndroidGradleBuildProcessParametersProvider.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    public List<String> getVMArguments() {
        if (!Projects.isBuildWithGradle(this.myProject)) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                AndroidGradleBuildProcessParametersProvider.$$$reportNull$$$0(1);
            }
            return list;
        }
        ArrayList jvmArgs = Lists.newArrayList();
        AndroidGradleBuildConfiguration buildConfiguration = AndroidGradleBuildConfiguration.getInstance(this.myProject);
        AndroidGradleBuildProcessParametersProvider.populateJvmArgs(buildConfiguration, jvmArgs, this.myProject);
        GradleExecutionSettings executionSettings = GradleUtil.getGradleExecutionSettings(this.myProject);
        if (executionSettings != null) {
            this.populateJvmArgs(executionSettings, (List<String>)jvmArgs);
        }
        this.populateJvmArgs(BuildSettings.getInstance(this.myProject), (List<String>)jvmArgs);
        if (!IdeInfo.getInstance().isAndroidStudio()) {
            AndroidGradleBuildProcessParametersProvider.addHttpProxySettings(jvmArgs);
        }
        ArrayList arrayList = jvmArgs;
        if (arrayList == null) {
            AndroidGradleBuildProcessParametersProvider.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @VisibleForTesting
    static void populateJvmArgs(@NotNull AndroidGradleBuildConfiguration buildConfiguration, @NotNull List<String> jvmArgs, @NotNull Project project) {
        if (buildConfiguration == null) {
            AndroidGradleBuildProcessParametersProvider.$$$reportNull$$$0(3);
        }
        if (jvmArgs == null) {
            AndroidGradleBuildProcessParametersProvider.$$$reportNull$$$0(4);
        }
        if (project == null) {
            AndroidGradleBuildProcessParametersProvider.$$$reportNull$$$0(5);
        }
        jvmArgs.add(AndroidGradleSettings.createJvmArg((String)"com.android.studio.gradle.offline.mode", (boolean)GradleSettings.getInstance((Project)project).isOfflineWork()));
        jvmArgs.add(AndroidGradleSettings.createJvmArg((String)"com.android.studio.gradle.configuration.on.demand", (boolean)buildConfiguration.USE_CONFIGURATION_ON_DEMAND));
        String[] commandLineOptions = buildConfiguration.getCommandLineOptions();
        int optionCount = 0;
        for (String option : commandLineOptions) {
            String name = "com.android.studio.gradle.daemon.command.line.option." + optionCount++;
            jvmArgs.add(AndroidGradleSettings.createJvmArg((String)name, (String)option));
        }
    }

    @VisibleForTesting
    void populateJvmArgs(@NotNull GradleExecutionSettings executionSettings, @NotNull List<String> jvmArgs) {
        File javaHome;
        String serviceDirectory;
        String gradleHome;
        if (executionSettings == null) {
            AndroidGradleBuildProcessParametersProvider.$$$reportNull$$$0(6);
        }
        if (jvmArgs == null) {
            AndroidGradleBuildProcessParametersProvider.$$$reportNull$$$0(7);
        }
        if ((gradleHome = executionSettings.getGradleHome()) != null && !gradleHome.isEmpty()) {
            gradleHome = FileUtil.toSystemDependentName((String)gradleHome);
            jvmArgs.add(AndroidGradleSettings.createJvmArg((String)"com.android.studio.gradle.home.path", (String)gradleHome));
        }
        if ((serviceDirectory = executionSettings.getServiceDirectory()) != null && !serviceDirectory.isEmpty()) {
            serviceDirectory = FileUtil.toSystemDependentName((String)serviceDirectory);
            jvmArgs.add(AndroidGradleSettings.createJvmArg((String)"com.android.studio.gradle.service.dir.path", (String)serviceDirectory));
        }
        if ((javaHome = IdeSdks.getInstance().getJdkPath()) != null) {
            jvmArgs.add(AndroidGradleSettings.createJvmArg((String)"com.android.studio.gradle.java.home.path", (String)javaHome.getPath()));
        }
        jvmArgs.add(AndroidGradleSettings.createJvmArg((String)"com.android.studio.gradle.project.path", (String)Projects.getBaseDirPath(this.myProject).getPath()));
        boolean verboseProcessing = executionSettings.isVerboseProcessing();
        jvmArgs.add(AndroidGradleSettings.createJvmArg((String)"com.android.studio.gradle.use.verbose.logging", (boolean)verboseProcessing));
        if (!IdeInfo.getInstance().isAndroidStudio()) {
            Set jvmOptions = executionSettings.getVmOptions();
            int jvmOptionCount = 0;
            for (String option : jvmOptions) {
                String name = "com.android.studio.gradle.daemon.jvm.option." + jvmOptionCount++;
                jvmArgs.add(AndroidGradleSettings.createJvmArg((String)name, (String)option));
            }
        }
    }

    private static void addHttpProxySettings(@NotNull List<String> jvmArgs) {
        if (jvmArgs == null) {
            AndroidGradleBuildProcessParametersProvider.$$$reportNull$$$0(8);
        }
        AndroidGradleBuildProcessParametersProvider.populateHttpProxyProperties(jvmArgs, HttpConfigurable.getInstance().getJvmProperties(false, null));
    }

    @VisibleForTesting
    static void populateHttpProxyProperties(List<String> jvmArgs, List<Pair<String, String>> properties) {
        int propertyCount = properties.size();
        for (int i = 0; i < propertyCount; ++i) {
            Pair<String, String> property = properties.get(i);
            String name = "com.android.studio.gradle.proxy.property." + i;
            String value = (String)property.first + ":" + (String)property.second;
            jvmArgs.add(AndroidGradleSettings.createJvmArg((String)name, (String)value));
        }
    }

    private void populateJvmArgs(@NotNull BuildSettings buildSettings, @NotNull List<String> jvmArgs) {
        BuildMode buildMode;
        if (buildSettings == null) {
            AndroidGradleBuildProcessParametersProvider.$$$reportNull$$$0(9);
        }
        if (jvmArgs == null) {
            AndroidGradleBuildProcessParametersProvider.$$$reportNull$$$0(10);
        }
        if ((buildMode = buildSettings.getBuildMode()) == null) {
            buildMode = BuildMode.DEFAULT_BUILD_MODE;
        }
        jvmArgs.add(AndroidGradleSettings.createJvmArg((String)"com.android.studio.gradle.build.mode", (String)buildMode.toString()));
        this.populateGradleTasksToInvoke(buildMode, jvmArgs);
    }

    @VisibleForTesting
    void populateGradleTasksToInvoke(@NotNull BuildMode buildMode, @NotNull List<String> jvmArgs) {
        if (buildMode == null) {
            AndroidGradleBuildProcessParametersProvider.$$$reportNull$$$0(11);
        }
        if (jvmArgs == null) {
            AndroidGradleBuildProcessParametersProvider.$$$reportNull$$$0(12);
        }
        if (buildMode == BuildMode.ASSEMBLE_TRANSLATE) {
            jvmArgs.add(AndroidGradleSettings.createJvmArg((String)"com.android.studio.gradle.gradle.tasks.0", (String)"assembleTranslate"));
            return;
        }
        BuildSettings buildSettings = BuildSettings.getInstance(this.myProject);
        Module[] modulesToBuild = buildSettings.getModulesToBuild();
        if (modulesToBuild == null || buildMode == BuildMode.ASSEMBLE && GradleSyncState.getInstance(this.myProject).lastSyncFailed()) {
            jvmArgs.add(AndroidGradleSettings.createJvmArg((String)"com.android.studio.gradle.gradle.tasks.0", (String)"assemble"));
            return;
        }
        GradleBuildInvoker.TestCompileType testCompileType = GradleBuildInvoker.getTestCompileType(buildSettings.getRunConfigurationTypeId());
        List<String> tasks = GradleBuildInvoker.findTasksToExecute(modulesToBuild, buildMode, testCompileType);
        int taskCount = tasks.size();
        for (int i = 0; i < taskCount; ++i) {
            String name = "com.android.studio.gradle.gradle.tasks." + i;
            jvmArgs.add(AndroidGradleSettings.createJvmArg((String)name, (String)tasks.get(i)));
        }
    }

    public boolean isProcessPreloadingEnabled() {
        return !GradleProjectInfo.getInstance(this.myProject).isBuildWithGradle();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/build/compiler/AndroidGradleBuildProcessParametersProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildConfiguration";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jvmArgs";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionSettings";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildSettings";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/build/compiler/AndroidGradleBuildProcessParametersProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVMArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "populateJvmArgs";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addHttpProxySettings";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "populateGradleTasksToInvoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

