/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.invoker;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.BaseArtifact;
import com.android.tools.idea.gradle.project.BuildSettings;
import com.android.tools.idea.gradle.project.build.invoker.BuildStopper;
import com.android.tools.idea.gradle.project.build.invoker.GradleInvocationResult;
import com.android.tools.idea.gradle.project.build.invoker.GradleTasksExecutor;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacetConfiguration;
import com.android.tools.idea.gradle.project.facet.java.JavaFacet;
import com.android.tools.idea.gradle.project.facet.java.JavaFacetConfiguration;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.sdk.IdeSdks;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleProperties;

public class GradleBuildInvoker {
    @NotNull
    private final Project myProject;
    @NotNull
    private final GradleTasksExecutor.Factory myTaskExecutorFactory;
    @NotNull
    private final Set<AfterGradleInvocationTask> myAfterTasks;
    @NotNull
    private final List<String> myOneTimeGradleOptions;
    @NotNull
    private final List<String> myLastBuildTasks;
    @NotNull
    private final BuildStopper myBuildStopper;

    public static GradleBuildInvoker getInstance(@NotNull Project project) {
        if (project == null) {
            GradleBuildInvoker.$$$reportNull$$$0(0);
        }
        return (GradleBuildInvoker)ServiceManager.getService((Project)project, GradleBuildInvoker.class);
    }

    public GradleBuildInvoker(@NotNull Project project) {
        if (project == null) {
            GradleBuildInvoker.$$$reportNull$$$0(1);
        }
        this(project, new GradleTasksExecutor.Factory());
    }

    @VisibleForTesting
    GradleBuildInvoker(@NotNull Project project, @NotNull GradleTasksExecutor.Factory tasksExecutorFactory) {
        if (project == null) {
            GradleBuildInvoker.$$$reportNull$$$0(2);
        }
        if (tasksExecutorFactory == null) {
            GradleBuildInvoker.$$$reportNull$$$0(3);
        }
        this.myAfterTasks = new LinkedHashSet<AfterGradleInvocationTask>();
        this.myOneTimeGradleOptions = new ArrayList<String>();
        this.myLastBuildTasks = new ArrayList<String>();
        this.myBuildStopper = new BuildStopper();
        this.myProject = project;
        this.myTaskExecutorFactory = tasksExecutorFactory;
    }

    public void cleanProject() {
        this.setProjectBuildMode(BuildMode.CLEAN);
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        List<String> tasks = GradleBuildInvoker.findTasksToExecute(moduleManager.getModules(), BuildMode.SOURCE_GEN, TestCompileType.NONE);
        tasks.add(0, "clean");
        this.executeTasks(tasks, Collections.singletonList(GradleBuildInvoker.createGenerateSourcesOnlyProperty()));
    }

    public void assembleTranslate() {
        this.setProjectBuildMode(BuildMode.ASSEMBLE_TRANSLATE);
        this.executeTasks(Collections.singletonList("assembleTranslate"));
    }

    public void generateSources(boolean cleanProject) {
        BuildMode buildMode = BuildMode.SOURCE_GEN;
        this.setProjectBuildMode(buildMode);
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        List<String> tasks = GradleBuildInvoker.findTasksToExecute(moduleManager.getModules(), buildMode, TestCompileType.NONE);
        if (cleanProject) {
            tasks.add(0, "clean");
        }
        this.executeTasks(tasks, Collections.singletonList(GradleBuildInvoker.createGenerateSourcesOnlyProperty()));
    }

    @NotNull
    private static String createGenerateSourcesOnlyProperty() {
        String string = AndroidGradleSettings.createProjectProperty((String)"android.injected.generateSourcesOnly", (boolean)true);
        if (string == null) {
            GradleBuildInvoker.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void compileJava(@NotNull Module[] modules, @NotNull TestCompileType testCompileType) {
        if (modules == null) {
            GradleBuildInvoker.$$$reportNull$$$0(5);
        }
        if (testCompileType == null) {
            GradleBuildInvoker.$$$reportNull$$$0(6);
        }
        BuildMode buildMode = BuildMode.COMPILE_JAVA;
        this.setProjectBuildMode(buildMode);
        List<String> tasks = GradleBuildInvoker.findTasksToExecute(modules, buildMode, testCompileType);
        this.executeTasks(tasks);
    }

    public void assemble(@NotNull Module[] modules, @NotNull TestCompileType testCompileType) {
        if (modules == null) {
            GradleBuildInvoker.$$$reportNull$$$0(7);
        }
        if (testCompileType == null) {
            GradleBuildInvoker.$$$reportNull$$$0(8);
        }
        this.assemble(modules, testCompileType, Collections.emptyList());
    }

    public void assemble(@NotNull Module[] modules, @NotNull TestCompileType testCompileType, @NotNull List<String> arguments) {
        if (modules == null) {
            GradleBuildInvoker.$$$reportNull$$$0(9);
        }
        if (testCompileType == null) {
            GradleBuildInvoker.$$$reportNull$$$0(10);
        }
        if (arguments == null) {
            GradleBuildInvoker.$$$reportNull$$$0(11);
        }
        BuildMode buildMode = BuildMode.ASSEMBLE;
        this.setProjectBuildMode(buildMode);
        List<String> tasks = GradleBuildInvoker.findTasksToExecute(modules, buildMode, testCompileType);
        this.executeTasks(tasks, arguments);
    }

    public void rebuild() {
        BuildMode buildMode = BuildMode.REBUILD;
        this.setProjectBuildMode(buildMode);
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        List<String> tasks = GradleBuildInvoker.findTasksToExecute(moduleManager.getModules(), buildMode, TestCompileType.NONE);
        this.executeTasks(tasks);
    }

    public void rebuildWithTempOptions(@NotNull List<String> options) {
        if (options == null) {
            GradleBuildInvoker.$$$reportNull$$$0(12);
        }
        this.myOneTimeGradleOptions.addAll(options);
        try {
            if (this.myLastBuildTasks.isEmpty()) {
                this.rebuild();
            } else {
                ArrayList<String> tasksFromLastBuild = new ArrayList<String>();
                tasksFromLastBuild.addAll(this.myLastBuildTasks);
                this.executeTasks(tasksFromLastBuild);
            }
        }
        finally {
            this.myOneTimeGradleOptions.clear();
        }
    }

    private void setProjectBuildMode(@NotNull BuildMode buildMode) {
        if (buildMode == null) {
            GradleBuildInvoker.$$$reportNull$$$0(13);
        }
        BuildSettings.getInstance(this.myProject).setBuildMode(buildMode);
    }

    @NotNull
    public static List<String> findCleanTasksForModules(@NotNull Module[] modules) {
        if (modules == null) {
            GradleBuildInvoker.$$$reportNull$$$0(14);
        }
        ArrayList<String> tasks = new ArrayList<String>();
        for (Module module : modules) {
            GradleFacet gradleFacet = GradleFacet.getInstance(module);
            if (gradleFacet == null) continue;
            String gradlePath = ((GradleFacetConfiguration)gradleFacet.getConfiguration()).GRADLE_PROJECT_PATH;
            GradleBuildInvoker.addTaskIfSpecified(tasks, gradlePath, "clean");
        }
        ArrayList<String> arrayList = tasks;
        if (arrayList == null) {
            GradleBuildInvoker.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @NotNull
    public static List<String> findTasksToExecute(@NotNull Module[] modules, @NotNull BuildMode buildMode, @NotNull TestCompileType testCompileType) {
        Project project;
        if (modules == null) {
            GradleBuildInvoker.$$$reportNull$$$0(16);
        }
        if (buildMode == null) {
            GradleBuildInvoker.$$$reportNull$$$0(17);
        }
        if (testCompileType == null) {
            GradleBuildInvoker.$$$reportNull$$$0(18);
        }
        ArrayList<String> tasks = new ArrayList<String>();
        if (BuildMode.ASSEMBLE == buildMode && GradleSyncState.getInstance(project = modules[0].getProject()).lastSyncFailed()) {
            List<String> list = Collections.singletonList("assemble");
            if (list == null) {
                GradleBuildInvoker.$$$reportNull$$$0(19);
            }
            return list;
        }
        for (Project module : modules) {
            if ("buildSrc".equals(module.getName())) continue;
            GradleBuildInvoker.findAndAddGradleBuildTasks((Module)module, buildMode, tasks, testCompileType);
        }
        if (buildMode == BuildMode.REBUILD && !tasks.isEmpty()) {
            tasks.add(0, "clean");
        }
        if (tasks.isEmpty()) {
            String format = "Unable to find Gradle tasks for project '%1$s' using BuildMode %2$s";
            GradleBuildInvoker.getLogger().info(String.format(format, modules[0].getProject().getName(), buildMode.name()));
        }
        ArrayList<String> arrayList = tasks;
        if (arrayList == null) {
            GradleBuildInvoker.$$$reportNull$$$0(20);
        }
        return arrayList;
    }

    public void executeTasks(@NotNull List<String> gradleTasks) {
        if (gradleTasks == null) {
            GradleBuildInvoker.$$$reportNull$$$0(21);
        }
        this.executeTasks(gradleTasks, this.myOneTimeGradleOptions);
    }

    public void executeTasks(@NotNull List<String> tasks, @Nullable BuildMode buildMode, @NotNull List<String> commandLineArguments) {
        if (tasks == null) {
            GradleBuildInvoker.$$$reportNull$$$0(22);
        }
        if (commandLineArguments == null) {
            GradleBuildInvoker.$$$reportNull$$$0(23);
        }
        if (buildMode != null) {
            this.setProjectBuildMode(buildMode);
        }
        this.executeTasks(tasks, commandLineArguments);
    }

    public void executeTasks(@NotNull List<String> gradleTasks, @NotNull List<String> commandLineArguments) {
        if (gradleTasks == null) {
            GradleBuildInvoker.$$$reportNull$$$0(24);
        }
        if (commandLineArguments == null) {
            GradleBuildInvoker.$$$reportNull$$$0(25);
        }
        ArrayList<String> jvmArguments = new ArrayList<String>();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            File androidHomePath;
            LocalProperties localProperties;
            try {
                localProperties = new LocalProperties(this.myProject);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (localProperties.getAndroidSdkPath() == null && (androidHomePath = IdeSdks.getInstance().getAndroidSdkPath()) != null) {
                jvmArguments.add(AndroidGradleSettings.createAndroidHomeJvmArg((String)androidHomePath.getPath()));
            }
        }
        Request request = new Request(this.myProject, gradleTasks);
        request.setJvmArguments(jvmArguments).setCommandLineArguments(commandLineArguments);
        this.executeTasks(request);
    }

    public void executeTasks(@NotNull Request request) {
        if (request == null) {
            GradleBuildInvoker.$$$reportNull$$$0(26);
        }
        this.myLastBuildTasks.clear();
        List<String> gradleTasks = request.getGradleTasks();
        this.myLastBuildTasks.addAll(gradleTasks);
        GradleBuildInvoker.getLogger().info("About to execute Gradle tasks: " + gradleTasks);
        if (gradleTasks.isEmpty()) {
            return;
        }
        GradleTasksExecutor executor = this.myTaskExecutorFactory.create(request, this.myBuildStopper);
        GradleBuildInvoker.saveAllFilesSafely();
        if (ApplicationManager.getApplication().isDispatchThread()) {
            executor.queue();
        } else if (request.isWaitForCompletion()) {
            executor.queueAndWaitForCompletion();
        } else {
            UIUtil.invokeAndWaitIfNeeded(() -> ((GradleTasksExecutor)executor).queue());
        }
    }

    public static void saveAllFilesSafely() {
        ApplicationManager.getApplication().invokeAndWait(() -> ApplicationManager.getApplication().runWriteAction(() -> FileDocumentManager.getInstance().saveAllDocuments()));
    }

    private static void findAndAddGradleBuildTasks(@NotNull Module module, @NotNull BuildMode buildMode, @NotNull List<String> tasks, @NotNull TestCompileType testCompileType) {
        block18: {
            String gradlePath;
            block17: {
                GradleFacet gradleFacet;
                if (module == null) {
                    GradleBuildInvoker.$$$reportNull$$$0(27);
                }
                if (buildMode == null) {
                    GradleBuildInvoker.$$$reportNull$$$0(28);
                }
                if (tasks == null) {
                    GradleBuildInvoker.$$$reportNull$$$0(29);
                }
                if (testCompileType == null) {
                    GradleBuildInvoker.$$$reportNull$$$0(30);
                }
                if ((gradleFacet = GradleFacet.getInstance(module)) == null) {
                    return;
                }
                gradlePath = ((GradleFacetConfiguration)gradleFacet.getConfiguration()).GRADLE_PROJECT_PATH;
                if (StringUtil.isEmpty((String)gradlePath)) {
                    String msg = String.format("Module '%1$s' does not have a Gradle path. It is likely that this module was manually added by the user.", module.getName());
                    GradleBuildInvoker.getLogger().info(msg);
                    return;
                }
                AndroidFacet androidFacet = AndroidFacet.getInstance(module);
                if (androidFacet == null) break block17;
                JpsAndroidModuleProperties properties = androidFacet.getProperties();
                AndroidModuleModel androidModel = AndroidModuleModel.get(module);
                switch (buildMode) {
                    case CLEAN: 
                    case SOURCE_GEN: {
                        GradleBuildInvoker.addAfterSyncTasks(tasks, gradlePath, properties);
                        GradleBuildInvoker.addAfterSyncTasksForTestArtifacts(tasks, gradlePath, testCompileType, androidModel);
                        break;
                    }
                    case ASSEMBLE: {
                        tasks.add(GradleBuildInvoker.createBuildTask(gradlePath, properties.ASSEMBLE_TASK_NAME));
                        if (testCompileType != TestCompileType.NONE) {
                            for (BaseArtifact artifact : GradleBuildInvoker.getArtifactsForTestCompileType(testCompileType, androidModel)) {
                                GradleBuildInvoker.addTaskIfSpecified(tasks, gradlePath, artifact.getAssembleTaskName());
                            }
                        }
                        break block18;
                    }
                    default: {
                        GradleBuildInvoker.addAfterSyncTasks(tasks, gradlePath, properties);
                        GradleBuildInvoker.addAfterSyncTasksForTestArtifacts(tasks, gradlePath, testCompileType, androidModel);
                        if (testCompileType != TestCompileType.UNIT_TESTS) {
                            GradleBuildInvoker.addTaskIfSpecified(tasks, gradlePath, properties.COMPILE_JAVA_TASK_NAME);
                        }
                        for (BaseArtifact artifact : GradleBuildInvoker.getArtifactsForTestCompileType(testCompileType, androidModel)) {
                            GradleBuildInvoker.addTaskIfSpecified(tasks, gradlePath, artifact.getCompileTaskName());
                        }
                        break block18;
                    }
                }
                break block18;
            }
            JavaFacet javaFacet = JavaFacet.getInstance(module);
            if (javaFacet != null && ((JavaFacetConfiguration)javaFacet.getConfiguration()).BUILDABLE) {
                String gradleTaskName = javaFacet.getGradleTaskName(buildMode);
                if (gradleTaskName != null) {
                    tasks.add(GradleBuildInvoker.createBuildTask(gradlePath, gradleTaskName));
                }
                if (testCompileType == TestCompileType.UNIT_TESTS) {
                    tasks.add(GradleBuildInvoker.createBuildTask(gradlePath, "testClasses"));
                }
            }
        }
    }

    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance(GradleBuildInvoker.class);
        if (logger == null) {
            GradleBuildInvoker.$$$reportNull$$$0(31);
        }
        return logger;
    }

    private static void addAfterSyncTasksForTestArtifacts(@NotNull List<String> tasks, @NotNull String gradlePath, @NotNull TestCompileType testCompileType, @Nullable AndroidModuleModel androidModel) {
        if (tasks == null) {
            GradleBuildInvoker.$$$reportNull$$$0(32);
        }
        if (gradlePath == null) {
            GradleBuildInvoker.$$$reportNull$$$0(33);
        }
        if (testCompileType == null) {
            GradleBuildInvoker.$$$reportNull$$$0(34);
        }
        Collection<BaseArtifact> testArtifacts = GradleBuildInvoker.getArtifactsForTestCompileType(testCompileType, androidModel);
        for (BaseArtifact artifact : testArtifacts) {
            for (String taskName : AndroidModuleModel.getIdeSetupTasks(artifact)) {
                GradleBuildInvoker.addTaskIfSpecified(tasks, gradlePath, taskName);
            }
        }
    }

    @NotNull
    private static Collection<BaseArtifact> getArtifactsForTestCompileType(@NotNull TestCompileType testCompileType, @Nullable AndroidModuleModel androidModel) {
        if (testCompileType == null) {
            GradleBuildInvoker.$$$reportNull$$$0(35);
        }
        if (androidModel == null) {
            List<BaseArtifact> list = Collections.emptyList();
            if (list == null) {
                GradleBuildInvoker.$$$reportNull$$$0(36);
            }
            return list;
        }
        AndroidArtifact testArtifact = null;
        switch (testCompileType) {
            case NONE: {
                Collection<BaseArtifact> collection = androidModel.getTestArtifactsInSelectedVariant();
                if (collection == null) {
                    GradleBuildInvoker.$$$reportNull$$$0(37);
                }
                return collection;
            }
            case ANDROID_TESTS: {
                testArtifact = androidModel.getAndroidTestArtifactInSelectedVariant();
                break;
            }
            case UNIT_TESTS: {
                testArtifact = androidModel.getUnitTestArtifactInSelectedVariant();
            }
        }
        ImmutableList immutableList = testArtifact != null ? ImmutableList.of((Object)testArtifact) : Collections.emptyList();
        if (immutableList == null) {
            GradleBuildInvoker.$$$reportNull$$$0(38);
        }
        return immutableList;
    }

    private static void addAfterSyncTasks(@NotNull List<String> tasks, @NotNull String gradlePath, @NotNull JpsAndroidModuleProperties properties) {
        if (tasks == null) {
            GradleBuildInvoker.$$$reportNull$$$0(39);
        }
        if (gradlePath == null) {
            GradleBuildInvoker.$$$reportNull$$$0(40);
        }
        if (properties == null) {
            GradleBuildInvoker.$$$reportNull$$$0(41);
        }
        for (String taskName : properties.AFTER_SYNC_TASK_NAMES) {
            GradleBuildInvoker.addTaskIfSpecified(tasks, gradlePath, taskName);
        }
    }

    private static void addTaskIfSpecified(@NotNull List<String> tasks, @NotNull String gradlePath, @Nullable String gradleTaskName) {
        String buildTask;
        if (tasks == null) {
            GradleBuildInvoker.$$$reportNull$$$0(42);
        }
        if (gradlePath == null) {
            GradleBuildInvoker.$$$reportNull$$$0(43);
        }
        if (StringUtil.isNotEmpty((String)gradleTaskName) && !tasks.contains(buildTask = GradleBuildInvoker.createBuildTask(gradlePath, gradleTaskName))) {
            tasks.add(buildTask);
        }
    }

    @NotNull
    public static String createBuildTask(@NotNull String gradleProjectPath, @NotNull String taskName) {
        if (gradleProjectPath == null) {
            GradleBuildInvoker.$$$reportNull$$$0(44);
        }
        if (taskName == null) {
            GradleBuildInvoker.$$$reportNull$$$0(45);
        }
        if (gradleProjectPath.equals(":")) {
            String string = gradleProjectPath + taskName;
            if (string == null) {
                GradleBuildInvoker.$$$reportNull$$$0(46);
            }
            return string;
        }
        String string = gradleProjectPath + ":" + taskName;
        if (string == null) {
            GradleBuildInvoker.$$$reportNull$$$0(47);
        }
        return string;
    }

    @NotNull
    public static TestCompileType getTestCompileType(@Nullable String runConfigurationId) {
        if (runConfigurationId != null) {
            if (AndroidCommonUtils.isInstrumentationTestConfiguration((String)runConfigurationId)) {
                TestCompileType testCompileType = TestCompileType.ANDROID_TESTS;
                if (testCompileType == null) {
                    GradleBuildInvoker.$$$reportNull$$$0(48);
                }
                return testCompileType;
            }
            if (AndroidCommonUtils.isTestConfiguration((String)runConfigurationId)) {
                TestCompileType testCompileType = TestCompileType.UNIT_TESTS;
                if (testCompileType == null) {
                    GradleBuildInvoker.$$$reportNull$$$0(49);
                }
                return testCompileType;
            }
        }
        TestCompileType testCompileType = TestCompileType.NONE;
        if (testCompileType == null) {
            GradleBuildInvoker.$$$reportNull$$$0(50);
        }
        return testCompileType;
    }

    public void stopBuild(@NotNull ExternalSystemTaskId id) {
        if (id == null) {
            GradleBuildInvoker.$$$reportNull$$$0(51);
        }
        this.myBuildStopper.attemptToStopBuild(id, null);
    }

    public void add(@NotNull AfterGradleInvocationTask task) {
        if (task == null) {
            GradleBuildInvoker.$$$reportNull$$$0(52);
        }
        this.myAfterTasks.add(task);
    }

    @NotNull
    AfterGradleInvocationTask[] getAfterInvocationTasks() {
        AfterGradleInvocationTask[] afterGradleInvocationTaskArray = this.myAfterTasks.toArray(new AfterGradleInvocationTask[this.myAfterTasks.size()]);
        if (afterGradleInvocationTaskArray == null) {
            GradleBuildInvoker.$$$reportNull$$$0(53);
        }
        return afterGradleInvocationTaskArray;
    }

    public void remove(@NotNull AfterGradleInvocationTask task) {
        if (task == null) {
            GradleBuildInvoker.$$$reportNull$$$0(54);
        }
        this.myAfterTasks.remove(task);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            GradleBuildInvoker.$$$reportNull$$$0(55);
        }
        return project;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 15: 
            case 19: 
            case 20: 
            case 31: 
            case 36: 
            case 37: 
            case 38: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 53: 
            case 55: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 15: 
            case 19: 
            case 20: 
            case 31: 
            case 36: 
            case 37: 
            case 38: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 53: 
            case 55: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasksExecutorFactory";
                break;
            }
            case 4: 
            case 15: 
            case 19: 
            case 20: 
            case 31: 
            case 36: 
            case 37: 
            case 38: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 53: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 18: 
            case 30: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testCompileType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 13: 
            case 17: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildMode";
                break;
            }
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleTasks";
                break;
            }
            case 22: 
            case 29: 
            case 32: 
            case 39: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLineArguments";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 33: 
            case 40: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradlePath";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleProjectPath";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskName";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 52: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createGenerateSourcesOnlyProperty";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "findCleanTasksForModules";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "findTasksToExecute";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactsForTestCompileType";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuildTask";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestCompileType";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getAfterInvocationTasks";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 15: 
            case 19: 
            case 20: 
            case 31: 
            case 36: 
            case 37: 
            case 38: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 53: 
            case 55: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "compileJava";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "assemble";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "rebuildWithTempOptions";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setProjectBuildMode";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findCleanTasksForModules";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findTasksToExecute";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "executeTasks";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "findAndAddGradleBuildTasks";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "addAfterSyncTasksForTestArtifacts";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getArtifactsForTestCompileType";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "addAfterSyncTasks";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "addTaskIfSpecified";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "createBuildTask";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "stopBuild";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 15: 
            case 19: 
            case 20: 
            case 31: 
            case 36: 
            case 37: 
            case 38: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 53: 
            case 55: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Request {
        @NotNull
        private final Project myProject;
        @NotNull
        private final List<String> myGradleTasks;
        @NotNull
        private final List<String> myJvmArguments;
        @NotNull
        private final List<String> myCommandLineArguments;
        @NotNull
        private final ExternalSystemTaskId myTaskId;
        @Nullable
        private ExternalSystemTaskNotificationListener myTaskListener;
        @Nullable
        private File myBuildFilePath;
        private boolean myWaitForCompletion;
        private boolean myUseEmbeddedGradle;

        public Request(@NotNull Project project, String ... gradleTasks) {
            if (project == null) {
                Request.$$$reportNull$$$0(0);
            }
            if (gradleTasks == null) {
                Request.$$$reportNull$$$0(1);
            }
            this(project, Arrays.asList(gradleTasks));
        }

        public Request(@NotNull Project project, @NotNull List<String> gradleTasks) {
            if (project == null) {
                Request.$$$reportNull$$$0(2);
            }
            if (gradleTasks == null) {
                Request.$$$reportNull$$$0(3);
            }
            this(project, gradleTasks, ExternalSystemTaskId.create((ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID, (ExternalSystemTaskType)ExternalSystemTaskType.EXECUTE_TASK, (Project)project));
        }

        public Request(@NotNull Project project, @NotNull List<String> gradleTasks, @NotNull ExternalSystemTaskId taskId) {
            if (project == null) {
                Request.$$$reportNull$$$0(4);
            }
            if (gradleTasks == null) {
                Request.$$$reportNull$$$0(5);
            }
            if (taskId == null) {
                Request.$$$reportNull$$$0(6);
            }
            this.myProject = project;
            this.myGradleTasks = new ArrayList<String>(gradleTasks);
            this.myJvmArguments = new ArrayList<String>();
            this.myCommandLineArguments = new ArrayList<String>();
            this.myTaskId = taskId;
        }

        @NotNull
        Project getProject() {
            Project project = this.myProject;
            if (project == null) {
                Request.$$$reportNull$$$0(7);
            }
            return project;
        }

        @NotNull
        List<String> getGradleTasks() {
            List<String> list = this.myGradleTasks;
            if (list == null) {
                Request.$$$reportNull$$$0(8);
            }
            return list;
        }

        @NotNull
        List<String> getJvmArguments() {
            List<String> list = this.myJvmArguments;
            if (list == null) {
                Request.$$$reportNull$$$0(9);
            }
            return list;
        }

        @NotNull
        public Request setJvmArguments(@NotNull List<String> jvmArguments) {
            if (jvmArguments == null) {
                Request.$$$reportNull$$$0(10);
            }
            this.myJvmArguments.clear();
            this.myJvmArguments.addAll(jvmArguments);
            Request request = this;
            if (request == null) {
                Request.$$$reportNull$$$0(11);
            }
            return request;
        }

        @NotNull
        List<String> getCommandLineArguments() {
            List<String> list = this.myCommandLineArguments;
            if (list == null) {
                Request.$$$reportNull$$$0(12);
            }
            return list;
        }

        @NotNull
        public Request setCommandLineArguments(@NotNull List<String> commandLineArguments) {
            if (commandLineArguments == null) {
                Request.$$$reportNull$$$0(13);
            }
            this.myCommandLineArguments.clear();
            this.myCommandLineArguments.addAll(commandLineArguments);
            Request request = this;
            if (request == null) {
                Request.$$$reportNull$$$0(14);
            }
            return request;
        }

        @Nullable
        public ExternalSystemTaskNotificationListener getTaskListener() {
            return this.myTaskListener;
        }

        @NotNull
        public Request setTaskListener(@Nullable ExternalSystemTaskNotificationListener taskListener) {
            this.myTaskListener = taskListener;
            Request request = this;
            if (request == null) {
                Request.$$$reportNull$$$0(15);
            }
            return request;
        }

        @NotNull
        ExternalSystemTaskId getTaskId() {
            ExternalSystemTaskId externalSystemTaskId = this.myTaskId;
            if (externalSystemTaskId == null) {
                Request.$$$reportNull$$$0(16);
            }
            return externalSystemTaskId;
        }

        @Nullable
        File getBuildFilePath() {
            return this.myBuildFilePath;
        }

        @NotNull
        public Request setBuildFilePath(@Nullable File buildFilePath) {
            this.myBuildFilePath = buildFilePath;
            Request request = this;
            if (request == null) {
                Request.$$$reportNull$$$0(17);
            }
            return request;
        }

        boolean isWaitForCompletion() {
            return this.myWaitForCompletion;
        }

        @NotNull
        public Request setWaitForCompletion(boolean waitForCompletion) {
            this.myWaitForCompletion = waitForCompletion;
            Request request = this;
            if (request == null) {
                Request.$$$reportNull$$$0(18);
            }
            return request;
        }

        boolean isUseEmbeddedGradle() {
            return this.myUseEmbeddedGradle;
        }

        @NotNull
        public Request setUseEmbeddedGradle(boolean useEmbeddedGradle) {
            this.myUseEmbeddedGradle = useEmbeddedGradle;
            Request request = this;
            if (request == null) {
                Request.$$$reportNull$$$0(19);
            }
            return request;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request that = (Request)o;
            return Objects.equals(this.myBuildFilePath, that.myBuildFilePath) && Objects.equals(this.myGradleTasks, that.myGradleTasks) && Objects.equals(this.myJvmArguments, that.myJvmArguments) && Objects.equals(this.myCommandLineArguments, that.myCommandLineArguments);
        }

        public int hashCode() {
            return Objects.hash(this.myBuildFilePath, this.myGradleTasks, this.myJvmArguments, this.myCommandLineArguments);
        }

        public String toString() {
            return "RequestSettings{myBuildFilePath=" + this.myBuildFilePath + ", myGradleTasks=" + this.myGradleTasks + ", myJvmArguments=" + this.myJvmArguments + ", myCommandLineArguments=" + this.myCommandLineArguments + '}';
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 11: 
                case 12: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 11: 
                case 12: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gradleTasks";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "taskId";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 11: 
                case 12: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker$Request";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jvmArguments";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commandLineArguments";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker$Request";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGradleTasks";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getJvmArguments";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setJvmArguments";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommandLineArguments";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setCommandLineArguments";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setTaskListener";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTaskId";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setBuildFilePath";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setWaitForCompletion";
                    break;
                }
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setUseEmbeddedGradle";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 11: 
                case 12: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "setJvmArguments";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "setCommandLineArguments";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 11: 
                case 12: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface AfterGradleInvocationTask {
        public void execute(@NotNull GradleInvocationResult var1);
    }

    public static enum TestCompileType {
        NONE,
        ANDROID_TESTS,
        UNIT_TESTS;

    }
}

