/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.invoker;

import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.fd.FlightRecorder;
import com.android.tools.idea.fd.InstantRunBuildProgressListener;
import com.android.tools.idea.fd.InstantRunSettings;
import com.android.tools.idea.gradle.output.parser.BuildOutputParser;
import com.android.tools.idea.gradle.project.build.compiler.AndroidGradleBuildConfiguration;
import com.android.tools.idea.gradle.project.build.console.view.GradleConsoleView;
import com.android.tools.idea.gradle.project.build.invoker.BuildProcessController;
import com.android.tools.idea.gradle.project.build.invoker.BuildStopper;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.project.build.invoker.GradleInvocationResult;
import com.android.tools.idea.gradle.project.build.invoker.GradleOutputForwarder;
import com.android.tools.idea.gradle.project.build.invoker.TaskExecutionProgressIndicator;
import com.android.tools.idea.gradle.project.build.invoker.messages.GradleBuildTreeViewPanel;
import com.android.tools.idea.gradle.project.common.GradleInitScripts;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.SelectSdkDialog;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import com.intellij.compiler.CompilerManagerImpl;
import com.intellij.compiler.CompilerWorkspaceConfiguration;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.VetoableProjectManagerListener;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.pom.Navigatable;
import com.intellij.ui.AppIcon;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.MessageView;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.SystemProperties;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.JComponent;
import net.jcip.annotations.GuardedBy;
import org.gradle.tooling.BuildCancelledException;
import org.gradle.tooling.BuildException;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.LongRunningOperation;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.events.ProgressEvent;
import org.gradle.tooling.events.ProgressListener;
import org.jetbrains.android.AndroidPlugin;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.service.JpsServiceManager;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionHelper;
import org.jetbrains.plugins.gradle.service.execution.GradleProgressEventConverter;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;

public abstract class GradleTasksExecutor
extends Task.Backgroundable {
    @NotNull
    public static final NotificationGroup LOGGING_NOTIFICATION = NotificationGroup.logOnlyGroup((String)"Gradle Build (Logging)");
    @NotNull
    public static final NotificationGroup BALLOON_NOTIFICATION = NotificationGroup.balloonGroup((String)"Gradle Build (Balloon)");
    private static final Key<Key<?>> CONTENT_ID_KEY = Key.create((String)"CONTENT_ID");

    protected GradleTasksExecutor(@Nullable Project project) {
        super(project, "Gradle Build Running", true);
    }

    public abstract void queueAndWaitForCompletion();

    public static void clearMessageView(@NotNull Project project) {
        if (project == null) {
            GradleTasksExecutor.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (project == null) {
                GradleTasksExecutor.$$$reportNull$$$0(2);
            }
            if (!project.isDisposed()) {
                GradleTasksExecutor.removeUnpinnedBuildMessages(project, null);
            }
        });
    }

    static void removeUnpinnedBuildMessages(@NotNull Project project, @Nullable Content toKeep) {
        if (project == null) {
            GradleTasksExecutor.$$$reportNull$$$0(1);
        }
        if (project.isInitialized()) {
            Content[] contents;
            MessageView messageView = MessageView.SERVICE.getInstance((Project)project);
            for (Content content : contents = messageView.getContentManager().getContents()) {
                if (content.isPinned() || content == toKeep || content.getUserData(CONTENT_ID_KEY) == null) continue;
                messageView.getContentManager().removeContent(content, true);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/android/tools/idea/gradle/project/build/invoker/GradleTasksExecutor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "clearMessageView";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "removeUnpinnedBuildMessages";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$clearMessageView$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class GradleTasksExecutorImpl
    extends GradleTasksExecutor {
        private static final ExternalSystemTaskNotificationListener GRADLE_LISTENER = new ExternalSystemTaskNotificationListenerAdapter(){};
        private static final long ONE_MINUTE_MS = 60000L;
        @NonNls
        private static final String CONTENT_NAME = "Gradle Build";
        @NonNls
        private static final String APP_ICON_ID = "compiler";
        private static final int BUFFER_SIZE = 2048;
        private static final String GRADLE_RUNNING_MSG_TITLE = "Gradle Running";
        private static final String PASSWORD_KEY_SUFFIX = ".password=";
        public static final String ANDROID_ADDITIONAL_PLUGINS = "android.additional.plugins";
        public static final String COM_ANDROID_TOOLS_PROFILER = "com.android.tools.profiler";
        @NotNull
        private final Key<Key<?>> myContentId;
        @NotNull
        private final Object myMessageViewLock;
        @NotNull
        private final Object myCompletionLock;
        @NotNull
        private final GradleBuildInvoker.Request myRequest;
        @NotNull
        private final BuildStopper myBuildStopper;
        @GuardedBy(value="myCompletionLock")
        private int myCompletionCounter;
        @GuardedBy(value="myMessageViewLock")
        @Nullable
        private GradleBuildTreeViewPanel myErrorTreeView;
        @NotNull
        private final GradleExecutionHelper myHelper;
        private volatile int myErrorCount;
        private volatile int myWarningCount;
        @NotNull
        private volatile ProgressIndicator myProgressIndicator;
        private volatile boolean myMessageViewIsPrepared;
        private volatile boolean myMessagesAutoActivated;
        private CloseListener myCloseListener;

        @VisibleForTesting
        GradleTasksExecutorImpl(@NotNull GradleBuildInvoker.Request request, @NotNull BuildStopper buildStopper) {
            if (request == null) {
                GradleTasksExecutorImpl.$$$reportNull$$$0(0);
            }
            if (buildStopper == null) {
                GradleTasksExecutorImpl.$$$reportNull$$$0(1);
            }
            super(request.getProject());
            this.myContentId = Key.create((String)"compile_content");
            this.myMessageViewLock = new Object();
            this.myCompletionLock = new Object();
            this.myHelper = new GradleExecutionHelper();
            this.myProgressIndicator = new EmptyProgressIndicator();
            this.myRequest = request;
            this.myBuildStopper = buildStopper;
        }

        public String getProcessId() {
            return "GradleTaskInvocation";
        }

        @Nullable
        public Task.NotificationInfo getNotificationInfo() {
            return new Task.NotificationInfo(this.myErrorCount > 0 ? "Gradle Invocation (errors)" : "Gradle Invocation (success)", "Gradle Invocation Finished", this.myErrorCount + " Errors, " + this.myWarningCount + " Warnings", true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                GradleTasksExecutorImpl.$$$reportNull$$$0(2);
            }
            if (IdeInfo.getInstance().isAndroidStudio()) {
                GradleUtil.clearStoredGradleJvmArgs(this.getProject());
            }
            this.myProgressIndicator = indicator;
            Project project = this.myRequest.getProject();
            this.myCloseListener = new CloseListener();
            MessageBusConnection busConnection = project.getMessageBus().connect();
            busConnection.subscribe(ProjectManager.TOPIC, (Object)this.myCloseListener);
            Semaphore semaphore = ((CompilerManagerImpl)CompilerManager.getInstance((Project)project)).getCompilationSemaphore();
            boolean acquired = false;
            try {
                try {
                    while (!acquired) {
                        acquired = semaphore.tryAcquire(300L, TimeUnit.MILLISECONDS);
                        if (!this.myProgressIndicator.isCanceled()) continue;
                        break;
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                this.addIndicatorDelegate();
                this.invokeGradleTasks();
            }
            finally {
                try {
                    this.myProgressIndicator.stop();
                    busConnection.disconnect();
                }
                finally {
                    if (acquired) {
                        semaphore.release();
                    }
                }
            }
        }

        private void addIndicatorDelegate() {
            if (this.myProgressIndicator instanceof ProgressIndicatorEx) {
                ProgressIndicatorEx indicator = (ProgressIndicatorEx)this.myProgressIndicator;
                indicator.addStateDelegate((ProgressIndicatorEx)new ProgressIndicatorStateDelegate(this.myRequest.getTaskId(), this.myBuildStopper));
            }
        }

        private void closeView() {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = myMessageViewLock;
                    synchronized (object) {
                        if (myErrorTreeView != null && !myRequest.getProject().isDisposed()) {
                            this.addStatisticsMessage(CompilerBundle.message((String)"statistics.error.count", (Object[])new Object[]{myErrorCount}));
                            this.addStatisticsMessage(CompilerBundle.message((String)"statistics.warnings.count", (Object[])new Object[]{myWarningCount}));
                            this.addMessage(new Message(Message.Kind.INFO, "See complete output in console", SourceFilePosition.UNKNOWN, new SourceFilePosition[0]), new OpenGradleConsole());
                            myErrorTreeView.selectFirstMessage();
                        }
                    }
                }

                private void addStatisticsMessage(@NotNull String text) {
                    if (text == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    this.addMessage(new Message(Message.Kind.STATISTICS, text, SourceFilePosition.UNKNOWN, new SourceFilePosition[0]), null);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/project/build/invoker/GradleTasksExecutor$GradleTasksExecutorImpl$2", "addStatisticsMessage"));
                }
            }, ModalityState.NON_MODAL);
        }

        private void invokeGradleTasks() {
            File buildFilePath;
            Application application;
            Runnable task;
            Project project = this.myRequest.getProject();
            GradleExecutionSettings executionSettings = GradleUtil.getOrCreateGradleExecutionSettings(project, this.myRequest.isUseEmbeddedGradle());
            Function executeTasksFunction = connection -> {
                block23: {
                    String testOutput;
                    Stopwatch stopwatch = Stopwatch.createStarted();
                    GradleConsoleView consoleView = GradleConsoleView.getInstance(project);
                    consoleView.clear();
                    List<String> gradleTasks = this.myRequest.getGradleTasks();
                    this.addMessage(new Message(Message.Kind.INFO, "Gradle tasks " + gradleTasks, SourceFilePosition.UNKNOWN, new SourceFilePosition[0]), null);
                    String executingTasksText = "Executing tasks: " + gradleTasks;
                    consoleView.print(executingTasksText + SystemProperties.getLineSeparator() + SystemProperties.getLineSeparator(), ConsoleViewContentType.NORMAL_OUTPUT);
                    this.addToEventLog(executingTasksText, MessageType.INFO);
                    GradleOutputForwarder output = new GradleOutputForwarder(consoleView);
                    BuildException buildError = null;
                    InstantRunBuildProgressListener instantRunProgressListener = null;
                    ExternalSystemTaskId id = this.myRequest.getTaskId();
                    CancellationTokenSource cancellationTokenSource = this.myBuildStopper.createAndRegisterTokenSource(id);
                    try {
                        String logMessage;
                        AndroidGradleBuildConfiguration buildConfiguration = AndroidGradleBuildConfiguration.getInstance(project);
                        ArrayList commandLineArguments = Lists.newArrayList((Object[])buildConfiguration.getCommandLineOptions());
                        if (buildConfiguration.USE_CONFIGURATION_ON_DEMAND && !commandLineArguments.contains("--configure-on-demand")) {
                            commandLineArguments.add("--configure-on-demand");
                        }
                        if (!commandLineArguments.contains("--parallel") && CompilerWorkspaceConfiguration.getInstance((Project)project).PARALLEL_COMPILATION) {
                            commandLineArguments.add("--parallel");
                        }
                        commandLineArguments.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.invoked.from.ide", (boolean)true));
                        commandLineArguments.addAll(this.myRequest.getCommandLineArguments());
                        GradleInitScripts initScripts = GradleInitScripts.getInstance();
                        initScripts.addLocalMavenRepoInitScriptCommandLineArgTo(commandLineArguments);
                        GradleUtil.attemptToUseEmbeddedGradle(project);
                        if (System.getProperty("enable.experimental.profiling") != null) {
                            initScripts.addProfilerClasspathInitScriptCommandLineArgTo(commandLineArguments);
                            commandLineArguments.add(AndroidGradleSettings.createProjectProperty((String)ANDROID_ADDITIONAL_PLUGINS, (String)COM_ANDROID_TOOLS_PROFILER));
                        }
                        if ((logMessage = "Build command line options: " + commandLineArguments).contains(PASSWORD_KEY_SUFFIX)) {
                            ArrayList<String> replaced = new ArrayList<String>(commandLineArguments.size());
                            for (String option : commandLineArguments) {
                                int index = option.indexOf(PASSWORD_KEY_SUFFIX);
                                if (index == -1) {
                                    replaced.add(option);
                                    continue;
                                }
                                replaced.add(option.substring(0, index + PASSWORD_KEY_SUFFIX.length()) + "*********");
                            }
                            logMessage = ((Object)replaced).toString();
                        }
                        GradleTasksExecutorImpl.getLogger().info(logMessage);
                        ArrayList<String> jvmArguments = new ArrayList<String>(this.myRequest.getJvmArguments());
                        BuildLauncher launcher = connection.newBuild();
                        GradleExecutionHelper.prepare((LongRunningOperation)launcher, (ExternalSystemTaskId)id, (GradleExecutionSettings)executionSettings, (ExternalSystemTaskNotificationListener)GRADLE_LISTENER, jvmArguments, (List)commandLineArguments, (ProjectConnection)connection);
                        File javaHome = IdeSdks.getInstance().getJdkPath();
                        if (javaHome != null) {
                            launcher.setJavaHome(javaHome);
                        }
                        launcher.forTasks(ArrayUtil.toStringArray(gradleTasks));
                        launcher.withCancellationToken(cancellationTokenSource.token());
                        GradleOutputForwarder.Listener outputListener = null;
                        ExternalSystemTaskNotificationListener taskListener = this.myRequest.getTaskListener();
                        if (taskListener != null) {
                            outputListener = (contentType, data, offset, length) -> {
                                if (this.myBuildStopper.contains(id)) {
                                    taskListener.onTaskOutput(id, new String(data, offset, length), contentType != ConsoleViewContentType.ERROR_OUTPUT);
                                }
                            };
                        }
                        output.attachTo(launcher, outputListener);
                        if (taskListener != null) {
                            launcher.addProgressListener(event -> {
                                if (this.myBuildStopper.contains(id)) {
                                    taskListener.onStatusChange(GradleProgressEventConverter.convert((ExternalSystemTaskId)id, (ProgressEvent)event));
                                }
                            });
                        }
                        if (InstantRunSettings.isInstantRunEnabled() && InstantRunSettings.isRecorderEnabled()) {
                            instantRunProgressListener = new InstantRunBuildProgressListener();
                            launcher.addProgressListener((ProgressListener)instantRunProgressListener);
                        }
                        launcher.run();
                        this.myBuildStopper.remove(id);
                    }
                    catch (BuildException e) {
                        buildError = e;
                        break block23;
                    }
                    catch (Throwable e2) {
                        String testOutput2;
                        this.handleTaskExecutionError(e2);
                        this.myBuildStopper.remove(id);
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        String gradleOutput = output.toString();
                        if (instantRunProgressListener != null) {
                            FlightRecorder.get(this.myProject).saveBuildOutput(gradleOutput, instantRunProgressListener);
                        }
                        Application application = ApplicationManager.getApplication();
                        if (AndroidPlugin.isGuiTestingMode() && StringUtil.isNotEmpty((String)(testOutput2 = (String)application.getUserData(AndroidPlugin.GRADLE_BUILD_OUTPUT_IN_GUI_TEST_KEY)))) {
                            gradleOutput = testOutput2;
                            application.putUserData(AndroidPlugin.GRADLE_BUILD_OUTPUT_IN_GUI_TEST_KEY, null);
                        }
                        this.showGradleOutput(gradleOutput, output, stopwatch, buildError);
                        break block23;
                    }
                    finally {
                        String testOutput3;
                        this.myBuildStopper.remove(id);
                        String gradleOutput = output.toString();
                        if (instantRunProgressListener != null) {
                            FlightRecorder.get(this.myProject).saveBuildOutput(gradleOutput, instantRunProgressListener);
                        }
                        Application application = ApplicationManager.getApplication();
                        if (AndroidPlugin.isGuiTestingMode() && StringUtil.isNotEmpty((String)(testOutput3 = (String)application.getUserData(AndroidPlugin.GRADLE_BUILD_OUTPUT_IN_GUI_TEST_KEY)))) {
                            gradleOutput = testOutput3;
                            application.putUserData(AndroidPlugin.GRADLE_BUILD_OUTPUT_IN_GUI_TEST_KEY, null);
                        }
                        this.showGradleOutput(gradleOutput, output, stopwatch, buildError);
                    }
                    String gradleOutput = output.toString();
                    if (instantRunProgressListener != null) {
                        FlightRecorder.get(this.myProject).saveBuildOutput(gradleOutput, instantRunProgressListener);
                    }
                    Application application = ApplicationManager.getApplication();
                    if (AndroidPlugin.isGuiTestingMode() && StringUtil.isNotEmpty((String)(testOutput = (String)application.getUserData(AndroidPlugin.GRADLE_BUILD_OUTPUT_IN_GUI_TEST_KEY)))) {
                        gradleOutput = testOutput;
                        application.putUserData(AndroidPlugin.GRADLE_BUILD_OUTPUT_IN_GUI_TEST_KEY, null);
                    }
                    this.showGradleOutput(gradleOutput, output, stopwatch, buildError);
                }
                return null;
            };
            if (AndroidPlugin.isGuiTestingMode() && (task = (Runnable)(application = ApplicationManager.getApplication()).getUserData(AndroidPlugin.EXECUTE_BEFORE_PROJECT_BUILD_IN_GUI_TEST_KEY)) != null) {
                application.putUserData(AndroidPlugin.EXECUTE_BEFORE_PROJECT_BUILD_IN_GUI_TEST_KEY, null);
                task.run();
            }
            File projectDirPath = (buildFilePath = this.myRequest.getBuildFilePath()) != null ? buildFilePath : Projects.getBaseDirPath(project);
            this.myHelper.execute(projectDirPath.getPath(), executionSettings, executeTasksFunction);
        }

        private void showGradleOutput(@NotNull String gradleOutput, @NotNull GradleOutputForwarder output, @NotNull Stopwatch stopwatch, @Nullable BuildException buildError) {
            if (gradleOutput == null) {
                GradleTasksExecutorImpl.$$$reportNull$$$0(3);
            }
            if (output == null) {
                GradleTasksExecutorImpl.$$$reportNull$$$0(4);
            }
            if (stopwatch == null) {
                GradleTasksExecutorImpl.$$$reportNull$$$0(5);
            }
            Application application = ApplicationManager.getApplication();
            ArrayList<Message> buildMessages = new ArrayList<Message>();
            GradleTasksExecutorImpl.collectMessages(gradleOutput, buildMessages).doWhenDone(() -> {
                if (output == null) {
                    GradleTasksExecutorImpl.$$$reportNull$$$0(33);
                }
                if (stopwatch == null) {
                    GradleTasksExecutorImpl.$$$reportNull$$$0(34);
                }
                boolean hasError = false;
                for (Message message : buildMessages) {
                    if (message.getKind() != Message.Kind.ERROR) continue;
                    hasError = true;
                    break;
                }
                if (!hasError && this.myErrorCount == 0 && buildError != null && !GradleUtil.hasCause(buildError, BuildCancelledException.class)) {
                    GradleTasksExecutorImpl.addBuildExceptionAsMessage(buildError, output.getStdErr(), buildMessages);
                }
                output.close();
                stopwatch.stop();
                this.add(buildMessages);
                if (!this.myProgressIndicator.isCanceled()) {
                    this.closeView();
                }
                application.invokeLater(() -> {
                    if (stopwatch == null) {
                        GradleTasksExecutorImpl.$$$reportNull$$$0(35);
                    }
                    this.notifyGradleInvocationCompleted(stopwatch.elapsed(TimeUnit.MILLISECONDS));
                });
                if (buildError == null || !GradleUtil.hasCause(buildError, BuildCancelledException.class)) {
                    application.invokeLater(this::showMessages);
                }
                if (this.getProject().isDisposed()) {
                    return;
                }
                boolean buildSuccessful = buildError == null;
                GradleInvocationResult result = new GradleInvocationResult(this.myRequest.getGradleTasks(), buildMessages, buildSuccessful);
                for (GradleBuildInvoker.AfterGradleInvocationTask task : GradleBuildInvoker.getInstance(this.getProject()).getAfterInvocationTasks()) {
                    task.execute(result);
                }
            });
        }

        @NotNull
        private static ActionCallback collectMessages(@NotNull String gradleOutput, @NotNull List<Message> messages) {
            if (gradleOutput == null) {
                GradleTasksExecutorImpl.$$$reportNull$$$0(6);
            }
            if (messages == null) {
                GradleTasksExecutorImpl.$$$reportNull$$$0(7);
            }
            ActionCallback callback = new ActionCallback();
            Runnable task = () -> {
                if (gradleOutput == null) {
                    GradleTasksExecutorImpl.$$$reportNull$$$0(31);
                }
                if (messages == null) {
                    GradleTasksExecutorImpl.$$$reportNull$$$0(32);
                }
                Iterable parsers = JpsServiceManager.getInstance().getExtensions(PatternAwareOutputParser.class);
                List compilerMessages = new BuildOutputParser(parsers).parseGradleOutput(gradleOutput, true);
                messages.addAll(compilerMessages);
                callback.setDone();
            };
            Application application = ApplicationManager.getApplication();
            if (application.isUnitTestMode()) {
                task.run();
            } else {
                application.executeOnPooledThread(task);
            }
            ActionCallback actionCallback = callback;
            if (actionCallback == null) {
                GradleTasksExecutorImpl.$$$reportNull$$$0(8);
            }
            return actionCallback;
        }

        private void add(@NotNull List<Message> buildMessages) {
            if (buildMessages == null) {
                GradleTasksExecutorImpl.$$$reportNull$$$0(9);
            }
            this.prepareMessageView();
            Runnable addMessageTask = () -> {
                if (buildMessages == null) {
                    GradleTasksExecutorImpl.$$$reportNull$$$0(30);
                }
                this.openMessageView();
                for (Message message : buildMessages) {
                    this.incrementErrorOrWarningCount(message);
                    if (!GradleTasksExecutorImpl.shouldShow(message)) continue;
                    this.add(message, null);
                }
            };
            ApplicationManager.getApplication().invokeLater(addMessageTask, ModalityState.NON_MODAL);
        }

        private void handleTaskExecutionError(@NotNull Throwable e) {
            if (e == null) {
                GradleTasksExecutorImpl.$$$reportNull$$$0(10);
            }
            if (this.myProgressIndicator.isCanceled()) {
                GradleTasksExecutorImpl.getLogger().info("Failed to complete Gradle execution. Project may be closing or already closed.", e);
                return;
            }
            Throwable rootCause = ExceptionUtil.getRootCause((Throwable)e);
            String error = Strings.nullToEmpty((String)rootCause.getMessage());
            if (error.contains("Build cancelled")) {
                return;
            }
            Runnable showErrorTask = () -> {
                String msg = "Failed to complete Gradle execution.";
                msg = StringUtil.isEmpty((String)error) ? msg + " Cause: unknown." : msg + "\n\nCause:\n" + error;
                this.addMessage(new Message(Message.Kind.ERROR, msg, SourceFilePosition.UNKNOWN, new SourceFilePosition[0]), null);
                this.showMessages();
                if (IdeInfo.getInstance().isAndroidStudio() && error.startsWith("Supplied javaHome is not a valid folder")) {
                    IdeSdks ideSdks = IdeSdks.getInstance();
                    File androidHome = ideSdks.getAndroidSdkPath();
                    String androidSdkPath = androidHome != null ? androidHome.getPath() : null;
                    SelectSdkDialog selectSdkDialog = new SelectSdkDialog(null, androidSdkPath);
                    selectSdkDialog.setModal(true);
                    if (selectSdkDialog.showAndGet()) {
                        String jdkHome = selectSdkDialog.getJdkHome();
                        UIUtil.invokeLaterIfNeeded(() -> ApplicationManager.getApplication().runWriteAction(() -> ideSdks.setJdkPath(new File(jdkHome))));
                    }
                }
            };
            AppUIUtil.invokeLaterIfProjectAlive((Project)this.myRequest.getProject(), (Runnable)showErrorTask);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void addBuildExceptionAsMessage(@NotNull BuildException e, @NotNull String stdErr, @NotNull List<Message> buildMessages) {
            if (e == null) {
                GradleTasksExecutorImpl.$$$reportNull$$$0(11);
            }
            if (stdErr == null) {
                GradleTasksExecutorImpl.$$$reportNull$$$0(12);
            }
            if (buildMessages == null) {
                GradleTasksExecutorImpl.$$$reportNull$$$0(13);
            }
            if (!stdErr.trim().isEmpty()) {
                Message msg = new Message(Message.Kind.ERROR, stdErr, SourceFilePosition.UNKNOWN, new SourceFilePosition[0]);
                buildMessages.add(msg);
            } else {
                ByteArrayOutputStream out = new ByteArrayOutputStream(2048);
                try {
                    e.printStackTrace(new PrintStream(out));
                    String message = "Internal error:" + SystemProperties.getLineSeparator() + out.toString();
                    Message msg = new Message(Message.Kind.ERROR, message, SourceFilePosition.UNKNOWN, new SourceFilePosition[0]);
                    buildMessages.add(msg);
                }
                finally {
                    try {
                        Closeables.close((Closeable)out, (boolean)true);
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        private void addMessage(@NotNull Message message, @Nullable Navigatable navigatable) {
            if (message == null) {
                GradleTasksExecutorImpl.$$$reportNull$$$0(14);
            }
            this.prepareMessageView();
            this.incrementErrorOrWarningCount(message);
            if (GradleTasksExecutorImpl.shouldShow(message)) {
                Runnable addMessageTask = () -> {
                    if (message == null) {
                        GradleTasksExecutorImpl.$$$reportNull$$$0(29);
                    }
                    this.openMessageView();
                    this.add(message, navigatable);
                };
                UIUtil.invokeLaterIfNeeded((Runnable)addMessageTask);
            }
        }

        private void incrementErrorOrWarningCount(@NotNull Message message) {
            Message.Kind kind;
            if (message == null) {
                GradleTasksExecutorImpl.$$$reportNull$$$0(15);
            }
            if ((kind = message.getKind()) == Message.Kind.WARNING) {
                ++this.myWarningCount;
            } else if (kind == Message.Kind.ERROR) {
                ++this.myErrorCount;
            }
        }

        private static boolean shouldShow(@NotNull Message message) {
            Message.Kind kind;
            if (message == null) {
                GradleTasksExecutorImpl.$$$reportNull$$$0(16);
            }
            return (kind = message.getKind()) != Message.Kind.SIMPLE && kind != Message.Kind.UNKNOWN;
        }

        private void prepareMessageView() {
            if (!this.myProgressIndicator.isRunning() || this.myMessageViewIsPrepared) {
                return;
            }
            this.myMessageViewIsPrepared = true;
            ApplicationManager.getApplication().invokeLater(() -> {
                if (!this.myRequest.getProject().isDisposed()) {
                    Object object = this.myMessageViewLock;
                    synchronized (object) {
                        if (this.myErrorTreeView == null) {
                            GradleTasksExecutorImpl.removeUnpinnedBuildMessages(this.myRequest.getProject(), null);
                        }
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void openMessageView() {
            JComponent component;
            if (this.myProgressIndicator.isCanceled()) {
                return;
            }
            Project project = this.myRequest.getProject();
            Object object = this.myMessageViewLock;
            synchronized (object) {
                if (this.myErrorTreeView != null) {
                    return;
                }
                this.myErrorTreeView = new GradleBuildTreeViewPanel(project);
                ExternalSystemTaskId id = this.myRequest.getTaskId();
                this.myErrorTreeView.setProcessController(new BuildProcessController(id, this.myBuildStopper, this.myProgressIndicator));
                component = this.myErrorTreeView.getComponent();
            }
            Content content = ContentFactory.SERVICE.getInstance().createContent(component, CONTENT_NAME, true);
            content.putUserData(CONTENT_ID_KEY, this.myContentId);
            MessageView messageView = this.getMessageView();
            ContentManager contentManager = messageView.getContentManager();
            contentManager.addContent(content);
            this.myCloseListener.setContent(contentManager, content);
            GradleTasksExecutorImpl.removeUnpinnedBuildMessages(this.myRequest.getProject(), content);
            contentManager.setSelectedContent(content);
        }

        private void activateGradleConsole() {
            ToolWindow window = this.getToolWindowManager().getToolWindow("Gradle Console");
            if (window != null) {
                window.activate(null, false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void add(@NotNull Message message, @Nullable Navigatable navigatable) {
            if (message == null) {
                GradleTasksExecutorImpl.$$$reportNull$$$0(17);
            }
            Object object = this.myMessageViewLock;
            synchronized (object) {
                if (this.myErrorTreeView != null && !this.myRequest.getProject().isDisposed()) {
                    boolean autoActivate;
                    Message.Kind messageKind = message.getKind();
                    int type = GradleTasksExecutorImpl.translateMessageKind(messageKind);
                    String[] textLines = GradleTasksExecutorImpl.splitIntoLines(message);
                    if (navigatable == null) {
                        VirtualFile file = this.findFileFrom(message);
                        List sourceFilePositions = message.getSourceFilePositions();
                        assert (!sourceFilePositions.isEmpty());
                        SourcePosition position = ((SourceFilePosition)sourceFilePositions.get(0)).getPosition();
                        int line = position.getStartLine();
                        int column = position.getStartColumn();
                        this.myErrorTreeView.addMessage(type, textLines, file, line, column, null);
                    } else {
                        this.myErrorTreeView.addMessage(type, textLines, null, navigatable, null, null, null);
                    }
                    boolean bl = autoActivate = !this.myMessagesAutoActivated && type == 4;
                    if (autoActivate) {
                        this.myMessagesAutoActivated = true;
                        this.activateMessageView();
                    }
                }
            }
        }

        @NotNull
        private static String[] splitIntoLines(@NotNull Message message) {
            String text;
            if (message == null) {
                GradleTasksExecutorImpl.$$$reportNull$$$0(18);
            }
            if ((text = message.getText()).indexOf(10) == -1) {
                String[] stringArray = new String[]{text};
                if (stringArray == null) {
                    GradleTasksExecutorImpl.$$$reportNull$$$0(19);
                }
                return stringArray;
            }
            String[] stringArray = ArrayUtil.toStringArray((Collection)Splitter.on((char)'\n').splitToList((CharSequence)text));
            if (stringArray == null) {
                GradleTasksExecutorImpl.$$$reportNull$$$0(20);
            }
            return stringArray;
        }

        @Nullable
        private VirtualFile findFileFrom(@NotNull Message message) {
            SourceFile source;
            if (message == null) {
                GradleTasksExecutorImpl.$$$reportNull$$$0(21);
            }
            if ((source = ((SourceFilePosition)message.getSourceFilePositions().get(0)).getFile()).getSourceFile() != null) {
                return (VirtualFile)ApplicationManager.getApplication().runWriteAction(() -> VfsUtil.findFileByIoFile((File)source.getSourceFile(), (boolean)true));
            }
            if (source.getDescription() != null) {
                String gradlePath = source.getDescription();
                Module module = GradleUtil.findModuleByGradlePath(this.myRequest.getProject(), gradlePath);
                if (module != null) {
                    GradleFacet facet = GradleFacet.getInstance(module);
                    assert (facet != null);
                    GradleModuleModel gradleModuleModel = facet.getGradleModuleModel();
                    return gradleModuleModel != null ? gradleModuleModel.getBuildFile() : null;
                }
            }
            return null;
        }

        private static int translateMessageKind(@NotNull Message.Kind kind) {
            if (kind == null) {
                GradleTasksExecutorImpl.$$$reportNull$$$0(22);
            }
            switch (kind) {
                case INFO: {
                    return 3;
                }
                case WARNING: {
                    return 5;
                }
                case ERROR: {
                    return 4;
                }
                case STATISTICS: {
                    return 2;
                }
                case SIMPLE: {
                    return 1;
                }
            }
            GradleTasksExecutorImpl.getLogger().warn("Unknown message kind: " + kind);
            return 0;
        }

        @NotNull
        private static Logger getLogger() {
            Logger logger = Logger.getInstance(GradleBuildInvoker.class);
            if (logger == null) {
                GradleTasksExecutorImpl.$$$reportNull$$$0(23);
            }
            return logger;
        }

        private void notifyGradleInvocationCompleted(long durationMillis) {
            Project project = this.myRequest.getProject();
            if (!project.isDisposed()) {
                MessageType messageType;
                String statusMsg = this.createStatusMessage(durationMillis);
                MessageType messageType2 = this.myErrorCount > 0 ? MessageType.ERROR : (messageType = this.myWarningCount > 0 ? MessageType.WARNING : MessageType.INFO);
                if (durationMillis > 60000L) {
                    BALLOON_NOTIFICATION.createNotification(statusMsg, messageType).notify(project);
                } else {
                    this.addToEventLog(statusMsg, messageType);
                }
            }
        }

        @NotNull
        private String createStatusMessage(long durationMillis) {
            String message = "Gradle build finished";
            if (this.myErrorCount > 0) {
                message = this.myWarningCount > 0 ? message + String.format(" with %d error(s) and %d warning(s)", this.myErrorCount, this.myWarningCount) : message + String.format(" with %d error(s)", this.myErrorCount);
            } else if (this.myWarningCount > 0) {
                message = message + String.format(" with %d warnings(s)", this.myWarningCount);
            }
            String string = message = message + " in " + StringUtil.formatDuration((long)durationMillis);
            if (string == null) {
                GradleTasksExecutorImpl.$$$reportNull$$$0(24);
            }
            return string;
        }

        private void addToEventLog(@NotNull String message, @NotNull MessageType type) {
            if (message == null) {
                GradleTasksExecutorImpl.$$$reportNull$$$0(25);
            }
            if (type == null) {
                GradleTasksExecutorImpl.$$$reportNull$$$0(26);
            }
            LOGGING_NOTIFICATION.createNotification(message, type).notify(this.myProject);
        }

        @NotNull
        private ToolWindowManager getToolWindowManager() {
            ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myRequest.getProject());
            if (toolWindowManager == null) {
                GradleTasksExecutorImpl.$$$reportNull$$$0(27);
            }
            return toolWindowManager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void showMessages() {
            Object object = this.myMessageViewLock;
            synchronized (object) {
                if (this.myErrorTreeView != null && !this.myRequest.getProject().isDisposed()) {
                    Content[] contents;
                    MessageView messageView = this.getMessageView();
                    for (Content content : contents = messageView.getContentManager().getContents()) {
                        if (content.getUserData(CONTENT_ID_KEY) == null) continue;
                        messageView.getContentManager().setSelectedContent(content);
                        return;
                    }
                }
            }
        }

        @NotNull
        private MessageView getMessageView() {
            MessageView messageView = MessageView.SERVICE.getInstance((Project)this.myRequest.getProject());
            if (messageView == null) {
                GradleTasksExecutorImpl.$$$reportNull$$$0(28);
            }
            return messageView;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void activateMessageView() {
            Object object = this.myMessageViewLock;
            synchronized (object) {
                ToolWindow window;
                if (this.myErrorTreeView != null && (window = this.getToolWindowManager().getToolWindow(ToolWindowId.MESSAGES_WINDOW)) != null) {
                    window.activate(null, false);
                }
            }
        }

        private void attemptToStopBuild() {
            this.myBuildStopper.attemptToStopBuild(this.myRequest.getTaskId(), this.myProgressIndicator);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void queueAndWaitForCompletion() {
            int counterBefore;
            Object object = this.myCompletionLock;
            synchronized (object) {
                counterBefore = this.myCompletionCounter;
            }
            UIUtil.invokeLaterIfNeeded(() -> ((GradleTasksExecutorImpl)this).queue());
            object = this.myCompletionLock;
            synchronized (object) {
                while (this.myCompletionCounter <= counterBefore) {
                    try {
                        this.myCompletionLock.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                        break;
                    }
                }
            }
        }

        public void onSuccess() {
            super.onSuccess();
            this.onCompletion();
        }

        public void onCancel() {
            super.onCancel();
            this.onCompletion();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onCompletion() {
            Object object = this.myCompletionLock;
            synchronized (object) {
                ++this.myCompletionCounter;
                this.myCompletionLock.notifyAll();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 8: 
                case 19: 
                case 20: 
                case 23: 
                case 24: 
                case 27: 
                case 28: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 8: 
                case 19: 
                case 20: 
                case 23: 
                case 24: 
                case 27: 
                case 28: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buildStopper";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 3: 
                case 6: 
                case 31: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gradleOutput";
                    break;
                }
                case 4: 
                case 33: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "output";
                    break;
                }
                case 5: 
                case 34: 
                case 35: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stopwatch";
                    break;
                }
                case 7: 
                case 32: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "messages";
                    break;
                }
                case 8: 
                case 19: 
                case 20: 
                case 23: 
                case 24: 
                case 27: 
                case 28: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/project/build/invoker/GradleTasksExecutor$GradleTasksExecutorImpl";
                    break;
                }
                case 9: 
                case 13: 
                case 30: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buildMessages";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stdErr";
                    break;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 21: 
                case 25: 
                case 29: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 26: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/project/build/invoker/GradleTasksExecutor$GradleTasksExecutorImpl";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectMessages";
                    break;
                }
                case 19: 
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "splitIntoLines";
                    break;
                }
                case 23: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLogger";
                    break;
                }
                case 24: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createStatusMessage";
                    break;
                }
                case 27: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getToolWindowManager";
                    break;
                }
                case 28: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessageView";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "run";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "showGradleOutput";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "collectMessages";
                    break;
                }
                case 8: 
                case 19: 
                case 20: 
                case 23: 
                case 24: 
                case 27: 
                case 28: {
                    break;
                }
                case 9: 
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "handleTaskExecutionError";
                    break;
                }
                case 11: 
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "addBuildExceptionAsMessage";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "addMessage";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "incrementErrorOrWarningCount";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "shouldShow";
                    break;
                }
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "splitIntoLines";
                    break;
                }
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "findFileFrom";
                    break;
                }
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "translateMessageKind";
                    break;
                }
                case 25: 
                case 26: {
                    objectArray = objectArray;
                    objectArray[2] = "addToEventLog";
                    break;
                }
                case 29: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$addMessage$10";
                    break;
                }
                case 30: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$add$6";
                    break;
                }
                case 31: 
                case 32: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$collectMessages$5";
                    break;
                }
                case 33: 
                case 34: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$showGradleOutput$4";
                    break;
                }
                case 35: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$null$3";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 8: 
                case 19: 
                case 20: 
                case 23: 
                case 24: 
                case 27: 
                case 28: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private class OpenGradleConsole
        implements Navigatable {
            private OpenGradleConsole() {
            }

            public void navigate(boolean requestFocus) {
                GradleTasksExecutorImpl.this.activateGradleConsole();
            }

            public boolean canNavigate() {
                return true;
            }

            public boolean canNavigateToSource() {
                return false;
            }
        }

        private class ProgressIndicatorStateDelegate
        extends TaskExecutionProgressIndicator {
            ProgressIndicatorStateDelegate(@NotNull ExternalSystemTaskId taskId, BuildStopper buildStopper) {
                if (taskId == null) {
                    ProgressIndicatorStateDelegate.$$$reportNull$$$0(0);
                }
                if (buildStopper == null) {
                    ProgressIndicatorStateDelegate.$$$reportNull$$$0(1);
                }
                super(taskId, buildStopper);
            }

            @Override
            void onCancel() {
                GradleTasksExecutorImpl.this.closeView();
                this.stopAppIconProgress();
            }

            public void stop() {
                super.stop();
                this.stopAppIconProgress();
            }

            private void stopAppIconProgress() {
                UIUtil.invokeLaterIfNeeded(() -> {
                    Project project;
                    AppIcon appIcon = AppIcon.getInstance();
                    if (appIcon.hideProgress(project = GradleTasksExecutorImpl.this.myRequest.getProject(), (Object)GradleTasksExecutorImpl.APP_ICON_ID)) {
                        if (GradleTasksExecutorImpl.this.myErrorCount > 0) {
                            appIcon.setErrorBadge(project, String.valueOf(GradleTasksExecutorImpl.this.myErrorCount));
                            appIcon.requestAttention(project, true);
                        } else {
                            appIcon.setOkBadge(project, true);
                            appIcon.requestAttention(project, false);
                        }
                    }
                });
            }

            protected void onProgressChange() {
                GradleTasksExecutorImpl.this.prepareMessageView();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "taskId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "buildStopper";
                        break;
                    }
                }
                objectArray[1] = "com/android/tools/idea/gradle/project/build/invoker/GradleTasksExecutor$GradleTasksExecutorImpl$ProgressIndicatorStateDelegate";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private class CloseListener
        extends ContentManagerAdapter
        implements VetoableProjectManagerListener {
            private ContentManager myContentManager;
            @Nullable
            private Content myContent;
            private boolean myIsApplicationExitingOrProjectClosing;
            private boolean myUserAcceptedCancel;

            private CloseListener() {
            }

            public boolean canClose(@NotNull Project project) {
                if (project == null) {
                    CloseListener.$$$reportNull$$$0(0);
                }
                if (project != GradleTasksExecutorImpl.this.myProject) {
                    return true;
                }
                if (this.shouldPromptUser()) {
                    this.myUserAcceptedCancel = this.askUserToCancelGradleExecution();
                    if (!this.myUserAcceptedCancel) {
                        return false;
                    }
                    GradleTasksExecutorImpl.this.attemptToStopBuild();
                    return true;
                }
                return !GradleTasksExecutorImpl.this.myProgressIndicator.isRunning();
            }

            public void projectClosed(Project project) {
                if (project == GradleTasksExecutorImpl.this.myProject && this.myContent != null) {
                    this.myContentManager.removeContent(this.myContent, true);
                }
            }

            public void projectClosing(Project project) {
                if (project.equals(GradleTasksExecutorImpl.this.myProject)) {
                    this.myIsApplicationExitingOrProjectClosing = true;
                }
            }

            void setContent(@NotNull ContentManager contentManager, @Nullable Content content) {
                if (contentManager == null) {
                    CloseListener.$$$reportNull$$$0(1);
                }
                this.myContent = content;
                this.myContentManager = contentManager;
                contentManager.addContentManagerListener((ContentManagerListener)this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void contentRemoved(ContentManagerEvent event) {
                if (event.getContent() == this.myContent) {
                    Object object = GradleTasksExecutorImpl.this.myMessageViewLock;
                    synchronized (object) {
                        Project project = GradleTasksExecutorImpl.this.myRequest.getProject();
                        if (GradleTasksExecutorImpl.this.myErrorTreeView != null && !project.isDisposed()) {
                            AppIcon appIcon;
                            Disposer.dispose((Disposable)GradleTasksExecutorImpl.this.myErrorTreeView);
                            GradleTasksExecutorImpl.this.myErrorTreeView = null;
                            if (GradleTasksExecutorImpl.this.myProgressIndicator.isRunning()) {
                                GradleTasksExecutorImpl.this.attemptToStopBuild();
                            }
                            if ((appIcon = AppIcon.getInstance()).hideProgress(project, (Object)GradleTasksExecutorImpl.APP_ICON_ID)) {
                                appIcon.setErrorBadge(project, null);
                            }
                        }
                    }
                    this.myContentManager.removeContentManagerListener((ContentManagerListener)this);
                    if (this.myContent != null) {
                        this.myContent.release();
                    }
                    this.myContent = null;
                }
            }

            public void contentRemoveQuery(ContentManagerEvent event) {
                if (event.getContent() == this.myContent && !GradleTasksExecutorImpl.this.myProgressIndicator.isCanceled() && this.shouldPromptUser()) {
                    this.myUserAcceptedCancel = this.askUserToCancelGradleExecution();
                    if (!this.myUserAcceptedCancel) {
                        event.consume();
                    }
                }
            }

            private boolean shouldPromptUser() {
                return !this.myUserAcceptedCancel && !this.myIsApplicationExitingOrProjectClosing && GradleTasksExecutorImpl.this.myProgressIndicator.isRunning();
            }

            private boolean askUserToCancelGradleExecution() {
                String msg = "Gradle is running. Proceed with Project closing?";
                int result = Messages.showYesNoDialog((Project)GradleTasksExecutorImpl.this.myProject, (String)msg, (String)GradleTasksExecutorImpl.GRADLE_RUNNING_MSG_TITLE, (Icon)Messages.getQuestionIcon());
                return result == 0;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "contentManager";
                        break;
                    }
                }
                objectArray2[1] = "com/android/tools/idea/gradle/project/build/invoker/GradleTasksExecutor$GradleTasksExecutorImpl$CloseListener";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "canClose";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setContent";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    static class Factory {
        Factory() {
        }

        @NotNull
        GradleTasksExecutor create(@NotNull GradleBuildInvoker.Request request, @NotNull BuildStopper buildStopper) {
            if (request == null) {
                Factory.$$$reportNull$$$0(0);
            }
            if (buildStopper == null) {
                Factory.$$$reportNull$$$0(1);
            }
            GradleTasksExecutorImpl gradleTasksExecutorImpl = new GradleTasksExecutorImpl(request, buildStopper);
            if (gradleTasksExecutorImpl == null) {
                Factory.$$$reportNull$$$0(2);
            }
            return gradleTasksExecutorImpl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buildStopper";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/project/build/invoker/GradleTasksExecutor$Factory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/project/build/invoker/GradleTasksExecutor$Factory";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

