/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.analytics.UsageTracker;
import com.google.common.base.Splitter;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SyncErrorHandler {
    private static final ExtensionPointName<SyncErrorHandler> EXTENSION_POINT_NAME = ExtensionPointName.create((String)"com.android.gradle.sync.syncErrorHandler");
    protected static final String EMPTY_LINE = "\n\n";
    protected static final NotificationType DEFAULT_NOTIFICATION_TYPE = NotificationType.ERROR;
    private static final Pattern ERROR_LOCATION_IN_FILE_PATTERN = Pattern.compile("Build file '(.*)' line: ([\\d]+)");
    private static final Pattern ERROR_IN_FILE_PATTERN = Pattern.compile("Build file '(.*)'");

    @NotNull
    public static SyncErrorHandler[] getExtensions() {
        SyncErrorHandler[] syncErrorHandlerArray = (SyncErrorHandler[])EXTENSION_POINT_NAME.getExtensions();
        if (syncErrorHandlerArray == null) {
            SyncErrorHandler.$$$reportNull$$$0(0);
        }
        return syncErrorHandlerArray;
    }

    public abstract boolean handleError(@NotNull ExternalSystemException var1, @NotNull NotificationData var2, @NotNull Project var3);

    @NotNull
    protected Throwable getRootCause(@NotNull Throwable error) {
        if (error == null) {
            SyncErrorHandler.$$$reportNull$$$0(1);
        }
        Throwable rootCause = error;
        while (rootCause.getCause() != null && rootCause.getCause().getMessage() != null) {
            rootCause = rootCause.getCause();
        }
        Throwable throwable = rootCause;
        if (throwable == null) {
            SyncErrorHandler.$$$reportNull$$$0(2);
        }
        return throwable;
    }

    protected static void updateUsageTracker() {
        SyncErrorHandler.updateUsageTracker(null, null);
    }

    protected static void updateUsageTracker(@NotNull AndroidStudioEvent.GradleSyncFailure syncFailure) {
        if (syncFailure == null) {
            SyncErrorHandler.$$$reportNull$$$0(3);
        }
        SyncErrorHandler.updateUsageTracker(syncFailure, null);
    }

    protected static void updateUsageTracker(@Nullable AndroidStudioEvent.GradleSyncFailure gradleSyncFailure, @Nullable String gradleMissingSignature) {
        AndroidStudioEvent.Builder builder = AndroidStudioEvent.newBuilder();
        if (gradleSyncFailure == null) {
            gradleSyncFailure = AndroidStudioEvent.GradleSyncFailure.UNKNOWN_GRADLE_FAILURE;
        }
        builder.setCategory(AndroidStudioEvent.EventCategory.GRADLE_SYNC).setKind(AndroidStudioEvent.EventKind.GRADLE_SYNC_FAILURE).setGradleSyncFailure(gradleSyncFailure);
        if (gradleMissingSignature != null) {
            builder.setGradleMissingSignature(gradleMissingSignature);
        }
        UsageTracker.getInstance().log(builder);
    }

    @NotNull
    protected static String getFirstLineMessage(@NotNull String text) {
        if (text == null) {
            SyncErrorHandler.$$$reportNull$$$0(4);
        }
        String string = (String)Splitter.on((char)'\n').omitEmptyStrings().trimResults().splitToList((CharSequence)text).get(0);
        if (string == null) {
            SyncErrorHandler.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    protected Pair<String, Integer> getErrorLocation(@NotNull String msg) {
        Matcher matcher;
        if (msg == null) {
            SyncErrorHandler.$$$reportNull$$$0(6);
        }
        if ((matcher = ERROR_LOCATION_IN_FILE_PATTERN.matcher(msg)).matches()) {
            String filePath = matcher.group(1);
            int line = -1;
            try {
                line = Integer.parseInt(matcher.group(2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return Pair.create((Object)filePath, (Object)line);
        }
        matcher = ERROR_IN_FILE_PATTERN.matcher(msg);
        if (matcher.matches()) {
            String filePath = matcher.group(1);
            return Pair.create((Object)filePath, (Object)-1);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/errors/SyncErrorHandler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncFailure";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msg";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensions";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/errors/SyncErrorHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootCause";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstLineMessage";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRootCause";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateUsageTracker";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFirstLineMessage";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getErrorLocation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

