/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post;

import com.android.tools.idea.gradle.project.sync.setup.post.ProjectSetupStep;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectSetup {
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProjectSetupStep[] mySetupSteps;

    public ProjectSetup(@NotNull Project project) {
        if (project == null) {
            ProjectSetup.$$$reportNull$$$0(0);
        }
        this(project, ProjectSetupStep.getExtensions());
    }

    @VisibleForTesting
    ProjectSetup(@NotNull Project project, ProjectSetupStep ... setupSteps) {
        if (project == null) {
            ProjectSetup.$$$reportNull$$$0(1);
        }
        if (setupSteps == null) {
            ProjectSetup.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.mySetupSteps = setupSteps;
    }

    public void setUpProject(@Nullable ProgressIndicator progressIndicator, boolean syncFailed) {
        Runnable invokeProjectSetupStepsTask = () -> {
            for (ProjectSetupStep step : this.mySetupSteps) {
                if (syncFailed && !step.invokeOnFailedSync()) continue;
                step.setUpProject(this.myProject, progressIndicator);
            }
        };
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            invokeProjectSetupStepsTask.run();
            return;
        }
        ApplicationManager.getApplication().runWriteAction(invokeProjectSetupStepsTask);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "setupSteps";
                break;
            }
        }
        objectArray[1] = "com/android/tools/idea/gradle/project/sync/setup/post/ProjectSetup";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

