/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.ui.dependencies;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.configurables.ui.UiUtil;
import com.android.tools.idea.gradle.structure.configurables.ui.dependencies.AbstractDeclaredDependenciesTableModel;
import com.android.tools.idea.gradle.structure.model.PsDependency;
import com.android.tools.idea.gradle.structure.model.PsModuleDependency;
import com.android.tools.idea.gradle.structure.model.android.PsModuleAndroidDependency;
import com.intellij.openapi.Disposable;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.table.TableView;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeclaredDependenciesTableView<T extends PsDependency>
extends TableView<T>
implements Disposable {
    @NotNull
    private final PsContext myContext;
    private KeyEventDispatcher myKeyEventDispatcher;

    public DeclaredDependenciesTableView(@NotNull AbstractDeclaredDependenciesTableModel<T> model, @NotNull PsContext context) {
        if (model == null) {
            DeclaredDependenciesTableView.$$$reportNull$$$0(0);
        }
        if (context == null) {
            DeclaredDependenciesTableView.$$$reportNull$$$0(1);
        }
        super(model);
        this.myContext = context;
        this.getSelectionModel().setSelectionMode(2);
        this.addHyperlinkFunctionality();
        this.setDragEnabled(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setShowGrid(false);
        new TableSpeedSearch((JTable)((Object)this), (o, cell) -> {
            PsDependency dependency;
            if (model == null) {
                DeclaredDependenciesTableView.$$$reportNull$$$0(5);
            }
            if ((dependency = (PsDependency)model.getItem(cell.getRow())) != null) {
                return AbstractDeclaredDependenciesTableModel.displayTextOf(dependency);
            }
            return o == null || o instanceof Boolean ? "" : o.toString();
        });
    }

    protected void processMouseEvent(MouseEvent e) {
        PsModuleDependency dependency;
        int id = e.getID();
        if (id == 501 && (dependency = this.getIfHyperlink(e)) != null) {
            String name = dependency.getName();
            this.myContext.setSelectedModule(name, (Object)this);
            return;
        }
        super.processMouseEvent(e);
    }

    @Nullable
    private PsModuleDependency getIfHyperlink(@NotNull MouseEvent e) {
        if (e == null) {
            DeclaredDependenciesTableView.$$$reportNull$$$0(2);
        }
        if (UiUtil.isMetaOrCtrlKeyPressed(e)) {
            Point point = new Point(e.getX(), e.getY());
            return this.getDependencyForLocation(point);
        }
        return null;
    }

    private void addHyperlinkFunctionality() {
        this.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                PsModuleDependency hovered = DeclaredDependenciesTableView.this.getIfHyperlink(e);
                DeclaredDependenciesTableView.this.setHoveredDependency(hovered);
            }
        });
        this.myKeyEventDispatcher = e -> {
            PsModuleDependency dependency = null;
            if (e.getID() == 401) {
                if (UiUtil.isMetaOrCtrlKeyPressed(e)) {
                    dependency = this.getDependencyUnderMousePointer();
                }
                this.setHoveredDependency(dependency);
            } else if (e.getID() == 402 && UiUtil.isMetaOrCtrlKeyPressed(e)) {
                this.setHoveredDependency(null);
            }
            return false;
        };
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.myKeyEventDispatcher);
    }

    @Nullable
    private PsModuleDependency getDependencyUnderMousePointer() {
        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
        if (pointerInfo != null) {
            Point location = pointerInfo.getLocation();
            SwingUtilities.convertPointFromScreen(location, (Component)((Object)this));
            return this.getDependencyForLocation(location);
        }
        return null;
    }

    @Nullable
    private PsModuleAndroidDependency getDependencyForLocation(@NotNull Point location) {
        PsDependency dependency;
        int row;
        int column;
        if (location == null) {
            DeclaredDependenciesTableView.$$$reportNull$$$0(3);
        }
        if ((column = this.columnAtPoint(location)) == 0 && (row = this.rowAtPoint(location)) > -1 && (dependency = (PsDependency)this.getListTableModel().getItem(row)) instanceof PsModuleAndroidDependency) {
            return (PsModuleAndroidDependency)dependency;
        }
        return null;
    }

    private void setHoveredDependency(@Nullable PsModuleDependency dependency) {
        this.getListTableModel().setHoveredDependency(dependency);
        Cursor cursor = Cursor.getDefaultCursor();
        if (dependency != null) {
            cursor = Cursor.getPredefinedCursor(12);
        }
        this.setCursor(cursor);
        this.repaint();
    }

    public AbstractDeclaredDependenciesTableModel<T> getListTableModel() {
        return (AbstractDeclaredDependenciesTableModel)((Object)super.getModel());
    }

    public void selectFirstRow() {
        if (!this.getItems().isEmpty()) {
            this.changeSelection(0, 0, false, false);
        }
    }

    @Nullable
    public T getSelectionIfSingle() {
        Collection selection = this.getSelection();
        if (selection.size() == 1) {
            PsDependency selected = (PsDependency)ContainerUtil.getFirstItem((Collection)selection);
            assert (selected != null);
            return (T)selected;
        }
        return null;
    }

    public void selectDependency(@NotNull String toSelect) {
        if (toSelect == null) {
            DeclaredDependenciesTableView.$$$reportNull$$$0(4);
        }
        this.requestFocusInWindow();
        for (PsDependency dependency : this.getItems()) {
            String dependencyAsText = dependency.toText(PsDependency.TextType.FOR_NAVIGATION);
            if (!toSelect.equals(dependencyAsText)) continue;
            this.setSelection(Collections.singletonList(dependency));
            break;
        }
    }

    public void dispose() {
        if (this.myKeyEventDispatcher != null) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.myKeyEventDispatcher);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toSelect";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/structure/configurables/ui/dependencies/DeclaredDependenciesTableView";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getIfHyperlink";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getDependencyForLocation";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "selectDependency";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$new$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

