/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.gpu;

import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.IDevice;
import com.android.tools.adtui.TimelineData;
import com.android.tools.idea.monitor.DeviceSampler;
import com.android.tools.idea.monitor.gpu.ProfileStateListener;
import com.android.tools.idea.monitor.gpu.gfxinfohandlers.GfxinfoHandler;
import com.android.tools.idea.monitor.gpu.gfxinfohandlers.JHandler;
import com.android.tools.idea.monitor.gpu.gfxinfohandlers.LHandler;
import com.android.tools.idea.monitor.gpu.gfxinfohandlers.MHandler;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GpuSampler
extends DeviceSampler {
    private final GfxinfoHandler[] myGfxinfoHandlers = new GfxinfoHandler[]{new JHandler(), new LHandler(), new MHandler()};
    private volatile GfxinfoHandler myCurrentGfxinfoHandler;
    private volatile int myApiLevel = 16;
    @Nullable
    protected ProfileStateListener myProfileStateListener;
    private boolean myGpuProfileSetting = true;

    public GpuSampler(int sampleFrequencyMs) {
        super(new TimelineData(3, 8192), sampleFrequencyMs);
    }

    @Override
    @NotNull
    public String getName() {
        if ("GPU Sampler" == null) {
            GpuSampler.$$$reportNull$$$0(0);
        }
        return "GPU Sampler";
    }

    public int getApiLevel() {
        return this.myApiLevel;
    }

    @Override
    protected boolean requiresSamplerRestart(@Nullable Client client) {
        return super.requiresSamplerRestart(client) || client != null && GpuSampler.decodeApiLevel(client) != this.myApiLevel;
    }

    @Override
    protected synchronized void prepareSampler() {
        Client client = this.getClient();
        if (client != null) {
            int newApiLevel = GpuSampler.decodeApiLevel(client);
            boolean createNewTimelineData = false;
            if (newApiLevel != this.myApiLevel) {
                this.myApiLevel = newApiLevel;
                for (GfxinfoHandler handler : this.myGfxinfoHandlers) {
                    if (!handler.accept(client)) continue;
                    createNewTimelineData = true;
                    break;
                }
            }
            for (GfxinfoHandler handler : this.myGfxinfoHandlers) {
                if (!handler.accept(client)) continue;
                this.myCurrentGfxinfoHandler = handler;
            }
            if (createNewTimelineData) {
                this.setTimelineData(this.myCurrentGfxinfoHandler.createTimelineData());
            }
        } else {
            this.myCurrentGfxinfoHandler = null;
        }
        this.setGpuProfileSetting(true);
        if (this.myCurrentGfxinfoHandler != null) {
            this.myCurrentGfxinfoHandler.setClient(client);
        }
        this.getTimelineData().clear();
    }

    @Override
    protected void sample(boolean forced) throws InterruptedException {
        Client client = this.getClient();
        assert (client != null);
        IDevice device = client.getDevice();
        if (device != null) {
            try {
                ClientData data = client.getClientData();
                ThreeState newGpuProfilingState = this.myCurrentGfxinfoHandler.getIsEnabledOnDevice(device);
                if (newGpuProfilingState != ThreeState.UNSURE) {
                    boolean newGpuBooleanState = newGpuProfilingState.toBoolean();
                    this.setGpuProfileSetting(newGpuBooleanState);
                }
                if (this.myGpuProfileSetting) {
                    this.myCurrentGfxinfoHandler.sample(device, data, this.getTimelineData());
                }
            }
            catch (RuntimeException e) {
                throw new InterruptedException("Sample error, interrupting.");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setGpuProfileSetting(boolean newSetting) {
        if (this.myGpuProfileSetting != newSetting) {
            this.myGpuProfileSetting = newSetting;
            Client client = this.getClient();
            if (client != null && this.myProfileStateListener != null) {
                this.myProfileStateListener.notifyGpuProfileStateChanged(client, this.myGpuProfileSetting);
            }
        }
    }

    public static int decodeApiLevel(@NotNull Client client) {
        if (client == null) {
            GpuSampler.$$$reportNull$$$0(1);
        }
        return client.getDevice().getVersion().getFeatureLevel();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/monitor/gpu/GpuSampler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/monitor/gpu/GpuSampler";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "decodeApiLevel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

