/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.project;

import com.android.tools.idea.model.MergedManifest;
import com.android.tools.idea.run.AndroidRunConfiguration;
import com.android.tools.idea.run.AndroidRunConfigurationType;
import com.android.tools.idea.run.TargetSelectionMode;
import com.android.tools.idea.run.util.LaunchUtils;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.InstantAppUrlFinder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidRunConfigurations {
    @NotNull
    public static AndroidRunConfigurations getInstance() {
        AndroidRunConfigurations androidRunConfigurations = (AndroidRunConfigurations)ServiceManager.getService(AndroidRunConfigurations.class);
        if (androidRunConfigurations == null) {
            AndroidRunConfigurations.$$$reportNull$$$0(0);
        }
        return androidRunConfigurations;
    }

    public void createRunConfiguration(@NotNull AndroidFacet facet) {
        if (facet == null) {
            AndroidRunConfigurations.$$$reportNull$$$0(1);
        }
        Module module = facet.getModule();
        ConfigurationFactory configurationFactory = AndroidRunConfigurationType.getInstance().getFactory();
        List configurations = RunManager.getInstance((Project)module.getProject()).getConfigurationsList(configurationFactory.getType());
        for (RunConfiguration configuration : configurations) {
            if (!(configuration instanceof AndroidRunConfiguration) || ((JavaRunConfigurationModule)((AndroidRunConfiguration)configuration).getConfigurationModule()).getModule() != module) continue;
            return;
        }
        this.addRunConfiguration(facet, null, TargetSelectionMode.SHOW_DIALOG, null);
    }

    public void addRunConfiguration(@NotNull AndroidFacet facet, @Nullable String activityClass, @Nullable TargetSelectionMode targetSelectionMode, @Nullable String preferredAvdName) {
        if (facet == null) {
            AndroidRunConfigurations.$$$reportNull$$$0(2);
        }
        Module module = facet.getModule();
        RunManager runManager = RunManager.getInstance((Project)module.getProject());
        AndroidRunConfigurationType runConfigurationType = AndroidRunConfigurationType.getInstance();
        RunnerAndConfigurationSettings settings = runManager.createRunConfiguration(module.getName(), runConfigurationType.getFactory());
        AndroidRunConfiguration configuration = (AndroidRunConfiguration)settings.getConfiguration();
        configuration.setModule(module);
        if (activityClass != null) {
            configuration.setLaunchActivity(activityClass);
        } else if (facet.getProjectType() == 4) {
            configuration.setLaunchUrl(AndroidRunConfigurations.getDefaultRunConfigurationUrl(facet));
        } else {
            configuration.MODE = LaunchUtils.isWatchFaceApp(facet) ? "do_nothing" : "default_activity";
        }
        if (targetSelectionMode != null) {
            configuration.getDeployTargetContext().setTargetSelectionMode(targetSelectionMode);
        }
        if (preferredAvdName != null) {
            configuration.PREFERRED_AVD = preferredAvdName;
        }
        runManager.addConfiguration(settings, false);
        runManager.setSelectedConfiguration(settings);
    }

    @NotNull
    private static String getDefaultRunConfigurationUrl(@NotNull AndroidFacet facet) {
        if (facet == null) {
            AndroidRunConfigurations.$$$reportNull$$$0(3);
        }
        String defaultUrl = "<<ERROR - NO URL SET>>";
        assert (facet.getProjectType() == 4);
        String foundUrl = new InstantAppUrlFinder(MergedManifest.get(facet)).getDefaultUrl();
        String string = StringUtil.isEmpty((String)foundUrl) ? defaultUrl : foundUrl;
        if (string == null) {
            AndroidRunConfigurations.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/project/AndroidRunConfigurations";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/project/AndroidRunConfigurations";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultRunConfigurationUrl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createRunConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addRunConfiguration";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultRunConfigurationUrl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

