/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.ResourceUrl;
import com.android.ide.common.vectordrawable.VdPreview;
import com.android.tools.idea.rendering.ImageUtils;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.Gray;
import com.intellij.util.RetinaImage;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.AndroidIcons;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class GutterIconCache {
    private static final Logger LOG = Logger.getInstance(GutterIconCache.class);
    private static final int MAX_WIDTH = JBUI.scale((int)16);
    private static final int MAX_HEIGHT = JBUI.scale((int)16);
    private static final Icon NONE = AndroidIcons.Android;
    private static final GutterIconCache ourInstance = new GutterIconCache();
    private Map<String, Icon> myThumbnailCache = Maps.newHashMap();
    private boolean myRetina;
    private static boolean ourRetinaEnabled = true;

    @NotNull
    public static GutterIconCache getInstance() {
        GutterIconCache gutterIconCache = ourInstance;
        if (gutterIconCache == null) {
            GutterIconCache.$$$reportNull$$$0(0);
        }
        return gutterIconCache;
    }

    @Nullable
    public Icon getIcon(@NotNull String path, @Nullable ResourceResolver resolver) {
        Icon myIcon;
        boolean isRetina;
        if (path == null) {
            GutterIconCache.$$$reportNull$$$0(1);
        }
        if (this.myRetina != (isRetina = UIUtil.isRetina())) {
            this.myRetina = isRetina;
            this.myThumbnailCache.clear();
        }
        if ((myIcon = this.myThumbnailCache.get(path)) == null) {
            myIcon = GutterIconCache.createIcon(path, resolver);
            if (myIcon == null) {
                myIcon = NONE;
            }
            this.myThumbnailCache.put(path, myIcon);
        }
        return myIcon != NONE ? myIcon : null;
    }

    @Nullable
    private static Icon createIcon(@NotNull String path, @Nullable ResourceResolver resolver) {
        if (path == null) {
            GutterIconCache.$$$reportNull$$$0(2);
        }
        if (path.endsWith(".xml")) {
            return GutterIconCache.createXmlIcon(path, resolver);
        }
        return GutterIconCache.createBitmapIcon(path);
    }

    @Nullable
    private static Icon createXmlIcon(@NotNull String path, @Nullable ResourceResolver resolver) {
        if (path == null) {
            GutterIconCache.$$$reportNull$$$0(3);
        }
        try {
            boolean isRetina = ourRetinaEnabled && UIUtil.isRetina();
            VdPreview.TargetSize imageTargetSize = VdPreview.TargetSize.createSizeFromWidth((int)(isRetina ? 2 * MAX_WIDTH : MAX_WIDTH));
            String xml = Files.toString((File)new File(path), (Charset)Charsets.UTF_8);
            if (xml.contains("<vector")) {
                Document document = XmlUtils.parseDocumentSilently((String)xml, (boolean)true);
                if (document == null) {
                    return null;
                }
                Element root = document.getDocumentElement();
                if (root == null) {
                    return null;
                }
                if (resolver != null) {
                    GutterIconCache.replaceResourceReferences(root, resolver);
                }
                StringBuilder builder = new StringBuilder(100);
                BufferedImage image = VdPreview.getPreviewFromVectorDocument((VdPreview.TargetSize)imageTargetSize, (Document)document, (StringBuilder)builder);
                if (builder.length() > 0) {
                    LOG.warn("Problems rendering " + path + ": " + builder);
                }
                if (image != null) {
                    if (isRetina) {
                        int scale = 2;
                        if (image.getWidth() >= 2 && image.getHeight() >= 2) {
                            try {
                                Image hdpiImage = RetinaImage.createFrom((Image)image, (int)2, null);
                                return new RetinaImageIcon(hdpiImage);
                            }
                            catch (Throwable t) {
                                ourRetinaEnabled = false;
                            }
                        }
                    }
                    return new ImageIcon(image);
                }
            }
        }
        catch (Throwable e) {
            LOG.warn(String.format("Could not read/render icon image %1$s", path), e);
        }
        return null;
    }

    private static void replaceResourceReferences(Node node, ResourceResolver resolver) {
        if (node.getNodeType() == 1) {
            Element element = (Element)node;
            NamedNodeMap attributes = element.getAttributes();
            int n = attributes.getLength();
            block0: for (int i = 0; i < n; ++i) {
                ResourceValue resourceValue;
                ResourceUrl resolvedUrl;
                Node attribute = attributes.item(i);
                String value = attribute.getNodeValue();
                if (!value.startsWith("@") && !value.startsWith("?")) continue;
                for (int j = 0; j < 10 && (resolvedUrl = ResourceUrl.parse((String)value)) != null && (resourceValue = resolvedUrl.theme ? resolver.findItemInTheme(resolvedUrl.name, resolvedUrl.framework) : resolver.findResValue(resolvedUrl.toString(), resolvedUrl.framework)) != null && (value = resourceValue.getValue()) != null; ++j) {
                    if (value.startsWith("@") || value.startsWith("?")) continue;
                    attribute.setNodeValue(value);
                    continue block0;
                }
            }
        }
        for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
            GutterIconCache.replaceResourceReferences(node, resolver);
        }
    }

    @Nullable
    private static Icon createBitmapIcon(@NotNull String path) {
        if (path == null) {
            GutterIconCache.$$$reportNull$$$0(4);
        }
        try {
            BufferedImage image = ImageIO.read(new File(path));
            if (image != null) {
                int imageWidth = image.getWidth();
                int imageHeight = image.getHeight();
                if (ourRetinaEnabled && UIUtil.isRetina()) {
                    BufferedImage scaled = image;
                    if (imageWidth > 2 * MAX_WIDTH || imageHeight > 2 * MAX_HEIGHT) {
                        double scale = 2.0 * Math.min((double)MAX_WIDTH / (double)imageWidth, (double)MAX_HEIGHT / (double)imageHeight);
                        scaled = ImageUtils.scale(image, scale, scale);
                    }
                    int scale = 2;
                    if (scaled.getWidth() >= 2 && scaled.getHeight() >= 2) {
                        try {
                            Image hdpiImage = RetinaImage.createFrom((Image)scaled, (int)2, null);
                            return new RetinaImageIcon(hdpiImage);
                        }
                        catch (Throwable t) {
                            ourRetinaEnabled = false;
                        }
                    }
                }
                if (imageWidth > MAX_WIDTH || imageHeight > MAX_HEIGHT) {
                    double scale = Math.min((double)MAX_WIDTH / (double)imageWidth, (double)MAX_HEIGHT / (double)imageHeight);
                    if (image.getType() == 13) {
                        BufferedImage bg = UIUtil.createImage((int)imageWidth, (int)imageHeight, (int)2);
                        Graphics g = bg.getGraphics();
                        g.setColor(Gray.TRANSPARENT);
                        g.fillRect(0, 0, bg.getWidth(), bg.getHeight());
                        UIUtil.drawImage((Graphics)g, (Image)image, (int)0, (int)0, null);
                        g.dispose();
                        image = bg;
                    }
                    image = ImageUtils.scale(image, scale, scale);
                }
                return new ImageIcon(image);
            }
        }
        catch (Throwable e) {
            LOG.warn(String.format("Could not read icon image %1$s", path), e);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/rendering/GutterIconCache";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/rendering/GutterIconCache";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createIcon";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createXmlIcon";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createBitmapIcon";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RetinaImageIcon
    extends ImageIcon {
        private RetinaImageIcon(Image image) {
            super(image, "");
        }

        @Override
        public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
            UIUtil.drawImage((Graphics)g, (Image)this.getImage(), (int)x, (int)y, null);
        }
    }
}

