/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.LayoutLibrary;
import com.android.ide.common.rendering.api.MergeCookie;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.diagnostics.crash.CrashReporter;
import com.android.tools.idea.gradle.structure.editors.AndroidProjectSettingsService;
import com.android.tools.idea.layoutlib.LayoutLibraryLoader;
import com.android.tools.idea.layoutlib.RenderingException;
import com.android.tools.idea.layoutlib.UnsupportedJavaRuntimeException;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.rendering.LayoutPullParserFactory;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderProblem;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.rendering.TagSnapshot;
import com.android.tools.idea.rendering.multi.CompatibilityRenderTarget;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.ui.designer.EditorDesignSurface;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.android.utils.HtmlBuilder;
import com.google.common.collect.Lists;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.maven.AndroidMavenUtil;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenderService {
    public static final boolean NELE_ENABLED = true;
    private static final long DEFAULT_RENDER_THREAD_TIMEOUT_MS = Integer.getInteger("layoutlib.thread.timeout", 6000).intValue();
    private static final long RENDER_THREAD_IDLE_TIMEOUT_MS = TimeUnit.SECONDS.toMillis(10L);
    private static final AtomicReference<Thread> ourRenderingThread = new AtomicReference();
    private static final ExecutorService ourRenderingExecutor = new ThreadPoolExecutor(0, 1, RENDER_THREAD_IDLE_TIMEOUT_MS, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), r -> {
        Thread renderingThread = new Thread(null, r, "Layoutlib Render Thread");
        renderingThread.setDaemon(true);
        ourRenderingThread.set(renderingThread);
        return renderingThread;
    });
    private static final AtomicInteger ourTimeoutExceptionCounter = new AtomicInteger(0);
    private static final String JDK_INSTALL_URL = "https://developer.android.com/preview/setup-sdk.html#java8";
    @NotNull
    private final AndroidFacet myFacet;
    private final Object myCredential;
    private static boolean ourWarnAboutObsoleteLayoutLibVersions;
    private static final int MEASURE_SPEC_MODE_SHIFT = 30;
    private static final int MAX_MAGNITUDE = 0x2000000;

    public RenderService(@NotNull AndroidFacet facet) {
        if (facet == null) {
            RenderService.$$$reportNull$$$0(0);
        }
        this.myCredential = new Object();
        this.myFacet = facet;
    }

    @NotNull
    public static RenderService get(@NotNull AndroidFacet facet) {
        if (facet == null) {
            RenderService.$$$reportNull$$$0(1);
        }
        RenderService renderService = facet.getRenderService();
        if (renderService == null) {
            RenderService.$$$reportNull$$$0(2);
        }
        return renderService;
    }

    @Nullable
    public static LayoutLibrary getLayoutLibrary(@Nullable Module module, @Nullable IAndroidTarget target) {
        if (module == null || target == null) {
            return null;
        }
        Project project = module.getProject();
        AndroidPlatform platform = AndroidPlatform.getInstance(module);
        if (platform != null) {
            try {
                return platform.getSdkData().getTargetData(target).getLayoutLibrary(project);
            }
            catch (RenderingException | IOException throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean supportsCapability(@NotNull Module module, @NotNull IAndroidTarget target, int capability) {
        if (module == null) {
            RenderService.$$$reportNull$$$0(3);
        }
        if (target == null) {
            RenderService.$$$reportNull$$$0(4);
        }
        Project project = module.getProject();
        AndroidPlatform platform = AndroidPlatform.getInstance(module);
        if (platform != null) {
            try {
                LayoutLibrary library = platform.getSdkData().getTargetData(target).getLayoutLibrary(project);
                if (library != null) {
                    return library.supports(capability);
                }
            }
            catch (RenderingException | IOException throwable) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean canRender(@Nullable PsiFile file) {
        return file != null && LayoutPullParserFactory.isSupported(file);
    }

    @NotNull
    public RenderLogger createLogger() {
        Module module = this.getModule();
        RenderLogger renderLogger = new RenderLogger(module.getName(), module, this.myCredential);
        if (renderLogger == null) {
            RenderService.$$$reportNull$$$0(5);
        }
        return renderLogger;
    }

    @Nullable
    public RenderTask createTask(@Nullable PsiFile psiFile, @NotNull Configuration configuration, @NotNull RenderLogger logger, @Nullable EditorDesignSurface surface) {
        LayoutLibrary layoutLib;
        if (configuration == null) {
            RenderService.$$$reportNull$$$0(6);
        }
        if (logger == null) {
            RenderService.$$$reportNull$$$0(7);
        }
        Module module = this.myFacet.getModule();
        Project project = module.getProject();
        AndroidPlatform platform = RenderService.getPlatform(module, logger);
        if (platform == null) {
            return null;
        }
        IAndroidTarget target = configuration.getTarget();
        if (target == null) {
            logger.addMessage(RenderProblem.createPlain(HighlightSeverity.ERROR, "No render target was chosen"));
            return null;
        }
        RenderService.warnIfObsoleteLayoutLib(module, logger, surface, target);
        try {
            layoutLib = platform.getSdkData().getTargetData(target).getLayoutLibrary(project);
            if (layoutLib == null) {
                String message = AndroidBundle.message("android.layout.preview.cannot.load.library.error", new Object[0]);
                logger.addMessage(RenderProblem.createPlain(HighlightSeverity.ERROR, message));
                return null;
            }
        }
        catch (UnsupportedJavaRuntimeException e) {
            RenderProblem.Html javaVersionProblem = RenderProblem.create(HighlightSeverity.ERROR);
            javaVersionProblem.getHtmlBuilder().add(e.getPresentableMessage()).newline().addLink("Install a supported JDK", JDK_INSTALL_URL);
            logger.addMessage(javaVersionProblem);
            return null;
        }
        catch (RenderingException e) {
            String message = e.getPresentableMessage();
            message = message != null ? message : AndroidBundle.message("android.layout.preview.default.error.message", new Object[0]);
            logger.addMessage(RenderProblem.createPlain(HighlightSeverity.ERROR, message, module.getProject(), logger.getLinkManager(), e));
            return null;
        }
        catch (IOException e) {
            String message = e.getMessage();
            logger.error(null, "I/O error: " + (message != null ? ": " + message : ""), e);
            return null;
        }
        if (psiFile != null && "PreferenceScreen".equals(AndroidPsiUtils.getRootTagName(psiFile)) && !layoutLib.supports(14)) {
            logger.addMessage(RenderProblem.createPlain(HighlightSeverity.ERROR, "This version of the rendering library does not support rendering Preferences. Update it using the SDK Manager"));
            return null;
        }
        Device device = configuration.getDevice();
        if (device == null) {
            logger.addMessage(RenderProblem.createPlain(HighlightSeverity.ERROR, "No device selected"));
            return null;
        }
        try {
            RenderTask task = new RenderTask(this, configuration, logger, layoutLib, device, this.myCredential, CrashReporter.getInstance());
            if (psiFile != null) {
                task.setPsiFile(psiFile);
            }
            task.setDesignSurface(surface);
            return task;
        }
        catch (IncorrectOperationException | AssertionError e) {
            assert (this.myFacet.isDisposed());
            return null;
        }
    }

    @NotNull
    public AndroidFacet getFacet() {
        AndroidFacet androidFacet = this.myFacet;
        if (androidFacet == null) {
            RenderService.$$$reportNull$$$0(8);
        }
        return androidFacet;
    }

    public Module getModule() {
        return this.myFacet.getModule();
    }

    public Project getProject() {
        return this.getModule().getProject();
    }

    @Nullable
    public AndroidPlatform getPlatform() {
        return AndroidPlatform.getInstance(this.getModule());
    }

    @Nullable
    private static AndroidPlatform getPlatform(@NotNull Module module, @Nullable RenderLogger logger) {
        AndroidPlatform platform;
        if (module == null) {
            RenderService.$$$reportNull$$$0(9);
        }
        if ((platform = AndroidPlatform.getInstance(module)) == null && logger != null) {
            if (!AndroidMavenUtil.isMavenizedModule(module)) {
                RenderProblem.Html message = RenderProblem.create(HighlightSeverity.ERROR);
                logger.addMessage(message);
                message.getHtmlBuilder().addLink("No Android SDK found. Please ", "configure", " an Android SDK.", logger.getLinkManager().createRunnableLink(() -> {
                    if (module == null) {
                        RenderService.$$$reportNull$$$0(16);
                    }
                    Project project = module.getProject();
                    ProjectSettingsService service = ProjectSettingsService.getInstance((Project)project);
                    if (AndroidProjectInfo.getInstance(project).requiresAndroidModel() && service instanceof AndroidProjectSettingsService) {
                        ((AndroidProjectSettingsService)service).openSdkSettings();
                        return;
                    }
                    AndroidSdkUtils.openModuleDependenciesConfigurable(module);
                }));
            } else {
                String message = AndroidBundle.message("android.maven.cannot.parse.android.sdk.error", module.getName());
                logger.addMessage(RenderProblem.createPlain(HighlightSeverity.ERROR, message));
            }
        }
        return platform;
    }

    private static void warnIfObsoleteLayoutLib(@NotNull Module module, @NotNull RenderLogger logger, @Nullable EditorDesignSurface surface, @NotNull IAndroidTarget target) {
        int revision;
        if (module == null) {
            RenderService.$$$reportNull$$$0(10);
        }
        if (logger == null) {
            RenderService.$$$reportNull$$$0(11);
        }
        if (target == null) {
            RenderService.$$$reportNull$$$0(12);
        }
        if (!ourWarnAboutObsoleteLayoutLibVersions) {
            return;
        }
        if (!LayoutLibraryLoader.USE_SDK_LAYOUTLIB) {
            ourWarnAboutObsoleteLayoutLibVersions = false;
            return;
        }
        if (target instanceof CompatibilityRenderTarget) {
            target = ((CompatibilityRenderTarget)target).getRenderTarget();
        }
        AndroidVersion version = target.getVersion();
        switch (version.getFeatureLevel()) {
            case 23: {
                revision = 2;
                break;
            }
            case 22: {
                revision = 2;
                break;
            }
            case 21: {
                revision = 2;
                break;
            }
            case 20: {
                revision = 2;
                break;
            }
            case 19: {
                revision = 4;
                break;
            }
            case 18: {
                revision = 3;
                break;
            }
            case 17: {
                revision = 3;
                break;
            }
            case 16: {
                revision = 5;
                break;
            }
            case 15: {
                revision = 5;
                break;
            }
            case 14: {
                revision = 4;
                break;
            }
            case 13: {
                revision = 1;
                break;
            }
            case 12: {
                revision = 3;
                break;
            }
            case 11: {
                revision = 2;
                break;
            }
            case 10: {
                revision = 2;
                break;
            }
            case 8: {
                revision = 3;
                break;
            }
            default: {
                revision = -1;
            }
        }
        if (revision >= 0 && target.getRevision() < revision) {
            RenderProblem.Html problem = RenderProblem.create(HighlightSeverity.WARNING);
            problem.tag("obsoleteLayoutlib");
            HtmlBuilder builder = problem.getHtmlBuilder();
            builder.add("Using an obsolete version of the " + target.getVersionName() + " layout library which contains many known bugs: ");
            builder.addLink("Install Update", logger.getLinkManager().createRunnableLink(() -> {
                if (module == null) {
                    RenderService.$$$reportNull$$$0(15);
                }
                ourWarnAboutObsoleteLayoutLibVersions = false;
                ArrayList requested = Lists.newArrayList();
                requested.add(DetailsTypes.getPlatformPath((AndroidVersion)version));
                ModelWizardDialog dialog = SdkQuickfixUtils.createDialogForPaths(module.getProject(), requested);
                if (dialog != null && dialog.showAndGet() && surface != null) {
                    Configuration configuration = surface.getConfiguration();
                    if (configuration != null) {
                        configuration.getConfigurationManager().setTarget(null);
                    }
                    surface.requestRender();
                    Messages.showInfoMessage((Project)module.getProject(), (String)"Note: Due to a bug you may need to restart the IDE for the new layout library to fully take effect", (String)"Restart Recommended");
                }
            }));
            builder.addLink(", ", "Ignore For Now", null, logger.getLinkManager().createRunnableLink(() -> {
                ourWarnAboutObsoleteLayoutLibVersions = false;
                if (surface != null) {
                    surface.requestRender();
                }
            }));
            logger.addMessage(problem);
        }
    }

    public static void runRenderAction(@NotNull Runnable runnable) throws Exception {
        if (runnable == null) {
            RenderService.$$$reportNull$$$0(13);
        }
        RenderService.runRenderAction(Executors.callable(runnable));
    }

    public static <T> T runRenderAction(@NotNull Callable<T> callable) throws Exception {
        if (callable == null) {
            RenderService.$$$reportNull$$$0(14);
        }
        try {
            if (ourTimeoutExceptionCounter.get() > 3) {
                ourRenderingExecutor.submit(() -> ourTimeoutExceptionCounter.set(0)).get(50L, TimeUnit.MILLISECONDS);
            }
            T result = ourRenderingExecutor.submit(callable).get(DEFAULT_RENDER_THREAD_TIMEOUT_MS, TimeUnit.MILLISECONDS);
            ourTimeoutExceptionCounter.set(0);
            return result;
        }
        catch (TimeoutException e) {
            ourTimeoutExceptionCounter.incrementAndGet();
            Thread renderingThread = ourRenderingThread.get();
            TimeoutException timeoutException = new TimeoutException("Preview timed out while rendering the layout.\nThis typically happens when there is an infinite loop or unbounded recursion in one of the custom views.");
            if (renderingThread != null) {
                timeoutException.setStackTrace(renderingThread.getStackTrace());
            }
            throw timeoutException;
        }
    }

    public static ViewInfo getSafeBounds(ViewInfo view) {
        int left = Math.abs(view.getLeft());
        int right = Math.abs(view.getRight());
        int top = Math.abs(view.getTop());
        int bottom = Math.abs(view.getBottom());
        if (left < 0x2000000 && right < 0x2000000 && top < 0x2000000 && bottom < 0x2000000) {
            return view;
        }
        return new ViewInfo(null, null, 0, 0, 0, 0);
    }

    @Nullable
    public static XmlTag getXmlTag(ViewInfo view) {
        Object cookie = view.getCookie();
        if (cookie != null) {
            if (cookie instanceof TagSnapshot) {
                TagSnapshot snapshot = (TagSnapshot)cookie;
                return snapshot.tag;
            }
            if (cookie instanceof MergeCookie && (cookie = ((MergeCookie)cookie).getCookie()) instanceof TagSnapshot) {
                TagSnapshot snapshot = (TagSnapshot)cookie;
                return snapshot.tag;
            }
            if (cookie instanceof XmlTag) {
                return (XmlTag)cookie;
            }
        }
        return null;
    }

    static {
        ShutDownTracker.getInstance().registerShutdownTask(() -> {
            ourRenderingExecutor.shutdownNow();
            ourRenderingThread.set(null);
        });
        ourWarnAboutObsoleteLayoutLibVersions = true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/rendering/RenderService";
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/rendering/RenderService";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createLogger";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "supportsCapability";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createTask";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPlatform";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "warnIfObsoleteLayoutLib";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "runRenderAction";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$warnIfObsoleteLayoutLib$3";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getPlatform$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

