/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.DevicePickerEntry;
import com.android.tools.idea.run.DevicePickerListModel;
import com.android.tools.idea.run.LaunchCompatibility;
import com.android.tools.idea.run.LaunchCompatibilityChecker;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.TitledSeparator;
import com.intellij.util.ThreeState;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListModel;
import org.jetbrains.annotations.NotNull;

public class AndroidDeviceRenderer
extends ColoredListCellRenderer<DevicePickerEntry> {
    private final LaunchCompatibilityChecker myCompatibilityChecker;
    private final SpeedSearchBase mySpeedSearch;

    public AndroidDeviceRenderer(@NotNull LaunchCompatibilityChecker checker, @NotNull SpeedSearchBase speedSearch) {
        if (checker == null) {
            AndroidDeviceRenderer.$$$reportNull$$$0(0);
        }
        if (speedSearch == null) {
            AndroidDeviceRenderer.$$$reportNull$$$0(1);
        }
        this.myCompatibilityChecker = checker;
        this.mySpeedSearch = speedSearch;
    }

    public Component getListCellRendererComponent(JList<? extends DevicePickerEntry> list, DevicePickerEntry value, int index, boolean selected, boolean hasFocus) {
        if (value != null && value.isMarker()) {
            String marker = value.getMarker();
            assert (marker != null) : "device picker marker entry doesn't have a descriptive string";
            if (value == DevicePickerEntry.NONE) {
                return AndroidDeviceRenderer.renderEmptyMarker(marker);
            }
            return AndroidDeviceRenderer.renderTitledSeparator(marker);
        }
        return super.getListCellRendererComponent(list, (Object)value, index, selected, hasFocus);
    }

    protected void customizeCellRenderer(@NotNull JList list, DevicePickerEntry entry, int index, boolean selected, boolean hasFocus) {
        boolean compatible;
        if (list == null) {
            AndroidDeviceRenderer.$$$reportNull$$$0(2);
        }
        AndroidDevice device = entry.getAndroidDevice();
        assert (device != null);
        LaunchCompatibility launchCompatibility = this.myCompatibilityChecker.validate(device);
        boolean bl = compatible = launchCompatibility.isCompatible() != ThreeState.NO;
        if (AndroidDeviceRenderer.shouldShowSerialNumbers(list, device)) {
            this.append("[" + device.getSerial() + "] ", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        device.renderName((SimpleColoredComponent)this, compatible, this.mySpeedSearch.getEnteredPrefix());
        if (launchCompatibility.getReason() != null) {
            this.append(" (" + launchCompatibility.getReason() + ")", SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES);
        }
    }

    private static boolean shouldShowSerialNumbers(@NotNull JList list, @NotNull AndroidDevice device) {
        if (list == null) {
            AndroidDeviceRenderer.$$$reportNull$$$0(3);
        }
        if (device == null) {
            AndroidDeviceRenderer.$$$reportNull$$$0(4);
        }
        if (device.isVirtual()) {
            return false;
        }
        ListModel model = list.getModel();
        if (model instanceof DevicePickerListModel) {
            return ((DevicePickerListModel)model).shouldShowSerialNumbers();
        }
        return false;
    }

    private static Component renderTitledSeparator(@NotNull String title) {
        if (title == null) {
            AndroidDeviceRenderer.$$$reportNull$$$0(5);
        }
        TitledSeparator separator = new TitledSeparator(title);
        separator.setBackground(UIUtil.getListBackground());
        separator.setTitleFont(UIUtil.getLabelFont());
        return separator;
    }

    private static Component renderEmptyMarker(@NotNull String title) {
        if (title == null) {
            AndroidDeviceRenderer.$$$reportNull$$$0(6);
        }
        return new JLabel(title);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checker";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "speedSearch";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/run/AndroidDeviceRenderer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "customizeCellRenderer";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldShowSerialNumbers";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "renderTitledSeparator";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "renderEmptyMarker";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

