/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceStateCache<T>
implements AndroidDebugBridge.IDeviceChangeListener,
Disposable {
    private final Table<String, String, T> myCache;

    public DeviceStateCache(@NotNull Disposable parent) {
        if (parent == null) {
            DeviceStateCache.$$$reportNull$$$0(0);
        }
        this.myCache = HashBasedTable.create();
        Disposer.register((Disposable)parent, (Disposable)this);
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
    }

    public void dispose() {
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
    }

    @Nullable
    public T get(@NotNull IDevice device, @NotNull String pkgName) {
        if (device == null) {
            DeviceStateCache.$$$reportNull$$$0(1);
        }
        if (pkgName == null) {
            DeviceStateCache.$$$reportNull$$$0(2);
        }
        return (T)this.myCache.get((Object)device.getSerialNumber(), (Object)pkgName);
    }

    @Nullable
    public T put(@NotNull IDevice device, @NotNull String pkgName, @NotNull T data) {
        if (device == null) {
            DeviceStateCache.$$$reportNull$$$0(3);
        }
        if (pkgName == null) {
            DeviceStateCache.$$$reportNull$$$0(4);
        }
        if (data == null) {
            DeviceStateCache.$$$reportNull$$$0(5);
        }
        return (T)this.myCache.put((Object)device.getSerialNumber(), (Object)pkgName, data);
    }

    public void deviceConnected(IDevice device) {
    }

    public void deviceDisconnected(IDevice device) {
        this.myCache.row((Object)device.getSerialNumber()).clear();
    }

    public void deviceChanged(IDevice device, int changeMask) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkgName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/run/DeviceStateCache";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "get";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "put";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

