/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.actions;

import com.android.tools.idea.uibuilder.analytics.NlUsageTrackerManager;
import com.android.tools.idea.uibuilder.lint.LintAnnotationsModel;
import com.android.tools.idea.uibuilder.lint.LintNotificationPanel;
import com.android.tools.idea.uibuilder.surface.DesignSurface;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.google.wireless.android.sdk.stats.LayoutEditorEvent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import icons.AndroidIcons;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class LintNotificationAction
extends AnAction {
    private final DesignSurface mySurface;
    private int myCount;

    public LintNotificationAction(@NotNull DesignSurface surface) {
        if (surface == null) {
            LintNotificationAction.$$$reportNull$$$0(0);
        }
        this.myCount = -1;
        this.mySurface = surface;
    }

    public void update(AnActionEvent e) {
        LintAnnotationsModel lintModel;
        Presentation presentation = e.getPresentation();
        ScreenView screenView = this.mySurface.getCurrentScreenView();
        int markerCount = 0;
        if (screenView != null && (lintModel = screenView.getModel().getLintAnnotationsModel()) != null) {
            markerCount = lintModel.getIssueCount();
        }
        if (markerCount != this.myCount) {
            Icon icon;
            this.myCount = markerCount;
            switch (markerCount) {
                case 0: {
                    icon = AndroidIcons.LintNotification.Lint0;
                    break;
                }
                case 1: {
                    icon = AndroidIcons.LintNotification.Lint1;
                    break;
                }
                case 2: {
                    icon = AndroidIcons.LintNotification.Lint2;
                    break;
                }
                case 3: {
                    icon = AndroidIcons.LintNotification.Lint3;
                    break;
                }
                case 4: {
                    icon = AndroidIcons.LintNotification.Lint4;
                    break;
                }
                case 5: {
                    icon = AndroidIcons.LintNotification.Lint5;
                    break;
                }
                case 6: {
                    icon = AndroidIcons.LintNotification.Lint6;
                    break;
                }
                case 7: {
                    icon = AndroidIcons.LintNotification.Lint7;
                    break;
                }
                case 8: {
                    icon = AndroidIcons.LintNotification.Lint8;
                    break;
                }
                case 9: {
                    icon = AndroidIcons.LintNotification.Lint9;
                    break;
                }
                default: {
                    icon = AndroidIcons.LintNotification.Lint9plus;
                }
            }
            presentation.setIcon(icon);
            presentation.setText(markerCount == 0 ? "No Warnings" : "Show Warnings and Errors");
        }
    }

    public void actionPerformed(AnActionEvent e) {
        LintAnnotationsModel lintModel;
        NlUsageTrackerManager.getInstance(this.mySurface).logAction(LayoutEditorEvent.LayoutEditorEventType.SHOW_LINT_MESSAGES);
        ScreenView screenView = this.mySurface.getCurrentScreenView();
        if (screenView != null && (lintModel = screenView.getModel().getLintAnnotationsModel()) != null && lintModel.getIssueCount() > 0) {
            LintNotificationPanel notificationPanel = new LintNotificationPanel(screenView, lintModel);
            Object source = e.getInputEvent().getSource();
            if (source instanceof JComponent) {
                notificationPanel.showInBestPositionFor(e.getProject(), (JComponent)source);
            } else {
                notificationPanel.showInBestPositionFor(e.getProject(), e.getDataContext());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "surface", "com/android/tools/idea/uibuilder/actions/LintNotificationAction", "<init>"));
    }
}

