/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint;

import android.support.constraint.solver.widgets.ConstraintAnchor;
import android.support.constraint.solver.widgets.ConstraintWidget;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintModel;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintUtilities;
import com.android.tools.idea.uibuilder.handlers.constraint.DrawConstraintModel;
import com.android.tools.idea.uibuilder.handlers.constraint.NlComponentUtils;
import com.android.tools.idea.uibuilder.handlers.constraint.SingleWidgetView;
import com.android.tools.idea.uibuilder.model.AttributesTransaction;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.scene.ConstraintComponentUtilities;
import com.android.tools.sherpa.drawing.BlueprintColorSet;
import com.android.tools.sherpa.drawing.ColorSet;
import com.android.tools.sherpa.structure.WidgetsScene;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicSliderUI;
import org.jetbrains.annotations.NotNull;

public class WidgetConstraintPanel
extends JPanel {
    private static final String HORIZONTAL_TOOL_TIP_TEXT = "Horizontal Bias";
    private static final String VERTICAL_TOOL_TIP_TEXT = "Vertical Bias";
    public static final String SIZE_ANY = "0dp";
    final SingleWidgetView mMain;
    final JSlider mVerticalSlider;
    final JSlider mHorizontalSlider;
    private WidgetsScene mScene;
    private boolean mConfiguringUI;
    ConstraintModel mConstraintModel;
    NlComponent mComponent;
    public static final int UNCONNECTED = -1;
    WriteCommandAction myWriteAction;
    private static final int DELAY_BEFORE_COMMIT = 400;
    ColorSet mColorSet;
    Timer myTimer;
    private boolean mDisableWidgetUpdates;
    private ChangeListener myChangeLiveListener;
    static final int CONNECTION_LEFT = 0;
    static final int CONNECTION_RIGHT = 1;
    static final int CONNECTION_TOP = 2;
    static final int CONNECTION_BOTTOM = 3;
    static final int CONNECTION_BASELINE = 4;
    static String[][] ourConstraintString = new String[][]{{"layout_constraintLeft_toLeftOf", "layout_constraintLeft_toRightOf"}, {"layout_constraintRight_toLeftOf", "layout_constraintRight_toRightOf"}, {"layout_constraintTop_toTopOf", "layout_constraintTop_toBottomOf"}, {"layout_constraintBottom_toTopOf", "layout_constraintBottom_toBottomOf"}, {"layout_constraintBaseline_toBaselineOf"}};
    static String[] ourMarginString = new String[]{"layout_marginLeft", "layout_marginRight", "layout_marginTop", "layout_marginBottom"};
    static String[][] ourDeleteAttributes = new String[][]{{"layout_constraintLeft_toLeftOf", "layout_constraintLeft_toRightOf", "layout_marginLeft", "layout_marginStart", "layout_constraintHorizontal_bias"}, {"layout_constraintRight_toLeftOf", "layout_constraintRight_toRightOf", "layout_marginRight", "layout_marginEnd", "layout_constraintHorizontal_bias"}, {"layout_constraintTop_toTopOf", "layout_constraintTop_toBottomOf", "layout_marginTop", "layout_constraintVertical_bias"}, {"layout_constraintBottom_toTopOf", "layout_constraintBottom_toBottomOf", "layout_marginBottom", "layout_constraintVertical_bias"}, {"layout_constraintBaseline_toBaselineOf"}};
    static String[][] ourDeleteNamespace = new String[][]{{"http://schemas.android.com/apk/res-auto", "http://schemas.android.com/apk/res-auto", "http://schemas.android.com/apk/res/android", "http://schemas.android.com/apk/res/android", "http://schemas.android.com/apk/res-auto"}, {"http://schemas.android.com/apk/res-auto", "http://schemas.android.com/apk/res-auto", "http://schemas.android.com/apk/res/android", "http://schemas.android.com/apk/res/android", "http://schemas.android.com/apk/res-auto"}, {"http://schemas.android.com/apk/res-auto", "http://schemas.android.com/apk/res-auto", "http://schemas.android.com/apk/res/android", "http://schemas.android.com/apk/res-auto"}, {"http://schemas.android.com/apk/res-auto", "http://schemas.android.com/apk/res-auto", "http://schemas.android.com/apk/res/android", "http://schemas.android.com/apk/res-auto"}, {"http://schemas.android.com/apk/res-auto"}};
    public static final int UNKNOWN = -1;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;

    public void setProperty(NlProperty property) {
        this.updateComponents(property.getComponents());
    }

    public void setAspect(String aspect) {
        this.setSherpaAttribute("layout_constraintDimensionRatio", aspect);
    }

    public WidgetConstraintPanel(@NotNull List<NlComponent> components) {
        if (components == null) {
            WidgetConstraintPanel.$$$reportNull$$$0(0);
        }
        super(new GridBagLayout());
        this.mVerticalSlider = new JSlider(1);
        this.mHorizontalSlider = new JSlider(0);
        this.mConfiguringUI = false;
        this.mColorSet = new InspectorColorSet();
        this.myTimer = new Timer(400, c -> {
            if (this.myWriteAction != null) {
                this.myWriteAction.execute();
            }
        });
        this.mDisableWidgetUpdates = false;
        this.myChangeLiveListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                WidgetConstraintPanel.this.configureUI();
            }
        };
        super.setBorder(new EmptyBorder(4, 0, 0, 0));
        this.setBackground(this.mColorSet.getInspectorBackgroundColor());
        this.mMain = new SingleWidgetView(this, this.mColorSet);
        this.setPreferredSize(new Dimension(200, 216));
        this.mVerticalSlider.setMajorTickSpacing(50);
        this.mHorizontalSlider.setMajorTickSpacing(50);
        this.mVerticalSlider.setBackground(this.mColorSet.getInspectorBackgroundColor());
        this.mHorizontalSlider.setBackground(this.mColorSet.getInspectorBackgroundColor());
        this.mHorizontalSlider.setToolTipText(HORIZONTAL_TOOL_TIP_TEXT);
        this.mVerticalSlider.setToolTipText(VERTICAL_TOOL_TIP_TEXT);
        this.updateComponents(components);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.fill = 1;
        this.add((Component)this.mVerticalSlider, gbc);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = 1;
        this.add((Component)this.mMain, gbc);
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridy = 1;
        this.add((Component)this.mHorizontalSlider, gbc);
        this.mVerticalSlider.setUI(new WidgetSliderUI(this.mVerticalSlider, this.mColorSet));
        this.mHorizontalSlider.setUI(new WidgetSliderUI(this.mHorizontalSlider, this.mColorSet));
        this.mHorizontalSlider.addChangeListener(e -> this.setHorizontalBias());
        this.mVerticalSlider.addChangeListener(e -> this.setVerticalBias());
    }

    private void widgetChanged() {
        this.mDisableWidgetUpdates = true;
        this.configureUI();
        this.mDisableWidgetUpdates = false;
        this.repaint();
    }

    private int getMargin(int type) {
        int margin = ConstraintUtilities.getMargin(this.mComponent, ourMarginString[type]);
        String connection = this.mComponent.getLiveAttribute("http://schemas.android.com/apk/res-auto", ourConstraintString[type][0]);
        if (connection == null && ourConstraintString[type].length > 1 && (connection = this.mComponent.getLiveAttribute("http://schemas.android.com/apk/res-auto", ourConstraintString[type][1])) == null) {
            margin = -1;
        }
        return margin;
    }

    private void configureUI() {
        float bias;
        boolean showHorizontalSlider;
        if (this.mComponent == null) {
            return;
        }
        this.mConfiguringUI = true;
        String sherpaNamespace = "http://schemas.android.com/apk/res-auto";
        int top = this.getMargin(2);
        int left = this.getMargin(0);
        int right = this.getMargin(1);
        int bottom = this.getMargin(3);
        String ratioString = this.mComponent.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintDimensionRatio");
        String horizontalBias = this.mComponent.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintHorizontal_bias");
        String verticalBias = this.mComponent.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_bias");
        boolean baseline = this.hasBaseline();
        boolean showVerticalSlider = bottom != -1 && top != -1;
        boolean bl = showHorizontalSlider = left != -1 && right != -1;
        if (showHorizontalSlider) {
            if (NlComponentUtils.isHorizontalChain(this.mComponent)) {
                NlComponent ctl = NlComponentUtils.getLeftMostInChain(this.mComponent);
                horizontalBias = ctl.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintHorizontal_bias");
            }
            bias = WidgetConstraintPanel.parseFloat(horizontalBias, 0.5f);
            this.mHorizontalSlider.setValue((int)(bias * 100.0f));
        }
        if (showVerticalSlider) {
            if (NlComponentUtils.isVerticalChain(this.mComponent)) {
                NlComponent ctl = NlComponentUtils.getTopMostInChain(this.mComponent);
                verticalBias = ctl.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_bias");
            }
            bias = WidgetConstraintPanel.parseFloat(verticalBias, 0.5f);
            this.mVerticalSlider.setValue(100 - (int)(bias * 100.0f));
        }
        this.mVerticalSlider.setEnabled(showVerticalSlider);
        this.mHorizontalSlider.setEnabled(showHorizontalSlider);
        this.mHorizontalSlider.invalidate();
        this.mVerticalSlider.invalidate();
        this.mVerticalSlider.setToolTipText(showVerticalSlider ? VERTICAL_TOOL_TIP_TEXT : null);
        this.mHorizontalSlider.setToolTipText(showHorizontalSlider ? HORIZONTAL_TOOL_TIP_TEXT : null);
        int widthValue = this.convertFromNL("layout_width");
        int heightValue = this.convertFromNL("layout_height");
        this.mMain.configureUi(bottom, top, left, right, baseline, widthValue, heightValue, ratioString);
        this.mConfiguringUI = false;
    }

    private static float parseFloat(String string, float defaultValue) {
        if (string != null && string.length() > 0) {
            try {
                return Float.parseFloat(string);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    int getDimension(NlComponent component, String nameSpace, String attribute) {
        String v = component.getLiveAttribute(nameSpace, attribute);
        if ("wrap_content".equalsIgnoreCase(v)) {
            return -1;
        }
        return ConstraintUtilities.getDpValue(component, v);
    }

    void setDimension(NlComponent component, String nameSpace, String attribute, int currentValue) {
        String v = component.getLiveAttribute(nameSpace, attribute);
        String marginString = component.getLiveAttribute("http://schemas.android.com/apk/res/android", attribute);
        int marginValue = -1;
        if (marginString != null) {
            marginValue = ConstraintComponentUtilities.getDpValue(component, component.getLiveAttribute("http://schemas.android.com/apk/res/android", attribute));
        }
        if (marginValue != -1 && marginValue == currentValue) {
            this.setAttribute("http://schemas.android.com/apk/res/android", attribute, marginString);
        } else {
            String marginY = String.format("%ddp", currentValue);
            this.setAttribute("http://schemas.android.com/apk/res/android", attribute, marginY);
        }
    }

    private void setAndroidAttribute(String attribute, String value) {
        this.setAttribute("http://schemas.android.com/apk/res/android", attribute, value);
    }

    private void setSherpaAttribute(String attribute, String value) {
        this.setAttribute("http://schemas.android.com/apk/res-auto", attribute, value);
    }

    private void setAttribute(final String nameSpace, final String attribute, final String value) {
        if (this.mConfiguringUI) {
            return;
        }
        NlModel model = this.mComponent.getModel();
        AttributesTransaction transaction = this.mComponent.startAttributeTransaction();
        transaction.setAttribute(nameSpace, attribute, value);
        transaction.apply();
        model.requestLayout(false);
        this.myTimer.setRepeats(false);
        Project project = model.getProject();
        XmlFile file = model.getFile();
        String label = "Change Widget";
        this.myWriteAction = new WriteCommandAction(project, label, new PsiFile[]{file}){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    2.$$$reportNull$$$0(0);
                }
                AttributesTransaction transaction = WidgetConstraintPanel.this.mComponent.startAttributeTransaction();
                transaction.setAttribute(nameSpace, attribute, value);
                transaction.commit();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/uibuilder/handlers/constraint/WidgetConstraintPanel$2", "run"));
            }
        };
        this.myTimer.restart();
    }

    private void removeAttribute(int type) {
        String label = "Constraint Disconnected";
        String[] attribute = ourDeleteAttributes[type];
        String[] namespace = ourDeleteNamespace[type];
        NlModel nlModel = this.mComponent.getModel();
        Project project = nlModel.getProject();
        XmlFile file = nlModel.getFile();
        final AttributesTransaction transaction = this.mComponent.startAttributeTransaction();
        for (int i = 0; i < attribute.length; ++i) {
            transaction.setAttribute(namespace[i], attribute[i], null);
        }
        ConstraintComponentUtilities.ensureHorizontalPosition(this.mComponent, transaction);
        ConstraintComponentUtilities.ensureVerticalPosition(this.mComponent, transaction);
        transaction.apply();
        WriteCommandAction action = new WriteCommandAction(project, label, new PsiFile[]{file}){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    3.$$$reportNull$$$0(0);
                }
                transaction.commit();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/uibuilder/handlers/constraint/WidgetConstraintPanel$3", "run"));
            }
        };
        action.execute();
    }

    public static float getDimensionRatio(String ratio) {
        float dimensionRatio;
        block16: {
            if (ratio == null || ratio.length() == 0) {
                return Float.NaN;
            }
            int dimensionRatioSide = -1;
            dimensionRatio = 0.0f;
            int len = ratio.length();
            int commaIndex = ratio.indexOf(44);
            if (commaIndex > 0 && commaIndex < len - 1) {
                String dimension = ratio.substring(0, commaIndex);
                if (dimension.equalsIgnoreCase("W")) {
                    dimensionRatioSide = 0;
                } else if (dimension.equalsIgnoreCase("H")) {
                    dimensionRatioSide = 1;
                }
                ++commaIndex;
            } else {
                commaIndex = 0;
            }
            int colonIndex = ratio.indexOf(58);
            if (colonIndex >= 0 && colonIndex < len - 1) {
                String nominator = ratio.substring(commaIndex, colonIndex);
                String denominator = ratio.substring(colonIndex + 1);
                if (nominator.length() > 0 && denominator.length() > 0) {
                    try {
                        float nominatorValue = Float.parseFloat(nominator);
                        float denominatorValue = Float.parseFloat(denominator);
                        if (!(nominatorValue > 0.0f) || !(denominatorValue > 0.0f)) break block16;
                        if (dimensionRatioSide == 1) {
                            dimensionRatio = Math.abs(denominatorValue / nominatorValue);
                            break block16;
                        }
                        dimensionRatio = Math.abs(nominatorValue / denominatorValue);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            } else {
                String r = ratio.substring(commaIndex);
                if (r.length() > 0) {
                    try {
                        dimensionRatio = Float.parseFloat(r);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
        if (dimensionRatio > 0.0f) {
            return dimensionRatio;
        }
        return Float.NaN;
    }

    public static int getDimensionRatioSide(String ratio) {
        if (ratio.toUpperCase().startsWith("W")) {
            return 0;
        }
        if (ratio.toUpperCase().startsWith("H")) {
            return 1;
        }
        return -1;
    }

    private int convertFromNL(String attribute) {
        int dimen = this.getDimension(this.mComponent, "http://schemas.android.com/apk/res/android", attribute);
        switch (dimen) {
            default: {
                return 0;
            }
            case -1: {
                return 2;
            }
            case 0: 
        }
        return 1;
    }

    private void configureUI_constraint_widget() {
        float bias;
        String biasString;
        boolean showHorizontalSlider;
        int top = this.getMargin(ConstraintAnchor.Type.TOP);
        int left = this.getMargin(ConstraintAnchor.Type.LEFT);
        int right = this.getMargin(ConstraintAnchor.Type.RIGHT);
        int bottom = this.getMargin(ConstraintAnchor.Type.BOTTOM);
        String ratioString = this.getSherpaAttribute("layout_constraintDimensionRatio");
        boolean baseline = this.hasBaseline();
        boolean showVerticalSlider = bottom != -1 && top != -1;
        boolean bl = showHorizontalSlider = left != -1 && right != -1;
        if (showHorizontalSlider) {
            biasString = this.getSherpaAttribute("layout_constraintHorizontal_bias");
            bias = 0.5f;
            if (biasString != null && biasString.length() != 0) {
                bias = Float.parseFloat(biasString);
            }
            this.mHorizontalSlider.setValue((int)(bias * 100.0f));
        }
        if (showVerticalSlider) {
            biasString = this.getSherpaAttribute("layout_constraintVertical_bias");
            bias = 0.5f;
            if (biasString != null && biasString.length() != 0) {
                bias = Float.parseFloat(biasString);
            }
            this.mVerticalSlider.setValue(100 - (int)(bias * 100.0f));
        }
        this.mVerticalSlider.setEnabled(showVerticalSlider);
        this.mHorizontalSlider.setEnabled(showHorizontalSlider);
        this.mHorizontalSlider.invalidate();
        this.mVerticalSlider.invalidate();
        this.mVerticalSlider.setToolTipText(showVerticalSlider ? VERTICAL_TOOL_TIP_TEXT : null);
        this.mHorizontalSlider.setToolTipText(showHorizontalSlider ? HORIZONTAL_TOOL_TIP_TEXT : null);
        this.getSherpaAttribute("layout_width");
        int widthVal = this.getLayoutDimensionDpValue("layout_width");
        int heightValue = this.getLayoutDimensionDpValue("layout_height");
        this.mMain.configureUi(bottom, top, left, right, baseline, widthVal, heightValue, ratioString);
    }

    private int getLayoutDimensionDpValue(String attribute) {
        String value = this.getSherpaAttribute(attribute);
        if ("wrap_content".equalsIgnoreCase(value)) {
            return -2;
        }
        if ("match_parent".equalsIgnoreCase(value)) {
            return -1;
        }
        return ConstraintUtilities.getDpValue(this.mComponent, value);
    }

    private boolean hasBaseline() {
        return null != this.getSherpaAttribute("layout_constraintBaseline_toBaselineOf");
    }

    private String getSherpaAttribute(String attr) {
        return this.mComponent.getLiveAttribute("http://schemas.android.com/apk/res-auto", attr);
    }

    public void updateComponents(@NotNull List<NlComponent> components) {
        if (components == null) {
            WidgetConstraintPanel.$$$reportNull$$$0(1);
        }
        NlComponent nlComponent = this.mComponent = components.isEmpty() ? null : components.get(0);
        if (this.mComponent != null) {
            this.mComponent.addLiveChangeListener(this.myChangeLiveListener);
            this.mConstraintModel = ConstraintModel.getConstraintModel(this.mComponent.getModel());
            this.mScene = this.mConstraintModel.getScene();
            this.mConstraintModel.getSelection().setContinuousListener(e -> this.widgetChanged());
            ConstraintWidget widget = this.mScene.getWidget((Object)this.mComponent);
            if (widget == null) {
                return;
            }
            this.configureUI();
        }
    }

    public boolean isApplicable() {
        if (this.mComponent == null) {
            return false;
        }
        NlComponent parent = this.mComponent.getParent();
        return parent != null && parent.isOrHasSuperclass("android.support.constraint.ConstraintLayout");
    }

    private int getMargin(ConstraintAnchor.Type type) {
        switch (type) {
            case LEFT: {
                return this.getDimension(this.mComponent, "http://schemas.android.com/apk/res/android", "layout_marginLeft");
            }
            case TOP: {
                return this.getDimension(this.mComponent, "http://schemas.android.com/apk/res/android", "layout_marginTop");
            }
            case RIGHT: {
                return this.getDimension(this.mComponent, "http://schemas.android.com/apk/res/android", "layout_marginRight");
            }
            case BOTTOM: {
                return this.getDimension(this.mComponent, "http://schemas.android.com/apk/res/android", "layout_marginBottom");
            }
        }
        return -1;
    }

    private void widgetModified() {
        if (this.mDisableWidgetUpdates) {
            return;
        }
        this.mConstraintModel.getDrawConstraintModels().forEach(DrawConstraintModel::repaint);
        this.saveWidget();
    }

    private void saveWidget() {
        this.mConstraintModel.requestSaveToXML();
    }

    private void setMargin(ConstraintAnchor.Type type, int margin) {
        switch (type) {
            case LEFT: {
                this.setDimension(this.mComponent, "http://schemas.android.com/apk/res/android", "layout_marginLeft", margin);
                break;
            }
            case TOP: {
                this.setDimension(this.mComponent, "http://schemas.android.com/apk/res/android", "layout_marginTop", margin);
                break;
            }
            case RIGHT: {
                this.setDimension(this.mComponent, "http://schemas.android.com/apk/res/android", "layout_marginRight", margin);
                break;
            }
            case BOTTOM: {
                this.setDimension(this.mComponent, "http://schemas.android.com/apk/res/android", "layout_marginBottom", margin);
            }
        }
        this.widgetModified();
    }

    private void killConstraint(ConstraintAnchor.Type type) {
        switch (type) {
            case LEFT: {
                this.removeAttribute(0);
                break;
            }
            case TOP: {
                this.removeAttribute(2);
                break;
            }
            case RIGHT: {
                this.removeAttribute(1);
                break;
            }
            case BOTTOM: {
                this.removeAttribute(3);
                break;
            }
            case BASELINE: {
                this.removeAttribute(4);
            }
        }
    }

    public void setHorizontalBias() {
        float bias = (float)this.mHorizontalSlider.getValue() / 100.0f;
        NlComponent component = this.mComponent;
        if (NlComponentUtils.isHorizontalChain(this.mComponent)) {
            component = NlComponentUtils.getLeftMostInChain(this.mComponent);
        }
        this.setSherpaAttribute("layout_constraintHorizontal_bias", Float.toString(bias));
    }

    public void setVerticalBias() {
        float bias = 1.0f - (float)this.mVerticalSlider.getValue() / 100.0f;
        NlComponent component = this.mComponent;
        if (NlComponentUtils.isVerticalChain(this.mComponent)) {
            component = NlComponentUtils.getTopMostInChain(this.mComponent);
        }
        this.setSherpaAttribute("layout_constraintVertical_bias", Float.toString(bias));
    }

    public void setTopMargin(int margin) {
        this.setDimension(this.mComponent, "http://schemas.android.com/apk/res/android", "layout_marginTop", margin);
    }

    public void setLeftMargin(int margin) {
        this.setDimension(this.mComponent, "http://schemas.android.com/apk/res/android", "layout_marginLeft", margin);
    }

    public void setRightMargin(int margin) {
        this.setDimension(this.mComponent, "http://schemas.android.com/apk/res/android", "layout_marginRight", margin);
    }

    public void setBottomMargin(int margin) {
        this.setDimension(this.mComponent, "http://schemas.android.com/apk/res/android", "layout_marginBottom", margin);
    }

    public void killTopConstraint() {
        this.killConstraint(ConstraintAnchor.Type.TOP);
    }

    public void killLeftConstraint() {
        this.killConstraint(ConstraintAnchor.Type.LEFT);
    }

    public void killRightConstraint() {
        this.killConstraint(ConstraintAnchor.Type.RIGHT);
    }

    public void killBottomConstraint() {
        this.killConstraint(ConstraintAnchor.Type.BOTTOM);
    }

    public void killBaselineConstraint() {
        this.killConstraint(ConstraintAnchor.Type.BASELINE);
    }

    public void setHorizontalConstraint(int horizontalConstraint) {
        String width = this.mComponent.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_width");
        if (width.endsWith("dp") && !width.equals(SIZE_ANY)) {
            this.mComponent.putClientProperty("layout_width", width);
        }
        switch (horizontalConstraint) {
            case 1: {
                this.setAndroidAttribute("layout_width", SIZE_ANY);
                break;
            }
            case 0: {
                String oldValue = (String)this.mComponent.getClientProperty("layout_width");
                if (oldValue == null) {
                    float dipValue = (float)this.mComponent.getModel().getConfiguration().getDensity().getDpiValue() / 160.0f;
                    oldValue = (int)(0.5f + (float)this.mComponent.w / dipValue) + "dp";
                }
                this.setAndroidAttribute("layout_width", oldValue);
                break;
            }
            case 2: {
                this.setAndroidAttribute("layout_width", "wrap_content");
            }
        }
    }

    public void setVerticalConstraint(int verticalConstraint) {
        String height = this.mComponent.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_height");
        if (height.endsWith("dp") && !height.equals(SIZE_ANY)) {
            this.mComponent.putClientProperty("layout_height", height);
        }
        switch (verticalConstraint) {
            case 1: {
                this.setAndroidAttribute("layout_height", SIZE_ANY);
                break;
            }
            case 0: {
                String oldValue = (String)this.mComponent.getClientProperty("layout_height");
                if (oldValue == null) {
                    float dipValue = (float)this.mComponent.getModel().getConfiguration().getDensity().getDpiValue() / 160.0f;
                    oldValue = (int)(0.5f + (float)this.mComponent.h / dipValue) + "dp";
                }
                this.setAndroidAttribute("layout_height", oldValue);
                break;
            }
            case 2: {
                this.setAndroidAttribute("layout_height", "wrap_content");
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "components";
        objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/WidgetConstraintPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "updateComponents";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class WidgetSliderUI
    extends BasicSliderUI {
        static final int thumbSize = 22;
        private static Font sSmallFont = new Font("Helvetica", 0, 10);
        ColorSet mColorSet;

        WidgetSliderUI(JSlider s, ColorSet colorSet) {
            super(s);
            this.mColorSet = colorSet;
        }

        @Override
        protected Dimension getThumbSize() {
            return new Dimension(22, 22);
        }

        @Override
        public void paintTrack(Graphics g) {
            if (this.slider.isEnabled()) {
                super.paintTrack(g);
            }
        }

        @Override
        protected Color getShadowColor() {
            return this.mColorSet.getInspectorStrokeColor();
        }

        @Override
        protected Color getHighlightColor() {
            return this.mColorSet.getInspectorStrokeColor();
        }

        @Override
        protected Color getFocusColor() {
            return new Color(0, 0, 0, 0);
        }

        @Override
        public void paintThumb(Graphics g) {
            String percentText = this.slider.getOrientation() == 1 ? Integer.toString(100 - this.slider.getValue()) : Integer.toString(this.slider.getValue());
            if (!this.slider.isEnabled()) {
                return;
            }
            g.setColor(this.mColorSet.getInspectorFillColor());
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.fillRoundRect(this.thumbRect.x + 1, this.thumbRect.y + 1, this.thumbRect.width - 2, this.thumbRect.height - 2, this.thumbRect.width - 2, this.thumbRect.height - 2);
            g.setColor(this.mColorSet.getInspectorStrokeColor());
            g.drawRoundRect(this.thumbRect.x + 1, this.thumbRect.y + 1, this.thumbRect.width - 2, this.thumbRect.height - 2, this.thumbRect.width - 2, this.thumbRect.height - 2);
            int x = this.thumbRect.x + this.thumbRect.width / 2;
            int y = this.thumbRect.y + this.thumbRect.height / 2 - 1;
            g.setFont(sSmallFont);
            FontMetrics fm = g.getFontMetrics();
            Rectangle2D bounds = fm.getStringBounds(percentText, g);
            double tw = bounds.getWidth();
            g.setColor(this.mColorSet.getInspectorStrokeColor());
            g.drawString(percentText, (int)((double)x - tw / 2.0), y + fm.getAscent() / 2);
        }
    }

    static class InspectorColorSet
    extends BlueprintColorSet {
        InspectorColorSet() {
            this.mDrawBackground = false;
            this.mDrawWidgetInfos = true;
            this.mInspectorBackgroundColor = new JBColor(0xE8E8E8, 3948353);
            this.mInspectorFillColor = new JBColor(0xDCDCDC, 4540746);
            this.mInspectorHighlightsStrokeColor = JBColor.border();
            this.mInspectorStrokeColor = JBColor.foreground();
            this.mInspectorConstraintColor = new JBColor(4489688, 4751560);
        }
    }
}

