/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.preference;

import com.android.tools.idea.uibuilder.api.DragType;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.graphics.NlDrawingStyle;
import com.android.tools.idea.uibuilder.graphics.NlGraphics;
import com.android.tools.idea.uibuilder.handlers.preference.PreferenceGroupDragHandler;
import com.android.tools.idea.uibuilder.model.NlComponent;
import java.awt.Rectangle;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PreferenceScreenDragHandler
extends PreferenceGroupDragHandler {
    private final NlComponent myInitialGroup;
    private final Map<NlComponent, Rectangle> myInitialPreferenceToBoundsMap;

    PreferenceScreenDragHandler(@NotNull ViewEditor editor, @NotNull ViewGroupHandler handler, @NotNull NlComponent group, @NotNull List<NlComponent> preferences, @NotNull DragType type) {
        if (editor == null) {
            PreferenceScreenDragHandler.$$$reportNull$$$0(0);
        }
        if (handler == null) {
            PreferenceScreenDragHandler.$$$reportNull$$$0(1);
        }
        if (group == null) {
            PreferenceScreenDragHandler.$$$reportNull$$$0(2);
        }
        if (preferences == null) {
            PreferenceScreenDragHandler.$$$reportNull$$$0(3);
        }
        if (type == null) {
            PreferenceScreenDragHandler.$$$reportNull$$$0(4);
        }
        super(editor, handler, group, preferences, type);
        this.myInitialGroup = group;
        this.myInitialPreferenceToBoundsMap = this.getPreferenceToBoundsMap(group);
    }

    @Override
    @Nullable
    public String update(int x, int y, int modifiers) {
        String message = super.update(x, y, modifiers);
        if (message != null) {
            return message;
        }
        if (this.myGroup.getChildren().isEmpty()) {
            return null;
        }
        Optional<NlComponent> category = this.myInitialPreferenceToBoundsMap.keySet().stream().filter(preference -> preference.getTagName().equals("PreferenceCategory") && this.myInitialPreferenceToBoundsMap.get(preference).contains(x, y)).findFirst();
        if (category.isPresent()) {
            if (this.myGroup != category.get()) {
                this.myGroup = category.get();
                this.myPreferenceToBoundsMap = this.getPreferenceToBoundsMap(this.myGroup);
                this.layout = this.myGroup;
            }
        } else if (this.myGroup != this.myInitialGroup) {
            this.myGroup = this.myInitialGroup;
            this.myPreferenceToBoundsMap = this.myInitialPreferenceToBoundsMap;
            this.layout = this.myInitialGroup;
        }
        this.updateActivePreference();
        return null;
    }

    @Override
    void drawDropPreviewLine(@NotNull NlGraphics graphics) {
        if (graphics == null) {
            PreferenceScreenDragHandler.$$$reportNull$$$0(5);
        }
        if (!this.myGroup.getChildren().isEmpty()) {
            super.drawDropPreviewLine(graphics);
        }
    }

    @Override
    void drawDropRecipientLines(@NotNull NlGraphics graphics) {
        List<NlComponent> preferences;
        if (graphics == null) {
            PreferenceScreenDragHandler.$$$reportNull$$$0(6);
        }
        if ((preferences = this.myGroup.getChildren()).isEmpty()) {
            return;
        }
        graphics.useStyle(NlDrawingStyle.DROP_RECIPIENT);
        Rectangle bounds = this.getBounds(this.myGroup);
        if (this.lastY >= this.getMidpointY(preferences.get(0)) || this.myGroup.getTagName().equals("PreferenceCategory")) {
            graphics.drawTop(bounds);
        }
        graphics.drawLeft(bounds);
        graphics.drawRight(bounds);
        if (this.lastY < this.getMidpointY(preferences.get(preferences.size() - 1))) {
            graphics.drawBottom(bounds);
        }
    }

    @Override
    void drawDropZoneLines(@NotNull NlGraphics graphics) {
        if (graphics == null) {
            PreferenceScreenDragHandler.$$$reportNull$$$0(7);
        }
        this.drawDropZoneLines(graphics, this.myGroup.getTagName().equals("PreferenceCategory") ? 0 : 1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferences";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphics";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/preference/PreferenceScreenDragHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "drawDropPreviewLine";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "drawDropRecipientLines";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "drawDropZoneLines";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

