/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.palette;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationListener;
import com.android.tools.idea.rendering.ImageUtils;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.res.ResourceNotificationManager;
import com.android.tools.idea.uibuilder.palette.DependencyManager;
import com.android.tools.idea.uibuilder.palette.IconPreviewFactory;
import com.android.tools.idea.uibuilder.palette.ItemTransferHandler;
import com.android.tools.idea.uibuilder.palette.Palette;
import com.android.tools.idea.uibuilder.surface.DesignSurface;
import com.android.tools.idea.uibuilder.surface.PanZoomListener;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.AdjustmentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlPreviewImagePanel
extends JComponent
implements Disposable {
    private static final int BORDER_WIDTH = 10;
    private final IconPreviewFactory myIconPreviewFactory;
    private final DependencyManager myDependencyManager;
    private final Runnable myCloseAutoHideCallback;
    private final ConfigurationListener myConfigurationListener;
    private final ResourceNotificationManager.ResourceChangeListener myResourceChangeListener;
    private final PanZoomListener myZoomListener;
    private DesignSurface myDesignSurface;
    private Palette.Item myItem;
    private BufferedImage myImage;
    private boolean myPreviewGenerationDone;
    private boolean myKeepImageScaledToMatchPanelWidth;
    private int myLastWidth;

    public NlPreviewImagePanel(@NotNull IconPreviewFactory iconFactory, @NotNull DependencyManager dependencyManager, @NotNull Runnable closeAutoHideCallback) {
        if (iconFactory == null) {
            NlPreviewImagePanel.$$$reportNull$$$0(0);
        }
        if (dependencyManager == null) {
            NlPreviewImagePanel.$$$reportNull$$$0(1);
        }
        if (closeAutoHideCallback == null) {
            NlPreviewImagePanel.$$$reportNull$$$0(2);
        }
        this.myIconPreviewFactory = iconFactory;
        this.myDependencyManager = dependencyManager;
        this.myCloseAutoHideCallback = closeAutoHideCallback;
        this.myResourceChangeListener = reason -> this.invalidateUI();
        this.myConfigurationListener = flags -> {
            this.invalidateUI();
            return true;
        };
        this.myZoomListener = new PanZoomListener(){

            @Override
            public void zoomChanged(DesignSurface designSurface) {
                NlPreviewImagePanel.this.invalidateUI();
            }

            @Override
            public void panningChanged(AdjustmentEvent adjustmentEvent) {
            }
        };
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                if (NlPreviewImagePanel.this.myItem == null) {
                    return;
                }
                if (!NlPreviewImagePanel.this.myDependencyManager.needsLibraryLoad(NlPreviewImagePanel.this.myItem)) {
                    TransferHandler handler = NlPreviewImagePanel.this.getTransferHandler();
                    if (handler != null) {
                        NlPreviewImagePanel.this.myCloseAutoHideCallback.run();
                        handler.exportAsDrag(NlPreviewImagePanel.this, event, 1);
                    }
                } else {
                    NlPreviewImagePanel.this.myDependencyManager.ensureLibraryIsIncluded(NlPreviewImagePanel.this.myItem);
                }
            }
        });
    }

    public void dispose() {
        this.setDesignSurface(null);
        this.setTransferHandler(null);
    }

    private void invalidateUI() {
        this.myImage = null;
        this.myPreviewGenerationDone = false;
        this.repaint();
    }

    public void setItem(@Nullable Palette.Item item) {
        this.myItem = item;
        this.invalidateUI();
    }

    @Nullable
    private Palette.Item getItem() {
        return this.myItem;
    }

    public void setDesignSurface(@Nullable DesignSurface designSurface) {
        Configuration newConfiguration;
        Configuration oldConfiguration;
        Module oldModule = null;
        Configuration configuration = oldConfiguration = this.myDesignSurface != null ? this.myDesignSurface.getConfiguration() : null;
        if (oldConfiguration != null) {
            oldModule = oldConfiguration.getModule();
            oldConfiguration.removeListener(this.myConfigurationListener);
        }
        if (this.myDesignSurface != null) {
            this.myDesignSurface.removePanZoomListener(this.myZoomListener);
        }
        this.myDesignSurface = designSurface;
        Module newModule = null;
        Configuration configuration2 = newConfiguration = this.myDesignSurface != null ? this.myDesignSurface.getConfiguration() : null;
        if (newConfiguration != null) {
            newModule = newConfiguration.getModule();
            newConfiguration.addListener(this.myConfigurationListener);
        }
        if (this.myDesignSurface != null) {
            this.myDesignSurface.addPanZoomListener(this.myZoomListener);
        }
        if (newModule != oldModule) {
            AndroidFacet newFacet;
            AndroidFacet oldFacet;
            ResourceNotificationManager manager = ResourceNotificationManager.getInstance(this.myDependencyManager.getProject());
            AndroidFacet androidFacet = oldFacet = oldModule != null ? AndroidFacet.getInstance(oldModule) : null;
            if (oldFacet != null) {
                manager.removeListener(this.myResourceChangeListener, oldFacet, null, null);
            }
            AndroidFacet androidFacet2 = newFacet = newModule != null ? AndroidFacet.getInstance(newModule) : null;
            if (newFacet != null) {
                manager.addListener(this.myResourceChangeListener, newFacet, null, null);
            }
        }
        this.myImage = null;
        this.myPreviewGenerationDone = false;
        this.setTransferHandler(designSurface != null ? new ItemTransferHandler(this.myDesignSurface, this::getItem, this.myIconPreviewFactory) : null);
        this.invalidateUI();
    }

    @Override
    public void paintComponent(@NotNull Graphics graphics) {
        BufferedImage cachedImage;
        if (graphics == null) {
            NlPreviewImagePanel.$$$reportNull$$$0(3);
        }
        if ((cachedImage = this.getPreviewImage()) != null) {
            int xDiff = Math.max(0, this.getWidth() - cachedImage.getWidth());
            int yDiff = Math.max(0, this.getHeight() - cachedImage.getHeight());
            int xMargin = Math.min(10, Math.max(0, xDiff - 20) / 2);
            int yMargin = Math.min(10, Math.max(0, yDiff - 20) / 2);
            graphics.setColor(this.getBackgroundColor());
            graphics.fillRect(xMargin, yMargin, this.getWidth() - 2 * xMargin, this.getHeight() - 2 * yMargin);
            UIUtil.drawImage((Graphics)graphics, (Image)cachedImage, (int)(xDiff / 2), (int)(yDiff / 2), (ImageObserver)this);
            if (cachedImage.getHeight() > this.getHeight() && graphics instanceof Graphics2D) {
                int width = Math.min(this.getWidth(), cachedImage.getWidth());
                int height = Math.min(this.getHeight(), cachedImage.getHeight());
                Graphics2D g2 = (Graphics2D)graphics;
                Color color = this.getBackground();
                g2.setPaint(new GradientPaint(new Point(0, height / 8), new Color(color.getRed(), color.getGreen(), color.getBlue(), 0), new Point(0, height), new Color(color.getRed(), color.getGreen(), color.getBlue(), 220)));
                g2.fillRect(xDiff / 2, 0, width, height);
            }
        } else if (this.myItem != null) {
            Icon icon = this.myDependencyManager.createLargeItemIcon(this.myItem, this);
            int x = Math.max(0, (this.getWidth() - icon.getIconWidth()) / 2);
            int y = Math.max(0, (this.getHeight() - icon.getIconWidth()) / 2);
            icon.paintIcon(this, graphics, x, y);
        }
    }

    @NotNull
    private Color getBackgroundColor() {
        ResourceResolver resolver;
        Configuration configuration = this.myDesignSurface != null ? this.myDesignSurface.getConfiguration() : null;
        ResourceResolver resourceResolver = resolver = configuration != null ? configuration.getResourceResolver() : null;
        if (resolver == null) {
            Color color = UIUtil.getPanelBackground();
            if (color == null) {
                NlPreviewImagePanel.$$$reportNull$$$0(4);
            }
            return color;
        }
        ResourceValue windowBackground = resolver.findItemInTheme("colorBackground", true);
        Color background = ResourceHelper.resolveColor((RenderResources)resolver, windowBackground, this.myDesignSurface.getProject());
        Color color = background != null ? background : UIUtil.getPanelBackground();
        if (color == null) {
            NlPreviewImagePanel.$$$reportNull$$$0(5);
        }
        return color;
    }

    @Nullable
    private BufferedImage getPreviewImage() {
        if (this.myPreviewGenerationDone && (this.myImage == null || this.myImage.getWidth() <= this.getWidth() && (!this.myKeepImageScaledToMatchPanelWidth || this.myLastWidth == this.getWidth()))) {
            return this.myImage;
        }
        this.myLastWidth = this.getWidth();
        this.myPreviewGenerationDone = true;
        if (this.myItem == null || this.myDesignSurface == null) {
            return null;
        }
        ScreenView screenView = this.myDesignSurface.getCurrentScreenView();
        if (screenView == null) {
            return null;
        }
        BufferedImage image = this.myIconPreviewFactory.renderDragImage(this.myItem, screenView);
        if (image == null) {
            return null;
        }
        double factor = ImageUtils.supportsRetina() ? 2.0 : 1.0;
        double scale = factor * this.myDesignSurface.getScale();
        boolean bl = this.myKeepImageScaledToMatchPanelWidth = (double)image.getWidth() * scale > (double)this.getWidth() * factor;
        if (this.myKeepImageScaledToMatchPanelWidth) {
            scale = factor * (double)this.getWidth() / (double)image.getWidth();
        }
        image = ImageUtils.scale(image, scale);
        this.myImage = ImageUtils.convertToRetinaIgnoringFailures(image);
        return this.myImage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iconFactory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closeAutoHideCallback";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphics";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/palette/NlPreviewImagePanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/palette/NlPreviewImagePanel";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackgroundColor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "paintComponent";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

