/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.facet;

import com.android.tools.idea.gradle.variant.view.BuildVariantView;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.res.ProjectResourceRepositoryRootListener;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.hash.HashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.android.maven.AndroidMavenUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleProperties;

public class ResourceFolderManager
implements ModificationTracker {
    private final AndroidFacet myFacet;
    private List<VirtualFile> myResDirCache;
    private long myGeneration;
    private final List<ResourceFolderListener> myListeners = Lists.newArrayList();
    private boolean myVariantListenerAdded;

    ResourceFolderManager(AndroidFacet facet) {
        this.myFacet = facet;
    }

    public void invalidate() {
        List<VirtualFile> old = this.myResDirCache;
        if (old == null) {
            return;
        }
        this.myResDirCache = null;
        this.getFolders();
        if (!old.equals(this.myResDirCache)) {
            this.notifyChanged(old, this.myResDirCache);
        }
    }

    @NotNull
    public List<VirtualFile> getFolders() {
        if (this.myResDirCache == null) {
            this.myResDirCache = this.computeFolders();
        }
        List<VirtualFile> list = this.myResDirCache;
        if (list == null) {
            ResourceFolderManager.$$$reportNull$$$0(0);
        }
        return list;
    }

    private List<VirtualFile> computeFolders() {
        if (this.myFacet.requiresAndroidModel()) {
            JpsAndroidModuleProperties state = ((AndroidFacetConfiguration)this.myFacet.getConfiguration()).getState();
            AndroidModel androidModel = this.myFacet.getAndroidModel();
            ArrayList<VirtualFile> resDirectories = new ArrayList<VirtualFile>();
            if (androidModel == null) {
                if (state != null) {
                    String path = state.RES_FOLDERS_RELATIVE_PATH;
                    if (path != null) {
                        VirtualFileManager manager = VirtualFileManager.getInstance();
                        for (String url : Splitter.on((char)';').omitEmptyStrings().trimResults().split((CharSequence)path)) {
                            VirtualFile dir = manager.findFileByUrl(url);
                            if (dir == null) continue;
                            resDirectories.add(dir);
                        }
                    } else {
                        String mainRes = "/src/main/res";
                        VirtualFile dir = AndroidRootUtil.getFileByRelativeModulePath(this.myFacet.getModule(), mainRes, true);
                        if (dir != null) {
                            resDirectories.add(dir);
                        } else {
                            String res = "/res";
                            dir = AndroidRootUtil.getFileByRelativeModulePath(this.myFacet.getModule(), res, true);
                            if (dir != null) {
                                resDirectories.add(dir);
                            }
                        }
                    }
                }
            } else {
                for (IdeaSourceProvider provider : IdeaSourceProvider.getCurrentSourceProviders(this.myFacet)) {
                    resDirectories.addAll(provider.getResDirectories());
                }
                if (state != null) {
                    StringBuilder path = new StringBuilder(400);
                    for (VirtualFile dir : resDirectories) {
                        if (path.length() != 0) {
                            path.append(';');
                        }
                        path.append(dir.getUrl());
                    }
                    state.RES_FOLDERS_RELATIVE_PATH = path.toString();
                }
                if (!this.myVariantListenerAdded) {
                    this.myVariantListenerAdded = true;
                    BuildVariantView.getInstance(this.myFacet.getModule().getProject()).addListener(this::invalidate);
                }
            }
            ProjectResourceRepositoryRootListener.ensureSubscribed(this.myFacet.getModule().getProject());
            return resDirectories;
        }
        return new ArrayList<VirtualFile>(this.myFacet.getMainIdeaSourceProvider().getResDirectories());
    }

    private void notifyChanged(@NotNull List<VirtualFile> before, @NotNull List<VirtualFile> after) {
        if (before == null) {
            ResourceFolderManager.$$$reportNull$$$0(1);
        }
        if (after == null) {
            ResourceFolderManager.$$$reportNull$$$0(2);
        }
        ++this.myGeneration;
        HashSet added = new HashSet(after.size());
        added.addAll(after);
        added.removeAll(before);
        HashSet removed = new HashSet(before.size());
        removed.addAll(before);
        removed.removeAll(after);
        for (ResourceFolderListener listener : new ArrayList<ResourceFolderListener>(this.myListeners)) {
            listener.resourceFoldersChanged(this.myFacet, after, (Collection<VirtualFile>)added, (Collection<VirtualFile>)removed);
        }
    }

    public long getModificationCount() {
        return this.myGeneration;
    }

    public synchronized void addListener(@NotNull ResourceFolderListener listener) {
        if (listener == null) {
            ResourceFolderManager.$$$reportNull$$$0(3);
        }
        this.myListeners.add(listener);
    }

    public synchronized void removeListener(@NotNull ResourceFolderListener listener) {
        if (listener == null) {
            ResourceFolderManager.$$$reportNull$$$0(4);
        }
        this.myListeners.remove(listener);
    }

    public static void addAarsFromModuleLibraries(@NotNull AndroidFacet facet, @NotNull Map<File, String> dirs) {
        OrderEntry[] orderEntries;
        if (facet == null) {
            ResourceFolderManager.$$$reportNull$$$0(5);
        }
        if (dirs == null) {
            ResourceFolderManager.$$$reportNull$$$0(6);
        }
        Module module = facet.getModule();
        for (OrderEntry orderEntry : orderEntries = ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
            if (!(orderEntry instanceof LibraryOrSdkOrderEntry) || !orderEntry.isValid() || !ResourceFolderManager.isAarDependency(facet, orderEntry)) continue;
            LibraryOrSdkOrderEntry entry = (LibraryOrSdkOrderEntry)orderEntry;
            VirtualFile[] libClasses = entry.getRootFiles(OrderRootType.CLASSES);
            String libraryName = entry.getPresentableName();
            File res = null;
            for (VirtualFile root : libClasses) {
                if (!root.getName().equals("res")) continue;
                res = VfsUtilCore.virtualToIoFile((VirtualFile)root);
                break;
            }
            if (res == null) {
                for (VirtualFile root : libClasses) {
                    File file = new File(VfsUtilCore.virtualToIoFile((VirtualFile)root).getParentFile(), "res");
                    if (!file.exists()) continue;
                    res = file;
                    break;
                }
            }
            if (res == null) continue;
            dirs.put(res, libraryName);
        }
    }

    private static boolean isAarDependency(@NotNull AndroidFacet facet, @NotNull OrderEntry orderEntry) {
        if (facet == null) {
            ResourceFolderManager.$$$reportNull$$$0(7);
        }
        if (orderEntry == null) {
            ResourceFolderManager.$$$reportNull$$$0(8);
        }
        if (facet.requiresAndroidModel() && orderEntry instanceof LibraryOrderEntry) {
            VirtualFile[] files = orderEntry.getFiles(OrderRootType.CLASSES);
            if (files.length >= 2) {
                for (VirtualFile file : files) {
                    if (!"res".equals(file.getName()) || !file.isDirectory()) continue;
                    return true;
                }
            }
            return false;
        }
        return AndroidMavenUtil.isMavenAarDependency(facet.getModule(), orderEntry);
    }

    public static boolean isLibraryResourceFile(@Nullable VirtualFile file) {
        if (file != null) {
            return ResourceFolderManager.isLibraryResourceFolder(file.getParent());
        }
        return false;
    }

    public static boolean isLibraryResourceFolder(@Nullable VirtualFile folder) {
        if (folder != null) {
            return ResourceFolderManager.isLibraryResourceRoot(folder.getParent());
        }
        return false;
    }

    public static boolean isLibraryResourceRoot(@Nullable VirtualFile res) {
        String name;
        VirtualFile exploded;
        VirtualFile aar;
        return res != null && (aar = res.getParent()) != null && (exploded = aar.getParent()) != null && (name = exploded.getName()).equals("exploded-aar");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/facet/ResourceFolderManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "before";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "after";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirs";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFolders";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/facet/ResourceFolderManager";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "notifyChanged";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addAarsFromModuleLibraries";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isAarDependency";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ResourceFolderListener {
        public void resourceFoldersChanged(@NotNull AndroidFacet var1, @NotNull List<VirtualFile> var2, @NotNull Collection<VirtualFile> var3, @NotNull Collection<VirtualFile> var4);
    }
}

