/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.Callable;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.intrinsics.JavaClassProperty;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

public class CallReceiver
extends StackValue {
    private final StackValue dispatchReceiver;
    private final StackValue extensionReceiver;
    private final Type secondReceiverType;

    private CallReceiver(@NotNull StackValue dispatchReceiver, @NotNull StackValue extensionReceiver, @NotNull Type type2, @Nullable Type secondReceiverType) {
        if (dispatchReceiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dispatchReceiver", "org/jetbrains/kotlin/codegen/CallReceiver", "<init>"));
        }
        if (extensionReceiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionReceiver", "org/jetbrains/kotlin/codegen/CallReceiver", "<init>"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/CallReceiver", "<init>"));
        }
        super(type2, dispatchReceiver.canHaveSideEffects() || extensionReceiver.canHaveSideEffects());
        this.dispatchReceiver = dispatchReceiver;
        this.extensionReceiver = extensionReceiver;
        this.secondReceiverType = secondReceiverType;
    }

    public StackValue withoutReceiverArgument() {
        return new CallReceiver(this.dispatchReceiver, CallReceiver.none(), this.type, this.secondReceiverType);
    }

    public static StackValue generateCallReceiver(@NotNull ResolvedCall<?> resolvedCall2, @NotNull ExpressionCodegen codegen, @Nullable Callable callableMethod, @Nullable ReceiverParameterDescriptor dispatchReceiverParameter, @NotNull StackValue dispatchReceiver, @Nullable ReceiverParameterDescriptor extensionReceiverParameter, @NotNull StackValue extensionReceiver) {
        Type type2;
        if (resolvedCall2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/codegen/CallReceiver", "generateCallReceiver"));
        }
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/CallReceiver", "generateCallReceiver"));
        }
        if (dispatchReceiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dispatchReceiver", "org/jetbrains/kotlin/codegen/CallReceiver", "generateCallReceiver"));
        }
        if (extensionReceiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionReceiver", "org/jetbrains/kotlin/codegen/CallReceiver", "generateCallReceiver"));
        }
        KotlinTypeMapper typeMapper = codegen.typeMapper;
        GenerationState state = codegen.getState();
        Type secondReceiverType = null;
        if (extensionReceiverParameter != null) {
            type2 = CallReceiver.calcExtensionReceiverType(resolvedCall2, extensionReceiverParameter, typeMapper, callableMethod, state);
            if (dispatchReceiverParameter != null) {
                secondReceiverType = CallReceiver.calcDispatchReceiverType(resolvedCall2, dispatchReceiverParameter, typeMapper, callableMethod);
            }
        } else {
            type2 = dispatchReceiverParameter != null ? CallReceiver.calcDispatchReceiverType(resolvedCall2, dispatchReceiverParameter, typeMapper, callableMethod) : (CallReceiver.isLocalFunCall(callableMethod) ? callableMethod.getGenerateCalleeType() : Type.VOID_TYPE);
        }
        assert (type2 != null) : "Could not map receiver type for " + resolvedCall2;
        return new CallReceiver(dispatchReceiver, extensionReceiver, type2, secondReceiverType);
    }

    private static Type calcDispatchReceiverType(@NotNull ResolvedCall<?> resolvedCall2, @Nullable ReceiverParameterDescriptor dispatchReceiver, @NotNull KotlinTypeMapper typeMapper, @Nullable Callable callableMethod) {
        if (resolvedCall2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/codegen/CallReceiver", "calcDispatchReceiverType"));
        }
        if (typeMapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMapper", "org/jetbrains/kotlin/codegen/CallReceiver", "calcDispatchReceiverType"));
        }
        if (dispatchReceiver == null) {
            return null;
        }
        Object descriptor2 = resolvedCall2.getResultingDescriptor();
        if (CodegenUtilKt.isJvmStaticInObjectOrClass(descriptor2)) {
            return Type.VOID_TYPE;
        }
        if (callableMethod != null) {
            return callableMethod.getDispatchReceiverType();
        }
        DeclarationDescriptor container2 = descriptor2.getContainingDeclaration();
        if (container2 instanceof ClassDescriptor) {
            return typeMapper.mapClass((ClassDescriptor)container2);
        }
        return typeMapper.mapType(dispatchReceiver);
    }

    private static Type calcExtensionReceiverType(@NotNull ResolvedCall<?> resolvedCall2, @Nullable ReceiverParameterDescriptor extensionReceiver, @NotNull KotlinTypeMapper typeMapper, @Nullable Callable callableMethod, @NotNull GenerationState state) {
        if (resolvedCall2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/codegen/CallReceiver", "calcExtensionReceiverType"));
        }
        if (typeMapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMapper", "org/jetbrains/kotlin/codegen/CallReceiver", "calcExtensionReceiverType"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/CallReceiver", "calcExtensionReceiverType"));
        }
        if (extensionReceiver == null) {
            return null;
        }
        Object descriptor2 = resolvedCall2.getCandidateDescriptor();
        if (descriptor2 instanceof PropertyDescriptor && state.getIntrinsics().getIntrinsic((PropertyDescriptor)descriptor2) != JavaClassProperty.INSTANCE) {
            ReceiverParameterDescriptor receiverCandidate = descriptor2.getExtensionReceiverParameter();
            assert (receiverCandidate != null);
            return typeMapper.mapType(receiverCandidate.getType());
        }
        return callableMethod != null ? callableMethod.getExtensionReceiverType() : typeMapper.mapType(extensionReceiver.getType());
    }

    @Override
    public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
        boolean hasExtensionReceiver;
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/CallReceiver", "putSelector"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/CallReceiver", "putSelector"));
        }
        StackValue currentExtensionReceiver = this.extensionReceiver;
        boolean bl = hasExtensionReceiver = this.extensionReceiver != CallReceiver.none();
        if (this.extensionReceiver instanceof StackValue.SafeCall) {
            currentExtensionReceiver.put(currentExtensionReceiver.type, v);
            currentExtensionReceiver = StackValue.onStack(currentExtensionReceiver.type);
        }
        Type dispatchReceiverType = this.secondReceiverType != null ? this.secondReceiverType : (hasExtensionReceiver ? this.dispatchReceiver.type : type2);
        this.dispatchReceiver.put(dispatchReceiverType, v);
        currentExtensionReceiver.moveToTopOfStack(hasExtensionReceiver ? type2 : currentExtensionReceiver.type, v, dispatchReceiverType.getSize());
    }

    @Override
    public void dup(@NotNull InstructionAdapter v, boolean withReceiver2) {
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/CallReceiver", "dup"));
        }
        AsmUtil.dup(v, this.extensionReceiver.type, this.dispatchReceiver.type);
    }

    @NotNull
    public StackValue getDispatchReceiver() {
        StackValue stackValue = this.dispatchReceiver;
        if (stackValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/CallReceiver", "getDispatchReceiver"));
        }
        return stackValue;
    }

    @NotNull
    public StackValue getExtensionReceiver() {
        StackValue stackValue = this.extensionReceiver;
        if (stackValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/CallReceiver", "getExtensionReceiver"));
        }
        return stackValue;
    }
}

