/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.range.forLoop;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.range.forLoop.AbstractForLoopGenerator;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/codegen/range/forLoop/ForInArrayLoopGenerator;", "Lorg/jetbrains/kotlin/codegen/range/forLoop/AbstractForLoopGenerator;", "codegen", "Lorg/jetbrains/kotlin/codegen/ExpressionCodegen;", "forExpression", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "(Lorg/jetbrains/kotlin/codegen/ExpressionCodegen;Lorg/jetbrains/kotlin/psi/KtForExpression;)V", "arrayVar", "", "indexVar", "loopRangeType", "Lorg/jetbrains/kotlin/types/KotlinType;", "assignToLoopParameter", "", "beforeLoop", "checkEmptyLoop", "loopExit", "Lorg/jetbrains/org/objectweb/asm/Label;", "checkPostConditionAndIncrement", "checkPreCondition", "backend"})
public final class ForInArrayLoopGenerator
extends AbstractForLoopGenerator {
    private int indexVar;
    private int arrayVar;
    private final KotlinType loopRangeType;

    @Override
    public void beforeLoop() {
        super.beforeLoop();
        Type type2 = Type.INT_TYPE;
        Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"Type.INT_TYPE");
        this.indexVar = this.createLoopTempVariable(type2);
        KtExpression loopRange = this.getForExpression().getLoopRange();
        StackValue value2 = this.getCodegen().gen(loopRange);
        Type asmLoopRangeType = this.getCodegen().asmType(this.loopRangeType);
        if (value2 instanceof StackValue.Local && Intrinsics.areEqual((Object)value2.type, (Object)asmLoopRangeType)) {
            this.arrayVar = ((StackValue.Local)value2).index;
        } else {
            Type type3 = AsmTypes.OBJECT_TYPE;
            Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"OBJECT_TYPE");
            this.arrayVar = this.createLoopTempVariable(type3);
            value2.put(asmLoopRangeType, this.getV());
            this.getV().store(this.arrayVar, AsmTypes.OBJECT_TYPE);
        }
        this.getV().iconst(0);
        this.getV().store(this.indexVar, Type.INT_TYPE);
    }

    @Override
    public void checkEmptyLoop(@NotNull Label loopExit) {
        Intrinsics.checkParameterIsNotNull((Object)loopExit, (String)"loopExit");
    }

    @Override
    public void checkPreCondition(@NotNull Label loopExit) {
        Intrinsics.checkParameterIsNotNull((Object)loopExit, (String)"loopExit");
        this.getV().load(this.indexVar, Type.INT_TYPE);
        this.getV().load(this.arrayVar, AsmTypes.OBJECT_TYPE);
        this.getV().arraylength();
        this.getV().ificmpge(loopExit);
    }

    @Override
    protected void assignToLoopParameter() {
        Type arrayElParamType = KotlinBuiltIns.isArray(this.loopRangeType) ? AsmUtil.boxType(this.getAsmElementType()) : this.getAsmElementType();
        this.getV().load(this.arrayVar, AsmTypes.OBJECT_TYPE);
        this.getV().load(this.indexVar, Type.INT_TYPE);
        this.getV().aload(arrayElParamType);
        StackValue.onStack(arrayElParamType).put(this.getAsmElementType(), this.getCodegen().v);
        this.getV().store(this.getLoopParameterVar(), this.getAsmElementType());
    }

    @Override
    protected void checkPostConditionAndIncrement(@NotNull Label loopExit) {
        Intrinsics.checkParameterIsNotNull((Object)loopExit, (String)"loopExit");
        this.getV().iinc(this.indexVar, 1);
    }

    public ForInArrayLoopGenerator(@NotNull ExpressionCodegen codegen, @NotNull KtForExpression forExpression) {
        Intrinsics.checkParameterIsNotNull((Object)codegen, (String)"codegen");
        Intrinsics.checkParameterIsNotNull((Object)forExpression, (String)"forExpression");
        super(codegen, forExpression);
        BindingContext bindingContext2 = this.getBindingContext();
        KtExpression ktExpression = forExpression.getLoopRange();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        KotlinType kotlinType = bindingContext2.getType(ktExpression);
        if (kotlinType == null) {
            Intrinsics.throwNpe();
        }
        this.loopRangeType = kotlinType;
    }
}

