/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.diagnostics.PositioningStrategy;
import org.jetbrains.kotlin.diagnostics.PositioningStrategyKt;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtConstructorDelegationReferenceExpression;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtImportAlias;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeList;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtWhenConditionInRange;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u00c2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001KB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J'\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010G\u001a\n\u0012\u0006\b\u0001\u0012\u00020I0H\"\u00020IH\u0007\u00a2\u0006\u0002\u0010JR\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00100\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010-\u001a\b\u0012\u0004\u0012\u00020,0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010/\u001a\b\u0012\u0004\u0012\u0002000\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00101\u001a\b\u0012\u0004\u0012\u0002020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00103\u001a\b\u0012\u0004\u0012\u0002040\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00105\u001a\b\u0012\u0004\u0012\u0002060\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00107\u001a\b\u0012\u0004\u0012\u00020\u00140\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00108\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00109\u001a\b\u0012\u0004\u0012\u00020:0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010;\u001a\b\u0012\u0004\u0012\u00020:0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00100\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00120\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010>\u001a\b\u0012\u0004\u0012\u00020?0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010B\u001a\b\u0012\u0004\u0012\u00020C0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010D\u001a\b\u0012\u0004\u0012\u00020E0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Lorg/jetbrains/kotlin/diagnostics/PositioningStrategies;", "", "()V", "ABSTRACT_MODIFIER", "Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "ARRAY_ACCESS", "Lorg/jetbrains/kotlin/psi/KtArrayAccessExpression;", "AS_TYPE", "Lorg/jetbrains/kotlin/psi/KtBinaryExpressionWithTypeRHS;", "CALL_ELEMENT", "Lcom/intellij/psi/PsiElement;", "CALL_EXPRESSION", "COMPANION_OBJECT", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "CUT_CHAR_QUOTES", "Lorg/jetbrains/kotlin/psi/KtElement;", "DECLARATION_NAME", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "DECLARATION_RETURN_TYPE", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "DECLARATION_SIGNATURE", "DECLARATION_SIGNATURE_OR_DEFAULT", "DECLARATION_WITH_BODY", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "DEFAULT", "DELEGATOR_SUPER_CALL", "Lorg/jetbrains/kotlin/psi/KtEnumEntry;", "ELSE_ENTRY", "Lorg/jetbrains/kotlin/psi/KtWhenEntry;", "FOR_REDECLARATION", "FOR_UNRESOLVED_REFERENCE", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "FUNCTION_PARAMETERS", "Lorg/jetbrains/kotlin/psi/KtFunction;", "IMPORT_ALIAS", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "LATEINIT_MODIFIER", "LONG_LITERAL_SUFFIX", "NULLABLE_TYPE", "Lorg/jetbrains/kotlin/psi/KtNullableType;", "OPEN_MODIFIER", "OVERRIDE_MODIFIER", "PARAMETER_DEFAULT_VALUE", "Lorg/jetbrains/kotlin/psi/KtParameter;", "PARAMETER_VARARG_MODIFIER", "PRIVATE_MODIFIER", "RECEIVER", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "RETURN_WITH_LABEL", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "SECONDARY_CONSTRUCTOR_DELEGATION_CALL", "Lorg/jetbrains/kotlin/psi/KtConstructorDelegationCall;", "SPECIAL_CONSTRUCT_TOKEN", "Lorg/jetbrains/kotlin/psi/KtExpression;", "TYPE_PARAMETERS_OR_DECLARATION_SIGNATURE", "UNREACHABLE_CODE", "UNUSED_VALUE", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "USELESS_ELVIS", "VALUE_ARGUMENTS", "VAL_OR_VAR_NODE", "VARIANCE_IN_PROJECTION", "Lorg/jetbrains/kotlin/psi/KtTypeProjection;", "VARIANCE_MODIFIER", "VISIBILITY_MODIFIER", "WHEN_CONDITION_IN_RANGE", "Lorg/jetbrains/kotlin/psi/KtWhenConditionInRange;", "WHEN_EXPRESSION", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "modifierSetPosition", "tokens", "", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "([Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;)Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;", "DeclarationHeader", "frontend"})
public final class PositioningStrategies {
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> DEFAULT;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtDeclaration> DECLARATION_RETURN_TYPE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtNamedDeclaration> DECLARATION_NAME;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtDeclaration> DECLARATION_SIGNATURE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> DECLARATION_SIGNATURE_OR_DEFAULT;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtDeclaration> TYPE_PARAMETERS_OR_DECLARATION_SIGNATURE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> ABSTRACT_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> OPEN_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> OVERRIDE_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> PRIVATE_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> LATEINIT_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> VARIANCE_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> FOR_REDECLARATION;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtReferenceExpression> FOR_UNRESOLVED_REFERENCE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtArrayAccessExpression> ARRAY_ACCESS;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> VISIBILITY_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtTypeProjection> VARIANCE_IN_PROJECTION;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtParameter> PARAMETER_DEFAULT_VALUE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtParameter> PARAMETER_VARARG_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> CALL_ELEMENT;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtDeclarationWithBody> DECLARATION_WITH_BODY;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtNamedDeclaration> VAL_OR_VAR_NODE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtWhenEntry> ELSE_ENTRY;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtWhenExpression> WHEN_EXPRESSION;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtWhenConditionInRange> WHEN_CONDITION_IN_RANGE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtExpression> SPECIAL_CONSTRUCT_TOKEN;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtNullableType> NULLABLE_TYPE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> CALL_EXPRESSION;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtElement> VALUE_ARGUMENTS;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtFunction> FUNCTION_PARAMETERS;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtElement> CUT_CHAR_QUOTES;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtElement> LONG_LITERAL_SUFFIX;
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> UNREACHABLE_CODE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtBinaryExpressionWithTypeRHS> AS_TYPE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtObjectDeclaration> COMPANION_OBJECT;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtConstructorDelegationCall> SECONDARY_CONSTRUCTOR_DELEGATION_CALL;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtEnumEntry> DELEGATOR_SUPER_CALL;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtBinaryExpression> UNUSED_VALUE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtBinaryExpression> USELESS_ELVIS;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtImportDirective> IMPORT_ALIAS;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtReturnExpression> RETURN_WITH_LABEL;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtCallableDeclaration> RECEIVER;
    public static final PositioningStrategies INSTANCE;

    @JvmStatic
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> modifierSetPosition(KtModifierKeywordToken ... tokens2) {
        Intrinsics.checkParameterIsNotNull((Object)tokens2, (String)"tokens");
        return new PositioningStrategy<KtModifierListOwner>(tokens2){
            final /* synthetic */ KtModifierKeywordToken[] $tokens;

            @NotNull
            public List<TextRange> mark(@NotNull KtModifierListOwner element3) {
                KtModifierList $receiver$iv;
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                KtModifierList ktModifierList = $receiver$iv = element3.getModifierList();
                if (ktModifierList == null) {
                    AssertionError assertionError;
                    AssertionError assertionError2 = assertionError;
                    AssertionError assertionError3 = assertionError;
                    String string = "No modifier list, but modifier has been found by the analyzer";
                    assertionError2((Object)string);
                    throw (Throwable)((Object)assertionError3);
                }
                KtModifierList modifierList = ktModifierList;
                KtModifierKeywordToken[] ktModifierKeywordTokenArray = this.$tokens;
                for (int i = 0; i < ktModifierKeywordTokenArray.length; ++i) {
                    KtModifierKeywordToken token = ktModifierKeywordTokenArray[i];
                    PsiElement modifier = modifierList.getModifier(token);
                    if (modifier == null) continue;
                    return PositioningStrategyKt.markElement(modifier);
                }
                throw (Throwable)new IllegalStateException("None of the modifiers is found: " + CollectionsKt.listOf((Object[])Arrays.copyOf(this.$tokens, this.$tokens.length)));
            }
            {
                this.$tokens = $captured_local_variable$0;
            }
        };
    }

    private PositioningStrategies() {
        INSTANCE = this;
        DEFAULT = new PositioningStrategy<PsiElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull PsiElement element3) {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                PsiElement psiElement2 = element3;
                if (psiElement2 instanceof KtObjectLiteralExpression) {
                    KtObjectDeclaration objectDeclaration = ((KtObjectLiteralExpression)element3).getObjectDeclaration();
                    PsiElement psiElement3 = objectDeclaration.getObjectKeyword();
                    if (psiElement3 == null) {
                        Intrinsics.throwNpe();
                    }
                    PsiElement objectKeyword = psiElement3;
                    KtSuperTypeList delegationSpecifierList = objectDeclaration.getSuperTypeList();
                    if (delegationSpecifierList == null) {
                        return PositioningStrategyKt.markElement(objectKeyword);
                    }
                    return PositioningStrategyKt.markRange(objectKeyword, (PsiElement)delegationSpecifierList);
                }
                if (psiElement2 instanceof KtObjectDeclaration) {
                    PsiElement psiElement4;
                    PsiElement psiElement5 = ((KtObjectDeclaration)element3).getObjectKeyword();
                    if (psiElement5 == null) {
                        Intrinsics.throwNpe();
                    }
                    if ((psiElement4 = ((KtObjectDeclaration)element3).getNameIdentifier()) == null && (psiElement4 = ((KtObjectDeclaration)element3).getObjectKeyword()) == null) {
                        Intrinsics.throwNpe();
                    }
                    return PositioningStrategyKt.markRange(psiElement5, psiElement4);
                }
                if (psiElement2 instanceof KtConstructorDelegationCall) {
                    return PositioningStrategies.SECONDARY_CONSTRUCTOR_DELEGATION_CALL.mark((KtConstructorDelegationCall)element3);
                }
                return super.mark(element3);
            }
        };
        DECLARATION_RETURN_TYPE = new PositioningStrategy<KtDeclaration>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtDeclaration element3) {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                return PositioningStrategyKt.markElement(this.getElementToMark(element3));
            }

            public boolean isValid(@NotNull KtDeclaration element3) {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                return !PositioningStrategyKt.hasSyntaxErrors(this.getElementToMark(element3));
            }

            /*
             * WARNING - void declaration
             */
            private final PsiElement getElementToMark(KtDeclaration declaration2) {
                void returnTypeRef;
                KtDeclaration ktDeclaration = declaration2;
                Pair pair2 = ktDeclaration instanceof KtCallableDeclaration ? new Pair((Object)((KtCallableDeclaration)declaration2).getTypeReference(), (Object)((KtCallableDeclaration)declaration2).getNameIdentifier()) : (ktDeclaration instanceof KtPropertyAccessor ? new Pair((Object)((KtPropertyAccessor)declaration2).getReturnTypeReference(), (Object)((KtPropertyAccessor)declaration2).getNamePlaceholder()) : new Pair(null, null));
                KtTypeReference ktTypeReference = (KtTypeReference)pair2.component1();
                PsiElement nameIdentifierOrPlaceholder = (PsiElement)pair2.component2();
                if (returnTypeRef != null) {
                    return (PsiElement)returnTypeRef;
                }
                if (nameIdentifierOrPlaceholder != null) {
                    return nameIdentifierOrPlaceholder;
                }
                return declaration2;
            }
        };
        DECLARATION_NAME = new DeclarationHeader<KtNamedDeclaration>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtNamedDeclaration element3) {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                PsiElement nameIdentifier = element3.getNameIdentifier();
                if (nameIdentifier != null) {
                    if (element3 instanceof KtClassOrObject) {
                        KtModifierList ktModifierList;
                        KtModifierList ktModifierList2 = element3.getModifierList();
                        if (ktModifierList2 == null || (ktModifierList2 = ktModifierList2.getModifier(KtTokens.ENUM_KEYWORD)) == null) {
                            ASTNode aSTNode = ((KtClassOrObject)element3).getNode().findChildByType(TokenSet.create((IElementType[])new IElementType[]{KtTokens.CLASS_KEYWORD, KtTokens.OBJECT_KEYWORD}));
                            ktModifierList2 = ktModifierList = aSTNode != null ? aSTNode.getPsi() : null;
                        }
                        if (ktModifierList2 == null) {
                            ktModifierList = element3;
                        }
                        KtModifierList startElement2 = ktModifierList;
                        return PositioningStrategyKt.markRange((PsiElement)startElement2, nameIdentifier);
                    }
                    return PositioningStrategyKt.markElement(nameIdentifier);
                }
                if (element3 instanceof KtNamedFunction) {
                    return PositioningStrategies.DECLARATION_SIGNATURE.mark((KtDeclaration)((PsiElement)element3));
                }
                return PositioningStrategies.DEFAULT.mark(element3);
            }
        };
        DECLARATION_SIGNATURE = new DeclarationHeader<KtDeclaration>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtDeclaration element3) {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                KtDeclaration ktDeclaration = element3;
                if (ktDeclaration instanceof KtConstructor) {
                    PsiElement psiElement2 = ((KtConstructor)element3).getConstructorKeyword();
                    if (psiElement2 == null) {
                        psiElement2 = (PsiElement)((KtConstructor)element3).getValueParameterList();
                    }
                    if (psiElement2 == null) {
                        return PositioningStrategyKt.markElement(element3);
                    }
                    PsiElement begin = psiElement2;
                    KtParameterList ktParameterList = ((KtConstructor)element3).getValueParameterList();
                    PsiElement psiElement3 = ktParameterList != null ? (PsiElement)ktParameterList : ((KtConstructor)element3).getConstructorKeyword();
                    if (psiElement3 == null) {
                        return PositioningStrategyKt.markElement(element3);
                    }
                    PsiElement end = psiElement3;
                    return PositioningStrategyKt.markRange(begin, end);
                }
                if (ktDeclaration instanceof KtFunction) {
                    NavigatablePsiElement navigatablePsiElement;
                    PsiElement endOfSignatureElement;
                    PsiElement psiElement4;
                    KtTypeReference ktTypeReference = ((KtFunction)element3).getTypeReference();
                    PsiElement psiElement5 = ktTypeReference != null ? (PsiElement)ktTypeReference : (PsiElement)((KtFunction)element3).getValueParameterList();
                    if (psiElement5 == null) {
                        psiElement5 = psiElement4 = ((KtFunction)element3).getNameIdentifier();
                    }
                    if (psiElement5 == null) {
                        psiElement4 = endOfSignatureElement = (PsiElement)element3;
                    }
                    if (element3 instanceof KtFunctionLiteral) {
                        KtTypeReference ktTypeReference2 = ((KtFunctionLiteral)element3).getReceiverTypeReference();
                        navigatablePsiElement = ktTypeReference2 != null ? (NavigatablePsiElement)ktTypeReference2 : (NavigatablePsiElement)((KtFunctionLiteral)element3).getValueParameterList();
                        if (navigatablePsiElement == null) {
                            navigatablePsiElement = element3;
                        }
                    } else {
                        navigatablePsiElement = element3;
                    }
                    NavigatablePsiElement startElement2 = navigatablePsiElement;
                    return PositioningStrategyKt.markRange((PsiElement)startElement2, endOfSignatureElement);
                }
                if (ktDeclaration instanceof KtProperty) {
                    KtTypeReference ktTypeReference = ((KtProperty)element3).getTypeReference();
                    PsiElement psiElement6 = ktTypeReference != null ? (PsiElement)ktTypeReference : ((KtProperty)element3).getNameIdentifier();
                    if (psiElement6 == null) {
                        psiElement6 = element3;
                    }
                    PsiElement endOfSignatureElement = psiElement6;
                    return PositioningStrategyKt.markRange(element3, endOfSignatureElement);
                }
                if (ktDeclaration instanceof KtPropertyAccessor) {
                    PsiElement psiElement7;
                    Object object;
                    KtTypeReference ktTypeReference = ((KtPropertyAccessor)element3).getReturnTypeReference();
                    if (ktTypeReference != null) {
                        object = ktTypeReference;
                    } else {
                        ASTNode aSTNode = ((KtPropertyAccessor)element3).getRightParenthesis();
                        object = psiElement7 = aSTNode != null ? aSTNode.getPsi() : null;
                    }
                    if (object == null) {
                        PsiElement psiElement8 = ((KtPropertyAccessor)element3).getNamePlaceholder();
                        psiElement7 = psiElement8;
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement8, (String)"element.namePlaceholder");
                    }
                    PsiElement endOfSignatureElement = psiElement7;
                    return PositioningStrategyKt.markRange(element3, endOfSignatureElement);
                }
                if (ktDeclaration instanceof KtClass) {
                    PsiElement psiElement9 = ((KtClass)element3).getNameIdentifier();
                    if (psiElement9 == null) {
                        return PositioningStrategyKt.markElement(element3);
                    }
                    PsiElement nameAsDeclaration = psiElement9;
                    KtParameterList ktParameterList = ((KtClass)element3).getPrimaryConstructorParameterList();
                    if (ktParameterList == null) {
                        PsiElement psiElement10 = nameAsDeclaration;
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement10, (String)"nameAsDeclaration");
                        return PositioningStrategyKt.markElement(psiElement10);
                    }
                    KtParameterList primaryConstructorParameterList = ktParameterList;
                    PsiElement psiElement11 = nameAsDeclaration;
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement11, (String)"nameAsDeclaration");
                    return PositioningStrategyKt.markRange(psiElement11, (PsiElement)primaryConstructorParameterList);
                }
                if (ktDeclaration instanceof KtObjectDeclaration) {
                    return PositioningStrategies.DECLARATION_NAME.mark((KtNamedDeclaration)element3);
                }
                if (ktDeclaration instanceof KtClassInitializer) {
                    TextRange textRange = ((KtClassInitializer)element3).getInitKeyword().getTextRange();
                    Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"element.initKeyword.textRange");
                    return PositioningStrategyKt.markRange(textRange);
                }
                return super.mark((PsiElement)element3);
            }
        };
        DECLARATION_SIGNATURE_OR_DEFAULT = new PositioningStrategy<PsiElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull PsiElement element3) {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                return element3 instanceof KtDeclaration ? PositioningStrategies.DECLARATION_SIGNATURE.mark((KtDeclaration)element3) : PositioningStrategies.DEFAULT.mark(element3);
            }

            public boolean isValid(@NotNull PsiElement element3) {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                return element3 instanceof KtDeclaration ? PositioningStrategies.DECLARATION_SIGNATURE.isValid((KtDeclaration)element3) : PositioningStrategies.DEFAULT.isValid(element3);
            }
        };
        TYPE_PARAMETERS_OR_DECLARATION_SIGNATURE = new PositioningStrategy<KtDeclaration>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtDeclaration element3) {
                KtTypeParameterList jetTypeParameterList;
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                if (element3 instanceof KtTypeParameterListOwner && (jetTypeParameterList = ((KtTypeParameterListOwner)element3).getTypeParameterList()) != null) {
                    return PositioningStrategyKt.markElement((PsiElement)jetTypeParameterList);
                }
                return PositioningStrategies.DECLARATION_SIGNATURE.mark((KtDeclaration)((PsiElement)element3));
            }
        };
        KtModifierKeywordToken[] ktModifierKeywordTokenArray = new KtModifierKeywordToken[1];
        KtModifierKeywordToken ktModifierKeywordToken = KtTokens.ABSTRACT_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken), (String)"KtTokens.ABSTRACT_KEYWORD");
        ktModifierKeywordTokenArray[0] = ktModifierKeywordToken;
        ABSTRACT_MODIFIER = PositioningStrategies.modifierSetPosition(ktModifierKeywordTokenArray);
        KtModifierKeywordToken[] ktModifierKeywordTokenArray2 = new KtModifierKeywordToken[1];
        KtModifierKeywordToken ktModifierKeywordToken2 = KtTokens.OPEN_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken2), (String)"KtTokens.OPEN_KEYWORD");
        ktModifierKeywordTokenArray2[0] = ktModifierKeywordToken2;
        OPEN_MODIFIER = PositioningStrategies.modifierSetPosition(ktModifierKeywordTokenArray2);
        KtModifierKeywordToken[] ktModifierKeywordTokenArray3 = new KtModifierKeywordToken[1];
        KtModifierKeywordToken ktModifierKeywordToken3 = KtTokens.OVERRIDE_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken3), (String)"KtTokens.OVERRIDE_KEYWORD");
        ktModifierKeywordTokenArray3[0] = ktModifierKeywordToken3;
        OVERRIDE_MODIFIER = PositioningStrategies.modifierSetPosition(ktModifierKeywordTokenArray3);
        KtModifierKeywordToken[] ktModifierKeywordTokenArray4 = new KtModifierKeywordToken[1];
        KtModifierKeywordToken ktModifierKeywordToken4 = KtTokens.PRIVATE_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken4), (String)"KtTokens.PRIVATE_KEYWORD");
        ktModifierKeywordTokenArray4[0] = ktModifierKeywordToken4;
        PRIVATE_MODIFIER = PositioningStrategies.modifierSetPosition(ktModifierKeywordTokenArray4);
        KtModifierKeywordToken[] ktModifierKeywordTokenArray5 = new KtModifierKeywordToken[1];
        KtModifierKeywordToken ktModifierKeywordToken5 = KtTokens.LATEINIT_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken5), (String)"KtTokens.LATEINIT_KEYWORD");
        ktModifierKeywordTokenArray5[0] = ktModifierKeywordToken5;
        LATEINIT_MODIFIER = PositioningStrategies.modifierSetPosition(ktModifierKeywordTokenArray5);
        KtModifierKeywordToken[] ktModifierKeywordTokenArray6 = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken6 = KtTokens.IN_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken6), (String)"KtTokens.IN_KEYWORD");
        ktModifierKeywordTokenArray6[0] = ktModifierKeywordToken6;
        KtModifierKeywordToken ktModifierKeywordToken7 = KtTokens.OUT_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken7), (String)"KtTokens.OUT_KEYWORD");
        ktModifierKeywordTokenArray6[1] = ktModifierKeywordToken7;
        VARIANCE_MODIFIER = PositioningStrategies.modifierSetPosition(ktModifierKeywordTokenArray6);
        FOR_REDECLARATION = new PositioningStrategy<PsiElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull PsiElement element3) {
                PsiElement nameIdentifier;
                PsiElement psiElement2;
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                PsiElement psiElement3 = element3;
                if (psiElement3 instanceof KtNamedDeclaration) {
                    psiElement2 = ((KtNamedDeclaration)element3).getNameIdentifier();
                } else if (psiElement3 instanceof KtFile) {
                    KtPackageDirective ktPackageDirective = ((KtFile)element3).getPackageDirective();
                    if (ktPackageDirective == null) {
                        Intrinsics.throwNpe();
                    }
                    psiElement2 = ktPackageDirective.getNameIdentifier();
                } else {
                    psiElement2 = nameIdentifier = null;
                }
                if (nameIdentifier == null && element3 instanceof KtObjectDeclaration) {
                    return PositioningStrategies.DEFAULT.mark(element3);
                }
                PsiElement psiElement4 = nameIdentifier;
                if (psiElement4 == null) {
                    psiElement4 = element3;
                }
                return PositioningStrategyKt.markElement(psiElement4);
            }
        };
        FOR_UNRESOLVED_REFERENCE = new PositioningStrategy<KtReferenceExpression>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtReferenceExpression element3) {
                List<TextRange> ranges;
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                if (element3 instanceof KtArrayAccessExpression && !(ranges = ((KtArrayAccessExpression)element3).getBracketRanges()).isEmpty()) {
                    List<TextRange> list2 = ranges;
                    Intrinsics.checkExpressionValueIsNotNull(list2, (String)"ranges");
                    return list2;
                }
                return CollectionsKt.listOf((Object)element3.getTextRange());
            }
        };
        ARRAY_ACCESS = new PositioningStrategy<KtArrayAccessExpression>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtArrayAccessExpression element3) {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                KtContainerNode ktContainerNode = element3.getIndicesNode();
                Intrinsics.checkExpressionValueIsNotNull((Object)ktContainerNode, (String)"element.indicesNode");
                return PositioningStrategyKt.markElement((PsiElement)ktContainerNode);
            }
        };
        VISIBILITY_MODIFIER = new PositioningStrategy<KtModifierListOwner>(){

            /*
             * WARNING - void declaration
             */
            @NotNull
            public List<TextRange> mark(@NotNull KtModifierListOwner element3) {
                PsiElement psiElement2;
                PsiElement nameIdentifier;
                void $receiver$iv$iv;
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                List visibilityTokens = CollectionsKt.listOf((Object[])new KtModifierKeywordToken[]{KtTokens.PRIVATE_KEYWORD, KtTokens.PROTECTED_KEYWORD, KtTokens.PUBLIC_KEYWORD, KtTokens.INTERNAL_KEYWORD});
                KtModifierList modifierList = element3.getModifierList();
                Iterable $receiver$iv = visibilityTokens;
                Object object = $receiver$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                void $receiver$iv$iv$iv = $receiver$iv$iv;
                Iterator<T> iterator2 = $receiver$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    TextRange textRange;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator2.next();
                    KtModifierKeywordToken it = (KtModifierKeywordToken)((Object)element$iv$iv);
                    KtModifierList ktModifierList = modifierList;
                    TextRange textRange2 = ktModifierList != null && (ktModifierList = ktModifierList.getModifier(it)) != null ? ktModifierList.getTextRange() : null;
                    if (textRange2 == null) continue;
                    TextRange it$iv$iv = textRange = textRange2;
                    destination$iv$iv.add(it$iv$iv);
                }
                List result2 = (List)destination$iv$iv;
                if (!result2.isEmpty()) {
                    return result2;
                }
                if (element3 instanceof PsiNameIdentifierOwner && (nameIdentifier = ((PsiNameIdentifierOwner)element3).getNameIdentifier()) != null) {
                    return PositioningStrategyKt.markElement(nameIdentifier);
                }
                object = element3;
                if (object instanceof KtObjectDeclaration) {
                    psiElement2 = ((KtObjectDeclaration)element3).getObjectKeyword();
                    if (psiElement2 == null) {
                        Intrinsics.throwNpe();
                    }
                } else if (object instanceof KtPropertyAccessor) {
                    PsiElement psiElement3 = ((KtPropertyAccessor)element3).getNamePlaceholder();
                    psiElement2 = psiElement3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"element.namePlaceholder");
                } else if (object instanceof KtAnonymousInitializer) {
                    psiElement2 = element3;
                } else {
                    throw (Throwable)new IllegalArgumentException("Can't find text range for element '" + element3.getClass().getCanonicalName() + "' with the text '" + element3.getText() + '\'');
                }
                PsiElement elementToMark = psiElement2;
                return PositioningStrategyKt.markElement(elementToMark);
            }
        };
        VARIANCE_IN_PROJECTION = new PositioningStrategy<KtTypeProjection>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtTypeProjection element3) {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                PsiElement psiElement2 = element3.getProjectionToken();
                if (psiElement2 == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"element.projectionToken!!");
                return PositioningStrategyKt.markElement(psiElement2);
            }
        };
        PARAMETER_DEFAULT_VALUE = new PositioningStrategy<KtParameter>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtParameter element3) {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                KtExpression ktExpression = element3.getDefaultValue();
                if (ktExpression == null) {
                    Intrinsics.throwNpe();
                }
                ASTNode aSTNode = ktExpression.getNode();
                Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"element.defaultValue!!.node");
                return PositioningStrategyKt.markNode(aSTNode);
            }
        };
        PARAMETER_VARARG_MODIFIER = new PositioningStrategy<KtParameter>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtParameter element3) {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                KtModifierList ktModifierList = element3.getModifierList();
                if (ktModifierList == null) {
                    Intrinsics.throwNpe();
                }
                PsiElement psiElement2 = ktModifierList.getModifier(KtTokens.VARARG_KEYWORD);
                if (psiElement2 == null) {
                    Intrinsics.throwNpe();
                }
                PsiElement varargModifier = psiElement2;
                ASTNode aSTNode = varargModifier.getNode();
                Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"varargModifier.node");
                return PositioningStrategyKt.markNode(aSTNode);
            }
        };
        CALL_ELEMENT = new PositioningStrategy<PsiElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull PsiElement element3) {
                KtElement ktElement;
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                PsiElement psiElement2 = element3;
                if (!(psiElement2 instanceof KtCallElement)) {
                    psiElement2 = null;
                }
                return PositioningStrategyKt.markElement((ktElement = (KtCallElement)psiElement2) != null && (ktElement = ktElement.getCalleeExpression()) != null ? (PsiElement)ktElement : element3);
            }
        };
        DECLARATION_WITH_BODY = new PositioningStrategy<KtDeclarationWithBody>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtDeclarationWithBody element3) {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                KtExpression ktExpression = element3.getBodyExpression();
                if (!(ktExpression instanceof KtBlockExpression)) {
                    ktExpression = null;
                }
                KtBlockExpression ktBlockExpression = (KtBlockExpression)ktExpression;
                TextRange lastBracketRange = ktBlockExpression != null ? ktBlockExpression.getLastBracketRange() : null;
                return lastBracketRange != null ? PositioningStrategyKt.markRange(lastBracketRange) : PositioningStrategyKt.markElement(element3);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean isValid(@NotNull KtDeclarationWithBody element3) {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                if (!super.isValid((PsiElement)element3)) return false;
                KtExpression ktExpression = element3.getBodyExpression();
                if (!(ktExpression instanceof KtBlockExpression)) {
                    ktExpression = null;
                }
                KtBlockExpression ktBlockExpression = (KtBlockExpression)ktExpression;
                if (ktBlockExpression == null) return false;
                TextRange textRange = ktBlockExpression.getLastBracketRange();
                if (textRange == null) return false;
                return true;
            }
        };
        VAL_OR_VAR_NODE = new PositioningStrategy<KtNamedDeclaration>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtNamedDeclaration element3) {
                List<TextRange> list2;
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                KtNamedDeclaration ktNamedDeclaration = element3;
                if (ktNamedDeclaration instanceof KtParameter) {
                    PsiElement psiElement2 = ((KtParameter)element3).getValOrVarKeyword();
                    if (psiElement2 == null) {
                        psiElement2 = element3;
                    }
                    list2 = PositioningStrategyKt.markElement(psiElement2);
                } else if (ktNamedDeclaration instanceof KtProperty) {
                    PsiElement psiElement3 = ((KtProperty)element3).getValOrVarKeyword();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"element.valOrVarKeyword");
                    list2 = PositioningStrategyKt.markElement(psiElement3);
                } else {
                    String string = "Declaration is neither a parameter nor a property: " + PsiUtilsKt.getElementTextWithContext(element3);
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                return list2;
            }
        };
        ELSE_ENTRY = new PositioningStrategy<KtWhenEntry>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtWhenEntry element3) {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                PsiElement psiElement2 = element3.getElseKeyword();
                if (psiElement2 == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"element.elseKeyword!!");
                return PositioningStrategyKt.markElement(psiElement2);
            }
        };
        WHEN_EXPRESSION = new PositioningStrategy<KtWhenExpression>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtWhenExpression element3) {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                PsiElement psiElement2 = element3.getWhenKeyword();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"element.whenKeyword");
                return PositioningStrategyKt.markElement(psiElement2);
            }
        };
        WHEN_CONDITION_IN_RANGE = new PositioningStrategy<KtWhenConditionInRange>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtWhenConditionInRange element3) {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                KtOperationReferenceExpression ktOperationReferenceExpression = element3.getOperationReference();
                Intrinsics.checkExpressionValueIsNotNull((Object)ktOperationReferenceExpression, (String)"element.operationReference");
                return PositioningStrategyKt.markElement((PsiElement)ktOperationReferenceExpression);
            }
        };
        SPECIAL_CONSTRUCT_TOKEN = new PositioningStrategy<KtExpression>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtExpression element3) {
                List<TextRange> list2;
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                KtExpression ktExpression = element3;
                if (ktExpression instanceof KtWhenExpression) {
                    PsiElement psiElement2 = ((KtWhenExpression)element3).getWhenKeyword();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"element.whenKeyword");
                    list2 = PositioningStrategyKt.markElement(psiElement2);
                } else if (ktExpression instanceof KtIfExpression) {
                    PsiElement psiElement3 = ((KtIfExpression)element3).getIfKeyword();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"element.ifKeyword");
                    list2 = PositioningStrategyKt.markElement(psiElement3);
                } else if (ktExpression instanceof KtOperationExpression) {
                    KtSimpleNameExpression ktSimpleNameExpression = ((KtOperationExpression)element3).getOperationReference();
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktSimpleNameExpression, (String)"element.operationReference");
                    list2 = PositioningStrategyKt.markElement((PsiElement)ktSimpleNameExpression);
                } else {
                    String string = "Expression is not an if, when or operation expression: " + PsiUtilsKt.getElementTextWithContext((PsiElement)element3);
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                return list2;
            }
        };
        NULLABLE_TYPE = new PositioningStrategy<KtNullableType>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtNullableType element3) {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                ASTNode aSTNode = element3.getQuestionMarkNode();
                Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"element.questionMarkNode");
                return PositioningStrategyKt.markNode(aSTNode);
            }
        };
        CALL_EXPRESSION = new PositioningStrategy<PsiElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull PsiElement element3) {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                if (element3 instanceof KtCallExpression) {
                    KtTypeArgumentList ktTypeArgumentList = ((KtCallExpression)element3).getTypeArgumentList();
                    PsiElement psiElement2 = ktTypeArgumentList != null ? (PsiElement)ktTypeArgumentList : (PsiElement)((KtCallExpression)element3).getCalleeExpression();
                    if (psiElement2 == null) {
                        psiElement2 = element3;
                    }
                    return PositioningStrategyKt.markRange(element3, psiElement2);
                }
                return PositioningStrategyKt.markElement(element3);
            }
        };
        VALUE_ARGUMENTS = new PositioningStrategy<KtElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtElement element3) {
                KtValueArgumentList ktValueArgumentList;
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                KtElement ktElement = element3;
                if (!(ktElement instanceof KtValueArgumentList)) {
                    ktElement = null;
                }
                if ((ktValueArgumentList = (KtValueArgumentList)ktElement) == null || (ktValueArgumentList = ktValueArgumentList.getRightParenthesis()) == null) {
                    ktValueArgumentList = (PsiElement)element3;
                }
                return PositioningStrategyKt.markElement((PsiElement)ktValueArgumentList);
            }
        };
        FUNCTION_PARAMETERS = new PositioningStrategy<KtFunction>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtFunction element3) {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                KtParameterList valueParameterList = element3.getValueParameterList();
                if (valueParameterList != null) {
                    return PositioningStrategyKt.markElement((PsiElement)valueParameterList);
                }
                if (element3 instanceof KtFunctionLiteral) {
                    ASTNode aSTNode = ((KtFunctionLiteral)element3).getLBrace().getNode();
                    Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"element.lBrace.node");
                    return PositioningStrategyKt.markNode(aSTNode);
                }
                return PositioningStrategies.DECLARATION_SIGNATURE_OR_DEFAULT.mark(element3);
            }
        };
        CUT_CHAR_QUOTES = new PositioningStrategy<KtElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtElement element3) {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                if (element3 instanceof KtConstantExpression && Intrinsics.areEqual((Object)((KtConstantExpression)element3).getNode().getElementType(), (Object)((Object)KtNodeTypes.CHARACTER_CONSTANT))) {
                    TextRange elementTextRange = element3.getTextRange();
                    return CollectionsKt.listOf((Object)TextRange.create((int)(elementTextRange.getStartOffset() + 1), (int)(elementTextRange.getEndOffset() - 1)));
                }
                return PositioningStrategyKt.markElement((PsiElement)element3);
            }
        };
        LONG_LITERAL_SUFFIX = new PositioningStrategy<KtElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtElement element3) {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                if (element3 instanceof KtConstantExpression && Intrinsics.areEqual((Object)((KtConstantExpression)element3).getNode().getElementType(), (Object)((Object)KtNodeTypes.INTEGER_CONSTANT))) {
                    int endOffset = PsiUtilsKt.getEndOffset((PsiElement)element3);
                    return CollectionsKt.listOf((Object)TextRange.create((int)(endOffset - 1), (int)endOffset));
                }
                return PositioningStrategyKt.markElement((PsiElement)element3);
            }
        };
        UNREACHABLE_CODE = new PositioningStrategy<PsiElement>(){

            @NotNull
            public List<TextRange> markDiagnostic(@NotNull ParametrizedDiagnostic<? extends PsiElement> diagnostic) {
                Intrinsics.checkParameterIsNotNull(diagnostic, (String)"diagnostic");
                A a = ((DiagnosticWithParameters1)Errors.UNREACHABLE_CODE.cast(diagnostic)).getA();
                Intrinsics.checkExpressionValueIsNotNull(a, (String)"Errors.UNREACHABLE_CODE.cast(diagnostic).a");
                return (List)a;
            }
        };
        AS_TYPE = new PositioningStrategy<KtBinaryExpressionWithTypeRHS>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtBinaryExpressionWithTypeRHS element3) {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                KtSimpleNameExpression ktSimpleNameExpression = element3.getOperationReference();
                Intrinsics.checkExpressionValueIsNotNull((Object)ktSimpleNameExpression, (String)"element.operationReference");
                return PositioningStrategyKt.markRange((PsiElement)ktSimpleNameExpression, (PsiElement)element3);
            }
        };
        COMPANION_OBJECT = new PositioningStrategy<KtObjectDeclaration>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtObjectDeclaration element3) {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                if (element3.hasModifier(KtTokens.COMPANION_KEYWORD)) {
                    KtModifierKeywordToken[] ktModifierKeywordTokenArray = new KtModifierKeywordToken[1];
                    KtModifierKeywordToken ktModifierKeywordToken = KtTokens.COMPANION_KEYWORD;
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken), (String)"KtTokens.COMPANION_KEYWORD");
                    ktModifierKeywordTokenArray[0] = ktModifierKeywordToken;
                    return PositioningStrategies.modifierSetPosition(ktModifierKeywordTokenArray).mark((KtModifierListOwner)((PsiElement)element3));
                }
                return PositioningStrategies.DEFAULT.mark(element3);
            }
        };
        SECONDARY_CONSTRUCTOR_DELEGATION_CALL = new PositioningStrategy<KtConstructorDelegationCall>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtConstructorDelegationCall element3) {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                if (element3.isImplicit()) {
                    PsiElement $receiver$iv = (PsiElement)element3;
                    PsiElement psiElement2 = PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtSecondaryConstructor.class, (boolean)true);
                    if (psiElement2 == null) {
                        Intrinsics.throwNpe();
                    }
                    KtSecondaryConstructor constructor2 = (KtSecondaryConstructor)psiElement2;
                    KtParameterList ktParameterList = constructor2.getValueParameterList();
                    if (ktParameterList == null) {
                        return PositioningStrategyKt.markElement(constructor2);
                    }
                    KtParameterList valueParameterList = ktParameterList;
                    PsiElement psiElement3 = constructor2.getConstructorKeyword();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"constructor.getConstructorKeyword()");
                    PsiElement psiElement4 = valueParameterList.getLastChild();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement4, (String)"valueParameterList.lastChild");
                    return PositioningStrategyKt.markRange(psiElement3, psiElement4);
                }
                KtConstructorDelegationReferenceExpression ktConstructorDelegationReferenceExpression = element3.getCalleeExpression();
                return PositioningStrategyKt.markElement(ktConstructorDelegationReferenceExpression != null ? (PsiElement)ktConstructorDelegationReferenceExpression : (PsiElement)element3);
            }
        };
        DELEGATOR_SUPER_CALL = new PositioningStrategy<KtEnumEntry>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtEnumEntry element3) {
                KtElementImplStub ktElementImplStub;
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                List<KtSuperTypeListEntry> specifiers = element3.getSuperTypeListEntries();
                if (specifiers.isEmpty()) {
                    ktElementImplStub = element3;
                } else {
                    KtSuperTypeListEntry ktSuperTypeListEntry = specifiers.get(0);
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktSuperTypeListEntry, (String)"specifiers[0]");
                    ktElementImplStub = ktSuperTypeListEntry;
                }
                return PositioningStrategyKt.markElement((PsiElement)ktElementImplStub);
            }
        };
        UNUSED_VALUE = new PositioningStrategy<KtBinaryExpression>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtBinaryExpression element3) {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                KtExpression ktExpression = element3.getLeft();
                if (ktExpression == null) {
                    Intrinsics.throwNpe();
                }
                return CollectionsKt.listOf((Object)new TextRange(PsiUtilsKt.getStartOffset((PsiElement)ktExpression), PsiUtilsKt.getEndOffset((PsiElement)element3.getOperationReference())));
            }
        };
        USELESS_ELVIS = new PositioningStrategy<KtBinaryExpression>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtBinaryExpression element3) {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                return CollectionsKt.listOf((Object)new TextRange(PsiUtilsKt.getStartOffset((PsiElement)element3.getOperationReference()), PsiUtilsKt.getEndOffset((PsiElement)element3)));
            }
        };
        IMPORT_ALIAS = new PositioningStrategy<KtImportDirective>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtImportDirective element3) {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                KtImportAlias ktImportAlias = element3.getAlias();
                if (ktImportAlias != null && (ktImportAlias = ktImportAlias.getNameIdentifier()) != null) {
                    KtImportAlias ktImportAlias2;
                    KtImportAlias it = ktImportAlias2 = ktImportAlias;
                    return PositioningStrategyKt.markElement((PsiElement)it);
                }
                KtExpression ktExpression = element3.getImportedReference();
                if (ktExpression != null) {
                    KtExpression ktExpression2 = ktExpression;
                    KtExpression it = ktExpression2;
                    if (it instanceof KtQualifiedExpression) {
                        KtExpression ktExpression3 = ((KtQualifiedExpression)it).getSelectorExpression();
                        if (ktExpression3 != null) {
                            KtExpression ktExpression4;
                            KtExpression it2 = ktExpression4 = ktExpression3;
                            return PositioningStrategyKt.markElement((PsiElement)it2);
                        }
                    }
                    KtExpression ktExpression5 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression5, (String)"it");
                    return PositioningStrategyKt.markElement((PsiElement)ktExpression5);
                }
                return PositioningStrategyKt.markElement((PsiElement)element3);
            }
        };
        RETURN_WITH_LABEL = new PositioningStrategy<KtReturnExpression>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtReturnExpression element3) {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                PsiElement labeledExpression = element3.getLabeledExpression();
                if (labeledExpression != null) {
                    return PositioningStrategyKt.markRange((PsiElement)element3, labeledExpression);
                }
                PsiElement psiElement2 = element3.getReturnKeyword();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"element.returnKeyword");
                return PositioningStrategyKt.markElement(psiElement2);
            }
        };
        RECEIVER = new DeclarationHeader<KtCallableDeclaration>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtCallableDeclaration element3) {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                KtTypeReference ktTypeReference = element3.getReceiverTypeReference();
                if (ktTypeReference != null) {
                    KtTypeReference ktTypeReference2;
                    KtTypeReference it;
                    KtTypeReference ktTypeReference3 = it = (ktTypeReference2 = ktTypeReference);
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktTypeReference3, (String)"it");
                    return PositioningStrategyKt.markElement(ktTypeReference3);
                }
                return PositioningStrategies.DEFAULT.mark(element3);
            }
        };
    }

    static {
        new PositioningStrategies();
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0012\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/diagnostics/PositioningStrategies$DeclarationHeader;", "T", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;", "()V", "isValid", "", "element", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;)Z", "frontend"})
    private static class DeclarationHeader<T extends KtDeclaration>
    extends PositioningStrategy<T> {
        @Override
        public boolean isValid(@NotNull T element3) {
            Intrinsics.checkParameterIsNotNull(element3, (String)"element");
            if (element3 instanceof KtNamedDeclaration && !(element3 instanceof KtObjectDeclaration) && !(element3 instanceof KtSecondaryConstructor) && !(element3 instanceof KtFunction) && ((KtNamedDeclaration)element3).getNameIdentifier() == null) {
                return false;
            }
            return super.isValid((PsiElement)element3);
        }
    }
}

