/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ClassFileViewProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.impl.java.stubs.StubPsiFactory;
import com.intellij.psi.impl.java.stubs.impl.PsiJavaFileStubImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassGenerationSupport;
import org.jetbrains.kotlin.asJava.builder.ClsWrapperStubPsiFactory;
import org.jetbrains.kotlin.asJava.builder.LightClassBuilderResult;
import org.jetbrains.kotlin.asJava.builder.LightClassConstructionContext;
import org.jetbrains.kotlin.asJava.builder.LightClassDataHolder;
import org.jetbrains.kotlin.asJava.classes.FakeLightClassForFileOfPackage;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForFacade;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForSourceDeclaration;
import org.jetbrains.kotlin.asJava.finder.JavaElementFinder;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.idea.caches.resolve.GetModuleInfoKt;
import org.jetbrains.kotlin.idea.caches.resolve.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.caches.resolve.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.caches.resolve.lightClasses.ClsJavaStubByVirtualFileCache;
import org.jetbrains.kotlin.idea.caches.resolve.lightClasses.IDELightClassContexts;
import org.jetbrains.kotlin.idea.caches.resolve.lightClasses.KtLightClassForDecompiledDeclaration;
import org.jetbrains.kotlin.idea.caches.resolve.lightClasses.LazyLightClassDataHolder;
import org.jetbrains.kotlin.idea.caches.resolve.lightClasses.PlatformWrappersKt;
import org.jetbrains.kotlin.idea.decompiler.classFile.KtClsFile;
import org.jetbrains.kotlin.idea.decompiler.navigation.SourceNavigationHelper;
import org.jetbrains.kotlin.idea.stubindex.KotlinFileFacadeClassByPackageIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinFileFacadeFqNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinFullClassNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinSourceFilterScope;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelClassByPackageIndex;
import org.jetbrains.kotlin.idea.stubindex.PackageIndexUtil;
import org.jetbrains.kotlin.idea.stubindex.StaticFacadeIndexUtil;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.lazy.NoDescriptorForDeclarationException;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u00c8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J$\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J(\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00172\u0016\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001cj\u0002`\u001fH\u0016J.\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00130#2\u0016\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001cj\u0002`\u001fH\u0016J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'H\u0002J*\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)2\u0006\u0010+\u001a\u00020,2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00130)2\u0006\u0010.\u001a\u00020/J\u001e\u00100\u001a\b\u0012\u0004\u0012\u00020\u00170#2\u0006\u00101\u001a\u00020,2\u0006\u00102\u001a\u000203H\u0016J\u001e\u00104\u001a\b\u0012\u0004\u0012\u00020\u00170#2\u0006\u00105\u001a\u00020,2\u0006\u00102\u001a\u000203H\u0016J\u0018\u00106\u001a\u00020%2\u0006\u00107\u001a\u00020\u00172\u0006\u00108\u001a\u00020%H\u0002J\u001e\u00109\u001a\b\u0012\u0004\u0012\u00020\u00130#2\u0006\u0010+\u001a\u00020,2\u0006\u0010:\u001a\u000203H\u0016J\u001e\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00130#2\u0006\u00101\u001a\u00020,2\u0006\u00102\u001a\u000203H\u0016J\u001e\u0010<\u001a\b\u0012\u0004\u0012\u00020%0)2\u0006\u00101\u001a\u00020,2\u0006\u0010:\u001a\u000203H\u0002J\u001e\u0010=\u001a\b\u0012\u0004\u0012\u00020*0#2\u0006\u00101\u001a\u00020,2\u0006\u0010:\u001a\u000203H\u0002J\u0010\u0010>\u001a\u00020,2\u0006\u00107\u001a\u00020\u0017H\u0002J\u001e\u0010?\u001a\b\u0012\u0004\u0012\u00020*0#2\u0006\u0010+\u001a\u00020,2\u0006\u0010:\u001a\u000203H\u0016J\u001e\u0010@\u001a\b\u0012\u0004\u0012\u00020*0#2\u0006\u00105\u001a\u00020,2\u0006\u0010:\u001a\u000203H\u0016J\u001e\u0010A\u001a\b\u0012\u0004\u0012\u00020B0#2\u0006\u00105\u001a\u00020,2\u0006\u0010:\u001a\u000203H\u0016J\u001e\u0010C\u001a\b\u0012\u0004\u0012\u00020*0#2\u0006\u00101\u001a\u00020,2\u0006\u0010:\u001a\u000203H\u0016J\u0012\u0010D\u001a\u0004\u0018\u00010E2\u0006\u0010\u001a\u001a\u00020\u0017H\u0016J\u0012\u0010F\u001a\u0004\u0018\u00010%2\u0006\u00107\u001a\u00020\u0017H\u0002J\u001e\u0010G\u001a\b\u0012\u0004\u0012\u00020,0#2\u0006\u0010H\u001a\u00020,2\u0006\u0010:\u001a\u000203H\u0016J\u0018\u0010I\u001a\u00020J2\u0006\u00101\u001a\u00020,2\u0006\u0010:\u001a\u000203H\u0016J\u0012\u0010K\u001a\u0004\u0018\u00010L2\u0006\u0010M\u001a\u00020NH\u0016J&\u0010O\u001a\b\u0012\u0004\u0012\u00020*0)2\b\u0010P\u001a\u0004\u0018\u00010Q2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00130)H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"Lorg/jetbrains/kotlin/idea/caches/resolve/IDELightClassGenerationSupport;", "Lorg/jetbrains/kotlin/asJava/LightClassGenerationSupport;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "psiManager", "Lcom/intellij/psi/PsiManager;", "scopeFileComparator", "Ljava/util/Comparator;", "Lcom/intellij/psi/PsiElement;", "kotlin.jvm.PlatformType", "analyze", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "analyzeFully", "createClsJavaClassFromVirtualFile", "Lcom/intellij/psi/impl/compiled/ClsClassImpl;", "mirrorFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "classFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "correspondingClassOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "createDataHolderForClass", "Lorg/jetbrains/kotlin/asJava/builder/LightClassDataHolder$ForClass;", "classOrObject", "builder", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/asJava/builder/LightClassConstructionContext;", "Lorg/jetbrains/kotlin/asJava/builder/LightClassBuilderResult;", "Lorg/jetbrains/kotlin/asJava/LightClassBuilder;", "createDataHolderForFacade", "Lorg/jetbrains/kotlin/asJava/builder/LightClassDataHolder$ForFacade;", "files", "", "createLightClassForDecompiledKotlinFile", "Lorg/jetbrains/kotlin/idea/caches/resolve/lightClasses/KtLightClassForDecompiledDeclaration;", "file", "Lorg/jetbrains/kotlin/idea/decompiler/classFile/KtClsFile;", "createLightClassForFileFacade", "", "Lcom/intellij/psi/PsiClass;", "facadeFqName", "Lorg/jetbrains/kotlin/name/FqName;", "facadeFiles", "moduleInfo", "Lorg/jetbrains/kotlin/idea/caches/resolve/IdeaModuleInfo;", "findClassOrObjectDeclarations", "fqName", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "findClassOrObjectDeclarationsInPackage", "packageFqName", "findCorrespondingLightClass", "decompiledClassOrObject", "rootLightClassForDecompiledFile", "findFilesForFacade", "scope", "findFilesForPackage", "findPackageParts", "findPlatformWrapper", "getClassRelativeName", "getFacadeClasses", "getFacadeClassesInPackage", "getFacadeNames", "", "getKotlinInternalClasses", "getLightClass", "Lorg/jetbrains/kotlin/asJava/classes/KtLightClass;", "getLightClassForDecompiledClassOrObject", "getSubPackages", "fqn", "packageExists", "", "resolveToDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "withFakeLightClasses", "lightClassForFacade", "Lorg/jetbrains/kotlin/asJava/classes/KtLightClassForFacade;", "idea-analysis"})
public final class IDELightClassGenerationSupport
extends LightClassGenerationSupport {
    private final Comparator<PsiElement> scopeFileComparator;
    private final PsiManager psiManager;
    private final Project project;

    @Override
    @NotNull
    public LightClassDataHolder.ForClass createDataHolderForClass(@NotNull KtClassOrObject classOrObject, @NotNull Function1<? super LightClassConstructionContext, LightClassBuilderResult> builder) {
        Intrinsics.checkParameterIsNotNull((Object)classOrObject, (String)"classOrObject");
        Intrinsics.checkParameterIsNotNull(builder, (String)"builder");
        return classOrObject.isLocal() ? (LightClassDataHolder.ForClass)new LazyLightClassDataHolder.ForClass(builder, (Function0<? extends LightClassConstructionContext>)((Function0)new Function0<LightClassConstructionContext>(classOrObject){
            final /* synthetic */ KtClassOrObject $classOrObject;

            @NotNull
            public final LightClassConstructionContext invoke() {
                return IDELightClassContexts.INSTANCE.contextForLocalClassOrObject(this.$classOrObject);
            }
            {
                this.$classOrObject = ktClassOrObject;
                super(0);
            }
        }), null) : (LightClassDataHolder.ForClass)new LazyLightClassDataHolder.ForClass(builder, (Function0<? extends LightClassConstructionContext>)((Function0)new Function0<LightClassConstructionContext>(classOrObject){
            final /* synthetic */ KtClassOrObject $classOrObject;

            @NotNull
            public final LightClassConstructionContext invoke() {
                return IDELightClassContexts.INSTANCE.contextForNonLocalClassOrObject(this.$classOrObject);
            }
            {
                this.$classOrObject = ktClassOrObject;
                super(0);
            }
        }), (Function0<? extends LightClassConstructionContext>)((Function0)new Function0<LightClassConstructionContext>(classOrObject){
            final /* synthetic */ KtClassOrObject $classOrObject;

            @Nullable
            public final LightClassConstructionContext invoke() {
                return IDELightClassContexts.INSTANCE.lightContextForClassOrObject(this.$classOrObject);
            }
            {
                this.$classOrObject = ktClassOrObject;
                super(0);
            }
        }));
    }

    @Override
    @NotNull
    public LightClassDataHolder.ForFacade createDataHolderForFacade(@NotNull Collection<? extends KtFile> files2, @NotNull Function1<? super LightClassConstructionContext, LightClassBuilderResult> builder) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(files2, (String)"files");
        Intrinsics.checkParameterIsNotNull(builder, (String)"builder");
        boolean bl2 = bl = !files2.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "No files in facade";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Iterable iterable = files2;
        Comparator<PsiElement> comparator = this.scopeFileComparator;
        Intrinsics.checkExpressionValueIsNotNull(comparator, (String)"scopeFileComparator");
        List sortedFiles = CollectionsKt.sortedWith((Iterable)iterable, comparator);
        return new LazyLightClassDataHolder.ForFacade(builder, (Function0<? extends LightClassConstructionContext>)((Function0)new Function0<LightClassConstructionContext>(sortedFiles){
            final /* synthetic */ List $sortedFiles;

            @NotNull
            public final LightClassConstructionContext invoke() {
                return IDELightClassContexts.INSTANCE.contextForFacade(this.$sortedFiles);
            }
            {
                this.$sortedFiles = list2;
                super(0);
            }
        }), (Function0<? extends LightClassConstructionContext>)((Function0)new Function0<LightClassConstructionContext>(sortedFiles){
            final /* synthetic */ List $sortedFiles;

            @NotNull
            public final LightClassConstructionContext invoke() {
                return IDELightClassContexts.INSTANCE.lightContextForFacade(this.$sortedFiles);
            }
            {
                this.$sortedFiles = list2;
                super(0);
            }
        }));
    }

    @Override
    @NotNull
    public Collection<KtClassOrObject> findClassOrObjectDeclarations(@NotNull FqName fqName2, @NotNull GlobalSearchScope searchScope2) {
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        Intrinsics.checkParameterIsNotNull((Object)searchScope2, (String)"searchScope");
        Object t = ApplicationUtilsKt.runReadAction((Function0)new Function0<Collection<KtClassOrObject>>(this, fqName2, searchScope2){
            final /* synthetic */ IDELightClassGenerationSupport this$0;
            final /* synthetic */ FqName $fqName;
            final /* synthetic */ GlobalSearchScope $searchScope;

            @NotNull
            public final Collection<KtClassOrObject> invoke() {
                Collection<KtClassOrObject> collection = KotlinFullClassNameIndex.getInstance().get(this.$fqName.asString(), IDELightClassGenerationSupport.access$getProject$p(this.this$0), KotlinSourceFilterScope.Companion.sourceAndClassFiles(this.$searchScope, IDELightClassGenerationSupport.access$getProject$p(this.this$0)));
                Intrinsics.checkExpressionValueIsNotNull(collection, (String)"KotlinFullClassNameIndex\u2026es(searchScope, project))");
                return collection;
            }
            {
                this.this$0 = iDELightClassGenerationSupport;
                this.$fqName = fqName2;
                this.$searchScope = globalSearchScope;
                super(0);
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(t, (String)"runReadAction {\n        \u2026cope, project))\n        }");
        return (Collection)t;
    }

    @Override
    @NotNull
    public Collection<KtFile> findFilesForPackage(@NotNull FqName fqName2, @NotNull GlobalSearchScope searchScope2) {
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        Intrinsics.checkParameterIsNotNull((Object)searchScope2, (String)"searchScope");
        return (Collection)ApplicationUtilsKt.runReadAction((Function0)new Function0<Collection<? extends KtFile>>(this, fqName2, searchScope2){
            final /* synthetic */ IDELightClassGenerationSupport this$0;
            final /* synthetic */ FqName $fqName;
            final /* synthetic */ GlobalSearchScope $searchScope;

            @NotNull
            public final Collection<KtFile> invoke() {
                return PackageIndexUtil.findFilesWithExactPackage(this.$fqName, KotlinSourceFilterScope.Companion.sourceAndClassFiles(this.$searchScope, IDELightClassGenerationSupport.access$getProject$p(this.this$0)), IDELightClassGenerationSupport.access$getProject$p(this.this$0));
            }
            {
                this.this$0 = iDELightClassGenerationSupport;
                this.$fqName = fqName2;
                this.$searchScope = globalSearchScope;
                super(0);
            }
        });
    }

    @Override
    @NotNull
    public Collection<KtClassOrObject> findClassOrObjectDeclarationsInPackage(@NotNull FqName packageFqName, @NotNull GlobalSearchScope searchScope2) {
        Intrinsics.checkParameterIsNotNull((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkParameterIsNotNull((Object)searchScope2, (String)"searchScope");
        Collection<KtClassOrObject> collection = KotlinTopLevelClassByPackageIndex.getInstance().get(packageFqName.asString(), this.project, KotlinSourceFilterScope.Companion.sourceAndClassFiles(searchScope2, this.project));
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"KotlinTopLevelClassByPac\u2026es(searchScope, project))");
        return collection;
    }

    @Override
    public boolean packageExists(@NotNull FqName fqName2, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
        return PackageIndexUtil.packageExists(fqName2, KotlinSourceFilterScope.Companion.sourceAndClassFiles(scope2, this.project), this.project);
    }

    @Override
    @NotNull
    public Collection<FqName> getSubPackages(@NotNull FqName fqn, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkParameterIsNotNull((Object)fqn, (String)"fqn");
        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
        return PackageIndexUtil.getSubPackageFqNames(fqn, KotlinSourceFilterScope.Companion.sourceAndClassFiles(scope2, this.project), this.project, MemberScope.Companion.getALL_NAME_FILTER());
    }

    @Override
    @Nullable
    public KtLightClass getLightClass(@NotNull KtClassOrObject classOrObject) {
        PsiFile psiFile;
        Intrinsics.checkParameterIsNotNull((Object)classOrObject, (String)"classOrObject");
        VirtualFile virtualFile2 = classOrObject.getContainingFile().getVirtualFile();
        if (virtualFile2 != null) {
            if (ProjectRootsUtil.isProjectSourceFile(this.project, virtualFile2)) {
                return KtLightClassForSourceDeclaration.Companion.create(classOrObject);
            }
            if (ProjectRootsUtil.isLibraryClassFile(this.project, virtualFile2)) {
                return this.getLightClassForDecompiledClassOrObject(classOrObject);
            }
            if (ProjectRootsUtil.isLibrarySourceFile(this.project, virtualFile2)) {
                PsiClass psiClass2 = SourceNavigationHelper.INSTANCE.getOriginalClass(classOrObject);
                if (!(psiClass2 instanceof KtLightClass)) {
                    psiClass2 = null;
                }
                return (KtLightClass)psiClass2;
            }
        }
        if (!((psiFile = classOrObject.getContainingFile()) instanceof KtFile)) {
            psiFile = null;
        }
        KtFile ktFile = (KtFile)psiFile;
        if ((ktFile != null ? KtPsiFactoryKt.getAnalysisContext(ktFile) : null) != null) {
            return KtLightClassForSourceDeclaration.Companion.create(classOrObject);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PsiClass> withFakeLightClasses(KtLightClassForFacade lightClassForFacade, List<? extends KtFile> facadeFiles) {
        if (lightClassForFacade == null) {
            return CollectionsKt.emptyList();
        }
        ArrayList<KtLightClassForFacade> lightClasses = new ArrayList<KtLightClassForFacade>();
        lightClasses.add(lightClassForFacade);
        if (facadeFiles.size() > 1) {
            Collection<FakeLightClassForFileOfPackage> collection;
            void $receiver$iv$iv;
            void $receiver$iv;
            Iterable iterable = facadeFiles;
            ArrayList<KtLightClassForFacade> arrayList = lightClasses;
            void var5_6 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                KtFile ktFile = (KtFile)item$iv$iv;
                collection = destination$iv$iv;
                FakeLightClassForFileOfPackage fakeLightClassForFileOfPackage = new FakeLightClassForFileOfPackage(lightClassForFacade, (KtFile)it);
                collection.add(fakeLightClassForFileOfPackage);
            }
            collection = (List)destination$iv$iv;
            arrayList.addAll((Collection)collection);
        }
        return lightClasses;
    }

    @Override
    @NotNull
    public Collection<PsiClass> getFacadeClasses(@NotNull FqName facadeFqName, @NotNull GlobalSearchScope scope2) {
        Object $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)facadeFqName, (String)"facadeFqName");
        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
        Object $receiver$iv = this.findFilesForFacade(facadeFqName, scope2);
        Iterable iterable = $receiver$iv;
        Object destination$iv$iv = new LinkedHashMap();
        Object object = $receiver$iv$iv.iterator();
        while (object.hasNext()) {
            Object object2;
            Object $receiver$iv$iv$iv = destination$iv$iv;
            Object element$iv$iv = object.next();
            KtFile p1 = (KtFile)element$iv$iv;
            IdeaModuleInfo key$iv$iv = GetModuleInfoKt.getModuleInfo((PsiElement)p1);
            Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Map filesByModule = destination$iv$iv;
        $receiver$iv$iv = $receiver$iv = filesByModule;
        destination$iv$iv = new ArrayList();
        object = $receiver$iv$iv;
        Iterator iterator2 = object.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            Iterable list$iv$iv = this.createLightClassForFileFacade(facadeFqName, (List)it.getValue(), (IdeaModuleInfo)it.getKey());
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public Collection<PsiClass> getKotlinInternalClasses(@NotNull FqName fqName2, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
        if (fqName2.isRoot()) {
            return CollectionsKt.emptyList();
        }
        return CollectionsKt.plus((Collection)this.findPackageParts(fqName2, scope2), (Iterable)this.findPlatformWrapper(fqName2, scope2));
    }

    /*
     * WARNING - void declaration
     */
    private final List<KtLightClassForDecompiledDeclaration> findPackageParts(FqName fqName2, GlobalSearchScope scope2) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Collection<KtFile> facadeKtFiles = StaticFacadeIndexUtil.getMultifileClassForPart(fqName2, scope2, this.project);
        String partShortName = fqName2.shortName().asString();
        String partClassFileShortName = partShortName + ".class";
        Iterable iterable = $receiver$iv = (Iterable)facadeKtFiles;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            KtLightClassForDecompiledDeclaration ktLightClassForDecompiledDeclaration;
            KtLightClassForDecompiledDeclaration ktLightClassForDecompiledDeclaration2;
            Object element$iv$iv = element$iv$iv$iv;
            KtFile facadeKtFile = (KtFile)element$iv$iv;
            if (facadeKtFile instanceof KtClsFile) {
                if (((KtClsFile)facadeKtFile).getVirtualFile().getParent().findChild(partClassFileShortName) == null) {
                    ktLightClassForDecompiledDeclaration2 = null;
                } else {
                    ClsClassImpl javaClsClass;
                    VirtualFile partClassFile;
                    VirtualFile virtualFile2 = partClassFile;
                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"partClassFile");
                    ktLightClassForDecompiledDeclaration2 = this.createClsJavaClassFromVirtualFile(facadeKtFile, virtualFile2, null) == null ? null : new KtLightClassForDecompiledDeclaration(javaClsClass, null, (KtClsFile)facadeKtFile);
                }
            } else {
                ktLightClassForDecompiledDeclaration2 = null;
            }
            if (ktLightClassForDecompiledDeclaration2 == null) continue;
            KtLightClassForDecompiledDeclaration it$iv$iv = ktLightClassForDecompiledDeclaration = ktLightClassForDecompiledDeclaration2;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Collection<PsiClass> findPlatformWrapper(FqName fqName2, GlobalSearchScope scope2) {
        Object object;
        List list2;
        PsiClass psiClass2;
        PsiClass psiClass3 = PlatformWrappersKt.platformMutabilityWrapper(fqName2, (Function1<? super String, ? extends PsiClass>)((Function1)new Function1<String, PsiClass>(this, scope2){
            final /* synthetic */ IDELightClassGenerationSupport this$0;
            final /* synthetic */ GlobalSearchScope $scope;

            @Nullable
            public final PsiClass invoke(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return JavaPsiFacade.getInstance((Project)IDELightClassGenerationSupport.access$getProject$p(this.this$0)).findClass(it, this.$scope);
            }
            {
                this.this$0 = iDELightClassGenerationSupport;
                this.$scope = globalSearchScope;
                super(1);
            }
        }));
        if (psiClass3 != null) {
            PsiClass it = psiClass2 = psiClass3;
            list2 = CollectionsKt.listOf((Object)it);
        } else {
            list2 = null;
        }
        if ((object = (psiClass2 = list2)) == null) {
            object = CollectionsKt.emptyList();
        }
        return (Collection)object;
    }

    @NotNull
    public final List<PsiClass> createLightClassForFileFacade(@NotNull FqName facadeFqName, @NotNull List<? extends KtFile> facadeFiles, @NotNull IdeaModuleInfo moduleInfo) {
        List list2;
        Intrinsics.checkParameterIsNotNull((Object)facadeFqName, (String)"facadeFqName");
        Intrinsics.checkParameterIsNotNull(facadeFiles, (String)"facadeFiles");
        Intrinsics.checkParameterIsNotNull((Object)moduleInfo, (String)"moduleInfo");
        if (moduleInfo instanceof ModuleSourceInfo) {
            KtLightClassForFacade lightClassForFacade = KtLightClassForFacade.Factory.createForFacade(this.psiManager, facadeFqName, moduleInfo.contentScope(), (Collection<? extends KtFile>)facadeFiles);
            list2 = this.withFakeLightClasses(lightClassForFacade, facadeFiles);
        } else {
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)facadeFiles;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                if (!(element$iv$iv instanceof KtClsFile)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList();
            Iterable $receiver$iv$iv$iv = $receiver$iv$iv;
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                KtLightClassForDecompiledDeclaration ktLightClassForDecompiledDeclaration;
                Object element$iv$iv = element$iv$iv$iv;
                KtClsFile it = (KtClsFile)element$iv$iv;
                if (this.createLightClassForDecompiledKotlinFile(it) == null) continue;
                KtLightClassForDecompiledDeclaration it$iv$iv = ktLightClassForDecompiledDeclaration;
                destination$iv$iv.add(it$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        }
        return list2;
    }

    @Override
    @NotNull
    public Collection<KtFile> findFilesForFacade(@NotNull FqName facadeFqName, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkParameterIsNotNull((Object)facadeFqName, (String)"facadeFqName");
        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
        Object t = ApplicationUtilsKt.runReadAction((Function0)new Function0<Collection<KtFile>>(this, facadeFqName, scope2){
            final /* synthetic */ IDELightClassGenerationSupport this$0;
            final /* synthetic */ FqName $facadeFqName;
            final /* synthetic */ GlobalSearchScope $scope;

            public final Collection<KtFile> invoke() {
                String string = this.$facadeFqName.asString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"facadeFqName.asString()");
                Collection<KtFile> collection = KotlinFileFacadeFqNameIndex.INSTANCE.get(string, IDELightClassGenerationSupport.access$getProject$p(this.this$0), this.$scope);
                Intrinsics.checkExpressionValueIsNotNull(collection, (String)"KotlinFileFacadeFqNameIn\u2026String(), project, scope)");
                return collection;
            }
            {
                this.this$0 = iDELightClassGenerationSupport;
                this.$facadeFqName = fqName2;
                this.$scope = globalSearchScope;
                super(0);
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(t, (String)"runReadAction {\n        \u2026project, scope)\n        }");
        return (Collection)t;
    }

    @Override
    @Nullable
    public DeclarationDescriptor resolveToDescriptor(@NotNull KtDeclaration declaration2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        try {
            return ResolutionUtils.resolveToDescriptor$default(declaration2, null, 1, null);
        }
        catch (NoDescriptorForDeclarationException e) {
            return null;
        }
    }

    @Override
    @NotNull
    public BindingContext analyze(@NotNull KtElement element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return ResolutionUtils.analyze(element3, BodyResolveMode.PARTIAL);
    }

    @Override
    @NotNull
    public BindingContext analyzeFully(@NotNull KtElement element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return ResolutionUtils.analyzeFully(element3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<String> getFacadeNames(@NotNull FqName packageFqName, @NotNull GlobalSearchScope scope2) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
        Collection facadeFilesInPackage2 = (Collection)ApplicationUtilsKt.runReadAction((Function0)new Function0<Collection<KtFile>>(this, packageFqName, scope2){
            final /* synthetic */ IDELightClassGenerationSupport this$0;
            final /* synthetic */ FqName $packageFqName;
            final /* synthetic */ GlobalSearchScope $scope;

            public final Collection<KtFile> invoke() {
                KotlinFileFacadeClassByPackageIndex kotlinFileFacadeClassByPackageIndex = KotlinFileFacadeClassByPackageIndex.Companion.getInstance();
                String string = this.$packageFqName.asString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"packageFqName.asString()");
                return kotlinFileFacadeClassByPackageIndex.get(string, IDELightClassGenerationSupport.access$getProject$p(this.this$0), this.$scope);
            }
            {
                this.this$0 = iDELightClassGenerationSupport;
                this.$packageFqName = fqName2;
                this.$scope = globalSearchScope;
                super(0);
            }
        });
        Iterable iterable = $receiver$iv = (Iterable)facadeFilesInPackage2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            KtFile ktFile = (KtFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            String string = JvmFileClassUtilKt.getJavaFileFacadeFqName((KtFile)it).shortName().asString();
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<PsiClass> getFacadeClassesInPackage(@NotNull FqName packageFqName, @NotNull GlobalSearchScope scope2) {
        Object value$iv$iv$iv;
        Object key$iv$iv;
        Object $receiver$iv$iv$iv;
        Object $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
        Collection facadeFilesInPackage2 = (Collection)ApplicationUtilsKt.runReadAction((Function0)new Function0<Collection<KtFile>>(this, packageFqName, scope2){
            final /* synthetic */ IDELightClassGenerationSupport this$0;
            final /* synthetic */ FqName $packageFqName;
            final /* synthetic */ GlobalSearchScope $scope;

            public final Collection<KtFile> invoke() {
                KotlinFileFacadeClassByPackageIndex kotlinFileFacadeClassByPackageIndex = KotlinFileFacadeClassByPackageIndex.Companion.getInstance();
                String string = this.$packageFqName.asString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"packageFqName.asString()");
                return kotlinFileFacadeClassByPackageIndex.get(string, IDELightClassGenerationSupport.access$getProject$p(this.this$0), this.$scope);
            }
            {
                this.this$0 = iDELightClassGenerationSupport;
                this.$packageFqName = fqName2;
                this.$scope = globalSearchScope;
                super(0);
            }
        });
        Object $receiver$iv = facadeFilesInPackage2;
        Iterable iterable = $receiver$iv;
        Object destination$iv$iv = new LinkedHashMap();
        Object object = $receiver$iv$iv.iterator();
        while (object.hasNext()) {
            Object object2;
            $receiver$iv$iv$iv = destination$iv$iv;
            Object element$iv$iv = object.next();
            KtFile it = (KtFile)element$iv$iv;
            key$iv$iv = new Pair((Object)JvmFileClassUtilKt.getJavaFileFacadeFqName(it), (Object)GetModuleInfoKt.getModuleInfo((PsiElement)it));
            value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Map groupedByFqNameAndModuleInfo = destination$iv$iv;
        $receiver$iv$iv = $receiver$iv = groupedByFqNameAndModuleInfo;
        destination$iv$iv = new ArrayList();
        object = $receiver$iv$iv;
        Iterator iterator2 = object.entrySet().iterator();
        while (iterator2.hasNext()) {
            void fqName2;
            void key;
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            key$iv$iv = it;
            $receiver$iv$iv$iv = key$iv$iv;
            value$iv$iv$iv = (Pair)$receiver$iv$iv$iv.getKey();
            $receiver$iv$iv$iv = key$iv$iv;
            List files2 = (List)$receiver$iv$iv$iv.getValue();
            void var16_14 = key;
            key$iv$iv = (FqName)var16_14.component1();
            IdeaModuleInfo moduleInfo = (IdeaModuleInfo)var16_14.component2();
            Iterable list$iv$iv = this.createLightClassForFileFacade((FqName)fqName2, files2, moduleInfo);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final KtLightClassForDecompiledDeclaration getLightClassForDecompiledClassOrObject(KtClassOrObject decompiledClassOrObject) {
        if (decompiledClassOrObject instanceof KtEnumEntry) {
            return null;
        }
        PsiFile psiFile = decompiledClassOrObject.getContainingFile();
        if (!(psiFile instanceof KtClsFile)) {
            psiFile = null;
        }
        KtClsFile ktClsFile = (KtClsFile)psiFile;
        if (ktClsFile == null) {
            return null;
        }
        KtClsFile containingKtFile = ktClsFile;
        KtLightClassForDecompiledDeclaration ktLightClassForDecompiledDeclaration = this.createLightClassForDecompiledKotlinFile(containingKtFile);
        if (ktLightClassForDecompiledDeclaration == null) {
            return null;
        }
        KtLightClassForDecompiledDeclaration rootLightClassForDecompiledFile = ktLightClassForDecompiledDeclaration;
        return this.findCorrespondingLightClass(decompiledClassOrObject, rootLightClassForDecompiledFile);
    }

    private final KtLightClassForDecompiledDeclaration findCorrespondingLightClass(KtClassOrObject decompiledClassOrObject, KtLightClassForDecompiledDeclaration rootLightClassForDecompiledFile) {
        FqName relativeFqName = this.getClassRelativeName(decompiledClassOrObject);
        Iterator<Name> iterator2 = relativeFqName.pathSegments().iterator();
        Name base = iterator2.next();
        boolean bl = Intrinsics.areEqual((Object)rootLightClassForDecompiledFile.getName(), (Object)base.asString());
        if (_Assertions.ENABLED && !bl) {
            String string = "Light class for file:\n" + decompiledClassOrObject.getContainingKtFile().getVirtualFile().getCanonicalPath() + "\nwas expected to have name: " + base.asString() + "\n Actual: " + rootLightClassForDecompiledFile.getName();
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        KtLightClassForDecompiledDeclaration current = rootLightClassForDecompiledFile;
        while (iterator2.hasNext()) {
            PsiClass innerClass;
            Name name2 = iterator2.next();
            String string = name2.asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name.asString()");
            PsiClass $receiver$iv = current.findInnerClassByName(string, false);
            if ($receiver$iv == null) {
                AssertionError assertionError;
                AssertionError assertionError2 = assertionError;
                AssertionError assertionError3 = assertionError;
                String string2 = "Could not find corresponding inner/nested class " + relativeFqName + " in class " + decompiledClassOrObject.getFqName() + "\n" + "File: " + decompiledClassOrObject.getContainingKtFile().getVirtualFile().getName();
                assertionError2((Object)string2);
                throw (Throwable)((Object)assertionError3);
            }
            PsiClass psiClass2 = innerClass;
            if (psiClass2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.idea.caches.resolve.lightClasses.KtLightClassForDecompiledDeclaration");
            }
            current = (KtLightClassForDecompiledDeclaration)psiClass2;
        }
        return current;
    }

    private final FqName getClassRelativeName(KtClassOrObject decompiledClassOrObject) {
        Name name2 = decompiledClassOrObject.getNameAsName();
        if (name2 == null) {
            Intrinsics.throwNpe();
        }
        Name name3 = name2;
        KtClassOrObject parent2 = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)decompiledClassOrObject, KtClassOrObject.class, (boolean)true);
        if (parent2 == null) {
            boolean bl = decompiledClassOrObject.isTopLevel();
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            FqName fqName2 = FqName.topLevel(name3);
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"FqName.topLevel(name)");
            return fqName2;
        }
        FqName fqName3 = this.getClassRelativeName(parent2).child(name3);
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"getClassRelativeName(parent).child(name)");
        return fqName3;
    }

    /*
     * WARNING - void declaration
     */
    private final KtLightClassForDecompiledDeclaration createLightClassForDecompiledKotlinFile(KtClsFile file2) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        VirtualFile virtualFile2 = file2.getVirtualFile();
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile virtualFile3 = virtualFile2;
        Iterable iterable = $receiver$iv = (Iterable)file2.getDeclarations();
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof KtClassOrObject)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        KtClassOrObject classOrObject = (KtClassOrObject)CollectionsKt.singleOrNull((List)((List)destination$iv$iv));
        ClsClassImpl clsClassImpl = this.createClsJavaClassFromVirtualFile(file2, virtualFile3, classOrObject);
        if (clsClassImpl == null) {
            return null;
        }
        ClsClassImpl javaClsClass = clsClassImpl;
        return new KtLightClassForDecompiledDeclaration(javaClsClass, classOrObject, file2);
    }

    private final ClsClassImpl createClsJavaClassFromVirtualFile(KtFile mirrorFile, VirtualFile classFile, KtClassOrObject correspondingClassOrObject) {
        PsiJavaFileStubImpl psiJavaFileStubImpl = ClsJavaStubByVirtualFileCache.Companion.getInstance(this.project).get(classFile);
        if (psiJavaFileStubImpl == null) {
            return null;
        }
        PsiJavaFileStubImpl javaFileStub = psiJavaFileStubImpl;
        javaFileStub.setPsiFactory((StubPsiFactory)ClsWrapperStubPsiFactory.INSTANCE);
        PsiManager manager = PsiManager.getInstance((Project)mirrorFile.getProject());
        ClsFileImpl fakeFile2 = new ClsFileImpl(correspondingClassOrObject, javaFileStub, mirrorFile, manager, classFile, (FileViewProvider)new ClassFileViewProvider(manager, classFile)){
            final /* synthetic */ KtClassOrObject $correspondingClassOrObject;
            final /* synthetic */ PsiJavaFileStubImpl $javaFileStub;
            final /* synthetic */ KtFile $mirrorFile;
            final /* synthetic */ PsiManager $manager;
            final /* synthetic */ VirtualFile $classFile;

            @NotNull
            public PsiElement getNavigationElement() {
                if (this.$correspondingClassOrObject != null) {
                    PsiFile psiFile = this.$correspondingClassOrObject.getNavigationElement().getContainingFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"correspondingClassOrObje\u2026ionElement.containingFile");
                    return (PsiElement)psiFile;
                }
                PsiElement psiElement2 = super.getNavigationElement();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"super.getNavigationElement()");
                return psiElement2;
            }

            @NotNull
            public PsiJavaFileStubImpl getStub() {
                return this.$javaFileStub;
            }

            @NotNull
            public KtFile getMirror() {
                return this.$mirrorFile;
            }

            public boolean isPhysical() {
                return false;
            }
            {
                this.$correspondingClassOrObject = $captured_local_variable$0;
                this.$javaFileStub = $captured_local_variable$1;
                this.$mirrorFile = $captured_local_variable$2;
                this.$manager = $captured_local_variable$3;
                this.$classFile = $captured_local_variable$4;
                super($super_call_param$5);
            }
        };
        javaFileStub.setPsi((PsiFile)fakeFile2);
        Object object = ArraysKt.single((Object[])fakeFile2.getClasses());
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.impl.compiled.ClsClassImpl");
        }
        return (ClsClassImpl)object;
    }

    public IDELightClassGenerationSupport(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.scopeFileComparator = JavaElementFinder.byClasspathComparator(GlobalSearchScope.allScope((Project)this.project));
        PsiManager psiManager = PsiManager.getInstance((Project)this.project);
        Intrinsics.checkExpressionValueIsNotNull((Object)psiManager, (String)"PsiManager.getInstance(project)");
        this.psiManager = psiManager;
    }

    @NotNull
    public static final /* synthetic */ Project access$getProject$p(IDELightClassGenerationSupport $this) {
        return $this.project;
    }
}

