/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping;

import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.engine.RequestHint;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.Location;
import com.sun.jdi.VMDisconnectedException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinMethodFilter;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0005H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinStepOverInlinedLinesHint;", "Lcom/intellij/debugger/engine/RequestHint;", "stepThread", "Lcom/intellij/debugger/jdi/ThreadReferenceProxyImpl;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "methodFilter", "Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinMethodFilter;", "(Lcom/intellij/debugger/jdi/ThreadReferenceProxyImpl;Lcom/intellij/debugger/engine/SuspendContextImpl;Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinMethodFilter;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "filter", "getDepth", "", "getNextStepDepth", "context", "idea"})
public final class KotlinStepOverInlinedLinesHint
extends RequestHint {
    private final Logger LOG;
    private final KotlinMethodFilter filter;

    public int getDepth() {
        return 2;
    }

    public int getNextStepDepth(@NotNull SuspendContextImpl context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        try {
            StackFrameProxyImpl frameProxy = context.getFrameProxy();
            if (frameProxy != null) {
                if (this.isTheSameFrame(context)) {
                    Location location2 = frameProxy.location();
                    Intrinsics.checkExpressionValueIsNotNull((Object)location2, (String)"frameProxy.location()");
                    return this.filter.locationMatches(context, location2) ? 0 : 2;
                }
                if (this.isSteppedOut()) {
                    return 0;
                }
                return 3;
            }
        }
        catch (VMDisconnectedException frameProxy) {
        }
        catch (EvaluateException e) {
            this.LOG.error((Throwable)e);
        }
        return 0;
    }

    public KotlinStepOverInlinedLinesHint(@NotNull ThreadReferenceProxyImpl stepThread, @NotNull SuspendContextImpl suspendContext, @NotNull KotlinMethodFilter methodFilter2) {
        Intrinsics.checkParameterIsNotNull((Object)stepThread, (String)"stepThread");
        Intrinsics.checkParameterIsNotNull((Object)suspendContext, (String)"suspendContext");
        Intrinsics.checkParameterIsNotNull((Object)methodFilter2, (String)"methodFilter");
        super(stepThread, suspendContext, (MethodFilter)methodFilter2);
        this.LOG = Logger.getInstance(KotlinStepOverInlinedLinesHint.class);
        this.filter = methodFilter2;
    }
}

