/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DefinitionsScopedSearch;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.LeakingThisDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.quickfix.AddModifierFix;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/LeakingThisInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "Companion", "idea"})
public final class LeakingThisInspection
extends AbstractKotlinInspection {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        return new KtVisitorVoid(holder){
            final /* synthetic */ ProblemsHolder $holder;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void visitExpression(@NotNull KtExpression expression2) {
                void $receiver$iv;
                Collection elements$iv;
                KtClass klass2;
                KtClassOrObject ktClassOrObject;
                IntentionWrapper memberFix;
                IntentionWrapper intentionWrapper;
                Object[] modifierListOwner;
                CallableMemberDescriptor memberDescriptorToFix;
                String string;
                LeakingThisDescriptor leakingThisDescriptor;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                BindingContext context = ResolutionUtils.analyzeFully(expression2);
                LeakingThisDescriptor leakingThisDescriptor2 = (LeakingThisDescriptor)context.get(BindingContext.LEAKING_THIS, expression2);
                if (leakingThisDescriptor2 == null) {
                    return;
                }
                LeakingThisDescriptor leakingThisDescriptor3 = leakingThisDescriptor = leakingThisDescriptor2;
                if (leakingThisDescriptor3 instanceof LeakingThisDescriptor.NonFinalClass) {
                    if (!(expression2 instanceof KtThisExpression)) return;
                    string = "Leaking 'this' in constructor of non-final class " + ((LeakingThisDescriptor.NonFinalClass)leakingThisDescriptor).getKlass().getName();
                } else if (leakingThisDescriptor3 instanceof LeakingThisDescriptor.NonFinalProperty) {
                    string = "Accessing non-final property " + ((LeakingThisDescriptor.NonFinalProperty)leakingThisDescriptor).getProperty().getName() + " in constructor";
                } else {
                    if (!(leakingThisDescriptor3 instanceof LeakingThisDescriptor.NonFinalFunction)) return;
                    string = "Calling non-final function " + ((LeakingThisDescriptor.NonFinalFunction)leakingThisDescriptor).getFunction().getName() + " in constructor";
                }
                String description = string;
                LeakingThisDescriptor leakingThisDescriptor4 = leakingThisDescriptor;
                CallableMemberDescriptor callableMemberDescriptor = memberDescriptorToFix = leakingThisDescriptor4 instanceof LeakingThisDescriptor.NonFinalProperty ? (CallableMemberDescriptor)((LeakingThisDescriptor.NonFinalProperty)leakingThisDescriptor).getProperty() : (leakingThisDescriptor4 instanceof LeakingThisDescriptor.NonFinalFunction ? (CallableMemberDescriptor)((LeakingThisDescriptor.NonFinalFunction)leakingThisDescriptor).getFunction() : null);
                if (callableMemberDescriptor != null) {
                    CallableMemberDescriptor callableMemberDescriptor2 = callableMemberDescriptor;
                    CallableMemberDescriptor it = callableMemberDescriptor2;
                    if (Intrinsics.areEqual((Object)((Object)it.getModality()), (Object)((Object)Modality.OPEN))) {
                        PsiElement psiElement2 = DescriptorToSourceUtils.descriptorToDeclaration(it);
                        if (!(psiElement2 instanceof KtDeclaration)) {
                            psiElement2 = null;
                        }
                        modifierListOwner = (KtDeclaration)psiElement2;
                        intentionWrapper = org.jetbrains.kotlin.idea.inspections.LeakingThisInspection$Companion.access$createMakeFinalFix(LeakingThisInspection.Companion, (KtDeclaration)modifierListOwner);
                    } else {
                        intentionWrapper = null;
                    }
                } else {
                    intentionWrapper = memberFix = null;
                }
                if (!((ktClassOrObject = leakingThisDescriptor.getClassOrObject()) instanceof KtClass)) {
                    ktClassOrObject = null;
                }
                IntentionWrapper classFix = (klass2 = (KtClass)ktClassOrObject) != null && klass2.hasModifier(KtTokens.OPEN_KEYWORD) ? org.jetbrains.kotlin.idea.inspections.LeakingThisInspection$Companion.access$createMakeFinalFix(LeakingThisInspection.Companion, klass2) : null;
                modifierListOwner = leakingThisDescriptor;
                ProblemHighlightType problemHighlightType = modifierListOwner instanceof LeakingThisDescriptor.NonFinalProperty || modifierListOwner instanceof LeakingThisDescriptor.NonFinalFunction ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.WEAK_WARNING;
                modifierListOwner = new IntentionWrapper[]{memberFix, classFix};
                ProblemHighlightType problemHighlightType2 = problemHighlightType;
                String string2 = description;
                PsiElement psiElement3 = (PsiElement)expression2;
                ProblemsHolder problemsHolder = this.$holder;
                IntentionWrapper[] intentionWrapperArray = elements$iv;
                elements$iv = ArraysKt.filterNotNull((Object[])intentionWrapperArray);
                void v7 = $receiver$iv;
                if (v7 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                }
                void thisCollection$iv = v7;
                IntentionWrapper[] intentionWrapperArray2 = thisCollection$iv.toArray(new IntentionWrapper[thisCollection$iv.size()]);
                if (intentionWrapperArray2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                intentionWrapperArray = intentionWrapperArray2;
                LocalQuickFix[] localQuickFixArray = (LocalQuickFix[])intentionWrapperArray;
                problemsHolder.registerProblem(psiElement3, string2, problemHighlightType2, Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
            }
            {
                this.$holder = $captured_local_variable$0;
            }
        };
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/LeakingThisInspection$Companion;", "", "()V", "createMakeFinalFix", "Lcom/intellij/codeInspection/IntentionWrapper;", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "idea"})
    public static final class Companion {
        private final IntentionWrapper createMakeFinalFix(KtDeclaration declaration2) {
            if (declaration2 == null) {
                return null;
            }
            SearchScope useScope2 = declaration2.getUseScope();
            if (DefinitionsScopedSearch.search((PsiElement)declaration2, (SearchScope)useScope2).findFirst() != null) {
                return null;
            }
            KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject(declaration2);
            if (!(ktClassOrObject instanceof KtClass)) {
                ktClassOrObject = null;
            }
            KtClass ktClass2 = (KtClass)ktClassOrObject;
            if (ktClass2 != null ? ktClass2.isInterface() : false) {
                return null;
            }
            KtModifierListOwner ktModifierListOwner = declaration2;
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.FINAL_KEYWORD;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken), (String)"KtTokens.FINAL_KEYWORD");
            return new IntentionWrapper((IntentionAction)new AddModifierFix(ktModifierListOwner, ktModifierKeywordToken), declaration2.getContainingFile());
        }

        private Companion() {
        }

        @Nullable
        public static final /* synthetic */ IntentionWrapper access$createMakeFinalFix(Companion $this, @Nullable KtDeclaration declaration2) {
            return $this.createMakeFinalFix(declaration2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

