/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.inspections.NamingConventionInspection;
import org.jetbrains.kotlin.idea.quickfix.RenameIdentifierFix;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtVisitorVoid;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/PackageNameInspection;", "Lorg/jetbrains/kotlin/idea/inspections/NamingConventionInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "RenamePackageFix", "idea"})
public final class PackageNameInspection
extends NamingConventionInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        return new KtVisitorVoid(this, holder){
            final /* synthetic */ PackageNameInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;

            public void visitPackageDirective(@NotNull KtPackageDirective directive) {
                Intrinsics.checkParameterIsNotNull((Object)directive, (String)"directive");
                String qualifiedName2 = directive.getQualifiedName();
                CharSequence charSequence = qualifiedName2;
                if (charSequence.length() > 0) {
                    Regex regex = this.this$0.getNameRegex();
                    String string = qualifiedName2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"qualifiedName");
                    if (!regex.matches((CharSequence)string)) {
                        KtExpression ktExpression = directive.getPackageNameExpression();
                        if (ktExpression == null) {
                            Intrinsics.throwNpe();
                        }
                        this.$holder.registerProblem((PsiElement)ktExpression, "Package name <code>#ref</code> doesn't match regex '" + this.this$0.getNamePattern() + "' #loc", new LocalQuickFix[]{new RenamePackageFix()});
                    }
                }
            }
            {
                this.this$0 = $outer;
                this.$holder = $captured_local_variable$1;
            }
        };
    }

    public PackageNameInspection() {
        super("Package", "[a-z][A-Za-z\\d\\.]*");
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0014\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/PackageNameInspection$RenamePackageFix;", "Lorg/jetbrains/kotlin/idea/quickfix/RenameIdentifierFix;", "()V", "getElementToRename", "Lcom/intellij/psi/PsiElement;", "element", "idea"})
    private static final class RenamePackageFix
    extends RenameIdentifierFix {
        @Override
        @Nullable
        protected PsiElement getElementToRename(@NotNull PsiElement element3) {
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            PsiElement psiElement2 = element3;
            if (!(psiElement2 instanceof KtPackageDirective)) {
                psiElement2 = null;
            }
            KtPackageDirective ktPackageDirective = (KtPackageDirective)psiElement2;
            if (ktPackageDirective == null) {
                return null;
            }
            KtPackageDirective packageDirective = ktPackageDirective;
            return (PsiElement)JavaPsiFacade.getInstance((Project)((KtPackageDirective)element3).getProject()).findPackage(packageDirective.getQualifiedName());
        }
    }
}

