/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.RedundantSemicolonInspection;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtStatementExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010\u000f\u001a\u00020\t*\u0004\u0018\u00010\u000eH\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RedundantSemicolonInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "Lcom/intellij/codeInspection/CleanupLocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "isRedundant", "semicolon", "Lcom/intellij/psi/PsiElement;", "isLineBreak", "Fix", "idea"})
public final class RedundantSemicolonInspection
extends AbstractKotlinInspection
implements CleanupLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        return new PsiElementVisitor(this, holder){
            final /* synthetic */ RedundantSemicolonInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;

            public void visitElement(@NotNull PsiElement element3) {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                super.visitElement(element3);
                if (Intrinsics.areEqual((Object)element3.getNode().getElementType(), (Object)((Object)KtTokens.SEMICOLON)) && RedundantSemicolonInspection.access$isRedundant(this.this$0, element3)) {
                    this.$holder.registerProblem(element3, "Redundant semicolon", ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{Fix.INSTANCE});
                }
            }
            {
                this.this$0 = $outer;
                this.$holder = $captured_local_variable$1;
            }
        };
    }

    private final boolean isRedundant(PsiElement semicolon2) {
        KtStatementExpression ktStatementExpression;
        KtClass it;
        boolean isAtEndOfLine;
        PsiElement nextLeaf2 = PsiUtilsKt.nextLeaf(semicolon2, (Function1<? super PsiElement, Boolean>)((Function1)new Function1<PsiElement, Boolean>(this){
            final /* synthetic */ RedundantSemicolonInspection this$0;

            public final boolean invoke(@NotNull PsiElement it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return !(it instanceof PsiWhiteSpace) && !(it instanceof PsiComment) || RedundantSemicolonInspection.access$isLineBreak(this.this$0, it);
            }
            {
                this.this$0 = redundantSemicolonInspection;
                super(1);
            }
        }));
        boolean bl = isAtEndOfLine = nextLeaf2 == null || this.isLineBreak(nextLeaf2);
        if (!isAtEndOfLine) {
            if (semicolon2.getParent() instanceof KtPackageDirective) {
                Object object;
                PsiElement psiElement2 = nextLeaf2;
                if (!(psiElement2 instanceof KtImportList)) {
                    psiElement2 = null;
                }
                if ((object = (KtImportList)psiElement2) != null && (object = ((KtImportList)object).getImports()) != null ? object.isEmpty() : false) {
                    return true;
                }
            }
            return false;
        }
        if (semicolon2.getParent() instanceof KtEnumEntry) {
            return false;
        }
        PsiElement psiElement3 = semicolon2.getParent().getParent();
        if (!(psiElement3 instanceof KtClass)) {
            psiElement3 = null;
        }
        KtClass ktClass2 = (KtClass)psiElement3;
        if (ktClass2 != null && (it = (ktStatementExpression = ktClass2)).isEnum()) {
            PsiElement psiElement4;
            Object $receiver$iv = (Object[])it;
            PsiElement[] psiElementArray = PsiTreeUtil.getChildrenOfType((PsiElement)$receiver$iv, KtEnumEntry.class);
            if (psiElementArray == null) {
                Object[] elements$iv$iv = new KtEnumEntry[0];
                psiElementArray = (PsiElement[])elements$iv$iv;
            }
            $receiver$iv = psiElementArray;
            if (((Object[])$receiver$iv).length == 0 && Intrinsics.areEqual((Object)((psiElement4 = PsiUtilsKt.prevLeaf(semicolon2, (Function1<? super PsiElement, Boolean>)((Function1)new Function1<PsiElement, Boolean>(this, semicolon2){
                final /* synthetic */ RedundantSemicolonInspection this$0;
                final /* synthetic */ PsiElement $semicolon$inlined;
                {
                    this.this$0 = redundantSemicolonInspection;
                    this.$semicolon$inlined = psiElement2;
                    super(1);
                }

                public final boolean invoke(@NotNull PsiElement it) {
                    return !(it instanceof PsiWhiteSpace) && !(it instanceof PsiComment) && !RedundantSemicolonInspection.access$isLineBreak(this.this$0, it);
                }
            }))) != null && (psiElement4 = psiElement4.getNode()) != null ? psiElement4.getElementType() : null), (Object)((Object)KtTokens.LBRACE)) && !($receiver$iv = (Collection)it.getDeclarations()).isEmpty()) {
                return false;
            }
        }
        PsiElement psiElement5 = PsiUtilsKt.prevLeaf$default(semicolon2, false, 1, null);
        Object object = psiElement5 != null ? psiElement5.getParent() : null;
        if (!(object instanceof KtLoopExpression)) {
            object = null;
        }
        KtLoopExpression ktLoopExpression = (KtLoopExpression)object;
        if (ktLoopExpression != null && !((it = (ktStatementExpression = ktLoopExpression)) instanceof KtDoWhileExpression) && ((KtLoopExpression)((Object)it)).getBody() == null) {
            return false;
        }
        PsiElement psiElement6 = nextLeaf2;
        return !Intrinsics.areEqual(psiElement6 != null && (psiElement6 = PsiUtilsKt.nextLeaf(psiElement6, (Function1<? super PsiElement, Boolean>)((Function1)isRedundant.3.INSTANCE))) != null && (psiElement6 = psiElement6.getNode()) != null ? psiElement6.getElementType() : null, (Object)((Object)KtTokens.LBRACE));
    }

    private final boolean isLineBreak(@Nullable PsiElement $receiver) {
        return $receiver instanceof PsiWhiteSpace && $receiver.textContains('\n');
    }

    public static final /* synthetic */ boolean access$isRedundant(RedundantSemicolonInspection $this, @NotNull PsiElement semicolon2) {
        return $this.isRedundant(semicolon2);
    }

    public static final /* synthetic */ boolean access$isLineBreak(RedundantSemicolonInspection $this, @Nullable PsiElement $receiver) {
        return $this.isLineBreak($receiver);
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RedundantSemicolonInspection$Fix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "idea"})
    private static final class Fix
    implements LocalQuickFix {
        public static final Fix INSTANCE;

        @NotNull
        public String getName() {
            return "Remove redundant semicolon";
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            if (!FileModificationService.getInstance().preparePsiElementForWrite(descriptor2.getPsiElement())) {
                return;
            }
            descriptor2.getPsiElement().delete();
        }

        private Fix() {
            INSTANCE = this;
        }

        static {
            new Fix();
        }
    }
}

