/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.intentions.ConvertPrimaryConstructorToSecondaryIntention;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.intentions.SpecifyTypeExplicitlyIntention;
import org.jetbrains.kotlin.idea.util.CommentSaver;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtClassOrObjectKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationStub;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\u001a\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00022\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J*\u0010\u0010\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001c\u0010\u0017\u001a\u00020\u0014*\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001c\u0010\u0017\u001a\u00020\u0014*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertPrimaryConstructorToSecondaryIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtPrimaryConstructor;", "()V", "addSemicolonIfNotExist", "", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "factory", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "lastEnumEntry", "Lorg/jetbrains/kotlin/psi/KtEnumEntry;", "applyTo", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "convertValueParametersToProperties", "anchorBefore", "Lcom/intellij/psi/PsiElement;", "isApplicableTo", "", "caretOffset", "", "isIndependent", "Lorg/jetbrains/kotlin/psi/KtProperty;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "idea"})
public final class ConvertPrimaryConstructorToSecondaryIntention
extends SelfTargetingIntention<KtPrimaryConstructor> {
    @Override
    public boolean isApplicableTo(@NotNull KtPrimaryConstructor element3, int caretOffset) {
        boolean bl;
        block6: {
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject(element3);
            if (!(ktClassOrObject instanceof KtClass)) {
                ktClassOrObject = null;
            }
            KtClass ktClass2 = (KtClass)ktClassOrObject;
            if (ktClass2 == null) {
                return false;
            }
            KtClass containingClass = ktClass2;
            if (containingClass.isAnnotation() || containingClass.isData()) {
                return false;
            }
            Iterable $receiver$iv = element3.getValueParameters();
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $receiver$iv) {
                    KtParameter it = (KtParameter)element$iv;
                    if (!it.hasValOrVar() || it.getAnnotationEntries().isEmpty()) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final boolean isIndependent(@NotNull KtReferenceExpression $receiver, ClassDescriptor classDescriptor, BindingContext context) {
        boolean bl;
        DeclarationDescriptor referencedDescriptor;
        DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)context.get(BindingContext.REFERENCE_TARGET, $receiver);
        if (declarationDescriptor == null) {
            return false;
        }
        DeclarationDescriptor declarationDescriptor2 = referencedDescriptor = declarationDescriptor;
        if (declarationDescriptor2 instanceof ValueParameterDescriptor) {
            CallableDescriptor callableDescriptor = ((ValueParameterDescriptor)referencedDescriptor).getContainingDeclaration();
            if (!(callableDescriptor instanceof ConstructorDescriptor)) {
                callableDescriptor = null;
            }
            ConstructorDescriptor constructorDescriptor = (ConstructorDescriptor)callableDescriptor;
            bl = Intrinsics.areEqual((Object)(constructorDescriptor != null ? constructorDescriptor.getContainingDeclaration() : null), (Object)classDescriptor) ^ true;
        } else {
            bl = !SequencesKt.contains(DescriptorUtilsKt.getParents(referencedDescriptor), (Object)classDescriptor);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isIndependent(@NotNull KtProperty $receiver, KtClass klass2, BindingContext context) {
        void result$iv$iv$iv;
        void $receiver$iv;
        void $receiver$iv$iv;
        KtExpression ktExpression = $receiver.getInitializer();
        if (ktExpression == null) {
            return true;
        }
        KtExpression propertyInitializer = ktExpression;
        ClassDescriptor classDescriptor = (ClassDescriptor)context.get(BindingContext.CLASS, klass2);
        if (classDescriptor == null) {
            return false;
        }
        ClassDescriptor classDescriptor2 = classDescriptor;
        PsiElement psiElement2 = (PsiElement)propertyInitializer;
        Function1 predicate$iv = (Function1)new Function1<KtReferenceExpression, Boolean>(this, classDescriptor2, context){
            final /* synthetic */ ConvertPrimaryConstructorToSecondaryIntention this$0;
            final /* synthetic */ ClassDescriptor $classDescriptor;
            final /* synthetic */ BindingContext $context;

            public final boolean invoke(@NotNull KtReferenceExpression it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                ClassDescriptor classDescriptor = this.$classDescriptor;
                Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor, (String)"classDescriptor");
                return !ConvertPrimaryConstructorToSecondaryIntention.access$isIndependent(this.this$0, it, classDescriptor, this.$context);
            }
            {
                this.this$0 = convertPrimaryConstructorToSecondaryIntention;
                this.$classDescriptor = classDescriptor;
                this.$context = bindingContext2;
                super(1);
            }
        };
        void $receiver$iv$iv$iv = $receiver$iv$iv = $receiver$iv;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        $receiver$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, (Ref.ObjectRef)result$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $captured_local_variable$0;
                this.$result = $captured_local_variable$1;
            }

            public void visitElement(@NotNull PsiElement element3) {
                if (element3 instanceof KtReferenceExpression && ((Boolean)this.$predicate.invoke((Object)element3)).booleanValue()) {
                    this.$result.element = element3;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element3;
                super.visitElement(element3);
            }
        });
        return !((PsiElement)result$iv$iv$iv.element != null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void applyTo(@NotNull KtPrimaryConstructor element3, @Nullable Editor editor) {
        KtEnumEntry lastEnumEntry;
        KtDeclarationStub ktDeclarationStub;
        CommentSaver commentSaver;
        KtPsiFactory factory2;
        KtClass klass2;
        block38: {
            void this_$iv;
            Object iterator$iv;
            KtSecondaryConstructor constructor2;
            block37: {
                KtSecondaryConstructor ktSecondaryConstructor;
                void this_$iv2;
                KtDeclaration ktDeclaration;
                KtDeclaration ktDeclaration2;
                KtDeclaration it;
                Object it2;
                block36: {
                    void $receiver$iv$iv;
                    void $receiver$iv$iv2;
                    void $receiver$iv$iv3;
                    Object annotations2;
                    Object object;
                    Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                    KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject(element3);
                    if (!(ktClassOrObject instanceof KtClass)) {
                        ktClassOrObject = null;
                    }
                    KtClass ktClass2 = (KtClass)ktClassOrObject;
                    if (ktClass2 == null) {
                        return;
                    }
                    klass2 = ktClass2;
                    if (klass2.isAnnotation()) {
                        return;
                    }
                    BindingContext context = ResolutionUtils.analyze$default(klass2, null, 1, null);
                    factory2 = KtPsiFactoryKt.KtPsiFactory$default(klass2, false, 2, null);
                    commentSaver = new CommentSaver(element3, false, 2, null);
                    Map initializerMap = new LinkedHashMap();
                    for (KtProperty property2 : klass2.getProperties()) {
                        Object object2;
                        KtExpression initializer2;
                        if (this.isIndependent(property2, klass2, context)) continue;
                        if (property2.getTypeReference() == null) {
                            new SpecifyTypeExplicitlyIntention().applyTo(property2, editor);
                        }
                        if (property2.getInitializer() == null) {
                            Intrinsics.throwNpe();
                        }
                        object = initializerMap;
                        Intrinsics.checkExpressionValueIsNotNull((Object)initializer2.getText(), (String)"initializer.text");
                        object.put(property2, object2);
                        initializer2.delete();
                        PsiElement psiElement2 = property2.getEqualsToken();
                        if (psiElement2 == null) {
                            Intrinsics.throwNpe();
                        }
                        psiElement2.delete();
                    }
                    KtPsiFactory.CallableBuilder callableBuilder = new KtPsiFactory.CallableBuilder(KtPsiFactory.CallableBuilder.Target.CONSTRUCTOR);
                    KtPsiFactory ktPsiFactory = factory2;
                    Object $receiver = callableBuilder;
                    KtModifierList ktModifierList = element3.getModifierList();
                    if (ktModifierList != null) {
                        it2 = object = ktModifierList;
                        String string = it2.getText();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.text");
                        ((KtPsiFactory.CallableBuilder)$receiver).modifier(string);
                    }
                    KtPsiFactory.CallableBuilder.typeParams$default((KtPsiFactory.CallableBuilder)$receiver, null, 1, null);
                    KtPsiFactory.CallableBuilder.name$default((KtPsiFactory.CallableBuilder)$receiver, null, 1, null);
                    for (KtParameter valueParameter : element3.getValueParameters()) {
                        annotations2 = CollectionsKt.joinToString$default((Iterable)valueParameter.getAnnotationEntries(), (CharSequence)" ", null, null, (int)0, null, (Function1)applyTo.constructor.1.annotations.1.INSTANCE, (int)30, null);
                        String vararg = valueParameter.isVarArg() ? KtTokens.VARARG_KEYWORD.getValue() : "";
                        StringBuilder stringBuilder = new StringBuilder().append("").append((String)annotations2).append(' ').append(vararg).append(' ');
                        String string = valueParameter.getName();
                        if (string == null) {
                            string = "";
                        }
                        String string2 = stringBuilder.append(string).toString();
                        Object object3 = valueParameter.getTypeReference();
                        if (object3 == null || (object3 = object3.getText()) == null) {
                            object3 = "";
                        }
                        KtExpression ktExpression = valueParameter.getDefaultValue();
                        ((KtPsiFactory.CallableBuilder)$receiver).param(string2, (String)object3, ktExpression != null ? ktExpression.getText() : null);
                    }
                    ((KtPsiFactory.CallableBuilder)$receiver).noReturnType();
                    for (KtSuperTypeListEntry superTypeEntry : klass2.getSuperTypeListEntries()) {
                        if (!(superTypeEntry instanceof KtSuperTypeCallEntry)) continue;
                        Object object4 = ((KtSuperTypeCallEntry)superTypeEntry).getValueArgumentList();
                        if (object4 == null || (object4 = object4.getText()) == null) {
                            object4 = "";
                        }
                        ((KtPsiFactory.CallableBuilder)$receiver).superDelegation((String)object4);
                        KtTypeReference ktTypeReference = ((KtSuperTypeCallEntry)superTypeEntry).getTypeReference();
                        if (ktTypeReference == null) {
                            Intrinsics.throwNpe();
                        }
                        String string = ktTypeReference.getText();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"superTypeEntry.typeReference!!.text");
                        superTypeEntry.replace((PsiElement)factory2.createSuperTypeEntry(string));
                    }
                    Iterable $receiver$iv = element3.getValueParameters();
                    annotations2 = $receiver$iv;
                    Iterable destination$iv$iv = new ArrayList();
                    for (Object element$iv$iv : $receiver$iv$iv3) {
                        KtParameter it3 = (KtParameter)element$iv$iv;
                        if (!it3.hasValOrVar()) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    String valueParameterInitializers2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, (Function1)applyTo.constructor.1.valueParameterInitializers.2.INSTANCE, (int)30, null);
                    Iterable $receiver$iv2 = klass2.getDeclarations();
                    destination$iv$iv = $receiver$iv2;
                    Iterable destination$iv$iv2 = new ArrayList();
                    for (Object element$iv$iv : $receiver$iv$iv2) {
                        KtDeclaration it4 = (KtDeclaration)element$iv$iv;
                        if (!(it4 instanceof KtProperty && initializerMap.get(it4) != null || it4 instanceof KtAnonymousInitializer)) continue;
                        destination$iv$iv2.add(element$iv$iv);
                    }
                    String classBodyInitializers2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv2), (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<KtDeclaration, CharSequence>(element3, klass2, factory2, initializerMap){
                        final /* synthetic */ KtPrimaryConstructor $element$inlined;
                        final /* synthetic */ KtClass $klass$inlined;
                        final /* synthetic */ KtPsiFactory $factory$inlined;
                        final /* synthetic */ Map $initializerMap$inlined;
                        {
                            this.$element$inlined = ktPrimaryConstructor;
                            this.$klass$inlined = ktClass2;
                            this.$factory$inlined = ktPsiFactory;
                            this.$initializerMap$inlined = map2;
                            super(1);
                        }

                        @NotNull
                        public final CharSequence invoke(@NotNull KtDeclaration it) {
                            CharSequence charSequence;
                            if (it instanceof KtProperty) {
                                String string = ((KtProperty)it).getName();
                                if (string == null) {
                                    Intrinsics.throwNpe();
                                }
                                String name2 = string;
                                String text2 = (String)this.$initializerMap$inlined.get(it);
                                charSequence = text2 != null ? "" + KtTokens.THIS_KEYWORD.getValue() + '.' + name2 + " = " + text2 : "";
                            } else {
                                Object object;
                                KtExpression ktExpression = ((KtAnonymousInitializer)it).getBody();
                                if (!(ktExpression instanceof KtBlockExpression)) {
                                    ktExpression = null;
                                }
                                charSequence = (object = (KtBlockExpression)ktExpression) != null && (object = ((KtBlockExpression)object).getStatements()) != null && (object = CollectionsKt.joinToString$default((Iterable)((Iterable)object), (CharSequence)"\n", null, null, (int)0, null, (Function1)applyTo.constructor.1.classBodyInitializers.1.INSTANCE, (int)30, null)) != null ? (CharSequence)object : (CharSequence)"";
                            }
                            return charSequence;
                        }
                    }), (int)30, null);
                    Iterable $receiver$iv3 = CollectionsKt.listOf((Object[])new String[]{valueParameterInitializers2, classBodyInitializers2});
                    destination$iv$iv2 = $receiver$iv3;
                    Collection destination$iv$iv3 = new ArrayList();
                    for (Object element$iv$iv : $receiver$iv$iv) {
                        String p1 = (String)element$iv$iv;
                        CharSequence $i$f$filterTo = p1;
                        if (!($i$f$filterTo.length() > 0)) continue;
                        destination$iv$iv3.add(element$iv$iv);
                    }
                    List allInitializers = (List)destination$iv$iv3;
                    $receiver$iv3 = allInitializers;
                    if (!$receiver$iv3.isEmpty()) {
                        ((KtPsiFactory.CallableBuilder)$receiver).blockBody(CollectionsKt.joinToString$default((Iterable)allInitializers, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
                    }
                    Object object5 = callableBuilder;
                    constructor2 = ktPsiFactory.createSecondaryConstructor(((KtPsiFactory.CallableBuilder)object5).asString());
                    List<KtDeclaration> $receiver$iv4 = klass2.getDeclarations();
                    iterator$iv = $receiver$iv4.listIterator($receiver$iv4.size());
                    while (iterator$iv.hasPrevious()) {
                        KtDeclaration element$iv = iterator$iv.previous();
                        it = element$iv;
                        if (!(it instanceof KtEnumEntry)) continue;
                        ktDeclaration2 = element$iv;
                        break block36;
                    }
                    ktDeclaration2 = ktDeclaration = null;
                }
                if (!(ktDeclaration2 instanceof KtEnumEntry)) {
                    ktDeclaration = null;
                }
                if ((ktDeclarationStub = (lastEnumEntry = (KtEnumEntry)ktDeclaration)) == null) break block37;
                it2 = iterator$iv = ktDeclarationStub;
                it = klass2;
                KtDeclaration declaration$iv = constructor2;
                PsiElement psiElement3 = (PsiElement)it2;
                if (psiElement3 == null) {
                    psiElement3 = (PsiElement)CollectionsKt.lastOrNull(this_$iv2.getDeclarations());
                }
                if (psiElement3 == null) {
                    void this_$iv$iv = this_$iv2;
                    KtClassBody body$iv$iv = KtClassOrObjectKt.getOrCreateBody((KtClassOrObject)this_$iv$iv);
                    PsiElement psiElement4 = body$iv$iv.getRBrace();
                    if (psiElement4 == null && (psiElement4 = body$iv$iv.getLastChild()) == null) {
                        Intrinsics.throwNpe();
                    }
                    PsiElement anchor$iv$iv = PsiTreeUtil.skipSiblingsBackward((PsiElement)psiElement4, (Class[])new Class[]{PsiWhiteSpace.class});
                    PsiElement psiElement5 = body$iv$iv.addAfter(declaration$iv, anchor$iv$iv);
                    if (psiElement5 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtSecondaryConstructor");
                    }
                    ktSecondaryConstructor = (KtSecondaryConstructor)psiElement5;
                } else {
                    PsiElement anchorBefore$iv = psiElement3;
                    PsiElement psiElement6 = KtClassOrObjectKt.getOrCreateBody((KtClassOrObject)this_$iv2).addAfter(declaration$iv, anchorBefore$iv);
                    if (psiElement6 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtSecondaryConstructor");
                    }
                    ktSecondaryConstructor = (KtSecondaryConstructor)psiElement6;
                }
                ktDeclarationStub = ktSecondaryConstructor;
                if (ktSecondaryConstructor != null) break block38;
            }
            iterator$iv = klass2;
            Object anchor$iv = null;
            PsiElement psiElement7 = (PsiElement)CollectionsKt.firstOrNull(this_$iv.getDeclarations());
            if (psiElement7 == null) {
                void this_$iv$iv = this_$iv;
                KtClassBody body$iv$iv = KtClassOrObjectKt.getOrCreateBody((KtClassOrObject)this_$iv$iv);
                PsiElement psiElement8 = body$iv$iv.getRBrace();
                if (psiElement8 == null && (psiElement8 = body$iv$iv.getLastChild()) == null) {
                    Intrinsics.throwNpe();
                }
                PsiElement anchor$iv$iv = PsiTreeUtil.skipSiblingsBackward((PsiElement)psiElement8, (Class[])new Class[]{PsiWhiteSpace.class});
                PsiElement psiElement9 = body$iv$iv.addAfter(constructor2, anchor$iv$iv);
                if (psiElement9 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtSecondaryConstructor");
                }
                ktDeclarationStub = (KtSecondaryConstructor)psiElement9;
            } else {
                PsiElement anchorAfter$iv = psiElement7;
                PsiElement psiElement10 = KtClassOrObjectKt.getOrCreateBody((KtClassOrObject)this_$iv).addBefore(constructor2, anchorAfter$iv);
                if (psiElement10 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtSecondaryConstructor");
                }
                ktDeclarationStub = (KtSecondaryConstructor)psiElement10;
            }
        }
        KtDeclarationStub secondaryConstructor = ktDeclarationStub;
        CommentSaver.restore$default(commentSaver, secondaryConstructor, false, 2, null);
        this.convertValueParametersToProperties(element3, klass2, factory2, lastEnumEntry);
        if (klass2.isEnum()) {
            this.addSemicolonIfNotExist(klass2, factory2, lastEnumEntry);
        }
        for (KtAnonymousInitializer anonymousInitializer : klass2.getAnonymousInitializers()) {
            anonymousInitializer.delete();
        }
        element3.delete();
    }

    private final void convertValueParametersToProperties(KtPrimaryConstructor element3, KtClass klass2, KtPsiFactory factory2, PsiElement anchorBefore) {
        for (KtParameter valueParameter : CollectionsKt.reversed((Iterable)element3.getValueParameters())) {
            KtClass this_$iv;
            if (!valueParameter.hasValOrVar()) continue;
            boolean isVararg = valueParameter.hasModifier(KtTokens.VARARG_KEYWORD);
            valueParameter.removeModifier(KtTokens.VARARG_KEYWORD);
            KtTypeReference ktTypeReference = valueParameter.getTypeReference();
            String typeText = ktTypeReference != null ? ktTypeReference.getText() : null;
            KtModifierList ktModifierList = valueParameter.getModifierList();
            String string = ktModifierList != null ? ktModifierList.getText() : null;
            String string2 = valueParameter.getName();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"valueParameter.name!!");
            KtProperty property2 = factory2.createProperty(string, string2, isVararg && typeText != null ? "Array<out " + typeText + '>' : typeText, valueParameter.isMutable(), null);
            if (anchorBefore == null) {
                PsiElement anchorAfter$iv;
                KtClass ktClass2 = klass2;
                Object anchor$iv = null;
                if ((PsiElement)CollectionsKt.firstOrNull(this_$iv.getDeclarations()) == null) {
                    KtClass this_$iv$iv = this_$iv;
                    KtClassBody body$iv$iv = KtClassOrObjectKt.getOrCreateBody(this_$iv$iv);
                    PsiElement psiElement2 = body$iv$iv.getRBrace();
                    if (psiElement2 == null && (psiElement2 = body$iv$iv.getLastChild()) == null) {
                        Intrinsics.throwNpe();
                    }
                    PsiElement anchor$iv$iv = PsiTreeUtil.skipSiblingsBackward((PsiElement)psiElement2, (Class[])new Class[]{PsiWhiteSpace.class});
                    PsiElement psiElement3 = body$iv$iv.addAfter(property2, anchor$iv$iv);
                    if (psiElement3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtProperty");
                    }
                    KtProperty cfr_ignored_0 = (KtProperty)psiElement3;
                    continue;
                }
                PsiElement psiElement4 = KtClassOrObjectKt.getOrCreateBody(this_$iv).addBefore(property2, anchorAfter$iv);
                if (psiElement4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtProperty");
                }
                KtProperty cfr_ignored_1 = (KtProperty)psiElement4;
                continue;
            }
            this_$iv = klass2;
            PsiElement anchorBefore$iv = anchorBefore;
            PsiElement psiElement5 = KtClassOrObjectKt.getOrCreateBody(this_$iv).addAfter(property2, anchorBefore$iv);
            if (psiElement5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtProperty");
            }
            KtProperty cfr_ignored_2 = (KtProperty)psiElement5;
        }
    }

    private final void addSemicolonIfNotExist(KtClass klass2, KtPsiFactory factory2, KtEnumEntry lastEnumEntry) {
        if (lastEnumEntry == null) {
            KtClassBody ktClassBody;
            KtClassBody it = ktClassBody = KtClassOrObjectKt.getOrCreateBody(klass2);
            it.addAfter(factory2.createSemicolon(), it.getLBrace());
        } else {
            boolean bl;
            block5: {
                Object[] $receiver$iv = (Object[])lastEnumEntry;
                PsiElement[] psiElementArray = PsiTreeUtil.getChildrenOfType((PsiElement)$receiver$iv, LeafPsiElement.class);
                if (psiElementArray == null) {
                    Object[] elements$iv$iv = new LeafPsiElement[0];
                    psiElementArray = (PsiElement[])elements$iv$iv;
                }
                $receiver$iv = psiElementArray;
                for (int i = 0; i < $receiver$iv.length; ++i) {
                    Object element$iv = $receiver$iv[i];
                    LeafPsiElement it = (LeafPsiElement)element$iv;
                    if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)((Object)KtTokens.SEMICOLON))) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
            if (bl) {
                lastEnumEntry.add(factory2.createSemicolon());
            }
        }
    }

    public ConvertPrimaryConstructorToSecondaryIntention() {
        super(KtPrimaryConstructor.class, "Convert to secondary constructor", null, 4, null);
    }

    public static final /* synthetic */ boolean access$isIndependent(ConvertPrimaryConstructorToSecondaryIntention $this, @NotNull KtReferenceExpression $receiver, @NotNull ClassDescriptor classDescriptor, @NotNull BindingContext context) {
        return $this.isIndependent($receiver, classDescriptor, context);
    }
}

