/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringFactory;
import com.intellij.refactoring.RenameRefactoring;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.refactoring.rename.RenameHandlerRegistry;
import java.awt.Component;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\nH\u0014J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\nH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RenameIdentifierFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getElementToRename", "Lcom/intellij/psi/PsiElement;", "element", "getFamilyName", "", "getName", "renameWithoutEditor", "startInWriteAction", "", "idea"})
public class RenameIdentifierFix
implements LocalQuickFix {
    @NotNull
    public String getName() {
        return "Rename";
    }

    @NotNull
    public String getFamilyName() {
        return this.getName();
    }

    public boolean startInWriteAction() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        block6: {
            void elements$iv;
            RenameHandler renameHandler;
            DataContext dataContext;
            PsiElement element3;
            block5: {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
                PsiElement psiElement2 = descriptor2.getPsiElement();
                if (psiElement2 == null) {
                    return;
                }
                element3 = psiElement2;
                PsiFile psiFile = element3.getContainingFile();
                if (psiFile == null) {
                    return;
                }
                PsiFile file2 = psiFile;
                if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
                    return;
                }
                FileEditorManager editorManager = FileEditorManager.getInstance((Project)project);
                FileEditor fileEditor = editorManager.getSelectedEditor(file2.getVirtualFile());
                if (fileEditor == null) {
                    this.renameWithoutEditor(element3);
                    return;
                }
                FileEditor fileEditor2 = fileEditor;
                dataContext = DataManager.getInstance().getDataContext((Component)fileEditor2.getComponent());
                renameHandler = RenameHandlerRegistry.getInstance().getRenameHandler(dataContext);
                Editor editor = editorManager.getSelectedTextEditor();
                if (editor == null) break block5;
                RenameHandler renameHandler2 = renameHandler;
                if (renameHandler2 == null) break block6;
                renameHandler2.invoke(project, editor, file2, dataContext);
                break block6;
            }
            PsiElement psiElement3 = this.getElementToRename(element3);
            if (psiElement3 == null) {
                return;
            }
            PsiElement elementToRename = psiElement3;
            RenameHandler renameHandler3 = renameHandler;
            if (renameHandler3 == null) break block6;
            Object[] objectArray = new PsiElement[]{elementToRename};
            Project project2 = project;
            RenameHandler renameHandler4 = renameHandler3;
            void var14_14 = elements$iv;
            renameHandler4.invoke(project2, (PsiElement[])var14_14, dataContext);
        }
    }

    @Nullable
    protected PsiElement getElementToRename(@NotNull PsiElement element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return element3.getParent();
    }

    private final void renameWithoutEditor(PsiElement element3) {
        PsiElement elementToRename = this.getElementToRename(element3);
        RefactoringFactory factory2 = RefactoringFactory.getInstance((Project)element3.getProject());
        RenameRefactoring renameRefactoring = factory2.createRename(elementToRename, null, true, true);
        renameRefactoring.run();
    }
}

